/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.util;

import com.facebook.common.internal.ByteStreams;
import com.facebook.common.internal.Preconditions;
import com.facebook.infer.annotation.Nullsafe;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class StreamUtil {
    public static byte[] getBytesFromStream(InputStream is) throws IOException {
        return StreamUtil.getBytesFromStream(is, is.available());
    }

    public static byte[] getBytesFromStream(InputStream inputStream, int hint) throws IOException {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(hint){

            @Override
            public byte[] toByteArray() {
                if (this.count == this.buf.length) {
                    return this.buf;
                }
                return super.toByteArray();
            }
        };
        ByteStreams.copy(inputStream, byteOutput);
        return byteOutput.toByteArray();
    }

    public static long skip(InputStream inputStream, long bytesCount) throws IOException {
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkArgument(bytesCount >= 0L);
        long toSkip = bytesCount;
        while (toSkip > 0L) {
            long skipped = inputStream.skip(toSkip);
            if (skipped > 0L) {
                toSkip -= skipped;
                continue;
            }
            if (inputStream.read() != -1) {
                --toSkip;
                continue;
            }
            return bytesCount - toSkip;
        }
        return bytesCount;
    }
}

