/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.media;

import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.media.MimeTypeMapWrapper;
import com.facebook.infer.annotation.Nullsafe;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class MediaUtils {
    public static final Map<String, String> ADDITIONAL_ALLOWED_MIME_TYPES = ImmutableMap.of("mkv", "video/x-matroska", "glb", "model/gltf-binary");

    public static boolean isPhoto(@Nullable String mimeType) {
        return mimeType != null && mimeType.startsWith("image/");
    }

    public static boolean isVideo(@Nullable String mimeType) {
        return mimeType != null && mimeType.startsWith("video/");
    }

    public static boolean isThreeD(@Nullable String mimeType) {
        return mimeType != null && mimeType.equals("model/gltf-binary");
    }

    @Nullable
    public static String extractMime(String path) {
        String extension = MediaUtils.extractExtension(path);
        if (extension == null) {
            return null;
        }
        String mimeType = MimeTypeMapWrapper.getMimeTypeFromExtension(extension = extension.toLowerCase(Locale.US));
        if (mimeType == null) {
            mimeType = ADDITIONAL_ALLOWED_MIME_TYPES.get(extension);
        }
        return mimeType;
    }

    @Nullable
    private static String extractExtension(String path) {
        int pos = path.lastIndexOf(46);
        if (pos < 0 || pos == path.length() - 1) {
            return null;
        }
        return path.substring(pos + 1);
    }

    public static boolean isNonNativeSupportedMimeType(String mimeType) {
        return ADDITIONAL_ALLOWED_MIME_TYPES.containsValue(mimeType);
    }
}

