/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.logging;

import android.util.Log;
import com.facebook.common.logging.LoggingDelegate;
import com.facebook.infer.annotation.Nullsafe;
import java.io.PrintWriter;
import java.io.StringWriter;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class FLogDefaultLoggingDelegate
implements LoggingDelegate {
    public static final FLogDefaultLoggingDelegate sInstance = new FLogDefaultLoggingDelegate();
    private String mApplicationTag = "unknown";
    private int mMinimumLoggingLevel = 5;

    public static FLogDefaultLoggingDelegate getInstance() {
        return sInstance;
    }

    private FLogDefaultLoggingDelegate() {
    }

    public void setApplicationTag(String tag) {
        this.mApplicationTag = tag;
    }

    @Override
    public void setMinimumLoggingLevel(int level) {
        this.mMinimumLoggingLevel = level;
    }

    @Override
    public int getMinimumLoggingLevel() {
        return this.mMinimumLoggingLevel;
    }

    @Override
    public boolean isLoggable(int level) {
        return this.mMinimumLoggingLevel <= level;
    }

    @Override
    public void v(String tag, String msg) {
        this.println(2, tag, msg);
    }

    @Override
    public void v(String tag, String msg, Throwable tr) {
        this.println(2, tag, msg, tr);
    }

    @Override
    public void d(String tag, String msg) {
        this.println(3, tag, msg);
    }

    @Override
    public void d(String tag, String msg, Throwable tr) {
        this.println(3, tag, msg, tr);
    }

    @Override
    public void i(String tag, String msg) {
        this.println(4, tag, msg);
    }

    @Override
    public void i(String tag, String msg, Throwable tr) {
        this.println(4, tag, msg, tr);
    }

    @Override
    public void w(String tag, String msg) {
        this.println(5, tag, msg);
    }

    @Override
    public void w(String tag, String msg, Throwable tr) {
        this.println(5, tag, msg, tr);
    }

    @Override
    public void e(String tag, String msg) {
        this.println(6, tag, msg);
    }

    @Override
    public void e(String tag, String msg, Throwable tr) {
        this.println(6, tag, msg, tr);
    }

    @Override
    public void wtf(String tag, String msg) {
        this.println(6, tag, msg);
    }

    @Override
    public void wtf(String tag, String msg, Throwable tr) {
        this.println(6, tag, msg, tr);
    }

    @Override
    public void log(int priority, String tag, String msg) {
        this.println(priority, tag, msg);
    }

    private void println(int priority, String tag, String msg) {
        Log.println((int)priority, (String)this.prefixTag(tag), (String)msg);
    }

    private void println(int priority, String tag, String msg, Throwable tr) {
        Log.println((int)priority, (String)this.prefixTag(tag), (String)FLogDefaultLoggingDelegate.getMsg(msg, tr));
    }

    private String prefixTag(String tag) {
        if (this.mApplicationTag != null) {
            return this.mApplicationTag + ":" + tag;
        }
        return tag;
    }

    private static String getMsg(String msg, Throwable tr) {
        return msg + '\n' + FLogDefaultLoggingDelegate.getStackTraceString(tr);
    }

    private static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        return sw.toString();
    }
}

