/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.callercontext;

import android.os.Parcel;
import android.os.Parcelable;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ContextChain
implements Parcelable {
    public static final String TAG_PRODUCT = "p";
    public static final String TAG_INFRA = "i";
    public static final String TAG_PRODUCT_AND_INFRA = "pi";
    private static final char PARENT_SEPARATOR = '/';
    private static boolean sUseDeepEquals = false;
    private final String mTag;
    private final String mName;
    private final int mLevel;
    @Nullable
    private final ContextChain mParent;
    @Nullable
    private Map<String, Object> mExtraData;
    @Nullable
    private String mSerializedString;
    public static final Parcelable.Creator<ContextChain> CREATOR = new Parcelable.Creator<ContextChain>(){

        public ContextChain createFromParcel(Parcel in) {
            return new ContextChain(in);
        }

        public ContextChain[] newArray(int size) {
            return new ContextChain[size];
        }
    };

    public static void setUseDeepEquals(boolean useDeepEquals) {
        sUseDeepEquals = useDeepEquals;
    }

    public ContextChain(String tag, String name, @Nullable Map<String, String> extraData, @Nullable ContextChain parent) {
        this.mTag = tag;
        this.mName = name;
        this.mLevel = parent != null ? parent.mLevel + 1 : 0;
        this.mParent = parent;
        Map<String, Object> parentExtraData = null;
        if (parent != null) {
            parentExtraData = parent.getExtraData();
        }
        if (parentExtraData != null) {
            this.mExtraData = new HashMap<String, Object>(parentExtraData);
        }
        if (extraData != null) {
            if (this.mExtraData == null) {
                this.mExtraData = new HashMap<String, Object>();
            }
            this.mExtraData.putAll(extraData);
        }
    }

    public ContextChain(String tag, String name, @Nullable ContextChain parent) {
        this(tag, name, null, parent);
    }

    protected ContextChain(Parcel in) {
        this.mTag = in.readString();
        this.mName = in.readString();
        this.mLevel = in.readInt();
        this.mParent = (ContextChain)in.readParcelable(ContextChain.class.getClassLoader());
    }

    public String getName() {
        return this.mName;
    }

    public String getTag() {
        return this.mTag;
    }

    @Nullable
    public Map<String, Object> getExtraData() {
        return this.mExtraData;
    }

    @Nullable
    public ContextChain getParent() {
        return this.mParent;
    }

    public ContextChain getRootContextChain() {
        return this.mParent == null ? this : this.mParent.getRootContextChain();
    }

    @Nullable
    public String getStringExtra(String key) {
        if (this.mExtraData == null) {
            return null;
        }
        Object val = this.mExtraData.get(key);
        return val == null ? null : String.valueOf(val);
    }

    public void putObjectExtra(String key, Object value) {
        if (this.mExtraData == null) {
            this.mExtraData = new HashMap<String, Object>();
        }
        this.mExtraData.put(key, value);
    }

    public String toString() {
        if (this.mSerializedString == null) {
            this.mSerializedString = this.mTag + ":" + this.mName;
            if (this.mParent != null) {
                this.mSerializedString = this.mParent.toString() + '/' + this.mSerializedString;
            }
        }
        return this.mSerializedString;
    }

    public String[] toStringArray() {
        String[] result = new String[this.mLevel + 1];
        ContextChain current = this;
        for (int i = this.mLevel; i >= 0; --i) {
            Preconditions.checkNotNull(current, "ContextChain level mismatch, this should not happen.");
            result[i] = current.mTag + ":" + current.mName;
            current = current.mParent;
        }
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (sUseDeepEquals) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ContextChain other = (ContextChain)obj;
            return Objects.equal(this.mTag, other.mTag) && Objects.equal(this.mName, other.mName) && this.mLevel == other.mLevel && (this.mParent == other.mParent || this.mParent != null && this.mParent.equals(other.mParent));
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (sUseDeepEquals) {
            int result = super.hashCode();
            result = 31 * result + (this.mTag != null ? this.mTag.hashCode() : 0);
            result = 31 * result + (this.mName != null ? this.mName.hashCode() : 0);
            result = 31 * result + this.mLevel;
            result = 31 * result + (this.mParent != null ? this.mParent.hashCode() : 0);
            return result;
        }
        return super.hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mTag);
        dest.writeString(this.mName);
        dest.writeInt(this.mLevel);
        dest.writeParcelable((Parcelable)this.mParent, flags);
    }
}

