/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.executors;

import android.os.Handler;
import com.facebook.common.executors.HandlerExecutorService;
import com.facebook.common.executors.ScheduledFutureImpl;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class HandlerExecutorServiceImpl
extends AbstractExecutorService
implements HandlerExecutorService {
    private final Handler mHandler;

    public HandlerExecutorServiceImpl(Handler handler) {
        this.mHandler = handler;
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(Runnable command) {
        this.mHandler.post(command);
    }

    protected <T> ScheduledFutureImpl<T> newTaskFor(Runnable runnable, T value) {
        return new ScheduledFutureImpl<T>(this.mHandler, runnable, value);
    }

    protected <T> ScheduledFutureImpl<T> newTaskFor(Callable<T> callable) {
        return new ScheduledFutureImpl<T>(this.mHandler, callable);
    }

    public ScheduledFuture<?> submit(Runnable task) {
        return this.submit(task, (Object)null);
    }

    public <T> ScheduledFuture<T> submit(Runnable task, @Nullable T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture future = this.newTaskFor(task, (Object)result);
        this.execute(future);
        return future;
    }

    public <T> ScheduledFuture<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture future = this.newTaskFor((Callable)task);
        this.execute(future);
        return future;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        RunnableFuture future = this.newTaskFor(command, (Object)null);
        this.mHandler.postDelayed((Runnable)future, unit.toMillis(delay));
        return future;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        RunnableFuture future = this.newTaskFor(callable);
        this.mHandler.postDelayed((Runnable)future, unit.toMillis(delay));
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void quit() {
        this.mHandler.getLooper().quit();
    }

    @Override
    public boolean isHandlerThread() {
        return Thread.currentThread() == this.mHandler.getLooper().getThread();
    }
}

