/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.AccessTokenTracker;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookGraphResponseException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.internal.WorkQueue;
import com.facebook.internal.instrument.crashreport.CrashShieldHandler;
import com.facebook.share.Sharer;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.ShareVideo;
import com.facebook.share.model.ShareVideoContent;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoUploader {
    private static final String TAG = "VideoUploader";
    private static final String PARAM_UPLOAD_PHASE = "upload_phase";
    private static final String PARAM_VALUE_UPLOAD_START_PHASE = "start";
    private static final String PARAM_VALUE_UPLOAD_TRANSFER_PHASE = "transfer";
    private static final String PARAM_VALUE_UPLOAD_FINISH_PHASE = "finish";
    private static final String PARAM_TITLE = "title";
    private static final String PARAM_DESCRIPTION = "description";
    private static final String PARAM_REF = "ref";
    private static final String PARAM_FILE_SIZE = "file_size";
    private static final String PARAM_SESSION_ID = "upload_session_id";
    private static final String PARAM_VIDEO_ID = "video_id";
    private static final String PARAM_START_OFFSET = "start_offset";
    private static final String PARAM_END_OFFSET = "end_offset";
    private static final String PARAM_VIDEO_FILE_CHUNK = "video_file_chunk";
    private static final String ERROR_UPLOAD = "Video upload failed";
    private static final String ERROR_BAD_SERVER_RESPONSE = "Unexpected error in server response";
    private static final int UPLOAD_QUEUE_MAX_CONCURRENT = 8;
    private static final int MAX_RETRIES_PER_PHASE = 2;
    private static final int RETRY_DELAY_UNIT_MS = 5000;
    private static final int RETRY_DELAY_BACK_OFF_FACTOR = 3;
    private static boolean initialized;
    private static Handler handler;
    private static WorkQueue uploadQueue;
    private static Set<UploadContext> pendingUploads;
    private static AccessTokenTracker accessTokenTracker;

    public static synchronized void uploadAsync(ShareVideoContent videoContent, FacebookCallback<Sharer.Result> callback) throws FileNotFoundException {
        VideoUploader.uploadAsync(videoContent, "me", callback);
    }

    public static synchronized void uploadAsync(ShareVideoContent videoContent, String graphNode, FacebookCallback<Sharer.Result> callback) throws FileNotFoundException {
        if (!initialized) {
            VideoUploader.registerAccessTokenTracker();
            initialized = true;
        }
        Validate.notNull((Object)videoContent, (String)"videoContent");
        Validate.notNull((Object)graphNode, (String)"graphNode");
        ShareVideo video = videoContent.getVideo();
        Validate.notNull((Object)video, (String)"videoContent.video");
        Uri videoUri = video.getLocalUrl();
        Validate.notNull((Object)videoUri, (String)"videoContent.video.localUrl");
        UploadContext uploadContext = new UploadContext(videoContent, graphNode, callback);
        uploadContext.initialize();
        pendingUploads.add(uploadContext);
        VideoUploader.enqueueUploadStart(uploadContext, 0);
    }

    private static synchronized void cancelAllRequests() {
        for (UploadContext uploadContext : pendingUploads) {
            uploadContext.isCanceled = true;
        }
    }

    private static synchronized void removePendingUpload(UploadContext uploadContext) {
        pendingUploads.remove(uploadContext);
    }

    private static synchronized Handler getHandler() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        return handler;
    }

    private static void issueResponse(UploadContext uploadContext, FacebookException error, String videoId) {
        VideoUploader.removePendingUpload(uploadContext);
        Utility.closeQuietly((Closeable)uploadContext.videoStream);
        if (uploadContext.callback != null) {
            if (error != null) {
                ShareInternalUtility.invokeOnErrorCallback(uploadContext.callback, (FacebookException)error);
            } else if (uploadContext.isCanceled) {
                ShareInternalUtility.invokeOnCancelCallback(uploadContext.callback);
            } else {
                ShareInternalUtility.invokeOnSuccessCallback(uploadContext.callback, (String)videoId);
            }
        }
    }

    private static void enqueueUploadStart(UploadContext uploadContext, int completedRetries) {
        VideoUploader.enqueueRequest(uploadContext, new StartUploadWorkItem(uploadContext, completedRetries));
    }

    private static void enqueueUploadChunk(UploadContext uploadContext, String chunkStart, String chunkEnd, int completedRetries) {
        VideoUploader.enqueueRequest(uploadContext, new TransferChunkWorkItem(uploadContext, chunkStart, chunkEnd, completedRetries));
    }

    private static void enqueueUploadFinish(UploadContext uploadContext, int completedRetries) {
        VideoUploader.enqueueRequest(uploadContext, new FinishUploadWorkItem(uploadContext, completedRetries));
    }

    private static synchronized void enqueueRequest(UploadContext uploadContext, Runnable workItem) {
        uploadContext.workItem = uploadQueue.addActiveWorkItem(workItem);
    }

    private static byte[] getChunk(UploadContext uploadContext, String chunkStart, String chunkEnd) throws IOException {
        int len;
        if (!Utility.areObjectsEqual((Object)chunkStart, (Object)uploadContext.chunkStart)) {
            VideoUploader.logError(null, "Error reading video chunk. Expected chunk '%s'. Requested chunk '%s'.", uploadContext.chunkStart, chunkStart);
            return null;
        }
        long chunkStartLong = Long.parseLong(chunkStart);
        long chunkEndLong = Long.parseLong(chunkEnd);
        int chunkSize = (int)(chunkEndLong - chunkStartLong);
        ByteArrayOutputStream byteBufferStream = new ByteArrayOutputStream();
        int bufferSize = Math.min(8192, chunkSize);
        byte[] buffer = new byte[bufferSize];
        while ((len = uploadContext.videoStream.read(buffer)) != -1) {
            byteBufferStream.write(buffer, 0, len);
            if ((chunkSize -= len) == 0) break;
            if (chunkSize >= 0) continue;
            VideoUploader.logError(null, "Error reading video chunk. Expected buffer length - '%d'. Actual - '%d'.", chunkSize + len, len);
            return null;
        }
        uploadContext.chunkStart = chunkEnd;
        return byteBufferStream.toByteArray();
    }

    private static void registerAccessTokenTracker() {
        accessTokenTracker = new AccessTokenTracker(){

            protected void onCurrentAccessTokenChanged(AccessToken oldAccessToken, AccessToken currentAccessToken) {
                if (oldAccessToken == null) {
                    return;
                }
                if (currentAccessToken == null || !Utility.areObjectsEqual((Object)currentAccessToken.getUserId(), (Object)oldAccessToken.getUserId())) {
                    VideoUploader.cancelAllRequests();
                }
            }
        };
    }

    private static void logError(Exception e, String format, Object ... args) {
        Log.e((String)TAG, (String)String.format(Locale.ROOT, format, args), (Throwable)e);
    }

    static {
        uploadQueue = new WorkQueue(8);
        pendingUploads = new HashSet<UploadContext>();
    }

    private static abstract class UploadWorkItemBase
    implements Runnable {
        protected UploadContext uploadContext;
        protected int completedRetries;

        protected UploadWorkItemBase(UploadContext uploadContext, int completedRetries) {
            this.uploadContext = uploadContext;
            this.completedRetries = completedRetries;
        }

        @Override
        public void run() {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return;
            }
            try {
                if (!this.uploadContext.isCanceled) {
                    try {
                        this.executeGraphRequestSynchronously(this.getParameters());
                    }
                    catch (FacebookException fe) {
                        this.endUploadWithFailure(fe);
                    }
                    catch (Exception e) {
                        this.endUploadWithFailure(new FacebookException(VideoUploader.ERROR_UPLOAD, (Throwable)e));
                    }
                } else {
                    this.endUploadWithFailure(null);
                }
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return;
            }
        }

        protected void executeGraphRequestSynchronously(Bundle parameters) {
            GraphRequest request = new GraphRequest(this.uploadContext.accessToken, String.format(Locale.ROOT, "%s/videos", this.uploadContext.graphNode), parameters, HttpMethod.POST, null);
            GraphResponse response = request.executeAndWait();
            if (response != null) {
                FacebookRequestError error = response.getError();
                JSONObject responseJSON = response.getJSONObject();
                if (error != null) {
                    if (!this.attemptRetry(error.getSubErrorCode())) {
                        this.handleError((FacebookException)new FacebookGraphResponseException(response, VideoUploader.ERROR_UPLOAD));
                    }
                } else if (responseJSON != null) {
                    try {
                        this.handleSuccess(responseJSON);
                    }
                    catch (JSONException e) {
                        this.endUploadWithFailure(new FacebookException(VideoUploader.ERROR_BAD_SERVER_RESPONSE, (Throwable)e));
                    }
                } else {
                    this.handleError(new FacebookException(VideoUploader.ERROR_BAD_SERVER_RESPONSE));
                }
            } else {
                this.handleError(new FacebookException(VideoUploader.ERROR_BAD_SERVER_RESPONSE));
            }
        }

        private boolean attemptRetry(int errorCode) {
            if (this.completedRetries < 2 && this.getTransientErrorCodes().contains(errorCode)) {
                int delay = 5000 * (int)Math.pow(3.0, this.completedRetries);
                VideoUploader.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                            return;
                        }
                        try {
                            UploadWorkItemBase.this.enqueueRetry(UploadWorkItemBase.this.completedRetries + 1);
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                            return;
                        }
                    }
                }, (long)delay);
                return true;
            }
            return false;
        }

        protected void endUploadWithFailure(FacebookException error) {
            this.issueResponseOnMainThread(error, null);
        }

        protected void issueResponseOnMainThread(final FacebookException error, final String videoId) {
            VideoUploader.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                        return;
                    }
                    try {
                        VideoUploader.issueResponse(UploadWorkItemBase.this.uploadContext, error, videoId);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                        return;
                    }
                }
            });
        }

        protected abstract Bundle getParameters() throws Exception;

        protected abstract void handleSuccess(JSONObject var1) throws JSONException;

        protected abstract void handleError(FacebookException var1);

        protected abstract Set<Integer> getTransientErrorCodes();

        protected abstract void enqueueRetry(int var1);
    }

    private static class FinishUploadWorkItem
    extends UploadWorkItemBase {
        static final Set<Integer> transientErrorCodes = new HashSet<Integer>(){
            {
                this.add(1363011);
            }
        };

        public FinishUploadWorkItem(UploadContext uploadContext, int completedRetries) {
            super(uploadContext, completedRetries);
        }

        @Override
        public Bundle getParameters() {
            Bundle parameters = new Bundle();
            if (this.uploadContext.params != null) {
                parameters.putAll(this.uploadContext.params);
            }
            parameters.putString(VideoUploader.PARAM_UPLOAD_PHASE, VideoUploader.PARAM_VALUE_UPLOAD_FINISH_PHASE);
            parameters.putString(VideoUploader.PARAM_SESSION_ID, this.uploadContext.sessionId);
            Utility.putNonEmptyString((Bundle)parameters, (String)VideoUploader.PARAM_TITLE, (String)this.uploadContext.title);
            Utility.putNonEmptyString((Bundle)parameters, (String)VideoUploader.PARAM_DESCRIPTION, (String)this.uploadContext.description);
            Utility.putNonEmptyString((Bundle)parameters, (String)VideoUploader.PARAM_REF, (String)this.uploadContext.ref);
            return parameters;
        }

        @Override
        protected void handleSuccess(JSONObject jsonObject) throws JSONException {
            if (jsonObject.getBoolean("success")) {
                this.issueResponseOnMainThread(null, this.uploadContext.videoId);
            } else {
                this.handleError(new FacebookException(VideoUploader.ERROR_BAD_SERVER_RESPONSE));
            }
        }

        @Override
        protected void handleError(FacebookException error) {
            VideoUploader.logError((Exception)((Object)error), "Video '%s' failed to finish uploading", new Object[]{this.uploadContext.videoId});
            this.endUploadWithFailure(error);
        }

        @Override
        protected Set<Integer> getTransientErrorCodes() {
            return transientErrorCodes;
        }

        @Override
        protected void enqueueRetry(int retriesCompleted) {
            VideoUploader.enqueueUploadFinish(this.uploadContext, retriesCompleted);
        }
    }

    private static class TransferChunkWorkItem
    extends UploadWorkItemBase {
        static final Set<Integer> transientErrorCodes = new HashSet<Integer>(){
            {
                this.add(1363019);
                this.add(1363021);
                this.add(1363030);
                this.add(1363033);
                this.add(1363041);
            }
        };
        private String chunkStart;
        private String chunkEnd;

        public TransferChunkWorkItem(UploadContext uploadContext, String chunkStart, String chunkEnd, int completedRetries) {
            super(uploadContext, completedRetries);
            this.chunkStart = chunkStart;
            this.chunkEnd = chunkEnd;
        }

        @Override
        public Bundle getParameters() throws IOException {
            Bundle parameters = new Bundle();
            parameters.putString(VideoUploader.PARAM_UPLOAD_PHASE, VideoUploader.PARAM_VALUE_UPLOAD_TRANSFER_PHASE);
            parameters.putString(VideoUploader.PARAM_SESSION_ID, this.uploadContext.sessionId);
            parameters.putString(VideoUploader.PARAM_START_OFFSET, this.chunkStart);
            byte[] chunk = VideoUploader.getChunk(this.uploadContext, this.chunkStart, this.chunkEnd);
            if (chunk == null) {
                throw new FacebookException("Error reading video");
            }
            parameters.putByteArray(VideoUploader.PARAM_VIDEO_FILE_CHUNK, chunk);
            return parameters;
        }

        @Override
        protected void handleSuccess(JSONObject jsonObject) throws JSONException {
            String endOffset;
            String startOffset = jsonObject.getString(VideoUploader.PARAM_START_OFFSET);
            if (Utility.areObjectsEqual((Object)startOffset, (Object)(endOffset = jsonObject.getString(VideoUploader.PARAM_END_OFFSET)))) {
                VideoUploader.enqueueUploadFinish(this.uploadContext, 0);
            } else {
                VideoUploader.enqueueUploadChunk(this.uploadContext, startOffset, endOffset, 0);
            }
        }

        @Override
        protected void handleError(FacebookException error) {
            VideoUploader.logError((Exception)((Object)error), "Error uploading video '%s'", new Object[]{this.uploadContext.videoId});
            this.endUploadWithFailure(error);
        }

        @Override
        protected Set<Integer> getTransientErrorCodes() {
            return transientErrorCodes;
        }

        @Override
        protected void enqueueRetry(int retriesCompleted) {
            VideoUploader.enqueueUploadChunk(this.uploadContext, this.chunkStart, this.chunkEnd, retriesCompleted);
        }
    }

    private static class StartUploadWorkItem
    extends UploadWorkItemBase {
        static final Set<Integer> transientErrorCodes = new HashSet<Integer>(){
            {
                this.add(6000);
            }
        };

        public StartUploadWorkItem(UploadContext uploadContext, int completedRetries) {
            super(uploadContext, completedRetries);
        }

        @Override
        public Bundle getParameters() {
            Bundle parameters = new Bundle();
            parameters.putString(VideoUploader.PARAM_UPLOAD_PHASE, VideoUploader.PARAM_VALUE_UPLOAD_START_PHASE);
            parameters.putLong(VideoUploader.PARAM_FILE_SIZE, this.uploadContext.videoSize);
            return parameters;
        }

        @Override
        protected void handleSuccess(JSONObject jsonObject) throws JSONException {
            this.uploadContext.sessionId = jsonObject.getString(VideoUploader.PARAM_SESSION_ID);
            this.uploadContext.videoId = jsonObject.getString(VideoUploader.PARAM_VIDEO_ID);
            String startOffset = jsonObject.getString(VideoUploader.PARAM_START_OFFSET);
            String endOffset = jsonObject.getString(VideoUploader.PARAM_END_OFFSET);
            VideoUploader.enqueueUploadChunk(this.uploadContext, startOffset, endOffset, 0);
        }

        @Override
        protected void handleError(FacebookException error) {
            VideoUploader.logError((Exception)((Object)error), "Error starting video upload", new Object[0]);
            this.endUploadWithFailure(error);
        }

        @Override
        protected Set<Integer> getTransientErrorCodes() {
            return transientErrorCodes;
        }

        @Override
        protected void enqueueRetry(int retriesCompleted) {
            VideoUploader.enqueueUploadStart(this.uploadContext, retriesCompleted);
        }
    }

    private static class UploadContext {
        public final Uri videoUri;
        public final String title;
        public final String description;
        public final String ref;
        public final String graphNode;
        public final AccessToken accessToken = AccessToken.getCurrentAccessToken();
        public final FacebookCallback<Sharer.Result> callback;
        public String sessionId;
        public String videoId;
        public InputStream videoStream;
        public long videoSize;
        public String chunkStart = "0";
        public boolean isCanceled;
        public WorkQueue.WorkItem workItem;
        public Bundle params;

        private UploadContext(ShareVideoContent videoContent, String graphNode, FacebookCallback<Sharer.Result> callback) {
            this.videoUri = videoContent.getVideo().getLocalUrl();
            this.title = videoContent.getContentTitle();
            this.description = videoContent.getContentDescription();
            this.ref = videoContent.getRef();
            this.graphNode = graphNode;
            this.callback = callback;
            this.params = videoContent.getVideo().getParameters();
            if (!Utility.isNullOrEmpty((Collection)videoContent.getPeopleIds())) {
                this.params.putString("tags", TextUtils.join((CharSequence)", ", (Iterable)videoContent.getPeopleIds()));
            }
            if (!Utility.isNullOrEmpty((String)videoContent.getPlaceId())) {
                this.params.putString("place", videoContent.getPlaceId());
            }
            if (!Utility.isNullOrEmpty((String)videoContent.getRef())) {
                this.params.putString(VideoUploader.PARAM_REF, videoContent.getRef());
            }
        }

        private void initialize() throws FileNotFoundException {
            block4: {
                try {
                    if (Utility.isFileUri((Uri)this.videoUri)) {
                        ParcelFileDescriptor fileDescriptor = ParcelFileDescriptor.open((File)new File(this.videoUri.getPath()), (int)0x10000000);
                        this.videoSize = fileDescriptor.getStatSize();
                        this.videoStream = new ParcelFileDescriptor.AutoCloseInputStream(fileDescriptor);
                        break block4;
                    }
                    if (Utility.isContentUri((Uri)this.videoUri)) {
                        this.videoSize = Utility.getContentSize((Uri)this.videoUri);
                        this.videoStream = FacebookSdk.getApplicationContext().getContentResolver().openInputStream(this.videoUri);
                        break block4;
                    }
                    throw new FacebookException("Uri must be a content:// or file:// uri");
                }
                catch (FileNotFoundException e) {
                    Utility.closeQuietly((Closeable)this.videoStream);
                    throw e;
                }
            }
        }
    }
}

