/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.threadcheck;

import android.os.Looper;
import android.util.Log;
import androidx.annotation.RestrictTo;
import com.facebook.internal.instrument.InstrumentData;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ThreadCheckHandler {
    private static final String TAG = ThreadCheckHandler.class.getCanonicalName();
    private static boolean enabled = false;

    private ThreadCheckHandler() {
    }

    public static void enable() {
        enabled = true;
    }

    public static void uiThreadViolationDetected(Class<?> clazz, String methodName, String methodDesc) {
        ThreadCheckHandler.log("@UiThread", clazz, methodName, methodDesc);
    }

    public static void workerThreadViolationDetected(Class<?> clazz, String methodName, String methodDesc) {
        ThreadCheckHandler.log("@WorkerThread", clazz, methodName, methodDesc);
    }

    private static void log(String annotation, Class<?> clazz, String methodName, String methodDesc) {
        if (!enabled) {
            return;
        }
        String message = String.format(Locale.US, "%s annotation violation detected in %s.%s%s. Current looper is %s and main looper is %s.", annotation, clazz.getName(), methodName, methodDesc, Looper.myLooper(), Looper.getMainLooper());
        Exception e = new Exception();
        Log.e((String)TAG, (String)message, (Throwable)e);
        InstrumentData.Builder.build(e, InstrumentData.Type.ThreadCheck).save();
    }
}

