/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.core.internal.logging.dumpsys;

import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class AndroidRootResolver {
    private static final String TAG = AndroidRootResolver.class.getSimpleName();
    private static final String WINDOW_MANAGER_IMPL_CLAZZ = "android.view.WindowManagerImpl";
    private static final String WINDOW_MANAGER_GLOBAL_CLAZZ = "android.view.WindowManagerGlobal";
    private static final String VIEWS_FIELD = "mViews";
    private static final String WINDOW_PARAMS_FIELD = "mParams";
    private static final String GET_DEFAULT_IMPL = "getDefault";
    private static final String GET_GLOBAL_INSTANCE = "getInstance";
    private boolean initialized;
    private Object windowManagerObj;
    private Field viewsField;
    private Field paramsField;

    public void attachActiveRootListener(Listener listener) {
        if (Build.VERSION.SDK_INT < 19 || listener == null) {
            return;
        }
        if (!this.initialized) {
            this.initialize();
        }
        try {
            Field modifiers = Field.class.getDeclaredField("accessFlags");
            modifiers.setAccessible(true);
            modifiers.setInt(this.viewsField, this.viewsField.getModifiers() & 0xFFFFFFEF);
            ArrayList views = (ArrayList)this.viewsField.get(this.windowManagerObj);
            ListenableArrayList listenableViews = new ListenableArrayList();
            listenableViews.setListener(listener);
            listenableViews.addAll(views);
            this.viewsField.set(this.windowManagerObj, listenableViews);
        }
        catch (Throwable e) {
            Log.d((String)TAG, (String)"Couldn't attach root listener.", (Throwable)e);
        }
    }

    @Nullable
    public List<Root> listActiveRoots() {
        if (!this.initialized) {
            this.initialize();
        }
        if (null == this.windowManagerObj) {
            Log.d((String)TAG, (String)"No reflective access to windowmanager object.");
            return null;
        }
        if (null == this.viewsField) {
            Log.d((String)TAG, (String)"No reflective access to mViews");
            return null;
        }
        if (null == this.paramsField) {
            Log.d((String)TAG, (String)"No reflective access to mPArams");
            return null;
        }
        List<View> views = null;
        List<WindowManager.LayoutParams> params = null;
        try {
            if (Build.VERSION.SDK_INT < 19) {
                views = Arrays.asList((View[])this.viewsField.get(this.windowManagerObj));
                params = Arrays.asList((WindowManager.LayoutParams[])this.paramsField.get(this.windowManagerObj));
            } else {
                views = (List<View>)this.viewsField.get(this.windowManagerObj);
                params = (List<WindowManager.LayoutParams>)this.paramsField.get(this.windowManagerObj);
            }
        }
        catch (RuntimeException re) {
            Log.d((String)TAG, (String)String.format("Reflective access to %s or %s on %s failed.", this.viewsField, this.paramsField, this.windowManagerObj), (Throwable)re);
            return null;
        }
        catch (IllegalAccessException iae) {
            Log.d((String)TAG, (String)String.format("Reflective access to %s or %s on %s failed.", this.viewsField, this.paramsField, this.windowManagerObj), (Throwable)iae);
            return null;
        }
        ArrayList<Root> roots = new ArrayList<Root>();
        int stop = views.size();
        for (int i = 0; i < stop; ++i) {
            roots.add(new Root(views.get(i), params.get(i)));
        }
        return roots;
    }

    private void initialize() {
        this.initialized = true;
        String accessClass = Build.VERSION.SDK_INT > 16 ? WINDOW_MANAGER_GLOBAL_CLAZZ : WINDOW_MANAGER_IMPL_CLAZZ;
        String instanceMethod = Build.VERSION.SDK_INT > 16 ? GET_GLOBAL_INSTANCE : GET_DEFAULT_IMPL;
        try {
            Class<?> clazz = Class.forName(accessClass);
            Method getMethod = clazz.getMethod(instanceMethod, new Class[0]);
            this.windowManagerObj = getMethod.invoke(null, new Object[0]);
            this.viewsField = clazz.getDeclaredField(VIEWS_FIELD);
            this.viewsField.setAccessible(true);
            this.paramsField = clazz.getDeclaredField(WINDOW_PARAMS_FIELD);
            this.paramsField.setAccessible(true);
        }
        catch (InvocationTargetException ite) {
            Log.d((String)TAG, (String)String.format("could not invoke: %s on %s", instanceMethod, accessClass), (Throwable)ite.getCause());
        }
        catch (ClassNotFoundException cnfe) {
            Log.d((String)TAG, (String)String.format("could not find class: %s", accessClass), (Throwable)cnfe);
        }
        catch (NoSuchFieldException nsfe) {
            Log.d((String)TAG, (String)String.format("could not find field: %s or %s on %s", WINDOW_PARAMS_FIELD, VIEWS_FIELD, accessClass), (Throwable)nsfe);
        }
        catch (NoSuchMethodException nsme) {
            Log.d((String)TAG, (String)String.format("could not find method: %s on %s", instanceMethod, accessClass), (Throwable)nsme);
        }
        catch (RuntimeException re) {
            Log.d((String)TAG, (String)String.format("reflective setup failed using obj: %s method: %s field: %s", accessClass, instanceMethod, VIEWS_FIELD), (Throwable)re);
        }
        catch (IllegalAccessException iae) {
            Log.d((String)TAG, (String)String.format("reflective setup failed using obj: %s method: %s field: %s", accessClass, instanceMethod, VIEWS_FIELD), (Throwable)iae);
        }
    }

    public static class ListenableArrayList
    extends ArrayList<View> {
        @Nullable
        private Listener listener;

        public void setListener(Listener listener) {
            this.listener = listener;
        }

        @Override
        public boolean add(View value) {
            boolean ret = super.add(value);
            if (ret && this.listener != null) {
                this.listener.onRootAdded(value);
                this.listener.onRootsChanged(this);
            }
            return ret;
        }

        @Override
        public boolean remove(@Nullable Object value) {
            boolean ret = super.remove(value);
            if (ret && this.listener != null && value instanceof View) {
                this.listener.onRootRemoved((View)value);
                this.listener.onRootsChanged(this);
            }
            return ret;
        }

        @Override
        public View remove(int index) {
            View view = (View)super.remove(index);
            if (this.listener != null) {
                this.listener.onRootRemoved(view);
                this.listener.onRootsChanged(this);
            }
            return view;
        }
    }

    public static interface Listener {
        public void onRootAdded(View var1);

        public void onRootRemoved(View var1);

        public void onRootsChanged(List<View> var1);
    }

    public static class Root {
        public final View view;
        public final WindowManager.LayoutParams param;

        private Root(View view, WindowManager.LayoutParams param) {
            this.view = view;
            this.param = param;
        }
    }
}

