/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.RatingBar;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TimePicker;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SuggestedEventViewHierarchy {
    static final String TAG = SuggestedEventViewHierarchy.class.getCanonicalName();
    private static final List<Class<? extends View>> blacklistedViews = new ArrayList<Class>(Arrays.asList(Switch.class, Spinner.class, DatePicker.class, TimePicker.class, RadioGroup.class, RatingBar.class, EditText.class, AdapterView.class));

    SuggestedEventViewHierarchy() {
    }

    /*
     * WARNING - void declaration
     */
    static JSONObject getDictionaryOfView(View view, View view2) {
        if (CrashShieldHandler.isObjectCrashing(SuggestedEventViewHierarchy.class)) {
            return null;
        }
        try {
            JSONObject json = new JSONObject();
            try {
                void clickedView;
                View view3;
                if (view3 == clickedView) {
                    json.put("is_interacted", true);
                }
                SuggestedEventViewHierarchy.updateBasicInfo(view3, json);
                JSONArray childViews = new JSONArray();
                List<View> children = ViewHierarchy.getChildrenOfView(view3);
                for (View child : children) {
                    JSONObject childInfo = SuggestedEventViewHierarchy.getDictionaryOfView(child, (View)clickedView);
                    childViews.put((Object)childInfo);
                }
                json.put("childviews", (Object)childViews);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return json;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SuggestedEventViewHierarchy.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void updateBasicInfo(View view, JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(SuggestedEventViewHierarchy.class)) {
            return;
        }
        try {
            try {
                void json;
                View view2;
                String text = ViewHierarchy.getTextOfView(view2);
                String hint = ViewHierarchy.getHintOfView(view2);
                json.put("classname", (Object)view2.getClass().getSimpleName());
                json.put("classtypebitmask", ViewHierarchy.getClassTypeBitmask(view2));
                if (!text.isEmpty()) {
                    json.put("text", (Object)text);
                }
                if (!hint.isEmpty()) {
                    json.put("hint", (Object)hint);
                }
                if (view2 instanceof EditText) {
                    json.put("inputtype", ((EditText)view2).getInputType());
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SuggestedEventViewHierarchy.class);
            return;
        }
    }

    static List<View> getAllClickableViews(View view) {
        if (CrashShieldHandler.isObjectCrashing(SuggestedEventViewHierarchy.class)) {
            return null;
        }
        try {
            View view2;
            ArrayList<View> clickableViews = new ArrayList<View>();
            for (Class<? extends View> viewClass : blacklistedViews) {
                if (!viewClass.isInstance(view2)) continue;
                return clickableViews;
            }
            if (view2.isClickable()) {
                clickableViews.add(view2);
            }
            List<View> children = ViewHierarchy.getChildrenOfView(view2);
            for (View child : children) {
                clickableViews.addAll(SuggestedEventViewHierarchy.getAllClickableViews(child));
            }
            return clickableViews;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SuggestedEventViewHierarchy.class);
            return null;
        }
    }

    static String getTextOfViewRecursively(View view) {
        if (CrashShieldHandler.isObjectCrashing(SuggestedEventViewHierarchy.class)) {
            return null;
        }
        try {
            View hostView;
            String text = ViewHierarchy.getTextOfView(hostView);
            if (!text.isEmpty()) {
                return text;
            }
            List<String> childrenText = SuggestedEventViewHierarchy.getTextOfChildren(hostView);
            return TextUtils.join((CharSequence)" ", childrenText);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SuggestedEventViewHierarchy.class);
            return null;
        }
    }

    private static List<String> getTextOfChildren(View view) {
        if (CrashShieldHandler.isObjectCrashing(SuggestedEventViewHierarchy.class)) {
            return null;
        }
        try {
            View view2;
            ArrayList<String> childrenText = new ArrayList<String>();
            List<View> childrenView = ViewHierarchy.getChildrenOfView(view2);
            for (View childView : childrenView) {
                String childText = ViewHierarchy.getTextOfView(childView);
                if (!childText.isEmpty()) {
                    childrenText.add(childText);
                }
                childrenText.addAll(SuggestedEventViewHierarchy.getTextOfChildren(childView));
            }
            return childrenText;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SuggestedEventViewHierarchy.class);
            return null;
        }
    }
}

