/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ondeviceprocessing;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.eventdeactivation.EventDeactivationManager;
import com.facebook.appevents.ondeviceprocessing.RemoteServiceWrapper;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

class RemoteServiceParametersHelper {
    private static final String TAG = RemoteServiceWrapper.class.getSimpleName();

    RemoteServiceParametersHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    static Bundle buildEventsBundle(RemoteServiceWrapper.EventType eventType, String string, List<AppEvent> list) {
        if (CrashShieldHandler.isObjectCrashing(RemoteServiceParametersHelper.class)) {
            return null;
        }
        try {
            void applicationId;
            RemoteServiceWrapper.EventType eventType2;
            ArrayList<AppEvent> appEvents;
            appEvents = new ArrayList<AppEvent>(appEvents);
            Bundle eventBundle = new Bundle();
            eventBundle.putString("event", eventType2.toString());
            eventBundle.putString("app_id", (String)applicationId);
            if (RemoteServiceWrapper.EventType.CUSTOM_APP_EVENTS == eventType2) {
                JSONArray filteredEventsJson = RemoteServiceParametersHelper.buildEventsJson(appEvents, (String)applicationId);
                if (filteredEventsJson.length() == 0) {
                    return null;
                }
                eventBundle.putString("custom_events", filteredEventsJson.toString());
            }
            return eventBundle;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RemoteServiceParametersHelper.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static JSONArray buildEventsJson(List<AppEvent> list, String string) {
        if (CrashShieldHandler.isObjectCrashing(RemoteServiceParametersHelper.class)) {
            return null;
        }
        try {
            void applicationId;
            List<AppEvent> appEvents;
            JSONArray filteredEventsJsonArray = new JSONArray();
            EventDeactivationManager.processEvents(appEvents);
            boolean includeImplicitEvents = RemoteServiceParametersHelper.includeImplicitEvents((String)applicationId);
            for (AppEvent event : appEvents) {
                if (event.isChecksumValid()) {
                    boolean isExplicitEvent;
                    boolean bl = isExplicitEvent = !event.getIsImplicit();
                    if (!isExplicitEvent && (!event.getIsImplicit() || !includeImplicitEvents)) continue;
                    filteredEventsJsonArray.put((Object)event.getJSONObject());
                    continue;
                }
                Utility.logd(TAG, "Event with invalid checksum: " + event.toString());
            }
            return filteredEventsJsonArray;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RemoteServiceParametersHelper.class);
            return null;
        }
    }

    private static boolean includeImplicitEvents(String string) {
        if (CrashShieldHandler.isObjectCrashing(RemoteServiceParametersHelper.class)) {
            return false;
        }
        try {
            String applicationId;
            boolean supportsImplicitLogging = false;
            FetchedAppSettings appSettings = FetchedAppSettingsManager.queryAppSettings(applicationId, false);
            if (appSettings != null) {
                supportsImplicitLogging = appSettings.supportsImplicitLogging();
            }
            return supportsImplicitLogging;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RemoteServiceParametersHelper.class);
            return false;
        }
    }
}

