/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import com.facebook.appevents.ml.MTensor;
import com.facebook.appevents.ml.Utils;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;

final class Operator {
    Operator() {
    }

    /*
     * WARNING - void declaration
     */
    static void addmv(MTensor mTensor, MTensor mTensor2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            void b;
            MTensor x;
            int n_example = x.getShape(0);
            int seq_len = x.getShape(1);
            int input_size = x.getShape(2);
            float[] x_data = x.getData();
            float[] b_data = b.getData();
            for (int i = 0; i < n_example; ++i) {
                for (int j = 0; j < seq_len; ++j) {
                    for (int k = 0; k < input_size; ++k) {
                        int n = i * seq_len * input_size + j * input_size + k;
                        x_data[n] = x_data[n] + b_data[k];
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static MTensor mul(MTensor mTensor, MTensor mTensor2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void w;
            MTensor x;
            int n_examples = x.getShape(0);
            int input_size = w.getShape(0);
            int output_size = w.getShape(1);
            MTensor y = new MTensor(new int[]{n_examples, output_size});
            float[] x_data = x.getData();
            float[] w_data = w.getData();
            float[] y_data = y.getData();
            for (int i = 0; i < n_examples; ++i) {
                for (int j = 0; j < output_size; ++j) {
                    y_data[i * output_size + j] = 0.0f;
                    for (int k = 0; k < input_size; ++k) {
                        int n = i * output_size + j;
                        y_data[n] = y_data[n] + x_data[i * input_size + k] * w_data[k * output_size + j];
                    }
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    static void relu(MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            MTensor x;
            float[] x_data = x.getData();
            for (int i = 0; i < x_data.length; ++i) {
                if (!(x_data[i] < 0.0f)) continue;
                x_data[i] = 0.0f;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    static void flatten(MTensor mTensor, int n) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            MTensor x;
            int start_dim;
            if (start_dim >= x.getShapeSize()) {
                return;
            }
            int output_size = 1;
            for (void i = start_dim; i < x.getShapeSize(); ++i) {
                output_size *= x.getShape((int)i);
            }
            int[] new_shape = new int[start_dim + true];
            for (int i = 0; i < start_dim; ++i) {
                new_shape[i] = x.getShape(i);
            }
            new_shape[start_dim] = output_size;
            x.reshape(new_shape);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    static MTensor concatenate(MTensor[] mTensorArray) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            MTensor[] tensors;
            int n_examples = tensors[0].getShape(0);
            int output_size = 0;
            for (int i = 0; i < tensors.length; ++i) {
                output_size += tensors[i].getShape(1);
            }
            MTensor y = new MTensor(new int[]{n_examples, output_size});
            float[] y_data = y.getData();
            for (int n = 0; n < n_examples; ++n) {
                int desPos = n * output_size;
                for (int i = 0; i < tensors.length; ++i) {
                    float[] x_data = tensors[i].getData();
                    int input_size = tensors[i].getShape(1);
                    System.arraycopy(x_data, n * input_size, y_data, desPos, input_size);
                    desPos += input_size;
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    static void softmax(MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            MTensor x;
            int n_examples = x.getShape(0);
            int input_size = x.getShape(1);
            float[] x_data = x.getData();
            for (int n = 0; n < n_examples; ++n) {
                int i;
                int start_idx = n * input_size;
                int end_idx = start_idx + input_size;
                float max = Float.MIN_VALUE;
                float sum = 0.0f;
                for (i = start_idx; i < end_idx; ++i) {
                    if (!(x_data[i] > max)) continue;
                    max = x_data[i];
                }
                for (i = start_idx; i < end_idx; ++i) {
                    x_data[i] = (float)Math.exp(x_data[i] - max);
                }
                for (i = start_idx; i < end_idx; ++i) {
                    sum += x_data[i];
                }
                for (i = start_idx; i < end_idx; ++i) {
                    x_data[i] = x_data[i] / sum;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static MTensor dense(MTensor mTensor, MTensor mTensor2, MTensor mTensor3) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void w;
            void b;
            MTensor x;
            int n_examples = x.getShape(0);
            int output_size = b.getShape(0);
            MTensor y = Operator.mul(x, (MTensor)w);
            float[] b_data = b.getData();
            float[] y_data = y.getData();
            for (int i = 0; i < n_examples; ++i) {
                for (int j = 0; j < output_size; ++j) {
                    int n = i * output_size + j;
                    y_data[n] = y_data[n] + b_data[j];
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static MTensor embedding(String[] stringArray, int n, MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            int seq_len;
            void w;
            String[] texts;
            int n_examples = texts.length;
            int embedding_size = w.getShape(1);
            MTensor y = new MTensor(new int[]{n_examples, seq_len, embedding_size});
            float[] y_data = y.getData();
            float[] w_data = w.getData();
            for (int i = 0; i < n_examples; ++i) {
                int[] vectorize_text = Utils.vectorize(texts[i], seq_len);
                for (int j = 0; j < seq_len; ++j) {
                    System.arraycopy(w_data, vectorize_text[j] * embedding_size, y_data, embedding_size * seq_len * i + embedding_size * j, embedding_size);
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    static MTensor transpose2D(MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            MTensor x;
            int m = x.getShape(0);
            int n = x.getShape(1);
            MTensor y = new MTensor(new int[]{n, m});
            float[] x_data = x.getData();
            float[] y_data = y.getData();
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n; ++j) {
                    y_data[j * m + i] = x_data[i * n + j];
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    static MTensor transpose3D(MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            MTensor x;
            int m = x.getShape(0);
            int n = x.getShape(1);
            int p = x.getShape(2);
            MTensor y = new MTensor(new int[]{p, n, m});
            float[] x_data = x.getData();
            float[] y_data = y.getData();
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < p; ++k) {
                        y_data[k * m * n + j * m + i] = x_data[i * n * p + j * p + k];
                    }
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static MTensor conv1D(MTensor mTensor, MTensor mTensor2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void w;
            MTensor x;
            int n_examples = x.getShape(0);
            int input_seq_len = x.getShape(1);
            int input_size = x.getShape(2);
            int kernel_size = w.getShape(0);
            int output_seq_len = input_seq_len - kernel_size + 1;
            int output_size = w.getShape(2);
            MTensor y = new MTensor(new int[]{n_examples, output_seq_len, output_size});
            float[] x_data = x.getData();
            float[] y_data = y.getData();
            float[] w_data = w.getData();
            for (int n = 0; n < n_examples; ++n) {
                for (int o = 0; o < output_size; ++o) {
                    for (int i = 0; i < output_seq_len; ++i) {
                        float sum = 0.0f;
                        for (int m = 0; m < kernel_size; ++m) {
                            for (int k = 0; k < input_size; ++k) {
                                sum += x_data[n * (input_seq_len * input_size) + (m + i) * input_size + k] * w_data[(m * input_size + k) * output_size + o];
                            }
                        }
                        y_data[n * (output_seq_len * output_size) + i * output_size + o] = sum;
                    }
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    static MTensor maxPool1D(MTensor mTensor, int n) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            int pool_size;
            MTensor x;
            int n_examples = x.getShape(0);
            int input_seq_len = x.getShape(1);
            int input_size = x.getShape(2);
            int output_seq_len = input_seq_len - pool_size + 1;
            MTensor y = new MTensor(new int[]{n_examples, output_seq_len, input_size});
            float[] x_data = x.getData();
            float[] y_data = y.getData();
            for (int n2 = 0; n2 < n_examples; ++n2) {
                for (int c = 0; c < input_size; ++c) {
                    for (int i = 0; i < output_seq_len; ++i) {
                        int y_index = n2 * output_seq_len * input_size + i * input_size + c;
                        int x_index = n2 * input_seq_len * input_size + i * input_size + c;
                        y_data[y_index] = Float.MIN_VALUE;
                        for (int r = 0; r < pool_size; ++r) {
                            y_data[y_index] = Math.max(y_data[y_index], x_data[x_index + r * input_size]);
                        }
                    }
                }
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }
}

