/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.appevents.ml.MTensor;
import com.facebook.appevents.ml.ModelManager;
import com.facebook.appevents.ml.Operator;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Model {
    private MTensor embedding;
    private MTensor convs_0_weight;
    private MTensor convs_1_weight;
    private MTensor convs_2_weight;
    private MTensor convs_0_bias;
    private MTensor convs_1_bias;
    private MTensor convs_2_bias;
    private MTensor fc1_weight;
    private MTensor fc2_weight;
    private MTensor fc1_bias;
    private MTensor fc2_bias;
    private final Map<String, MTensor> final_weights = new HashMap<String, MTensor>();
    private static final int SEQ_LEN = 128;

    private Model(Map<String, MTensor> weights) {
        this.embedding = weights.get("embed.weight");
        this.convs_0_weight = Operator.transpose3D(weights.get("convs.0.weight"));
        this.convs_1_weight = Operator.transpose3D(weights.get("convs.1.weight"));
        this.convs_2_weight = Operator.transpose3D(weights.get("convs.2.weight"));
        this.convs_0_bias = weights.get("convs.0.bias");
        this.convs_1_bias = weights.get("convs.1.bias");
        this.convs_2_bias = weights.get("convs.2.bias");
        this.fc1_weight = Operator.transpose2D(weights.get("fc1.weight"));
        this.fc2_weight = Operator.transpose2D(weights.get("fc2.weight"));
        this.fc1_bias = weights.get("fc1.bias");
        this.fc2_bias = weights.get("fc2.bias");
        HashSet<String> tasks = new HashSet<String>(){
            {
                this.add(ModelManager.Task.MTML_INTEGRITY_DETECT.toKey());
                this.add(ModelManager.Task.MTML_APP_EVENT_PREDICTION.toKey());
            }
        };
        for (String task : tasks) {
            String weightKey = task + ".weight";
            String biasKey = task + ".bias";
            MTensor weight = weights.get(weightKey);
            MTensor bias = weights.get(biasKey);
            if (weight != null) {
                weight = Operator.transpose2D(weight);
                this.final_weights.put(weightKey, weight);
            }
            if (bias == null) continue;
            this.final_weights.put(biasKey, bias);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public MTensor predictOnMTML(MTensor mTensor, String[] stringArray, String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void task;
            void dense;
            void texts;
            MTensor embed_x = Operator.embedding((String[])texts, 128, this.embedding);
            MTensor c0 = Operator.conv1D(embed_x, this.convs_0_weight);
            Operator.addmv(c0, this.convs_0_bias);
            Operator.relu(c0);
            MTensor c1 = Operator.conv1D(c0, this.convs_1_weight);
            Operator.addmv(c1, this.convs_1_bias);
            Operator.relu(c1);
            c1 = Operator.maxPool1D(c1, 2);
            MTensor c2 = Operator.conv1D(c1, this.convs_2_weight);
            Operator.addmv(c2, this.convs_2_bias);
            Operator.relu(c2);
            c0 = Operator.maxPool1D(c0, c0.getShape(1));
            c1 = Operator.maxPool1D(c1, c1.getShape(1));
            c2 = Operator.maxPool1D(c2, c2.getShape(1));
            Operator.flatten(c0, 1);
            Operator.flatten(c1, 1);
            Operator.flatten(c2, 1);
            MTensor concat = Operator.concatenate(new MTensor[]{c0, c1, c2, dense});
            MTensor dense1_x = Operator.dense(concat, this.fc1_weight, this.fc1_bias);
            Operator.relu(dense1_x);
            MTensor dense2_x = Operator.dense(dense1_x, this.fc2_weight, this.fc2_bias);
            Operator.relu(dense2_x);
            MTensor fc3_weight = this.final_weights.get((String)task + ".weight");
            MTensor fc3_bias = this.final_weights.get((String)task + ".bias");
            if (fc3_weight == null || fc3_bias == null) {
                return null;
            }
            MTensor res = Operator.dense(dense2_x, fc3_weight, fc3_bias);
            Operator.softmax(res);
            return res;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    @Nullable
    public static Model build(File file) {
        if (CrashShieldHandler.isObjectCrashing(Model.class)) {
            return null;
        }
        try {
            File file2;
            Map<String, MTensor> weights = Model.parse(file2);
            try {
                return new Model(weights);
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Model.class);
            return null;
        }
    }

    @Nullable
    private static Map<String, MTensor> parse(File file) {
        if (CrashShieldHandler.isObjectCrashing(Model.class)) {
            return null;
        }
        try {
            try {
                File file2;
                FileInputStream inputStream = new FileInputStream(file2);
                int length = ((InputStream)inputStream).available();
                DataInputStream dataIs = new DataInputStream(inputStream);
                byte[] allData = new byte[length];
                dataIs.readFully(allData);
                dataIs.close();
                if (length < 4) {
                    return null;
                }
                ByteBuffer bb = ByteBuffer.wrap(allData, 0, 4);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                int jsonLen = bb.getInt();
                if (length < jsonLen + 4) {
                    return null;
                }
                String jsonStr = new String(allData, 4, jsonLen);
                JSONObject info = new JSONObject(jsonStr);
                JSONArray names = info.names();
                Object[] keys = new String[names.length()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = names.getString(i);
                }
                Arrays.sort(keys);
                int offset = 4 + jsonLen;
                HashMap<String, MTensor> weights = new HashMap<String, MTensor>();
                Map<String, String> mapping = Model.getMapping();
                for (Object key : keys) {
                    int count = 1;
                    JSONArray shapes = info.getJSONArray((String)key);
                    int[] shape = new int[shapes.length()];
                    for (int i = 0; i < shape.length; ++i) {
                        shape[i] = shapes.getInt(i);
                        count *= shape[i];
                    }
                    if (offset + count * 4 > length) {
                        return null;
                    }
                    bb = ByteBuffer.wrap(allData, offset, count * 4);
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                    MTensor tensor = new MTensor(shape);
                    bb.asFloatBuffer().get(tensor.getData(), 0, count);
                    Object finalKey = key;
                    if (mapping.containsKey(key)) {
                        finalKey = mapping.get(key);
                    }
                    weights.put((String)finalKey, tensor);
                    offset += count * 4;
                }
                return weights;
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Model.class);
            return null;
        }
    }

    private static Map<String, String> getMapping() {
        if (CrashShieldHandler.isObjectCrashing(Model.class)) {
            return null;
        }
        try {
            return new HashMap<String, String>(){
                {
                    this.put("embedding.weight", "embed.weight");
                    this.put("dense1.weight", "fc1.weight");
                    this.put("dense2.weight", "fc2.weight");
                    this.put("dense3.weight", "fc3.weight");
                    this.put("dense1.bias", "fc1.bias");
                    this.put("dense2.bias", "fc2.bias");
                    this.put("dense3.bias", "fc3.bias");
                }
            };
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Model.class);
            return null;
        }
    }
}

