/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.codeless.CodelessMatcher;
import com.facebook.appevents.codeless.internal.EventBinding;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CodelessLoggingEventListener {
    private static final String TAG = CodelessLoggingEventListener.class.getCanonicalName();

    /*
     * WARNING - void declaration
     */
    public static AutoLoggingOnClickListener getOnClickListener(EventBinding eventBinding, View view, View view2) {
        if (CrashShieldHandler.isObjectCrashing(CodelessLoggingEventListener.class)) {
            return null;
        }
        try {
            void hostView;
            void rootView;
            EventBinding mapping;
            return new AutoLoggingOnClickListener(mapping, (View)rootView, (View)hostView);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessLoggingEventListener.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static AutoLoggingOnItemClickListener getOnItemClickListener(EventBinding eventBinding, View view, AdapterView adapterView) {
        if (CrashShieldHandler.isObjectCrashing(CodelessLoggingEventListener.class)) {
            return null;
        }
        try {
            void hostView;
            void rootView;
            EventBinding mapping;
            return new AutoLoggingOnItemClickListener(mapping, (View)rootView, (AdapterView)hostView);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessLoggingEventListener.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void logEvent(EventBinding eventBinding, View view, View view2) {
        if (CrashShieldHandler.isObjectCrashing(CodelessLoggingEventListener.class)) {
            return;
        }
        try {
            void hostView;
            void rootView;
            EventBinding mapping;
            final String eventName = mapping.getEventName();
            final Bundle parameters = CodelessMatcher.getParameters(mapping, (View)rootView, (View)hostView);
            CodelessLoggingEventListener.updateParameters(parameters);
            FacebookSdk.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        Context context = FacebookSdk.getApplicationContext();
                        AppEventsLogger appEventsLogger = AppEventsLogger.newLogger(context);
                        appEventsLogger.logEvent(eventName, parameters);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessLoggingEventListener.class);
            return;
        }
    }

    protected static void updateParameters(Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(CodelessLoggingEventListener.class)) {
            return;
        }
        try {
            Bundle parameters;
            String value = parameters.getString("_valueToSum");
            if (value != null) {
                parameters.putDouble("_valueToSum", AppEventUtility.normalizePrice(value));
            }
            parameters.putString("_is_fb_codeless", "1");
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessLoggingEventListener.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(EventBinding eventBinding, View view, View view2) {
        if (CrashShieldHandler.isObjectCrashing(CodelessLoggingEventListener.class)) {
            return;
        }
        try {
            void x2;
            void x1;
            EventBinding x0;
            CodelessLoggingEventListener.logEvent(x0, (View)x1, (View)x2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessLoggingEventListener.class);
            return;
        }
    }

    public static class AutoLoggingOnItemClickListener
    implements AdapterView.OnItemClickListener {
        private EventBinding mapping;
        private WeakReference<AdapterView> hostView;
        private WeakReference<View> rootView;
        @Nullable
        private AdapterView.OnItemClickListener existingOnItemClickListener;
        private boolean supportCodelessLogging = false;

        private AutoLoggingOnItemClickListener(EventBinding mapping, View rootView, AdapterView hostView) {
            if (null == mapping || null == rootView || null == hostView) {
                return;
            }
            this.existingOnItemClickListener = hostView.getOnItemClickListener();
            this.mapping = mapping;
            this.hostView = new WeakReference<AdapterView>(hostView);
            this.rootView = new WeakReference<View>(rootView);
            this.supportCodelessLogging = true;
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
            if (this.existingOnItemClickListener != null) {
                this.existingOnItemClickListener.onItemClick(parent, view, position, id);
            }
            if (this.rootView.get() != null && this.hostView.get() != null) {
                CodelessLoggingEventListener.access$200(this.mapping, (View)this.rootView.get(), (View)this.hostView.get());
            }
        }

        public boolean getSupportCodelessLogging() {
            return this.supportCodelessLogging;
        }
    }

    public static class AutoLoggingOnClickListener
    implements View.OnClickListener {
        private EventBinding mapping;
        private WeakReference<View> hostView;
        private WeakReference<View> rootView;
        @Nullable
        private View.OnClickListener existingOnClickListener;
        private boolean supportCodelessLogging = false;

        private AutoLoggingOnClickListener(EventBinding mapping, View rootView, View hostView) {
            if (null == mapping || null == rootView || null == hostView) {
                return;
            }
            this.existingOnClickListener = ViewHierarchy.getExistingOnClickListener(hostView);
            this.mapping = mapping;
            this.hostView = new WeakReference<View>(hostView);
            this.rootView = new WeakReference<View>(rootView);
            this.supportCodelessLogging = true;
        }

        /*
         * WARNING - void declaration
         */
        public void onClick(View view) {
            if (CrashShieldHandler.isObjectCrashing(this)) {
                return;
            }
            try {
                if (this.existingOnClickListener != null) {
                    void view2;
                    this.existingOnClickListener.onClick((View)view2);
                }
                if (this.rootView.get() != null && this.hostView.get() != null) {
                    CodelessLoggingEventListener.access$200(this.mapping, (View)this.rootView.get(), (View)this.hostView.get());
                }
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable(throwable, this);
                return;
            }
        }

        public boolean getSupportCodelessLogging() {
            return this.supportCodelessLogging;
        }
    }
}

