/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.os.Bundle;
import android.webkit.JavascriptInterface;
import androidx.annotation.VisibleForTesting;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.Logger;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

class FacebookSDKJSInterface {
    public static final String TAG = FacebookSDKJSInterface.class.getSimpleName();
    private static final String PROTOCOL = "fbmq-0.1";
    private static final String PARAMETER_FBSDK_PIXEL_REFERRAL = "_fb_pixel_referral_id";
    private Context context;

    public FacebookSDKJSInterface(Context context) {
        this.context = context;
    }

    private static Bundle jsonToBundle(JSONObject jSONObject) throws JSONException {
        if (CrashShieldHandler.isObjectCrashing(FacebookSDKJSInterface.class)) {
            return null;
        }
        try {
            JSONObject jsonObject;
            Bundle bundle = new Bundle();
            Iterator iter = jsonObject.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = jsonObject.getString(key);
                bundle.putString(key, value);
            }
            return bundle;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, FacebookSDKJSInterface.class);
            return null;
        }
    }

    @VisibleForTesting
    static Bundle jsonStringToBundle(String string) {
        if (CrashShieldHandler.isObjectCrashing(FacebookSDKJSInterface.class)) {
            return null;
        }
        try {
            try {
                String jsonString;
                JSONObject jsonObject = new JSONObject(jsonString);
                return FacebookSDKJSInterface.jsonToBundle(jsonObject);
            }
            catch (JSONException jSONException) {
                return new Bundle();
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, FacebookSDKJSInterface.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JavascriptInterface
    public void sendEvent(String string, String string2, String string3) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void event_name;
            void jsonString;
            void pixelId;
            if (pixelId == null) {
                Logger.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "Can't bridge an event without a referral Pixel ID. Check your webview Pixel configuration");
                return;
            }
            InternalAppEventsLogger logger = new InternalAppEventsLogger(this.context);
            Bundle parameters = FacebookSDKJSInterface.jsonStringToBundle((String)jsonString);
            parameters.putString(PARAMETER_FBSDK_PIXEL_REFERRAL, (String)pixelId);
            logger.logEvent((String)event_name, parameters);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JavascriptInterface
    public String getProtocol() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            return PROTOCOL;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }
}

