/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookException;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.eventdeactivation.EventDeactivationManager;
import com.facebook.appevents.integrity.IntegrityManager;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.appevents.restrictivedatafilter.RestrictiveDataManager;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AppEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final HashSet<String> validatedIdentifiers = new HashSet();
    private final JSONObject jsonObject;
    private final boolean isImplicit;
    private final boolean inBackground;
    private final String name;
    private final String checksum;

    public AppEvent(String contextName, @NonNull String eventName, Double valueToSum, Bundle parameters, boolean isImplicitlyLogged, boolean isInBackground, @Nullable UUID currentSessionId) throws JSONException, FacebookException {
        this.isImplicit = isImplicitlyLogged;
        this.inBackground = isInBackground;
        this.name = eventName;
        this.jsonObject = this.getJSONObjectForAppEvent(contextName, eventName, valueToSum, parameters, currentSessionId);
        this.checksum = this.calculateChecksum();
    }

    public String getName() {
        return this.name;
    }

    private AppEvent(String jsonString, boolean isImplicit, boolean inBackground, String checksum) throws JSONException {
        this.jsonObject = new JSONObject(jsonString);
        this.isImplicit = isImplicit;
        this.name = this.jsonObject.optString("_eventName");
        this.checksum = checksum;
        this.inBackground = inBackground;
    }

    public boolean getIsImplicit() {
        return this.isImplicit;
    }

    public JSONObject getJSONObject() {
        return this.jsonObject;
    }

    public boolean isChecksumValid() {
        if (this.checksum == null) {
            return true;
        }
        return this.calculateChecksum().equals(this.checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateIdentifier(String identifier) throws FacebookException {
        boolean alreadyValidated;
        String regex = "^[0-9a-zA-Z_]+[0-9a-zA-Z _-]*$";
        int MAX_IDENTIFIER_LENGTH = 40;
        if (identifier == null || identifier.length() == 0 || identifier.length() > 40) {
            if (identifier == null) {
                identifier = "<None Provided>";
            }
            throw new FacebookException(String.format(Locale.ROOT, "Identifier '%s' must be less than %d characters", identifier, 40));
        }
        HashSet<String> hashSet = validatedIdentifiers;
        synchronized (hashSet) {
            alreadyValidated = validatedIdentifiers.contains(identifier);
        }
        if (!alreadyValidated) {
            if (identifier.matches("^[0-9a-zA-Z_]+[0-9a-zA-Z _-]*$")) {
                hashSet = validatedIdentifiers;
                synchronized (hashSet) {
                    validatedIdentifiers.add(identifier);
                }
            } else {
                throw new FacebookException(String.format("Skipping event named '%s' due to illegal name - must be under 40 chars and alphanumeric, _, - or space, and not start with a space or hyphen.", identifier));
            }
        }
    }

    private JSONObject getJSONObjectForAppEvent(String contextName, @NonNull String eventName, Double valueToSum, Bundle parameters, @Nullable UUID currentSessionId) throws JSONException {
        AppEvent.validateIdentifier(eventName);
        JSONObject eventObject = new JSONObject();
        eventName = RestrictiveDataManager.processEvent(eventName);
        eventObject.put("_eventName", (Object)eventName);
        eventObject.put("_eventName_md5", (Object)AppEvent.md5Checksum(eventName));
        eventObject.put("_logTime", System.currentTimeMillis() / 1000L);
        eventObject.put("_ui", (Object)contextName);
        if (currentSessionId != null) {
            eventObject.put("_session_id", (Object)currentSessionId);
        }
        if (parameters != null) {
            Map<String, String> processedParam = this.validateParameters(parameters);
            for (String key : processedParam.keySet()) {
                eventObject.put(key, (Object)processedParam.get(key));
            }
        }
        if (valueToSum != null) {
            eventObject.put("_valueToSum", valueToSum.doubleValue());
        }
        if (this.inBackground) {
            eventObject.put("_inBackground", (Object)"1");
        }
        if (this.isImplicit) {
            eventObject.put("_implicitlyLogged", (Object)"1");
        } else {
            Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Created app event '%s'", eventObject.toString());
        }
        return eventObject;
    }

    private Map<String, String> validateParameters(Bundle parameters) throws FacebookException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String key : parameters.keySet()) {
            AppEvent.validateIdentifier(key);
            Object value = parameters.get(key);
            if (!(value instanceof String) && !(value instanceof Number)) {
                throw new FacebookException(String.format("Parameter value '%s' for key '%s' should be a string or a numeric type.", value, key));
            }
            paramMap.put(key, value.toString());
        }
        IntegrityManager.processParameters(paramMap);
        RestrictiveDataManager.processParameters(paramMap, this.name);
        EventDeactivationManager.processDeprecatedParameters(paramMap, this.name);
        return paramMap;
    }

    private Object writeReplace() {
        return new SerializationProxyV2(this.jsonObject.toString(), this.isImplicit, this.inBackground, this.checksum);
    }

    public String toString() {
        return String.format("\"%s\", implicit: %b, json: %s", this.jsonObject.optString("_eventName"), this.isImplicit, this.jsonObject.toString());
    }

    private String calculateChecksum() {
        if (Build.VERSION.SDK_INT > 19) {
            return AppEvent.md5Checksum(this.jsonObject.toString());
        }
        ArrayList keys = new ArrayList();
        Iterator iterator = this.jsonObject.keys();
        while (iterator.hasNext()) {
            keys.add(iterator.next());
        }
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append(key).append(" = ").append(this.jsonObject.optString(key)).append('\n');
        }
        return AppEvent.md5Checksum(sb.toString());
    }

    private static String md5Checksum(String toHash) {
        String hash;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] bytes = toHash.getBytes("UTF-8");
            digest.update(bytes, 0, bytes.length);
            bytes = digest.digest();
            hash = AppEventUtility.bytesToHex(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            Utility.logd("Failed to generate checksum: ", e);
            return "0";
        }
        catch (UnsupportedEncodingException e) {
            Utility.logd("Failed to generate checksum: ", e);
            return "1";
        }
        return hash;
    }

    static class SerializationProxyV2
    implements Serializable {
        private static final long serialVersionUID = 20160803001L;
        private final String jsonString;
        private final boolean isImplicit;
        private final boolean inBackground;
        private final String checksum;

        private SerializationProxyV2(String jsonString, boolean isImplicit, boolean inBackground, String checksum) {
            this.jsonString = jsonString;
            this.isImplicit = isImplicit;
            this.inBackground = inBackground;
            this.checksum = checksum;
        }

        private Object readResolve() throws JSONException {
            return new AppEvent(this.jsonString, this.isImplicit, this.inBackground, this.checksum);
        }
    }

    static class SerializationProxyV1
    implements Serializable {
        private static final long serialVersionUID = -2488473066578201069L;
        private final String jsonString;
        private final boolean isImplicit;
        private final boolean inBackground;

        private SerializationProxyV1(String jsonString, boolean isImplicit, boolean inBackground) {
            this.jsonString = jsonString;
            this.isImplicit = isImplicit;
            this.inBackground = inBackground;
        }

        private Object readResolve() throws JSONException {
            return new AppEvent(this.jsonString, this.isImplicit, this.inBackground, null);
        }
    }
}

