/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import androidx.annotation.RestrictTo;
import com.facebook.AccessToken;
import com.facebook.FacebookSdk;
import com.facebook.internal.Utility;
import java.io.Serializable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AccessTokenAppIdPair
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String accessTokenString;
    private final String applicationId;

    public AccessTokenAppIdPair(AccessToken accessToken) {
        this(accessToken.getToken(), FacebookSdk.getApplicationId());
    }

    public AccessTokenAppIdPair(String accessTokenString, String applicationId) {
        this.accessTokenString = Utility.isNullOrEmpty(accessTokenString) ? null : accessTokenString;
        this.applicationId = applicationId;
    }

    public String getAccessTokenString() {
        return this.accessTokenString;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public int hashCode() {
        return (this.accessTokenString == null ? 0 : this.accessTokenString.hashCode()) ^ (this.applicationId == null ? 0 : this.applicationId.hashCode());
    }

    public boolean equals(Object o) {
        if (!(o instanceof AccessTokenAppIdPair)) {
            return false;
        }
        AccessTokenAppIdPair p = (AccessTokenAppIdPair)o;
        return Utility.areObjectsEqual(p.accessTokenString, this.accessTokenString) && Utility.areObjectsEqual(p.applicationId, this.applicationId);
    }

    private Object writeReplace() {
        return new SerializationProxyV1(this.accessTokenString, this.applicationId);
    }

    static class SerializationProxyV1
    implements Serializable {
        private static final long serialVersionUID = -2488473066578201069L;
        private final String accessTokenString;
        private final String appId;

        private SerializationProxyV1(String accessTokenString, String appId) {
            this.accessTokenString = accessTokenString;
            this.appId = appId;
        }

        private Object readResolve() {
            return new AccessTokenAppIdPair(this.accessTokenString, this.appId);
        }
    }
}

