/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.FacebookSdk;
import com.facebook.Profile;
import com.facebook.ProfileCache;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;

public final class ProfileManager {
    public static final String ACTION_CURRENT_PROFILE_CHANGED = "com.facebook.sdk.ACTION_CURRENT_PROFILE_CHANGED";
    public static final String EXTRA_OLD_PROFILE = "com.facebook.sdk.EXTRA_OLD_PROFILE";
    public static final String EXTRA_NEW_PROFILE = "com.facebook.sdk.EXTRA_NEW_PROFILE";
    private static volatile ProfileManager instance;
    private final LocalBroadcastManager localBroadcastManager;
    private final ProfileCache profileCache;
    private Profile currentProfile;

    ProfileManager(LocalBroadcastManager localBroadcastManager, ProfileCache profileCache) {
        Validate.notNull(localBroadcastManager, "localBroadcastManager");
        Validate.notNull(profileCache, "profileCache");
        this.localBroadcastManager = localBroadcastManager;
        this.profileCache = profileCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ProfileManager getInstance() {
        if (instance != null) return instance;
        Class<ProfileManager> clazz = ProfileManager.class;
        synchronized (ProfileManager.class) {
            if (instance != null) return instance;
            Context applicationContext = FacebookSdk.getApplicationContext();
            LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)applicationContext);
            instance = new ProfileManager(localBroadcastManager, new ProfileCache());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    Profile getCurrentProfile() {
        return this.currentProfile;
    }

    boolean loadCurrentProfile() {
        Profile profile = this.profileCache.load();
        if (profile != null) {
            this.setCurrentProfile(profile, false);
            return true;
        }
        return false;
    }

    void setCurrentProfile(@Nullable Profile currentProfile) {
        this.setCurrentProfile(currentProfile, true);
    }

    private void setCurrentProfile(@Nullable Profile currentProfile, boolean writeToCache) {
        Profile oldProfile = this.currentProfile;
        this.currentProfile = currentProfile;
        if (writeToCache) {
            if (currentProfile != null) {
                this.profileCache.save(currentProfile);
            } else {
                this.profileCache.clear();
            }
        }
        if (!Utility.areObjectsEqual(oldProfile, currentProfile)) {
            this.sendCurrentProfileChangedBroadcast(oldProfile, currentProfile);
        }
    }

    private void sendCurrentProfileChangedBroadcast(Profile oldProfile, Profile currentProfile) {
        Intent intent = new Intent(ACTION_CURRENT_PROFILE_CHANGED);
        intent.putExtra(EXTRA_OLD_PROFILE, (Parcelable)oldProfile);
        intent.putExtra(EXTRA_NEW_PROFILE, (Parcelable)currentProfile);
        this.localBroadcastManager.sendBroadcast(intent);
    }
}

