/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.AccessToken;
import com.facebook.AccessTokenCache;
import com.facebook.CurrentAccessTokenExpirationBroadcastReceiver;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONObject;

public final class AccessTokenManager {
    public static final String TAG = "AccessTokenManager";
    public static final String ACTION_CURRENT_ACCESS_TOKEN_CHANGED = "com.facebook.sdk.ACTION_CURRENT_ACCESS_TOKEN_CHANGED";
    public static final String EXTRA_OLD_ACCESS_TOKEN = "com.facebook.sdk.EXTRA_OLD_ACCESS_TOKEN";
    public static final String EXTRA_NEW_ACCESS_TOKEN = "com.facebook.sdk.EXTRA_NEW_ACCESS_TOKEN";
    public static final String SHARED_PREFERENCES_NAME = "com.facebook.AccessTokenManager.SharedPreferences";
    private static final int TOKEN_EXTEND_THRESHOLD_SECONDS = 86400;
    private static final int TOKEN_EXTEND_RETRY_SECONDS = 3600;
    private static final String TOKEN_EXTEND_GRAPH_PATH = "oauth/access_token";
    private static final String ME_PERMISSIONS_GRAPH_PATH = "me/permissions";
    private static volatile AccessTokenManager instance;
    private final LocalBroadcastManager localBroadcastManager;
    private final AccessTokenCache accessTokenCache;
    private AccessToken currentAccessToken;
    private AtomicBoolean tokenRefreshInProgress = new AtomicBoolean(false);
    private Date lastAttemptedTokenExtendDate = new Date(0L);

    AccessTokenManager(LocalBroadcastManager localBroadcastManager, AccessTokenCache accessTokenCache) {
        Validate.notNull(localBroadcastManager, "localBroadcastManager");
        Validate.notNull(accessTokenCache, "accessTokenCache");
        this.localBroadcastManager = localBroadcastManager;
        this.accessTokenCache = accessTokenCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static AccessTokenManager getInstance() {
        if (instance != null) return instance;
        Class<AccessTokenManager> clazz = AccessTokenManager.class;
        synchronized (AccessTokenManager.class) {
            if (instance != null) return instance;
            Context applicationContext = FacebookSdk.getApplicationContext();
            LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)applicationContext);
            AccessTokenCache accessTokenCache = new AccessTokenCache();
            instance = new AccessTokenManager(localBroadcastManager, accessTokenCache);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    AccessToken getCurrentAccessToken() {
        return this.currentAccessToken;
    }

    boolean loadCurrentAccessToken() {
        AccessToken accessToken = this.accessTokenCache.load();
        if (accessToken != null) {
            this.setCurrentAccessToken(accessToken, false);
            return true;
        }
        return false;
    }

    void setCurrentAccessToken(AccessToken currentAccessToken) {
        this.setCurrentAccessToken(currentAccessToken, true);
    }

    private void setCurrentAccessToken(AccessToken currentAccessToken, boolean saveToCache) {
        AccessToken oldAccessToken = this.currentAccessToken;
        this.currentAccessToken = currentAccessToken;
        this.tokenRefreshInProgress.set(false);
        this.lastAttemptedTokenExtendDate = new Date(0L);
        if (saveToCache) {
            if (currentAccessToken != null) {
                this.accessTokenCache.save(currentAccessToken);
            } else {
                this.accessTokenCache.clear();
                Utility.clearFacebookCookies(FacebookSdk.getApplicationContext());
            }
        }
        if (!Utility.areObjectsEqual(oldAccessToken, currentAccessToken)) {
            this.sendCurrentAccessTokenChangedBroadcastIntent(oldAccessToken, currentAccessToken);
            this.setTokenExpirationBroadcastAlarm();
        }
    }

    void currentAccessTokenChanged() {
        this.sendCurrentAccessTokenChangedBroadcastIntent(this.currentAccessToken, this.currentAccessToken);
    }

    private void sendCurrentAccessTokenChangedBroadcastIntent(AccessToken oldAccessToken, AccessToken currentAccessToken) {
        Intent intent = new Intent(FacebookSdk.getApplicationContext(), CurrentAccessTokenExpirationBroadcastReceiver.class);
        intent.setAction(ACTION_CURRENT_ACCESS_TOKEN_CHANGED);
        intent.putExtra(EXTRA_OLD_ACCESS_TOKEN, (Parcelable)oldAccessToken);
        intent.putExtra(EXTRA_NEW_ACCESS_TOKEN, (Parcelable)currentAccessToken);
        this.localBroadcastManager.sendBroadcast(intent);
    }

    private void setTokenExpirationBroadcastAlarm() {
        Context context = FacebookSdk.getApplicationContext();
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (!AccessToken.isCurrentAccessTokenActive() || accessToken.getExpires() == null || alarmManager == null) {
            return;
        }
        Intent intent = new Intent(context, CurrentAccessTokenExpirationBroadcastReceiver.class);
        intent.setAction(ACTION_CURRENT_ACCESS_TOKEN_CHANGED);
        PendingIntent alarmIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        try {
            alarmManager.set(1, accessToken.getExpires().getTime(), alarmIntent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void extendAccessTokenIfNeeded() {
        if (!this.shouldExtendAccessToken()) {
            return;
        }
        this.refreshCurrentAccessToken(null);
    }

    private boolean shouldExtendAccessToken() {
        if (this.currentAccessToken == null) {
            return false;
        }
        Long now = new Date().getTime();
        return this.currentAccessToken.getSource().canExtendToken() && now - this.lastAttemptedTokenExtendDate.getTime() > 3600000L && now - this.currentAccessToken.getLastRefresh().getTime() > 86400000L;
    }

    private static GraphRequest createGrantedPermissionsRequest(AccessToken accessToken, GraphRequest.Callback callback) {
        Bundle parameters = new Bundle();
        return new GraphRequest(accessToken, ME_PERMISSIONS_GRAPH_PATH, parameters, HttpMethod.GET, callback);
    }

    private static GraphRequest createExtendAccessTokenRequest(AccessToken accessToken, GraphRequest.Callback callback) {
        Bundle parameters = new Bundle();
        parameters.putString("grant_type", "fb_extend_sso_token");
        parameters.putString("client_id", accessToken.getApplicationId());
        return new GraphRequest(accessToken, TOKEN_EXTEND_GRAPH_PATH, parameters, HttpMethod.GET, callback);
    }

    void refreshCurrentAccessToken(final AccessToken.AccessTokenRefreshCallback callback) {
        if (Looper.getMainLooper().equals(Looper.myLooper())) {
            this.refreshCurrentAccessTokenImpl(callback);
        } else {
            Handler mainHandler = new Handler(Looper.getMainLooper());
            mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        AccessTokenManager.this.refreshCurrentAccessTokenImpl(callback);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
        }
    }

    private void refreshCurrentAccessTokenImpl(final AccessToken.AccessTokenRefreshCallback callback) {
        final AccessToken accessToken = this.currentAccessToken;
        if (accessToken == null) {
            if (callback != null) {
                callback.OnTokenRefreshFailed(new FacebookException("No current access token to refresh"));
            }
            return;
        }
        if (!this.tokenRefreshInProgress.compareAndSet(false, true)) {
            if (callback != null) {
                callback.OnTokenRefreshFailed(new FacebookException("Refresh already in progress"));
            }
            return;
        }
        this.lastAttemptedTokenExtendDate = new Date();
        final HashSet permissions = new HashSet();
        final HashSet declinedPermissions = new HashSet();
        final HashSet expiredPermissions = new HashSet();
        final AtomicBoolean permissionsCallSucceeded = new AtomicBoolean(false);
        final RefreshResult refreshResult = new RefreshResult();
        GraphRequestBatch batch = new GraphRequestBatch(AccessTokenManager.createGrantedPermissionsRequest(accessToken, new GraphRequest.Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                JSONObject result = response.getJSONObject();
                if (result == null) {
                    return;
                }
                JSONArray permissionsArray = result.optJSONArray("data");
                if (permissionsArray == null) {
                    return;
                }
                permissionsCallSucceeded.set(true);
                for (int i = 0; i < permissionsArray.length(); ++i) {
                    JSONObject permissionEntry = permissionsArray.optJSONObject(i);
                    if (permissionEntry == null) continue;
                    String permission2 = permissionEntry.optString("permission");
                    String status = permissionEntry.optString("status");
                    if (Utility.isNullOrEmpty(permission2) || Utility.isNullOrEmpty(status)) continue;
                    if ((status = status.toLowerCase(Locale.US)).equals("granted")) {
                        permissions.add(permission2);
                        continue;
                    }
                    if (status.equals("declined")) {
                        declinedPermissions.add(permission2);
                        continue;
                    }
                    if (status.equals("expired")) {
                        expiredPermissions.add(permission2);
                        continue;
                    }
                    Log.w((String)AccessTokenManager.TAG, (String)("Unexpected status: " + status));
                }
            }
        }), AccessTokenManager.createExtendAccessTokenRequest(accessToken, new GraphRequest.Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                JSONObject data = response.getJSONObject();
                if (data == null) {
                    return;
                }
                refreshResult.accessToken = data.optString("access_token");
                refreshResult.expiresAt = data.optInt("expires_at");
                refreshResult.dataAccessExpirationTime = data.optLong("data_access_expiration_time");
                refreshResult.graphDomain = data.optString("graph_domain", null);
            }
        }));
        batch.addCallback(new GraphRequestBatch.Callback(){

            @Override
            public void onBatchCompleted(GraphRequestBatch batch) {
                AccessToken newAccessToken;
                block11: {
                    block10: {
                        newAccessToken = null;
                        try {
                            if (AccessTokenManager.getInstance().getCurrentAccessToken() != null && AccessTokenManager.getInstance().getCurrentAccessToken().getUserId() == accessToken.getUserId()) break block10;
                            if (callback != null) {
                                callback.OnTokenRefreshFailed(new FacebookException("No current access token to refresh"));
                            }
                            AccessTokenManager.this.tokenRefreshInProgress.set(false);
                            if (callback != null && newAccessToken != null) {
                                callback.OnTokenRefreshed(newAccessToken);
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            AccessTokenManager.this.tokenRefreshInProgress.set(false);
                            if (callback != null && newAccessToken != null) {
                                callback.OnTokenRefreshed(newAccessToken);
                            }
                            throw throwable;
                        }
                    }
                    if (permissionsCallSucceeded.get() || refreshResult.accessToken != null || refreshResult.expiresAt != 0) break block11;
                    if (callback != null) {
                        callback.OnTokenRefreshFailed(new FacebookException("Failed to refresh access token"));
                    }
                    AccessTokenManager.this.tokenRefreshInProgress.set(false);
                    if (callback != null && newAccessToken != null) {
                        callback.OnTokenRefreshed(newAccessToken);
                    }
                    return;
                }
                newAccessToken = new AccessToken(refreshResult.accessToken != null ? refreshResult.accessToken : accessToken.getToken(), accessToken.getApplicationId(), accessToken.getUserId(), permissionsCallSucceeded.get() ? permissions : accessToken.getPermissions(), permissionsCallSucceeded.get() ? declinedPermissions : accessToken.getDeclinedPermissions(), permissionsCallSucceeded.get() ? expiredPermissions : accessToken.getExpiredPermissions(), accessToken.getSource(), refreshResult.expiresAt != 0 ? new Date((long)refreshResult.expiresAt * 1000L) : accessToken.getExpires(), new Date(), refreshResult.dataAccessExpirationTime != null ? new Date(refreshResult.dataAccessExpirationTime * 1000L) : accessToken.getDataAccessExpirationTime(), refreshResult.graphDomain);
                AccessTokenManager.getInstance().setCurrentAccessToken(newAccessToken);
                AccessTokenManager.this.tokenRefreshInProgress.set(false);
                if (callback != null && newAccessToken != null) {
                    callback.OnTokenRefreshed(newAccessToken);
                }
            }
        });
        batch.executeAsync();
    }

    private static class RefreshResult {
        public String accessToken;
        public int expiresAt;
        public Long dataAccessExpirationTime;
        public String graphDomain;

        private RefreshResult() {
        }
    }
}

