/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Handler;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestAsyncTask;
import com.facebook.GraphResponse;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class GraphRequestBatch
extends AbstractList<GraphRequest> {
    private static AtomicInteger idGenerator = new AtomicInteger();
    private Handler callbackHandler;
    private List<GraphRequest> requests = new ArrayList<GraphRequest>();
    private int timeoutInMilliseconds = 0;
    private final String id = Integer.valueOf(idGenerator.incrementAndGet()).toString();
    private List<Callback> callbacks = new ArrayList<Callback>();
    private String batchApplicationId;

    public GraphRequestBatch() {
        this.requests = new ArrayList<GraphRequest>();
    }

    public GraphRequestBatch(Collection<GraphRequest> requests) {
        this.requests = new ArrayList<GraphRequest>(requests);
    }

    public GraphRequestBatch(GraphRequest ... requests) {
        this.requests = Arrays.asList(requests);
    }

    public GraphRequestBatch(GraphRequestBatch requests) {
        this.requests = new ArrayList<GraphRequest>(requests);
        this.callbackHandler = requests.callbackHandler;
        this.timeoutInMilliseconds = requests.timeoutInMilliseconds;
        this.callbacks = new ArrayList<Callback>(requests.callbacks);
    }

    public int getTimeout() {
        return this.timeoutInMilliseconds;
    }

    public void setTimeout(int timeoutInMilliseconds) {
        if (timeoutInMilliseconds < 0) {
            throw new IllegalArgumentException("Argument timeoutInMilliseconds must be >= 0.");
        }
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public void addCallback(Callback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        }
    }

    public void removeCallback(Callback callback) {
        this.callbacks.remove(callback);
    }

    @Override
    public final boolean add(GraphRequest request) {
        return this.requests.add(request);
    }

    @Override
    public final void add(int location, GraphRequest request) {
        this.requests.add(location, request);
    }

    @Override
    public final void clear() {
        this.requests.clear();
    }

    @Override
    public final GraphRequest get(int i) {
        return this.requests.get(i);
    }

    @Override
    public final GraphRequest remove(int location) {
        return this.requests.remove(location);
    }

    @Override
    public final GraphRequest set(int location, GraphRequest request) {
        return this.requests.set(location, request);
    }

    @Override
    public final int size() {
        return this.requests.size();
    }

    final String getId() {
        return this.id;
    }

    final Handler getCallbackHandler() {
        return this.callbackHandler;
    }

    final void setCallbackHandler(Handler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    final List<GraphRequest> getRequests() {
        return this.requests;
    }

    final List<Callback> getCallbacks() {
        return this.callbacks;
    }

    public final String getBatchApplicationId() {
        return this.batchApplicationId;
    }

    public final void setBatchApplicationId(String batchApplicationId) {
        this.batchApplicationId = batchApplicationId;
    }

    public final List<GraphResponse> executeAndWait() {
        return this.executeAndWaitImpl();
    }

    public final GraphRequestAsyncTask executeAsync() {
        return this.executeAsyncImpl();
    }

    List<GraphResponse> executeAndWaitImpl() {
        return GraphRequest.executeBatchAndWait(this);
    }

    GraphRequestAsyncTask executeAsyncImpl() {
        return GraphRequest.executeBatchAsync(this);
    }

    public static interface OnProgressCallback
    extends Callback {
        public void onBatchProgress(GraphRequestBatch var1, long var2, long var4);
    }

    public static interface Callback {
        public void onBatchCompleted(GraphRequestBatch var1);
    }
}

