/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument;

import android.os.Build;
import androidx.annotation.RestrictTo;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u0000 -2\u00020\u0001:\u0003,-.B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0012\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001b\b\u0012\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rB\u000f\b\u0012\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010%\u001a\u00020&J\u0011\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010*\u001a\u00020&J\b\u0010+\u001a\u00020\u000bH\u0016R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0014R\u0010\u0010 \u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/facebook/internal/instrument/InstrumentData;", "", "features", "Lorg/json/JSONArray;", "(Lorg/json/JSONArray;)V", "e", "", "t", "Lcom/facebook/internal/instrument/InstrumentData$Type;", "(Ljava/lang/Throwable;Lcom/facebook/internal/instrument/InstrumentData$Type;)V", "anrCause", "", "st", "(Ljava/lang/String;Ljava/lang/String;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "analysisReportParameters", "Lorg/json/JSONObject;", "getAnalysisReportParameters", "()Lorg/json/JSONObject;", "appVersion", "cause", "exceptionReportParameters", "getExceptionReportParameters", "featureNames", "filename", "isValid", "", "()Z", "parameters", "getParameters", "stackTrace", "timestamp", "", "Ljava/lang/Long;", "type", "clear", "", "compareTo", "", "data", "save", "toString", "Builder", "Companion", "Type", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InstrumentData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String filename;
    @Nullable
    private Type type;
    @Nullable
    private JSONArray featureNames;
    @Nullable
    private String appVersion;
    @Nullable
    private String cause;
    @Nullable
    private String stackTrace;
    @Nullable
    private Long timestamp;
    @NotNull
    private static final String UNKNOWN = "Unknown";
    @NotNull
    private static final String PARAM_TIMESTAMP = "timestamp";
    @NotNull
    private static final String PARAM_APP_VERSION = "app_version";
    @NotNull
    private static final String PARAM_DEVICE_OS = "device_os_version";
    @NotNull
    private static final String PARAM_DEVICE_MODEL = "device_model";
    @NotNull
    private static final String PARAM_REASON = "reason";
    @NotNull
    private static final String PARAM_CALLSTACK = "callstack";
    @NotNull
    private static final String PARAM_TYPE = "type";
    @NotNull
    private static final String PARAM_FEATURE_NAMES = "feature_names";

    private InstrumentData(JSONArray features) {
        this.type = Type.Analysis;
        this.timestamp = System.currentTimeMillis() / (long)1000;
        this.featureNames = features;
        String string = new StringBuffer().append("analysis_log_").append(String.valueOf(this.timestamp)).append(".json").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuffer()\n            .append(InstrumentUtility.ANALYSIS_REPORT_PREFIX)\n            .append(timestamp.toString())\n            .append(\".json\")\n            .toString()");
        this.filename = string;
    }

    private InstrumentData(Throwable e, Type t) {
        this.type = t;
        this.appVersion = Utility.INSTANCE.getAppVersion();
        this.cause = InstrumentUtility.getCause(e);
        this.stackTrace = InstrumentUtility.getStackTrace(e);
        this.timestamp = System.currentTimeMillis() / (long)1000;
        String string = new StringBuffer().append(t.getLogPrefix()).append(String.valueOf(this.timestamp)).append(".json").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuffer().append(t.logPrefix).append(timestamp.toString()).append(\".json\").toString()");
        this.filename = string;
    }

    private InstrumentData(String anrCause, String st) {
        this.type = Type.AnrReport;
        this.appVersion = Utility.INSTANCE.getAppVersion();
        this.cause = anrCause;
        this.stackTrace = st;
        this.timestamp = System.currentTimeMillis() / (long)1000;
        String string = new StringBuffer().append("anr_log_").append(String.valueOf(this.timestamp)).append(".json").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuffer()\n            .append(InstrumentUtility.ANR_REPORT_PREFIX)\n            .append(timestamp.toString())\n            .append(\".json\")\n            .toString()");
        this.filename = string;
    }

    private InstrumentData(File file) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        this.filename = string;
        this.type = InstrumentData.Companion.getType(this.filename);
        JSONObject obj = InstrumentUtility.readFile(this.filename, true);
        if (obj != null) {
            this.timestamp = obj.optLong(PARAM_TIMESTAMP, 0L);
            this.appVersion = obj.optString(PARAM_APP_VERSION, null);
            this.cause = obj.optString(PARAM_REASON, null);
            this.stackTrace = obj.optString(PARAM_CALLSTACK, null);
            this.featureNames = obj.optJSONArray(PARAM_FEATURE_NAMES);
        }
    }

    public final int compareTo(@NotNull InstrumentData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Long l = this.timestamp;
        if (l == null) {
            return -1;
        }
        long ts = l;
        Long l2 = data.timestamp;
        if (l2 == null) {
            return 1;
        }
        long dts = l2;
        return Intrinsics.compare((long)dts, (long)ts);
    }

    public final boolean isValid() {
        boolean bl;
        Type type = this.type;
        int n = type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
        switch (n) {
            case 1: {
                if (this.featureNames != null && this.timestamp != null) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (this.stackTrace != null && this.cause != null && this.timestamp != null) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (this.stackTrace != null && this.timestamp != null) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public final void save() {
        if (!this.isValid()) {
            return;
        }
        InstrumentUtility.writeFile(this.filename, this.toString());
    }

    public final void clear() {
        InstrumentUtility.deleteFile(this.filename);
    }

    @NotNull
    public String toString() {
        Object object = this.getParameters();
        if (object == null) {
            String string = new JSONObject().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONObject().toString()");
            return string;
        }
        JSONObject params = object;
        object = params.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"params.toString()");
        return object;
    }

    private final JSONObject getParameters() {
        JSONObject jSONObject;
        Type type = this.type;
        int n = type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
        switch (n) {
            case 1: {
                jSONObject = this.getAnalysisReportParameters();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                jSONObject = this.getExceptionReportParameters();
                break;
            }
            default: {
                jSONObject = null;
            }
        }
        return jSONObject;
    }

    private final JSONObject getAnalysisReportParameters() {
        JSONObject obj = new JSONObject();
        try {
            if (this.featureNames != null) {
                obj.put(PARAM_FEATURE_NAMES, (Object)this.featureNames);
            }
            if (this.timestamp != null) {
                obj.put(PARAM_TIMESTAMP, (Object)this.timestamp);
            }
            return obj;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    private final JSONObject getExceptionReportParameters() {
        JSONObject obj = new JSONObject();
        try {
            obj.put(PARAM_DEVICE_OS, (Object)Build.VERSION.RELEASE);
            obj.put(PARAM_DEVICE_MODEL, (Object)Build.MODEL);
            if (this.appVersion != null) {
                obj.put(PARAM_APP_VERSION, (Object)this.appVersion);
            }
            if (this.timestamp != null) {
                obj.put(PARAM_TIMESTAMP, (Object)this.timestamp);
            }
            if (this.cause != null) {
                obj.put(PARAM_REASON, (Object)this.cause);
            }
            if (this.stackTrace != null) {
                obj.put(PARAM_CALLSTACK, (Object)this.stackTrace);
            }
            if (this.type != null) {
                obj.put(PARAM_TYPE, (Object)this.type);
            }
            return obj;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public /* synthetic */ InstrumentData(File file, DefaultConstructorMarker $constructor_marker) {
        this(file);
    }

    public /* synthetic */ InstrumentData(Throwable e, Type t, DefaultConstructorMarker $constructor_marker) {
        this(e, t);
    }

    public /* synthetic */ InstrumentData(JSONArray features, DefaultConstructorMarker $constructor_marker) {
        this(features);
    }

    public /* synthetic */ InstrumentData(String anrCause, String st, DefaultConstructorMarker $constructor_marker) {
        this(anrCause, st);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/facebook/internal/instrument/InstrumentData$Type;", "", "(Ljava/lang/String;I)V", "logPrefix", "", "getLogPrefix", "()Ljava/lang/String;", "toString", "Unknown", "Analysis", "AnrReport", "CrashReport", "CrashShield", "ThreadCheck", "facebook-core_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type Unknown = new Type();
        public static final /* enum */ Type Analysis = new Type();
        public static final /* enum */ Type AnrReport = new Type();
        public static final /* enum */ Type CrashReport = new Type();
        public static final /* enum */ Type CrashShield = new Type();
        public static final /* enum */ Type ThreadCheck = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        @NotNull
        public String toString() {
            String string;
            Type type = this;
            int n = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
            switch (n) {
                case 1: {
                    string = "Analysis";
                    break;
                }
                case 2: {
                    string = "AnrReport";
                    break;
                }
                case 3: {
                    string = "CrashReport";
                    break;
                }
                case 4: {
                    string = "CrashShield";
                    break;
                }
                case 5: {
                    string = "ThreadCheck";
                    break;
                }
                default: {
                    string = InstrumentData.UNKNOWN;
                }
            }
            return string;
        }

        @NotNull
        public final String getLogPrefix() {
            String string;
            Type type = this;
            int n = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
            switch (n) {
                case 1: {
                    string = "analysis_log_";
                    break;
                }
                case 2: {
                    string = "anr_log_";
                    break;
                }
                case 3: {
                    string = "crash_log_";
                    break;
                }
                case 4: {
                    string = "shield_log_";
                    break;
                }
                case 5: {
                    string = "thread_check_log_";
                    break;
                }
                default: {
                    string = InstrumentData.UNKNOWN;
                }
            }
            return string;
        }

        public static Type[] values() {
            Type[] typeArray = $VALUES;
            return Arrays.copyOf(typeArray, typeArray.length);
        }

        public static Type valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.Unknown, Type.Analysis, Type.AnrReport, Type.CrashReport, Type.CrashShield, Type.ThreadCheck};
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Type.values().length];
                nArray[Type.Analysis.ordinal()] = 1;
                nArray[Type.AnrReport.ordinal()] = 2;
                nArray[Type.CrashReport.ordinal()] = 3;
                nArray[Type.CrashShield.ordinal()] = 4;
                nArray[Type.ThreadCheck.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/facebook/internal/instrument/InstrumentData$Builder;", "", "()V", "build", "Lcom/facebook/internal/instrument/InstrumentData;", "anrCause", "", "st", "e", "", "t", "Lcom/facebook/internal/instrument/InstrumentData$Type;", "features", "Lorg/json/JSONArray;", "load", "file", "Ljava/io/File;", "facebook-core_release"})
    public static final class Builder {
        @NotNull
        public static final Builder INSTANCE = new Builder();

        private Builder() {
        }

        @JvmStatic
        @NotNull
        public static final InstrumentData load(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new InstrumentData(file, null);
        }

        @JvmStatic
        @NotNull
        public static final InstrumentData build(@Nullable Throwable e, @NotNull Type t) {
            Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
            return new InstrumentData(e, t, null);
        }

        @JvmStatic
        @NotNull
        public static final InstrumentData build(@NotNull JSONArray features) {
            Intrinsics.checkNotNullParameter((Object)features, (String)"features");
            return new InstrumentData(features, null);
        }

        @JvmStatic
        @NotNull
        public static final InstrumentData build(@Nullable String anrCause, @Nullable String st) {
            return new InstrumentData(anrCause, st, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/internal/instrument/InstrumentData$Companion;", "", "()V", "PARAM_APP_VERSION", "", "PARAM_CALLSTACK", "PARAM_DEVICE_MODEL", "PARAM_DEVICE_OS", "PARAM_FEATURE_NAMES", "PARAM_REASON", "PARAM_TIMESTAMP", "PARAM_TYPE", "UNKNOWN", "getType", "Lcom/facebook/internal/instrument/InstrumentData$Type;", "filename", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Type getType(String filename) {
            if (StringsKt.startsWith$default((String)filename, (String)"crash_log_", (boolean)false, (int)2, null)) {
                return Type.CrashReport;
            }
            if (StringsKt.startsWith$default((String)filename, (String)"shield_log_", (boolean)false, (int)2, null)) {
                return Type.CrashShield;
            }
            if (StringsKt.startsWith$default((String)filename, (String)"thread_check_log_", (boolean)false, (int)2, null)) {
                return Type.ThreadCheck;
            }
            if (StringsKt.startsWith$default((String)filename, (String)"analysis_log_", (boolean)false, (int)2, null)) {
                return Type.Analysis;
            }
            if (StringsKt.startsWith$default((String)filename, (String)"anr_log_", (boolean)false, (int)2, null)) {
                return Type.AnrReport;
            }
            return Type.Unknown;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            nArray[Type.Analysis.ordinal()] = 1;
            nArray[Type.AnrReport.ordinal()] = 2;
            nArray[Type.CrashReport.ordinal()] = 3;
            nArray[Type.CrashShield.ordinal()] = 4;
            nArray[Type.ThreadCheck.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

