/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcel;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import android.view.autofill.AutofillManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.appevents.UserDataStore;
import com.facebook.appevents.internal.AppLinkManager;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.ProfileInformationCache;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009a\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u00e2\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010\u00042\u0006\u0010@\u001a\u00020AH\u0002J \u0010B\u001a\u00020;2\u0006\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020>2\u0006\u0010@\u001a\u00020AH\u0002J'\u0010C\u001a\u00020*\"\u0004\b\u0000\u0010D2\b\u0010E\u001a\u0004\u0018\u0001HD2\b\u0010F\u001a\u0004\u0018\u0001HDH\u0007\u00a2\u0006\u0002\u0010GJ\u0012\u0010H\u001a\u0004\u0018\u00010\"2\u0006\u0010I\u001a\u00020\u0004H\u0007J&\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010\u00042\b\u0010M\u001a\u0004\u0018\u00010\u00042\b\u0010N\u001a\u0004\u0018\u00010OH\u0007J\u0018\u0010P\u001a\u00020;2\u0006\u0010@\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u0004H\u0002J\u0010\u0010R\u001a\u00020;2\u0006\u0010@\u001a\u00020AH\u0007J\u0012\u0010S\u001a\u00020;2\b\u0010T\u001a\u0004\u0018\u00010UH\u0007J\u001e\u0010V\u001a\u0004\u0018\u00010\u00042\b\u0010W\u001a\u0004\u0018\u00010\u00042\b\u0010X\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010Y\u001a\u00020\u00132\u0006\u0010Z\u001a\u00020[H\u0002J&\u0010\\\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0018\u00010]j\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001`^2\b\u0010_\u001a\u0004\u0018\u00010`H\u0007J\u0016\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00040b2\u0006\u0010_\u001a\u00020`H\u0007J\u001c\u0010c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010d2\u0006\u0010e\u001a\u00020\"H\u0007J\u001c\u0010f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040d2\u0006\u0010e\u001a\u00020\"H\u0007J\u001a\u0010g\u001a\u00020\u00062\b\u0010h\u001a\u0004\u0018\u00010i2\u0006\u0010j\u001a\u00020kH\u0007J\u0012\u0010l\u001a\u00020;2\b\u0010m\u001a\u0004\u0018\u00010nH\u0007J\b\u0010o\u001a\u00020*H\u0002J\u0010\u0010p\u001a\u00020\u00042\u0006\u0010q\u001a\u00020\u0006H\u0007J\u0012\u0010r\u001a\u00020\u00042\b\u0010@\u001a\u0004\u0018\u00010AH\u0007J\u0010\u0010s\u001a\u00020\u00042\u0006\u0010@\u001a\u00020AH\u0007J\n\u0010t\u001a\u0004\u0018\u00010\u0004H\u0007J&\u0010u\u001a\u0004\u0018\u00010v2\b\u0010w\u001a\u0004\u0018\u00010O2\b\u0010x\u001a\u0004\u0018\u00010\u00042\u0006\u0010y\u001a\u00020vH\u0007J\u0010\u0010z\u001a\u00020\u00132\u0006\u0010{\u001a\u00020KH\u0007J\n\u0010|\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010}\u001a\u00020\u00042\b\u0010~\u001a\u0004\u0018\u00010\u0004H\u0007J\u0011\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010I\u001a\u00020\u0004H\u0002J\u001b\u0010\u0081\u0001\u001a\u00020;2\u0006\u0010I\u001a\u00020\u00042\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0007J\u0013\u0010\u0084\u0001\u001a\u00020\u00042\b\u0010@\u001a\u0004\u0018\u00010AH\u0007JM\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00012\f\u0010\u0087\u0001\u001a\u0007\u0012\u0002\b\u00030\u0088\u00012\u0007\u0010\u0089\u0001\u001a\u00020\u00042\"\u0010\u008a\u0001\u001a\u0012\u0012\r\b\u0001\u0012\t\u0012\u0002\b\u0003\u0018\u00010\u0088\u00010\u008b\u0001\"\t\u0012\u0002\b\u0003\u0018\u00010\u0088\u0001H\u0007\u00a2\u0006\u0003\u0010\u008c\u0001JH\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00012\u0007\u0010\u008d\u0001\u001a\u00020\u00042\u0007\u0010\u0089\u0001\u001a\u00020\u00042\"\u0010\u008a\u0001\u001a\u0012\u0012\r\b\u0001\u0012\t\u0012\u0002\b\u0003\u0018\u00010\u0088\u00010\u008b\u0001\"\t\u0012\u0002\b\u0003\u0018\u00010\u0088\u0001H\u0007\u00a2\u0006\u0003\u0010\u008e\u0001J\u0014\u0010\u008f\u0001\u001a\u00020\u00042\t\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0004H\u0002J(\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u0010e\u001a\u00020\"2\b\u0010x\u001a\u0004\u0018\u00010\u00042\t\u0010\u0092\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J\u0016\u0010\u0093\u0001\u001a\u0004\u0018\u00010\u00042\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010KH\u0007J\u001c\u0010\u0095\u0001\u001a\u00020\u00042\b\u0010\u0096\u0001\u001a\u00030\u0097\u00012\u0007\u0010Z\u001a\u00030\u0098\u0001H\u0002J\u001d\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u00042\u0007\u0010\u009a\u0001\u001a\u00020\u00042\u0007\u0010Z\u001a\u00030\u0098\u0001H\u0002J\u001c\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u00042\u0007\u0010\u009a\u0001\u001a\u00020\u00042\u0006\u0010x\u001a\u00020\u0004H\u0002J@\u0010\u009b\u0001\u001a\u0004\u0018\u00010\u00012\t\u0010\u009c\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010\u009d\u0001\u001a\u00030\u0086\u00012\u0018\u0010\u009e\u0001\u001a\r\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u008b\u0001\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0003\u0010\u009f\u0001J\u0011\u0010\u00a0\u0001\u001a\u00020*2\u0006\u0010@\u001a\u00020AH\u0007J\u0011\u0010\u00a1\u0001\u001a\u00020*2\u0006\u0010@\u001a\u00020AH\u0007J\u0014\u0010\u00a2\u0001\u001a\u00020*2\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010KH\u0007J\u0015\u0010\u00a3\u0001\u001a\u00020*2\n\u0010\u00a4\u0001\u001a\u0005\u0018\u00010\u00a5\u0001H\u0007J\u0014\u0010\u00a6\u0001\u001a\u00020*2\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010KH\u0007J\u0011\u0010\u00a7\u0001\u001a\u00020*2\u0006\u0010@\u001a\u00020AH\u0002J\u0013\u0010\u00a8\u0001\u001a\u00020*2\b\u0010W\u001a\u0004\u0018\u00010\u0004H\u0007J\u0019\u0010\u00a8\u0001\u001a\u00020*2\u000e\u0010\u00a9\u0001\u001a\t\u0012\u0002\b\u0003\u0018\u00010\u00aa\u0001H\u0007J\u0014\u0010\u00ab\u0001\u001a\u00020*2\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010KH\u0007J\u0018\u0010\u00ac\u0001\u001a\t\u0012\u0004\u0012\u00020\u00040\u00ad\u00012\u0006\u0010_\u001a\u00020`H\u0007J\u0017\u0010\u00ae\u0001\u001a\b\u0012\u0004\u0012\u00020\u00040b2\u0006\u0010_\u001a\u00020`H\u0007J\u001e\u0010\u00af\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040d2\u0007\u0010\u00b0\u0001\u001a\u00020\u0004H\u0007J'\u0010\u00b1\u0001\u001a\u00020;2\t\u0010\u00b2\u0001\u001a\u0004\u0018\u00010\u00042\u0011\u0010\u00b3\u0001\u001a\f\u0018\u00010\u00b4\u0001j\u0005\u0018\u0001`\u00b5\u0001H\u0007J\u001f\u0010\u00b1\u0001\u001a\u00020;2\t\u0010\u00b2\u0001\u001a\u0004\u0018\u00010\u00042\t\u0010\u00b6\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J+\u0010\u00b1\u0001\u001a\u00020;2\t\u0010\u00b2\u0001\u001a\u0004\u0018\u00010\u00042\t\u0010\u00b6\u0001\u001a\u0004\u0018\u00010\u00042\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00b8\u0001H\u0007J\"\u0010\u00b9\u0001\u001a\u00020\u00042\u0017\u0010\u00ba\u0001\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040dH\u0007J\u0013\u0010\u00bb\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010x\u001a\u00020\u0004H\u0007J\u0011\u0010\u00bc\u0001\u001a\u00020*2\u0006\u0010@\u001a\u00020AH\u0007J\u0014\u0010\u00bd\u0001\u001a\u00020O2\t\u0010\u00be\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J.\u0010\u00bf\u0001\u001a\u00020;2\u0006\u0010F\u001a\u00020O2\b\u0010x\u001a\u0004\u0018\u00010\u00042\u0011\u0010\u00c0\u0001\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010bH\u0007J&\u0010\u00c1\u0001\u001a\u00020*2\u0006\u0010w\u001a\u00020O2\b\u0010x\u001a\u0004\u0018\u00010\u00042\t\u0010\u00c2\u0001\u001a\u0004\u0018\u00010\u0001H\u0007J&\u0010\u00c3\u0001\u001a\u00020;2\u0006\u0010F\u001a\u00020O2\b\u0010x\u001a\u0004\u0018\u00010\u00042\t\u0010\u00c2\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J&\u0010\u00c4\u0001\u001a\u00020;2\u0006\u0010F\u001a\u00020O2\b\u0010x\u001a\u0004\u0018\u00010\u00042\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010KH\u0007J!\u0010\u00c5\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010d2\b\u0010\u00c6\u0001\u001a\u00030\u00c7\u0001H\u0007J\u0013\u0010\u00c8\u0001\u001a\u00020\u00042\b\u0010h\u001a\u0004\u0018\u00010iH\u0007J%\u0010\u00c9\u0001\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010d2\b\u0010\u00c6\u0001\u001a\u00030\u00c7\u0001H\u0007J\t\u0010\u00ca\u0001\u001a\u00020;H\u0002J\t\u0010\u00cb\u0001\u001a\u00020\u0006H\u0002J\u0012\u0010\u00cc\u0001\u001a\u00020;2\u0007\u0010\u00cd\u0001\u001a\u00020AH\u0002J\u0012\u0010\u00ce\u0001\u001a\u00020;2\u0007\u0010\u00cd\u0001\u001a\u00020AH\u0002J\t\u0010\u00cf\u0001\u001a\u00020;H\u0002J\t\u0010\u00d0\u0001\u001a\u00020;H\u0002J\u0015\u0010\u00d1\u0001\u001a\u00020;2\n\u0010\u00d2\u0001\u001a\u0005\u0018\u00010\u00d3\u0001H\u0007J\u001f\u0010\u00d4\u0001\u001a\u00020\u00042\t\u0010\u00d5\u0001\u001a\u0004\u0018\u00010\"2\t\u0010\u00d6\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J6\u0010\u00d7\u0001\u001a\u00020;2\u0006\u0010<\u001a\u00020\"2\b\u0010=\u001a\u0004\u0018\u00010>2\b\u0010?\u001a\u0004\u0018\u00010\u00042\u0007\u0010\u00d8\u0001\u001a\u00020*2\u0006\u0010@\u001a\u00020AH\u0007J\u001a\u0010\u00d9\u0001\u001a\u00020;2\u0006\u0010<\u001a\u00020\"2\u0007\u0010\u00cd\u0001\u001a\u00020AH\u0007J\u0014\u0010\u00da\u0001\u001a\u0004\u0018\u00010\u00042\u0007\u0010Z\u001a\u00030\u0098\u0001H\u0007J\u0013\u0010\u00da\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010x\u001a\u00020\u0004H\u0007J\u0016\u0010\u00db\u0001\u001a\u0004\u0018\u00010\u00042\t\u0010Z\u001a\u0005\u0018\u00010\u0098\u0001H\u0007J\u0015\u0010\u00db\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010x\u001a\u0004\u0018\u00010\u0004H\u0007J\u001d\u0010\u00dc\u0001\u001a\u00020*2\b\u0010E\u001a\u0004\u0018\u00010\u00042\b\u0010F\u001a\u0004\u0018\u00010\u0004H\u0007J!\u0010\u00dd\u0001\u001a\u0004\u0018\u00010`2\t\u0010\u00d5\u0001\u001a\u0004\u0018\u00010\"2\t\u0010\u00de\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J!\u0010\u00df\u0001\u001a\u0004\u0018\u00010\"2\t\u0010\u00d5\u0001\u001a\u0004\u0018\u00010\"2\t\u0010\u00de\u0001\u001a\u0004\u0018\u00010\u0004H\u0007J*\u0010\u00e0\u0001\u001a\u00020;2\b\u0010\u00c6\u0001\u001a\u00030\u00c7\u00012\u0015\u0010\u00ba\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010dH\u0007J.\u0010\u00e1\u0001\u001a\u00020;2\b\u0010\u00c6\u0001\u001a\u00030\u00c7\u00012\u0019\u0010\u00ba\u0001\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010dH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8G\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\"8G\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001a\"\u0004\b'\u0010\u001cR\u000e\u0010(\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020*8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010\u0002\u001a\u0004\b)\u0010,R\u0011\u0010-\u001a\u00020*8G\u00a2\u0006\u0006\u001a\u0004\b-\u0010,R\u001c\u0010.\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010 \"\u0004\b0\u00101R\u000e\u00102\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u00103\u001a\u0004\u0018\u00010\u001e8G\u00a2\u0006\u0006\u001a\u0004\b4\u0010 R\u000e\u00105\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00107\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u001a\"\u0004\b9\u0010\u001c\u00a8\u0006\u00e3\u0001"}, d2={"Lcom/facebook/internal/Utility;", "", "()V", "ARC_DEVICE_PATTERN", "", "DEFAULT_STREAM_BUFFER_SIZE", "", "EXTRA_APP_EVENTS_INFO_FORMAT_VERSION", "FACEBOOK_PROFILE_FIELDS", "HASH_ALGORITHM_MD5", "HASH_ALGORITHM_SHA1", "HASH_ALGORITHM_SHA256", "INSTAGRAM_PROFILE_FIELDS", "LOG_TAG", "NO_CARRIER", "REFRESH_TIME_FOR_EXTENDED_DEVICE_INFO_MILLIS", "URL_SCHEME", "UTF8", "availableExternalStorageGB", "", "getAvailableExternalStorageGB", "()J", "setAvailableExternalStorageGB", "(J)V", "carrierName", "getCarrierName", "()Ljava/lang/String;", "setCarrierName", "(Ljava/lang/String;)V", "currentLocale", "Ljava/util/Locale;", "getCurrentLocale", "()Ljava/util/Locale;", "dataProcessingOptions", "Lorg/json/JSONObject;", "getDataProcessingOptions", "()Lorg/json/JSONObject;", "deviceTimeZoneName", "getDeviceTimeZoneName", "setDeviceTimeZoneName", "deviceTimezoneAbbreviation", "isAutoAppLinkSetup", "", "isAutoAppLinkSetup$annotations", "()Z", "isDataProcessingRestricted", "locale", "getLocale", "setLocale", "(Ljava/util/Locale;)V", "numCPUCores", "resourceLocale", "getResourceLocale", "timestampOfLastCheck", "totalExternalStorageGB", "versionName", "getVersionName", "setVersionName", "appendAnonIdUnderCompliance", "", "params", "attributionIdentifiers", "Lcom/facebook/internal/AttributionIdentifiers;", "anonymousAppDeviceGUID", "context", "Landroid/content/Context;", "appendAttributionIdUnderCompliance", "areObjectsEqual", "T", "a", "b", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "awaitGetGraphMeRequestWithCache", "accessToken", "buildUri", "Landroid/net/Uri;", "authority", "path", "parameters", "Landroid/os/Bundle;", "clearCookiesForDomain", "domain", "clearFacebookCookies", "closeQuietly", "closeable", "Ljava/io/Closeable;", "coerceValueIfNullOrEmpty", "s", "valueIfNullOrEmpty", "convertBytesToGB", "bytes", "", "convertJSONArrayToHashSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "jsonArray", "Lorg/json/JSONArray;", "convertJSONArrayToList", "", "convertJSONObjectToHashMap", "", "jsonObject", "convertJSONObjectToStringMap", "copyAndCloseInputStream", "inputStream", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "disconnectQuietly", "connection", "Ljava/net/URLConnection;", "externalStorageExists", "generateRandomString", "length", "getActivityName", "getAppName", "getAppVersion", "getBundleLongAsDate", "Ljava/util/Date;", "bundle", "key", "dateBase", "getContentSize", "contentUri", "getCurrentTokenDomainWithDefault", "getGraphDomainFromTokenDomain", "tokenGraphDomain", "getGraphMeRequestWithCache", "Lcom/facebook/GraphRequest;", "getGraphMeRequestWithCacheAsync", "callback", "Lcom/facebook/internal/Utility$GraphMeRequestWithCacheCallback;", "getMetadataApplicationId", "getMethodQuietly", "Ljava/lang/reflect/Method;", "clazz", "Ljava/lang/Class;", "methodName", "parameterTypes", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "className", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "getProfileFieldsForGraphDomain", "graphDomain", "getStringPropertyAsJSON", "nonJSONPropertyKey", "getUriString", "uri", "hashBytes", "hash", "Ljava/security/MessageDigest;", "", "hashWithAlgorithm", "algorithm", "invokeMethodQuietly", "receiver", "method", "args", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "isAutofillAvailable", "isChromeOS", "isContentUri", "isCurrentAccessToken", "token", "Lcom/facebook/AccessToken;", "isFileUri", "isGooglePlayServicesAvailable", "isNullOrEmpty", "c", "", "isWebUri", "jsonArrayToSet", "", "jsonArrayToStringList", "jsonStrToMap", "str", "logd", "tag", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "t", "", "mapToJsonStr", "map", "md5hash", "mustFixWindowParamsForAutofill", "parseUrlQueryString", "queryString", "putCommaSeparatedStringList", "list", "putJSONValueInBundle", "value", "putNonEmptyString", "putUri", "readNonnullStringMapFromParcel", "parcel", "Landroid/os/Parcel;", "readStreamToString", "readStringMapFromParcel", "refreshAvailableExternalStorage", "refreshBestGuessNumberOfCPUCores", "refreshCarrierName", "appContext", "refreshPeriodicExtendedDeviceInfo", "refreshTimezone", "refreshTotalExternalStorage", "runOnNonUiThread", "runnable", "Ljava/lang/Runnable;", "safeGetStringFromResponse", "response", "propertyName", "setAppEventAttributionParameters", "limitEventUsage", "setAppEventExtendedDeviceInfoParameters", "sha1hash", "sha256hash", "stringsEqualOrEmpty", "tryGetJSONArrayFromResponse", "propertyKey", "tryGetJSONObjectFromResponse", "writeNonnullStringMapToParcel", "writeStringMapToParcel", "GraphMeRequestWithCacheCallback", "facebook-core_release"})
public final class Utility {
    @NotNull
    public static final Utility INSTANCE = new Utility();
    @NotNull
    public static final String LOG_TAG = "FacebookSDK";
    @NotNull
    private static final String HASH_ALGORITHM_MD5 = "MD5";
    @NotNull
    private static final String HASH_ALGORITHM_SHA1 = "SHA-1";
    @NotNull
    private static final String HASH_ALGORITHM_SHA256 = "SHA-256";
    @NotNull
    private static final String URL_SCHEME = "https";
    @NotNull
    private static final String EXTRA_APP_EVENTS_INFO_FORMAT_VERSION = "a2";
    @NotNull
    private static final String UTF8 = "UTF-8";
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 8192;
    private static final int REFRESH_TIME_FOR_EXTENDED_DEVICE_INFO_MILLIS = 1800000;
    @NotNull
    private static final String NO_CARRIER = "NoCarrier";
    private static int numCPUCores;
    private static long timestampOfLastCheck;
    private static long totalExternalStorageGB;
    private static long availableExternalStorageGB;
    @NotNull
    private static String deviceTimezoneAbbreviation;
    @NotNull
    private static String deviceTimeZoneName;
    @NotNull
    private static String carrierName;
    @Nullable
    private static String versionName;
    @Nullable
    private static Locale locale;
    @NotNull
    private static final String ARC_DEVICE_PATTERN = ".+_cheets|cheets_.+";
    @NotNull
    private static final String FACEBOOK_PROFILE_FIELDS = "id,name,first_name,middle_name,last_name";
    @NotNull
    private static final String INSTAGRAM_PROFILE_FIELDS = "id,name,profile_picture";

    private Utility() {
    }

    public final long getAvailableExternalStorageGB() {
        return availableExternalStorageGB;
    }

    public final void setAvailableExternalStorageGB(long l) {
        availableExternalStorageGB = l;
    }

    @NotNull
    public final String getDeviceTimeZoneName() {
        return deviceTimeZoneName;
    }

    public final void setDeviceTimeZoneName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        deviceTimeZoneName = string;
    }

    @NotNull
    public final String getCarrierName() {
        return carrierName;
    }

    public final void setCarrierName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        carrierName = string;
    }

    @Nullable
    public final String getVersionName() {
        return versionName;
    }

    public final void setVersionName(@Nullable String string) {
        versionName = string;
    }

    @Nullable
    public final Locale getLocale() {
        return locale;
    }

    public final void setLocale(@Nullable Locale locale) {
        Utility.locale = locale;
    }

    @JvmStatic
    public static final boolean isNullOrEmpty(@Nullable Collection<?> c) {
        return c == null || c.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isNullOrEmpty(@Nullable String s) {
        if (s == null) return true;
        CharSequence charSequence = s;
        boolean bl = false;
        if (charSequence.length() != 0) return false;
        return true;
    }

    @JvmStatic
    @Nullable
    public static final String coerceValueIfNullOrEmpty(@Nullable String s, @Nullable String valueIfNullOrEmpty) {
        return Utility.isNullOrEmpty(s) ? valueIfNullOrEmpty : s;
    }

    @JvmStatic
    @Nullable
    public static final String md5hash(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return INSTANCE.hashWithAlgorithm(HASH_ALGORITHM_MD5, key);
    }

    @JvmStatic
    @Nullable
    public static final String sha1hash(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return INSTANCE.hashWithAlgorithm(HASH_ALGORITHM_SHA1, key);
    }

    @JvmStatic
    @Nullable
    public static final String sha1hash(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return INSTANCE.hashWithAlgorithm(HASH_ALGORITHM_SHA1, bytes);
    }

    @JvmStatic
    @Nullable
    public static final String sha256hash(@Nullable String key) {
        return key == null ? (String)null : INSTANCE.hashWithAlgorithm(HASH_ALGORITHM_SHA256, key);
    }

    @JvmStatic
    @Nullable
    public static final String sha256hash(@Nullable byte[] bytes) {
        return bytes == null ? (String)null : INSTANCE.hashWithAlgorithm(HASH_ALGORITHM_SHA256, bytes);
    }

    private final String hashWithAlgorithm(String algorithm, String key) {
        String string = key;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return this.hashWithAlgorithm(algorithm, byArray);
    }

    private final String hashWithAlgorithm(String algorithm, byte[] bytes) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        MessageDigest hash = messageDigest;
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash");
        return this.hashBytes(hash, bytes);
    }

    private final String hashBytes(MessageDigest hash, byte[] bytes) {
        hash.update(bytes);
        byte[] digest = hash.digest();
        StringBuilder builder = new StringBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)digest, (String)"digest");
        for (byte b : digest) {
            builder.append(Integer.toHexString(b >> 4 & 0xF));
            builder.append(Integer.toHexString(b >> 0 & 0xF));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Uri buildUri(@Nullable String authority, @Nullable String path, @Nullable Bundle parameters) {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(URL_SCHEME);
        builder.authority(authority);
        builder.path(path);
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                Object parameter = parameters.get(key);
                if (!(parameter instanceof String)) continue;
                builder.appendQueryParameter(key, (String)parameter);
            }
        }
        Uri uri = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"builder.build()");
        return uri;
    }

    @JvmStatic
    @NotNull
    public static final Bundle parseUrlQueryString(@Nullable String queryString) {
        Bundle params = new Bundle();
        if (!Utility.isNullOrEmpty(queryString)) {
            boolean bl = false;
            int n = 0;
            n = 0;
            boolean bl2 = false;
            if (queryString == null) {
                boolean bl3 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            String[] stringArray = new String[]{"&"};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)queryString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] array = stringArray2;
            stringArray = array;
            n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String parameter = stringArray[n];
                ++n;
                String[] stringArray3 = new String[]{"="};
                Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)parameter, (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray2 = false;
                Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                if (thisCollection$iv2.toArray(new String[0]) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                try {
                    String[] keyValuePair;
                    if (keyValuePair.length == 2) {
                        params.putString(URLDecoder.decode(keyValuePair[0], UTF8), URLDecoder.decode(keyValuePair[1], UTF8));
                        continue;
                    }
                    if (keyValuePair.length != 1) continue;
                    params.putString(URLDecoder.decode(keyValuePair[0], UTF8), "");
                }
                catch (UnsupportedEncodingException e) {
                    Utility.logd(LOG_TAG, e);
                }
            }
        }
        return params;
    }

    @JvmStatic
    public static final void putNonEmptyString(@NotNull Bundle b, @Nullable String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!Utility.isNullOrEmpty(value)) {
            b.putString(key, value);
        }
    }

    @JvmStatic
    public static final void putCommaSeparatedStringList(@NotNull Bundle b, @Nullable String key, @Nullable List<String> list) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (list != null) {
            String commaSeparated = TextUtils.join((CharSequence)",", (Iterable)list);
            b.putString(key, commaSeparated);
        }
    }

    @JvmStatic
    public static final void putUri(@NotNull Bundle b, @Nullable String key, @Nullable Uri uri) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (uri != null) {
            Utility.putNonEmptyString(b, key, uri.toString());
        }
    }

    @JvmStatic
    public static final boolean putJSONValueInBundle(@NotNull Bundle bundle, @Nullable String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        if (value == null) {
            bundle.remove(key);
        } else if (value instanceof Boolean) {
            bundle.putBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof boolean[]) {
            bundle.putBooleanArray(key, (boolean[])value);
        } else if (value instanceof Double) {
            bundle.putDouble(key, ((Number)value).doubleValue());
        } else if (value instanceof double[]) {
            bundle.putDoubleArray(key, (double[])value);
        } else if (value instanceof Integer) {
            bundle.putInt(key, ((Number)value).intValue());
        } else if (value instanceof int[]) {
            bundle.putIntArray(key, (int[])value);
        } else if (value instanceof Long) {
            bundle.putLong(key, ((Number)value).longValue());
        } else if (value instanceof long[]) {
            bundle.putLongArray(key, (long[])value);
        } else if (value instanceof String) {
            bundle.putString(key, (String)value);
        } else if (value instanceof JSONArray) {
            bundle.putString(key, ((JSONArray)value).toString());
        } else if (value instanceof JSONObject) {
            bundle.putString(key, ((JSONObject)value).toString());
        } else {
            return false;
        }
        return true;
    }

    @JvmStatic
    public static final void closeQuietly(@Nullable Closeable closeable) {
        try {
            Closeable closeable2 = closeable;
            if (closeable2 != null) {
                closeable2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @JvmStatic
    public static final void disconnectQuietly(@Nullable URLConnection connection) {
        if (connection != null && connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    @JvmStatic
    @NotNull
    public static final String getMetadataApplicationId(@Nullable Context context) {
        Validate.notNull(context, "context");
        return FacebookSdk.INSTANCE.getApplicationId();
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Object> convertJSONObjectToHashMap(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        HashMap map = new HashMap();
        JSONArray jSONArray = jsonObject.names();
        if (jSONArray == null) {
            return map;
        }
        int n = 0;
        JSONArray keys = jSONArray;
        int n2 = keys.length();
        if (n < n2) {
            do {
                int i = n++;
                String key = null;
                try {
                    Object object;
                    String string = keys.getString(i);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"keys.getString(i)");
                    key = string;
                    Map<String, Object> value = jsonObject.get(key);
                    if (value instanceof JSONObject) {
                        object = value;
                        value = Utility.convertJSONObjectToHashMap((JSONObject)object);
                    }
                    object = map;
                    Map<String, Object> map2 = value;
                    Intrinsics.checkNotNullExpressionValue(map2, (String)"value");
                    boolean bl = false;
                    object.put(key, map2);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            } while (n < n2);
        }
        return map;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> convertJSONObjectToStringMap(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        HashMap map = new HashMap();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = jsonObject.optString(key);
            if (value == null) continue;
            Map map2 = map;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            String string = key;
            String string2 = value;
            boolean bl = false;
            map2.put(string, string2);
        }
        return map;
    }

    @JvmStatic
    @Nullable
    public static final HashSet<String> convertJSONArrayToHashSet(@Nullable JSONArray jsonArray) {
        block6: {
            block5: {
                if (jsonArray == null) break block5;
                JSONArray jSONArray = jsonArray;
                boolean bl = false;
                if (jSONArray.length() != 0) break block6;
            }
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        int n2 = jsonArray.length();
        if (n < n2) {
            do {
                int i = n++;
                String string = jsonArray.getString(i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonArray.getString(i)");
                String element = string;
                hashSet.add(element);
            } while (n < n2);
        }
        return hashSet;
    }

    @JvmStatic
    @NotNull
    public static final List<String> convertJSONArrayToList(@NotNull JSONArray jsonArray) {
        List list;
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        try {
            List result = new ArrayList();
            int n = 0;
            int n2 = jsonArray.length();
            if (n < n2) {
                do {
                    int i = n++;
                    String string = jsonArray.getString(i);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonArray.getString(i)");
                    result.add(string);
                } while (n < n2);
            }
        }
        catch (JSONException je) {
            list = new ArrayList();
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final Object getStringPropertyAsJSON(@NotNull JSONObject jsonObject, @Nullable String key, @Nullable String nonJSONPropertyKey) throws JSONException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        JSONObject jsonObject2 = jsonObject;
        Object value = jsonObject2.opt(key);
        if (value != null && value instanceof String) {
            JSONTokener tokener = new JSONTokener((String)value);
            value = tokener.nextValue();
        }
        if (value != null && !(value instanceof JSONObject) && !(value instanceof JSONArray)) {
            if (nonJSONPropertyKey == null) throw new FacebookException("Got an unexpected non-JSON object.");
            jsonObject2 = new JSONObject();
            jsonObject2.putOpt(nonJSONPropertyKey, value);
            object = jsonObject2;
            return object;
        } else {
            object = value;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final String readStreamToString(@Nullable InputStream inputStream) throws IOException {
        String string;
        BufferedInputStream bufferedInputStream = null;
        InputStreamReader reader = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            reader = new InputStreamReader(bufferedInputStream);
            StringBuilder stringBuilder = new StringBuilder();
            int bufferSize = 2048;
            char[] buffer = new char[bufferSize];
            int n = 0;
            while (true) {
                int n2 = reader.read(buffer);
                boolean bl = false;
                boolean bl2 = false;
                int it = n2;
                boolean bl3 = false;
                n = it;
                if (n2 == -1) break;
                stringBuilder.append(buffer, 0, n);
            }
            string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n      bufferedInputStream = BufferedInputStream(inputStream)\n      reader = InputStreamReader(bufferedInputStream)\n      val stringBuilder = StringBuilder()\n      val bufferSize = 1024 * 2\n      val buffer = CharArray(bufferSize)\n      var n = 0\n      while (reader.read(buffer).also { n = it } != -1) {\n        stringBuilder.append(buffer, 0, n)\n      }\n      stringBuilder.toString()\n    }");
        }
        finally {
            Utility.closeQuietly(bufferedInputStream);
            Utility.closeQuietly(reader);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final int copyAndCloseInputStream(@Nullable InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        InputStream inputStream2;
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        BufferedInputStream bufferedInputStream = null;
        int totalBytes = 0;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while (true) {
                int n = bufferedInputStream.read(buffer);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                bytesRead = it;
                if (n == -1) break;
                outputStream.write(buffer, 0, bytesRead);
                totalBytes += bytesRead;
            }
            inputStream2 = bufferedInputStream;
        }
        catch (Throwable throwable) {
            InputStream inputStream3 = bufferedInputStream;
            if (inputStream3 != null) {
                ((BufferedInputStream)inputStream3).close();
            }
            inputStream3 = inputStream;
            if (inputStream3 != null) {
                inputStream3.close();
            }
            throw throwable;
        }
        ((BufferedInputStream)inputStream2).close();
        inputStream2 = inputStream;
        if (inputStream2 != null) {
            inputStream2.close();
        }
        return totalBytes;
    }

    @JvmStatic
    public static final boolean stringsEqualOrEmpty(@Nullable String a, @Nullable String b) {
        boolean bEmpty;
        CharSequence charSequence = a;
        boolean bl = false;
        boolean bl2 = false;
        boolean aEmpty = charSequence == null || charSequence.length() == 0;
        CharSequence charSequence2 = b;
        bl2 = false;
        boolean bl3 = false;
        boolean bl4 = bEmpty = charSequence2 == null || charSequence2.length() == 0;
        if (aEmpty && bEmpty) {
            return true;
        }
        return !aEmpty && !bEmpty ? Intrinsics.areEqual((Object)a, (Object)b) : false;
    }

    private final void clearCookiesForDomain(Context context, String domain) {
        CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)context);
        syncManager.sync();
        CookieManager cookieManager = CookieManager.getInstance();
        String string = cookieManager.getCookie(domain);
        if (string == null) {
            return;
        }
        String cookies = string;
        String[] stringArray = new String[]{";"};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)cookies, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] splitCookies = stringArray2;
        stringArray = splitCookies;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String[] cookieParts;
            String cookie = stringArray[n];
            ++n;
            String[] stringArray3 = new String[]{"="};
            Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)cookie, (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            if (thisCollection$iv2.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            if (cookieParts.length <= 0) continue;
            String $this$trim$iv = cookieParts[0];
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String newCookie = Intrinsics.stringPlus((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (Object)"=;expires=Sat, 1 Jan 2000 00:00:01 UTC;");
            cookieManager.setCookie(domain, newCookie);
        }
        cookieManager.removeExpiredCookie();
    }

    @JvmStatic
    public static final void clearFacebookCookies(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            INSTANCE.clearCookiesForDomain(context, "facebook.com");
            INSTANCE.clearCookiesForDomain(context, ".facebook.com");
            INSTANCE.clearCookiesForDomain(context, "https://facebook.com");
            INSTANCE.clearCookiesForDomain(context, "https://.facebook.com");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JvmStatic
    public static final void logd(@Nullable String tag, @Nullable Exception e) {
        if (FacebookSdk.INSTANCE.isDebugEnabled() && tag != null && e != null) {
            Log.d((String)tag, (String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    @JvmStatic
    public static final void logd(@Nullable String tag, @Nullable String msg) {
        if (FacebookSdk.INSTANCE.isDebugEnabled() && tag != null && msg != null) {
            Log.d((String)tag, (String)msg);
        }
    }

    @JvmStatic
    public static final void logd(@Nullable String tag, @Nullable String msg, @Nullable Throwable t) {
        if (FacebookSdk.INSTANCE.isDebugEnabled()) {
            if (!Utility.isNullOrEmpty(tag)) {
                Log.d((String)tag, (String)msg, (Throwable)t);
            }
        }
    }

    @JvmStatic
    public static final <T> boolean areObjectsEqual(@Nullable T a, @Nullable T b) {
        return a == null ? b == null : Intrinsics.areEqual(a, b);
    }

    @JvmStatic
    @NotNull
    public static final String safeGetStringFromResponse(@Nullable JSONObject response, @Nullable String propertyName) {
        String string;
        if (response != null) {
            String string2 = response.optString(propertyName, "");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.optString(propertyName, \"\")");
            string = string2;
        } else {
            string = "";
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final JSONObject tryGetJSONObjectFromResponse(@Nullable JSONObject response, @Nullable String propertyKey) {
        JSONObject jSONObject = response;
        return jSONObject == null ? null : jSONObject.optJSONObject(propertyKey);
    }

    @JvmStatic
    @Nullable
    public static final JSONArray tryGetJSONArrayFromResponse(@Nullable JSONObject response, @Nullable String propertyKey) {
        JSONObject jSONObject = response;
        return jSONObject == null ? null : jSONObject.optJSONArray(propertyKey);
    }

    @JvmStatic
    @NotNull
    public static final List<String> jsonArrayToStringList(@NotNull JSONArray jsonArray) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        ArrayList<String> result = new ArrayList<String>();
        int n = 0;
        int n2 = jsonArray.length();
        if (n < n2) {
            do {
                int i = n++;
                result.add(jsonArray.getString(i));
            } while (n < n2);
        }
        return result;
    }

    @JvmStatic
    @NotNull
    public static final Set<String> jsonArrayToSet(@NotNull JSONArray jsonArray) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        Set result = new HashSet();
        int n = 0;
        int n2 = jsonArray.length();
        if (n < n2) {
            do {
                int i = n++;
                String string = jsonArray.getString(i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonArray.getString(i)");
                result.add(string);
            } while (n < n2);
        }
        return result;
    }

    @JvmStatic
    @NotNull
    public static final String mapToJsonStr(@NotNull Map<String, String> map) {
        String string;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        if (map.isEmpty()) {
            string = "";
        } else {
            String string2;
            try {
                JSONObject jsonObject = new JSONObject();
                Object object = map;
                boolean bl = false;
                Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object2 = object = iterator.next();
                    boolean bl2 = false;
                    String key = (String)object2.getKey();
                    Object object3 = object;
                    boolean bl3 = false;
                    String value = (String)object3.getValue();
                    jsonObject.put(key, (Object)value);
                }
                string2 = jsonObject.toString();
            }
            catch (JSONException _e) {
                string2 = "";
            }
            String string3 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n      try {\n        val jsonObject = JSONObject()\n        for ((key, value) in map) {\n          jsonObject.put(key, value)\n        }\n        jsonObject.toString()\n      } catch (_e: JSONException) {\n        \"\"\n      }\n    }");
            string = string3;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> jsonStrToMap(@NotNull String str) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Object object2 = str;
        boolean bl = false;
        if (object2.length() == 0) {
            object = new HashMap();
        } else {
            try {
                Map map = new HashMap();
                JSONObject jsonObject = new JSONObject(str);
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Map map2 = map;
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    String string = key;
                    String string2 = jsonObject.getString(key);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject.getString(key)");
                    boolean bl2 = false;
                    map2.put(string, string2);
                }
            }
            catch (JSONException _e) {
                object2 = new HashMap();
            }
            object = object2;
        }
        return object;
    }

    @JvmStatic
    public static final void setAppEventAttributionParameters(@NotNull JSONObject params, @Nullable AttributionIdentifiers attributionIdentifiers, @Nullable String anonymousAppDeviceGUID, boolean limitEventUsage, @NotNull Context context) throws JSONException {
        String campaignIDs;
        Object object;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!FeatureManager.isEnabled(FeatureManager.Feature.ServiceUpdateCompliance)) {
            params.put("anon_id", (Object)anonymousAppDeviceGUID);
        }
        params.put("application_tracking_enabled", !limitEventUsage);
        params.put("advertiser_id_collection_enabled", FacebookSdk.INSTANCE.getAdvertiserIDCollectionEnabled());
        if (attributionIdentifiers != null) {
            if (FeatureManager.isEnabled(FeatureManager.Feature.ServiceUpdateCompliance)) {
                INSTANCE.appendAnonIdUnderCompliance(params, attributionIdentifiers, anonymousAppDeviceGUID, context);
            }
            if (attributionIdentifiers.getAttributionId() != null) {
                if (FeatureManager.isEnabled(FeatureManager.Feature.ServiceUpdateCompliance)) {
                    INSTANCE.appendAttributionIdUnderCompliance(params, attributionIdentifiers, context);
                } else {
                    params.put("attribution", (Object)attributionIdentifiers.getAttributionId());
                }
            }
            if (attributionIdentifiers.getAndroidAdvertiserId() != null) {
                params.put("advertiser_id", (Object)attributionIdentifiers.getAndroidAdvertiserId());
                params.put("advertiser_tracking_enabled", !attributionIdentifiers.isTrackingLimited());
            }
            if (!attributionIdentifiers.isTrackingLimited()) {
                String userData = UserDataStore.INSTANCE.getAllHashedUserData();
                object = userData;
                boolean bl = false;
                if (!(object.length() == 0)) {
                    params.put("ud", (Object)userData);
                }
            }
            if (attributionIdentifiers.getAndroidInstallerPackage() != null) {
                params.put("installer_package", (Object)attributionIdentifiers.getAndroidInstallerPackage());
            }
        }
        String string = campaignIDs = (object = AppLinkManager.Companion.getInstance()) == null ? null : ((AppLinkManager)object).getInfo("campaign_ids");
        if (campaignIDs != null) {
            params.put("campaign_ids", (Object)campaignIDs);
        }
    }

    @JvmStatic
    @Nullable
    public static final String getAppVersion() {
        Context context = FacebookSdk.INSTANCE.getApplicationContext();
        if (context == null) {
            return null;
        }
        Context context2 = context;
        String pkgName = context2.getPackageName();
        try {
            PackageInfo packageInfo = context2.getPackageManager().getPackageInfo(pkgName, 0);
            if (packageInfo == null) {
                return null;
            }
            PackageInfo pi = packageInfo;
            return pi.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @JvmStatic
    public static final void setAppEventExtendedDeviceInfoParameters(@NotNull JSONObject params, @NotNull Context appContext) throws JSONException {
        Object pi2;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        JSONArray extraInfoArray = new JSONArray();
        extraInfoArray.put((Object)EXTRA_APP_EVENTS_INFO_FORMAT_VERSION);
        INSTANCE.refreshPeriodicExtendedDeviceInfo(appContext);
        String pkgName = appContext.getPackageName();
        int versionCode = -1;
        try {
            PackageInfo packageInfo = appContext.getPackageManager().getPackageInfo(pkgName, 0);
            if (packageInfo == null) {
                return;
            }
            pi2 = packageInfo;
            versionCode = ((PackageInfo)pi2).versionCode;
            versionName = ((PackageInfo)pi2).versionName;
        }
        catch (PackageManager.NameNotFoundException pi2) {
            // empty catch block
        }
        extraInfoArray.put((Object)pkgName);
        extraInfoArray.put(versionCode);
        extraInfoArray.put((Object)versionName);
        extraInfoArray.put((Object)Build.VERSION.RELEASE);
        extraInfoArray.put((Object)Build.MODEL);
        try {
            pi2 = appContext.getResources().getConfiguration().locale;
        }
        catch (Exception e) {
            pi2 = Locale.getDefault();
        }
        locale = pi2;
        pi2 = locale;
        StringBuilder stringBuilder = new StringBuilder().append(pi2 == null ? "" : ((e = ((Locale)pi2).getLanguage()) == null ? "" : e)).append('_');
        pi2 = locale;
        extraInfoArray.put((Object)stringBuilder.append(pi2 == null ? "" : ((e = ((Locale)pi2).getCountry()) == null ? "" : e)).toString());
        extraInfoArray.put((Object)deviceTimezoneAbbreviation);
        extraInfoArray.put((Object)carrierName);
        int width = 0;
        int height = 0;
        double density = 0.0;
        try {
            Display display;
            Object object;
            DisplayManager displayManager;
            Object object2;
            if (Build.VERSION.SDK_INT >= 17) {
                object2 = appContext.getSystemService("display");
                displayManager = object2 instanceof DisplayManager ? (DisplayManager)object2 : null;
                object2 = displayManager;
                object = object2 == null ? null : object2.getDisplay(0);
            } else {
                object2 = appContext.getSystemService("window");
                displayManager = object2 instanceof WindowManager ? (WindowManager)object2 : null;
                object = display = displayManager == null ? null : displayManager.getDefaultDisplay();
            }
            if (display != null) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                display.getMetrics(displayMetrics);
                width = displayMetrics.widthPixels;
                height = displayMetrics.heightPixels;
                density = displayMetrics.density;
            }
        }
        catch (Exception display) {
            // empty catch block
        }
        extraInfoArray.put(width);
        extraInfoArray.put(height);
        DecimalFormat df = new DecimalFormat("#.##");
        extraInfoArray.put((Object)df.format(density));
        extraInfoArray.put(INSTANCE.refreshBestGuessNumberOfCPUCores());
        extraInfoArray.put(totalExternalStorageGB);
        extraInfoArray.put(availableExternalStorageGB);
        extraInfoArray.put((Object)deviceTimeZoneName);
        params.put("extinfo", (Object)extraInfoArray.toString());
    }

    @JvmStatic
    @Nullable
    public static final Method getMethodQuietly(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... parameterTypes) {
        Method method;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        try {
            method = clazz.getMethod(methodName, Arrays.copyOf(parameterTypes, parameterTypes.length));
        }
        catch (NoSuchMethodException ex) {
            method = null;
        }
        return method;
    }

    @JvmStatic
    @Nullable
    public static final Method getMethodQuietly(@NotNull String className, @NotNull String methodName, Class<?> ... parameterTypes) {
        Method method;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        try {
            Class<?> clazz = Class.forName(className);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"clazz");
            method = Utility.getMethodQuietly(clazz, methodName, Arrays.copyOf(parameterTypes, parameterTypes.length));
        }
        catch (ClassNotFoundException ex) {
            method = null;
        }
        return method;
    }

    @JvmStatic
    @Nullable
    public static final Object invokeMethodQuietly(@Nullable Object receiver, @NotNull Method method, Object ... args) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            object = method.invoke(receiver, Arrays.copyOf(args, args.length));
        }
        catch (IllegalAccessException ex) {
            object = null;
        }
        catch (InvocationTargetException ex) {
            object = null;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final String getActivityName(@Nullable Context context) {
        String string;
        if (context == null) {
            string = "null";
        } else if (context == context.getApplicationContext()) {
            string = "unknown";
        } else {
            String string2 = context.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n      context.javaClass.simpleName\n    }");
            string = string2;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String getUriString(@Nullable Uri uri) {
        Uri uri2 = uri;
        return uri2 == null ? null : uri2.toString();
    }

    @JvmStatic
    public static final boolean isWebUri(@Nullable Uri uri) {
        return uri != null && (StringsKt.equals((String)"http", (String)uri.getScheme(), (boolean)true) || StringsKt.equals((String)URL_SCHEME, (String)uri.getScheme(), (boolean)true) || StringsKt.equals((String)"fbstaging", (String)uri.getScheme(), (boolean)true));
    }

    @JvmStatic
    public static final boolean isContentUri(@Nullable Uri uri) {
        return uri != null && StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true);
    }

    @JvmStatic
    public static final boolean isFileUri(@Nullable Uri uri) {
        return uri != null && StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final long getContentSize(@NotNull Uri contentUri) {
        Cursor cursor;
        block4: {
            Intrinsics.checkNotNullParameter((Object)contentUri, (String)"contentUri");
            cursor = null;
            try {
                cursor = FacebookSdk.INSTANCE.getApplicationContext().getContentResolver().query(contentUri, null, null, null, null);
                if (cursor != null) break block4;
                long l = 0L;
                Cursor cursor2 = cursor;
                return l;
            }
            catch (Throwable throwable) {
                Cursor cursor3 = cursor;
                if (cursor3 != null) {
                    cursor3.close();
                }
                throw throwable;
            }
        }
        int sizeIndex = cursor.getColumnIndex("_size");
        cursor.moveToFirst();
        long l = cursor.getLong(sizeIndex);
        Cursor cursor4 = cursor;
        cursor4.close();
        return l;
    }

    @JvmStatic
    @Nullable
    public static final Date getBundleLongAsDate(@Nullable Bundle bundle, @Nullable String key, @NotNull Date dateBase) {
        Intrinsics.checkNotNullParameter((Object)dateBase, (String)"dateBase");
        if (bundle == null) {
            return null;
        }
        long secondsFromBase = 0L;
        Object secondsObject = bundle.get(key);
        if (secondsObject instanceof Long) {
            secondsFromBase = ((Number)secondsObject).longValue();
        } else if (secondsObject instanceof String) {
            try {
                String string = (String)secondsObject;
                boolean bl = false;
                secondsFromBase = Long.parseLong(string);
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            return null;
        }
        return secondsFromBase == 0L ? new Date(Long.MAX_VALUE) : new Date(dateBase.getTime() + secondsFromBase * 1000L);
    }

    @JvmStatic
    public static final void writeStringMapToParcel(@NotNull Parcel parcel, @Nullable Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        if (map == null) {
            parcel.writeInt(-1);
        } else {
            parcel.writeInt(map.size());
            Object object = map;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl2 = false;
                String key = (String)object2.getKey();
                Object object3 = object;
                boolean bl3 = false;
                String value = (String)object3.getValue();
                parcel.writeString(key);
                parcel.writeString(value);
            }
        }
    }

    @JvmStatic
    @Nullable
    public static final Map<String, String> readStringMapFromParcel(@NotNull Parcel parcel) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        int size = parcel.readInt();
        if (size < 0) {
            return null;
        }
        Map map = new HashMap();
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                Map map2 = map;
                String string = parcel.readString();
                String string2 = parcel.readString();
                boolean bl = false;
                map2.put(string, string2);
            } while (n < size);
        }
        return map;
    }

    @JvmStatic
    public static final void writeNonnullStringMapToParcel(@NotNull Parcel parcel, @Nullable Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        if (map == null) {
            parcel.writeInt(-1);
        } else {
            parcel.writeInt(map.size());
            Object object = map;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl2 = false;
                String key = (String)object2.getKey();
                Object object3 = object;
                boolean bl3 = false;
                String value = (String)object3.getValue();
                parcel.writeString(key);
                parcel.writeString(value);
            }
        }
    }

    @JvmStatic
    @Nullable
    public static final Map<String, String> readNonnullStringMapFromParcel(@NotNull Parcel parcel) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        int size = parcel.readInt();
        if (size < 0) {
            return null;
        }
        Map map = new HashMap();
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                String key = parcel.readString();
                String value = parcel.readString();
                if (key == null || value == null) continue;
                Map map2 = map;
                boolean bl = false;
                map2.put(key, value);
            } while (n < size);
        }
        return map;
    }

    @JvmStatic
    public static final boolean isCurrentAccessToken(@Nullable AccessToken token) {
        return token != null && Intrinsics.areEqual((Object)token, (Object)AccessToken.Companion.getCurrentAccessToken());
    }

    @JvmStatic
    @NotNull
    public static final String getGraphDomainFromTokenDomain(@Nullable String tokenGraphDomain) {
        String facebookDomain = FacebookSdk.INSTANCE.getFacebookDomain();
        if (tokenGraphDomain == null) {
            return facebookDomain;
        }
        String string = tokenGraphDomain;
        return Intrinsics.areEqual((Object)string, (Object)"gaming") ? StringsKt.replace$default((String)facebookDomain, (String)"facebook.com", (String)"fb.gg", (boolean)false, (int)4, null) : (Intrinsics.areEqual((Object)string, (Object)"instagram") ? StringsKt.replace$default((String)facebookDomain, (String)"facebook.com", (String)"instagram.com", (boolean)false, (int)4, null) : facebookDomain);
    }

    @JvmStatic
    public static final void getGraphMeRequestWithCacheAsync(@NotNull String accessToken, @NotNull GraphMeRequestWithCacheCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        JSONObject cachedValue = ProfileInformationCache.getProfileInformation(accessToken);
        if (cachedValue != null) {
            callback2.onSuccess(cachedValue);
            return;
        }
        GraphRequest.Callback graphCallback = arg_0 -> Utility.getGraphMeRequestWithCacheAsync$lambda-3(callback2, accessToken, arg_0);
        GraphRequest graphRequest = INSTANCE.getGraphMeRequestWithCache(accessToken);
        graphRequest.setCallback(graphCallback);
        graphRequest.executeAsync();
    }

    @JvmStatic
    @Nullable
    public static final JSONObject awaitGetGraphMeRequestWithCache(@NotNull String accessToken) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        JSONObject cachedValue = ProfileInformationCache.getProfileInformation(accessToken);
        if (cachedValue != null) {
            return cachedValue;
        }
        GraphRequest graphRequest = INSTANCE.getGraphMeRequestWithCache(accessToken);
        GraphResponse response = graphRequest.executeAndWait();
        return response.getError() != null ? (JSONObject)null : response.getJsonObject();
    }

    private final GraphRequest getGraphMeRequestWithCache(String accessToken) {
        Bundle parameters = new Bundle();
        parameters.putString("fields", this.getProfileFieldsForGraphDomain(this.getCurrentTokenDomainWithDefault()));
        parameters.putString("access_token", accessToken);
        GraphRequest request = GraphRequest.Companion.newMeRequest(null, null);
        request.setParameters(parameters);
        request.setHttpMethod(HttpMethod.GET);
        return request;
    }

    private final String getProfileFieldsForGraphDomain(String graphDomain) {
        return Intrinsics.areEqual((Object)graphDomain, (Object)"instagram") ? INSTAGRAM_PROFILE_FIELDS : FACEBOOK_PROFILE_FIELDS;
    }

    private final String getCurrentTokenDomainWithDefault() {
        AccessToken accessToken = AccessToken.Companion.getCurrentAccessToken();
        return accessToken != null && accessToken.getGraphDomain() != null ? accessToken.getGraphDomain() : "facebook";
    }

    private final int refreshBestGuessNumberOfCPUCores() {
        if (numCPUCores > 0) {
            return numCPUCores;
        }
        try {
            File cpuDir = new File("/sys/devices/system/cpu/");
            File[] cpuFiles = cpuDir.listFiles(Utility::refreshBestGuessNumberOfCPUCores$lambda-4);
            if (cpuFiles != null) {
                numCPUCores = cpuFiles.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (numCPUCores <= 0) {
            numCPUCores = Math.max(Runtime.getRuntime().availableProcessors(), 1);
        }
        return numCPUCores;
    }

    private final void refreshPeriodicExtendedDeviceInfo(Context appContext) {
        if (timestampOfLastCheck == -1L || System.currentTimeMillis() - timestampOfLastCheck >= 1800000L) {
            timestampOfLastCheck = System.currentTimeMillis();
            this.refreshTimezone();
            this.refreshCarrierName(appContext);
            this.refreshTotalExternalStorage();
            this.refreshAvailableExternalStorage();
        }
    }

    private final void refreshTimezone() {
        try {
            TimeZone tz = TimeZone.getDefault();
            String string = tz.getDisplayName(tz.inDaylightTime(new Date()), 0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tz.getDisplayName(tz.inDaylightTime(Date()), TimeZone.SHORT)");
            deviceTimezoneAbbreviation = string;
            string = tz.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tz.id");
            deviceTimeZoneName = string;
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void refreshCarrierName(Context appContext) {
        if (Intrinsics.areEqual((Object)carrierName, (Object)NO_CARRIER)) {
            try {
                Object object = appContext.getSystemService("phone");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
                }
                TelephonyManager telephonyManager = (TelephonyManager)object;
                object = telephonyManager.getNetworkOperatorName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"telephonyManager.networkOperatorName");
                carrierName = object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final boolean externalStorageExists() {
        return Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState());
    }

    private final void refreshAvailableExternalStorage() {
        try {
            if (this.externalStorageExists()) {
                File path = Environment.getExternalStorageDirectory();
                StatFs stat = new StatFs(path.getPath());
                availableExternalStorageGB = (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
            }
            availableExternalStorageGB = this.convertBytesToGB(availableExternalStorageGB);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void refreshTotalExternalStorage() {
        try {
            if (this.externalStorageExists()) {
                File path = Environment.getExternalStorageDirectory();
                StatFs stat = new StatFs(path.getPath());
                totalExternalStorageGB = (long)stat.getBlockCount() * (long)stat.getBlockSize();
            }
            totalExternalStorageGB = this.convertBytesToGB(totalExternalStorageGB);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final long convertBytesToGB(double bytes) {
        return Math.round(bytes / 1.073741824E9);
    }

    private final void appendAnonIdUnderCompliance(JSONObject params, AttributionIdentifiers attributionIdentifiers, String anonymousAppDeviceGUID, Context context) {
        if (Build.VERSION.SDK_INT >= 31 && this.isGooglePlayServicesAvailable(context)) {
            if (!attributionIdentifiers.isTrackingLimited()) {
                params.put("anon_id", (Object)anonymousAppDeviceGUID);
            }
        } else {
            params.put("anon_id", (Object)anonymousAppDeviceGUID);
        }
    }

    private final void appendAttributionIdUnderCompliance(JSONObject params, AttributionIdentifiers attributionIdentifiers, Context context) {
        if (Build.VERSION.SDK_INT >= 31 && this.isGooglePlayServicesAvailable(context)) {
            if (!attributionIdentifiers.isTrackingLimited()) {
                params.put("attribution", (Object)attributionIdentifiers.getAttributionId());
            }
        } else {
            params.put("attribution", (Object)attributionIdentifiers.getAttributionId());
        }
    }

    private final boolean isGooglePlayServicesAvailable(Context context) {
        Object[] objectArray = new Class[]{Context.class};
        Method method = Utility.getMethodQuietly("com.google.android.gms.common.GooglePlayServicesUtil", "isGooglePlayServicesAvailable", objectArray);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        objectArray = new Object[]{context};
        Object connectionResult = Utility.invokeMethodQuietly(null, method2, objectArray);
        return connectionResult instanceof Integer && Intrinsics.areEqual((Object)connectionResult, (Object)0);
    }

    @JvmStatic
    @NotNull
    public static final String generateRandomString(int length) {
        Random r = new Random();
        String string = new BigInteger(length * 5, r).toString(32);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BigInteger(length * 5, r).toString(32)");
        return string;
    }

    @JvmStatic
    public static final boolean mustFixWindowParamsForAutofill(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Utility.isAutofillAvailable(context);
    }

    @JvmStatic
    public static final boolean isAutofillAvailable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT < 26) {
            return false;
        }
        AutofillManager afm = (AutofillManager)context.getSystemService(AutofillManager.class);
        return afm != null && afm.isAutofillSupported() && afm.isEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isChromeOS(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean isChromeOS = false;
        if (Build.VERSION.SDK_INT < 27) {
            if (Build.DEVICE == null) return false;
            String string = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DEVICE");
            CharSequence charSequence = string;
            Regex regex = new Regex(ARC_DEVICE_PATTERN);
            boolean bl = false;
            if (!regex.matches(charSequence)) return false;
            return true;
        }
        boolean bl = context.getPackageManager().hasSystemFeature("android.hardware.type.pc");
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final Locale getResourceLocale() {
        Locale locale;
        try {
            locale = FacebookSdk.INSTANCE.getApplicationContext().getResources().getConfiguration().locale;
        }
        catch (Exception e) {
            locale = null;
        }
        return locale;
    }

    @JvmStatic
    @NotNull
    public static final Locale getCurrentLocale() {
        Locale locale;
        Locale locale2 = INSTANCE.getResourceLocale();
        Locale locale3 = locale2;
        if (locale3 == null) {
            Locale locale4 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"getDefault()");
            locale = locale4;
        } else {
            locale = locale3;
        }
        return locale;
    }

    @JvmStatic
    public static final void runOnNonUiThread(@Nullable Runnable runnable) {
        try {
            FacebookSdk.INSTANCE.getExecutor().execute(runnable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JvmStatic
    @NotNull
    public static final String getAppName(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            String string2;
            String applicationName = FacebookSdk.INSTANCE.getApplicationName();
            if (applicationName != null) {
                return applicationName;
            }
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            if (stringId == 0) {
                string2 = ((Object)applicationInfo.nonLocalizedLabel).toString();
            } else {
                String string3 = context.getString(stringId);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(stringId)");
                string2 = string3;
            }
            string = string2;
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    public static final boolean isAutoAppLinkSetup() {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "fb%s://applinks";
            Object[] objectArray = new Object[1];
            objectArray[0] = FacebookSdk.INSTANCE.getApplicationId();
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            intent.setData(Uri.parse((String)string2));
            Context ctx = FacebookSdk.INSTANCE.getApplicationContext();
            PackageManager packageManager = ctx.getPackageManager();
            String packageName = ctx.getPackageName();
            List list = packageManager.queryIntentActivities(intent, 65536);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageManager.queryIntentActivities(intent, PackageManager.MATCH_DEFAULT_ONLY)");
            List activities = list;
            for (ResolveInfo info : activities) {
                if (!Intrinsics.areEqual((Object)packageName, (Object)info.activityInfo.packageName)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @JvmStatic
    public static /* synthetic */ void isAutoAppLinkSetup$annotations() {
    }

    @JvmStatic
    @Nullable
    public static final JSONObject getDataProcessingOptions() {
        if (CrashShieldHandler.isObjectCrashing(Utility.class)) {
            return null;
        }
        try {
            Context context = FacebookSdk.INSTANCE.getApplicationContext();
            String data = context.getSharedPreferences("com.facebook.sdk.DataProcessingOptions", 0).getString("data_processing_options", null);
            if (data != null) {
                try {
                    return new JSONObject(data);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Utility.class);
            return null;
        }
    }

    @JvmStatic
    public static final boolean isDataProcessingRestricted() {
        if (CrashShieldHandler.isObjectCrashing(Utility.class)) {
            return false;
        }
        try {
            JSONObject jSONObject = INSTANCE.getDataProcessingOptions();
            if (jSONObject == null) {
                return false;
            }
            JSONObject dataProcessingOptions = jSONObject;
            try {
                JSONArray options = dataProcessingOptions.getJSONArray("data_processing_options");
                int n = 0;
                int n2 = options.length();
                if (n < n2) {
                    do {
                        String option;
                        int i = n++;
                        String string = options.getString(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"options.getString(i)");
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                        if (!Intrinsics.areEqual((Object)option, (Object)"ldu")) continue;
                        return true;
                    } while (n < n2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Utility.class);
            return false;
        }
    }

    private static final void getGraphMeRequestWithCacheAsync$lambda-3(GraphMeRequestWithCacheCallback $callback, String $accessToken, GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)$accessToken, (String)"$accessToken");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.getError() != null) {
            $callback.onFailure(response.getError().getException());
        } else {
            JSONObject jSONObject = response.getJsonObject();
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (jSONObject == null) {
                boolean bl4 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ProfileInformationCache.putProfileInformation($accessToken, jSONObject);
            $callback.onSuccess(response.getJsonObject());
        }
    }

    private static final boolean refreshBestGuessNumberOfCPUCores$lambda-4(File dir, String fileName) {
        return Pattern.matches("cpu[0-9]+", fileName);
    }

    static {
        timestampOfLastCheck = -1L;
        totalExternalStorageGB = -1L;
        availableExternalStorageGB = -1L;
        deviceTimezoneAbbreviation = "";
        deviceTimeZoneName = "";
        carrierName = NO_CARRIER;
        versionName = "";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lcom/facebook/internal/Utility$GraphMeRequestWithCacheCallback;", "", "onFailure", "", "error", "Lcom/facebook/FacebookException;", "onSuccess", "userInfo", "Lorg/json/JSONObject;", "facebook-core_release"})
    public static interface GraphMeRequestWithCacheCallback {
        public void onSuccess(@Nullable JSONObject var1);

        public void onFailure(@Nullable FacebookException var1);
    }
}

