/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookException;
import com.facebook.internal.ImageRequest;
import com.facebook.internal.ImageResponse;
import com.facebook.internal.ImageResponseCache;
import com.facebook.internal.UrlRedirectCache;
import com.facebook.internal.Utility;
import com.facebook.internal.WorkQueue;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004-./0B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0012\u0010\u0019\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J(\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\"H\u0007J2\u0010#\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000f2\u000e\u0010$\u001a\n\u0018\u00010%j\u0004\u0018\u0001`&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010+\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/facebook/internal/ImageDownloader;", "", "()V", "CACHE_READ_QUEUE_MAX_CONCURRENT", "", "DOWNLOAD_QUEUE_MAX_CONCURRENT", "cacheReadQueue", "Lcom/facebook/internal/WorkQueue;", "downloadQueue", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "pendingRequests", "", "Lcom/facebook/internal/ImageDownloader$RequestKey;", "Lcom/facebook/internal/ImageDownloader$DownloaderContext;", "cancelRequest", "", "request", "Lcom/facebook/internal/ImageRequest;", "clearCache", "", "download", "key", "downloadAsync", "enqueueCacheRead", "allowCachedRedirects", "enqueueDownload", "enqueueRequest", "workQueue", "workItem", "Ljava/lang/Runnable;", "getPendingRequests", "", "issueResponse", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "bitmap", "Landroid/graphics/Bitmap;", "isCachedRedirect", "prioritizeRequest", "readFromCache", "removePendingRequest", "CacheReadWorkItem", "DownloadImageWorkItem", "DownloaderContext", "RequestKey", "facebook-core_release"})
public final class ImageDownloader {
    @NotNull
    public static final ImageDownloader INSTANCE = new ImageDownloader();
    private static final int DOWNLOAD_QUEUE_MAX_CONCURRENT = 8;
    private static final int CACHE_READ_QUEUE_MAX_CONCURRENT = 2;
    @Nullable
    private static Handler handler;
    @NotNull
    private static final WorkQueue downloadQueue;
    @NotNull
    private static final WorkQueue cacheReadQueue;
    @NotNull
    private static final Map<RequestKey, DownloaderContext> pendingRequests;

    private ImageDownloader() {
    }

    private final synchronized Handler getHandler() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void downloadAsync(@Nullable ImageRequest request) {
        if (request == null) {
            return;
        }
        RequestKey key = new RequestKey(request.getImageUri(), request.getCallerTag());
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (map) {
            Unit unit;
            boolean bl3 = false;
            DownloaderContext downloaderContext = pendingRequests.get(key);
            if (downloaderContext != null) {
                downloaderContext.setRequest(request);
                downloaderContext.setCancelled(false);
                WorkQueue.WorkItem workItem = downloaderContext.getWorkItem();
                if (workItem == null) {
                    unit = null;
                } else {
                    workItem.moveToFront();
                    unit = Unit.INSTANCE;
                }
            } else {
                INSTANCE.enqueueCacheRead(request, key, request.isCachedRedirectAllowed());
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean cancelRequest(@NotNull ImageRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        boolean cancelled = false;
        RequestKey key = new RequestKey(request.getImageUri(), request.getCallerTag());
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (map) {
            boolean bl3 = false;
            DownloaderContext downloaderContext = pendingRequests.get(key);
            if (downloaderContext != null) {
                cancelled = true;
                WorkQueue.WorkItem workItem = downloaderContext.getWorkItem();
                if (workItem != null && workItem.cancel()) {
                    pendingRequests.remove(key);
                } else {
                    downloaderContext.setCancelled(true);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        return cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void prioritizeRequest(@NotNull ImageRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        RequestKey key = new RequestKey(request.getImageUri(), request.getCallerTag());
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (map) {
            WorkQueue.WorkItem workItem;
            boolean bl3 = false;
            DownloaderContext downloaderContext = pendingRequests.get(key);
            if (downloaderContext != null && (workItem = downloaderContext.getWorkItem()) != null) {
                workItem.moveToFront();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmStatic
    public static final void clearCache() {
        ImageResponseCache.INSTANCE.clearCache();
        UrlRedirectCache.INSTANCE.clearCache();
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final Map<RequestKey, DownloaderContext> getPendingRequests() {
        return pendingRequests;
    }

    private final void enqueueCacheRead(ImageRequest request, RequestKey key, boolean allowCachedRedirects) {
        this.enqueueRequest(request, key, cacheReadQueue, new CacheReadWorkItem(key, allowCachedRedirects));
    }

    private final void enqueueDownload(ImageRequest request, RequestKey key) {
        this.enqueueRequest(request, key, downloadQueue, new DownloadImageWorkItem(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void enqueueRequest(ImageRequest request, RequestKey key, WorkQueue workQueue, Runnable workItem) {
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (map) {
            boolean bl3 = false;
            DownloaderContext downloaderContext = new DownloaderContext(request);
            Map<RequestKey, DownloaderContext> map2 = pendingRequests;
            boolean bl4 = false;
            map2.put(key, downloaderContext);
            downloaderContext.setWorkItem(WorkQueue.addActiveWorkItem$default(workQueue, workItem, false, 2, null));
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void issueResponse(RequestKey key, Exception error, Bitmap bitmap, boolean isCachedRedirect) {
        DownloaderContext completedRequestContext = this.removePendingRequest(key);
        if (completedRequestContext != null && !completedRequestContext.isCancelled()) {
            ImageRequest.Callback callback2;
            ImageRequest request = completedRequestContext.getRequest();
            ImageRequest imageRequest = request;
            ImageRequest.Callback callback3 = callback2 = imageRequest == null ? null : imageRequest.getCallback();
            if (callback2 != null && (imageRequest = this.getHandler()) != null) {
                imageRequest.post(() -> ImageDownloader.issueResponse$lambda-4(request, error, isCachedRedirect, bitmap, callback2));
            }
        }
    }

    private final void readFromCache(RequestKey key, boolean allowCachedRedirects) {
        InputStream cachedStream = null;
        boolean isCachedRedirect = false;
        if (allowCachedRedirects) {
            Uri redirectUri = UrlRedirectCache.getRedirectedUri(key.getUri());
            if (redirectUri != null) {
                cachedStream = ImageResponseCache.getCachedImageStream(redirectUri);
                boolean bl = isCachedRedirect = cachedStream != null;
            }
        }
        if (!isCachedRedirect) {
            cachedStream = ImageResponseCache.getCachedImageStream(key.getUri());
        }
        if (cachedStream != null) {
            Bitmap bitmap = BitmapFactory.decodeStream(cachedStream);
            Utility.closeQuietly(cachedStream);
            this.issueResponse(key, null, bitmap, isCachedRedirect);
        } else {
            ImageRequest request;
            DownloaderContext downloaderContext = this.removePendingRequest(key);
            DownloaderContext downloaderContext2 = downloaderContext;
            ImageRequest imageRequest = request = downloaderContext2 == null ? null : downloaderContext2.getRequest();
            if (downloaderContext != null && !downloaderContext.isCancelled() && request != null) {
                this.enqueueDownload(request, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void download(RequestKey key) {
        connection = null;
        stream = null;
        error = null;
        bitmap = null;
        issueResponse = true;
        try {
            url = new URL(key.getUri().toString());
            var8_10 = url.openConnection();
            if (var8_10 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            connection = (HttpURLConnection)var8_10;
            connection.setInstanceFollowRedirects(false);
            var8_11 = connection.getResponseCode();
            switch (var8_11) {
                case 301: 
                case 302: {
                    issueResponse = false;
                    redirectLocation = connection.getHeaderField("location");
                    if (!Utility.isNullOrEmpty(redirectLocation)) {
                        redirectUri = Uri.parse((String)redirectLocation);
                        UrlRedirectCache.cacheUriRedirect(key.getUri(), redirectUri);
                        downloaderContext = this.removePendingRequest(key);
                        if (downloaderContext != null && !downloaderContext.isCancelled()) {
                            v0 = downloaderContext.getRequest();
                            Intrinsics.checkNotNullExpressionValue((Object)redirectUri, (String)"redirectUri");
                            this.enqueueCacheRead(v0, new RequestKey(redirectUri, key.getTag()), false);
                            ** break;
                        }
                    }
lbl30:
                    // 5 sources

                    break;
                }
                case 200: {
                    stream = ImageResponseCache.interceptAndCacheImageStream(connection);
                    bitmap = BitmapFactory.decodeStream((InputStream)stream);
                    ** break;
lbl36:
                    // 1 sources

                    break;
                }
                default: {
                    stream = connection.getErrorStream();
                    errorMessageBuilder = new StringBuilder();
                    if (stream != null) {
                        reader = new InputStreamReader(stream);
                        buffer = new char[128];
                        bufferLength = 0;
                        while (true) {
                            var13_19 = reader.read(buffer, 0, buffer.length);
                            var14_20 = false;
                            var15_21 = false;
                            it = var13_19;
                            $i$a$-also-ImageDownloader$download$1 = false;
                            bufferLength = it;
                            if (var13_19 <= 0) break;
                            errorMessageBuilder.append(buffer, 0, bufferLength);
                        }
                        Utility.closeQuietly(reader);
                    } else {
                        errorMessageBuilder.append("Unexpected error while downloading an image.");
                    }
                    error = new FacebookException(errorMessageBuilder.toString());
                    break;
                }
            }
        }
        catch (IOException e) {
            error = e;
        }
        finally {
            Utility.closeQuietly(stream);
            Utility.disconnectQuietly(connection);
        }
        if (issueResponse) {
            this.issueResponse(key, error, bitmap, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DownloaderContext removePendingRequest(RequestKey key) {
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (map) {
            boolean bl3 = false;
            DownloaderContext downloaderContext = pendingRequests.remove(key);
            return downloaderContext;
        }
    }

    private static final void issueResponse$lambda-4(ImageRequest $request, Exception $error, boolean $isCachedRedirect, Bitmap $bitmap, ImageRequest.Callback $callback) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        ImageResponse response = new ImageResponse($request, $error, $isCachedRedirect, $bitmap);
        $callback.onCompleted(response);
    }

    static {
        downloadQueue = new WorkQueue(8, null, 2, null);
        cacheReadQueue = new WorkQueue(2, null, 2, null);
        pendingRequests = new HashMap();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/facebook/internal/ImageDownloader$RequestKey;", "", "uri", "Landroid/net/Uri;", "tag", "(Landroid/net/Uri;Ljava/lang/Object;)V", "getTag", "()Ljava/lang/Object;", "setTag", "(Ljava/lang/Object;)V", "getUri", "()Landroid/net/Uri;", "setUri", "(Landroid/net/Uri;)V", "equals", "", "o", "hashCode", "", "Companion", "facebook-core_release"})
    @VisibleForTesting(otherwise=2)
    public static final class RequestKey {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private Uri uri;
        @NotNull
        private Object tag;
        private static final int HASH_SEED = 29;
        private static final int HASH_MULTIPLIER = 37;

        public RequestKey(@NotNull Uri uri, @NotNull Object tag) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.uri = uri;
            this.tag = tag;
        }

        @NotNull
        public final Uri getUri() {
            return this.uri;
        }

        public final void setUri(@NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"<set-?>");
            this.uri = uri;
        }

        @NotNull
        public final Object getTag() {
            return this.tag;
        }

        public final void setTag(@NotNull Object object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
            this.tag = object;
        }

        public int hashCode() {
            int result = 29;
            result = result * 37 + this.uri.hashCode();
            result = result * 37 + this.tag.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object o) {
            boolean isEqual = false;
            if (o != null && o instanceof RequestKey) {
                Object compareTo = o;
                isEqual = ((RequestKey)compareTo).uri == this.uri && ((RequestKey)compareTo).tag == this.tag;
            }
            return isEqual;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/ImageDownloader$RequestKey$Companion;", "", "()V", "HASH_MULTIPLIER", "", "HASH_SEED", "facebook-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/facebook/internal/ImageDownloader$DownloaderContext;", "", "request", "Lcom/facebook/internal/ImageRequest;", "(Lcom/facebook/internal/ImageRequest;)V", "isCancelled", "", "()Z", "setCancelled", "(Z)V", "getRequest", "()Lcom/facebook/internal/ImageRequest;", "setRequest", "workItem", "Lcom/facebook/internal/WorkQueue$WorkItem;", "getWorkItem", "()Lcom/facebook/internal/WorkQueue$WorkItem;", "setWorkItem", "(Lcom/facebook/internal/WorkQueue$WorkItem;)V", "facebook-core_release"})
    @VisibleForTesting(otherwise=2)
    public static final class DownloaderContext {
        @NotNull
        private ImageRequest request;
        @Nullable
        private WorkQueue.WorkItem workItem;
        private boolean isCancelled;

        public DownloaderContext(@NotNull ImageRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.request = request;
        }

        @NotNull
        public final ImageRequest getRequest() {
            return this.request;
        }

        public final void setRequest(@NotNull ImageRequest imageRequest) {
            Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"<set-?>");
            this.request = imageRequest;
        }

        @Nullable
        public final WorkQueue.WorkItem getWorkItem() {
            return this.workItem;
        }

        public final void setWorkItem(@Nullable WorkQueue.WorkItem workItem) {
            this.workItem = workItem;
        }

        public final boolean isCancelled() {
            return this.isCancelled;
        }

        public final void setCancelled(boolean bl) {
            this.isCancelled = bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/internal/ImageDownloader$CacheReadWorkItem;", "Ljava/lang/Runnable;", "key", "Lcom/facebook/internal/ImageDownloader$RequestKey;", "allowCachedRedirects", "", "(Lcom/facebook/internal/ImageDownloader$RequestKey;Z)V", "run", "", "facebook-core_release"})
    private static final class CacheReadWorkItem
    implements Runnable {
        @NotNull
        private final RequestKey key;
        private final boolean allowCachedRedirects;

        public CacheReadWorkItem(@NotNull RequestKey key, boolean allowCachedRedirects) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.allowCachedRedirects = allowCachedRedirects;
        }

        @Override
        public void run() {
            if (CrashShieldHandler.isObjectCrashing(this)) {
                return;
            }
            try {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    INSTANCE.readFromCache(this.key, this.allowCachedRedirects);
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable(throwable, this);
                return;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/internal/ImageDownloader$DownloadImageWorkItem;", "Ljava/lang/Runnable;", "key", "Lcom/facebook/internal/ImageDownloader$RequestKey;", "(Lcom/facebook/internal/ImageDownloader$RequestKey;)V", "run", "", "facebook-core_release"})
    private static final class DownloadImageWorkItem
    implements Runnable {
        @NotNull
        private final RequestKey key;

        public DownloadImageWorkItem(@NotNull RequestKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
        }

        @Override
        public void run() {
            if (CrashShieldHandler.isObjectCrashing(this)) {
                return;
            }
            try {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    INSTANCE.download(this.key);
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable(throwable, this);
                return;
            }
        }
    }
}

