/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.restrictivedatafilter;

import android.util.Log;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J&\u0010\u0019\u001a\u00020\u00122\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/facebook/appevents/restrictivedatafilter/RestrictiveDataManager;", "", "()V", "PROCESS_EVENT_NAME", "", "REPLACEMENT_STRING", "RESTRICTIVE_PARAM", "RESTRICTIVE_PARAM_KEY", "TAG", "kotlin.jvm.PlatformType", "enabled", "", "restrictedEvents", "", "restrictiveParamFilters", "", "Lcom/facebook/appevents/restrictivedatafilter/RestrictiveDataManager$RestrictiveParamFilter;", "enable", "", "getMatchedRuleType", "eventName", "paramKey", "initialize", "isRestrictedEvent", "processEvent", "processParameters", "parameters", "", "RestrictiveParamFilter", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class RestrictiveDataManager {
    @NotNull
    public static final RestrictiveDataManager INSTANCE = new RestrictiveDataManager();
    private static boolean enabled;
    private static final String TAG;
    @NotNull
    private static final List<RestrictiveParamFilter> restrictiveParamFilters;
    @NotNull
    private static final Set<String> restrictedEvents;
    @NotNull
    private static final String REPLACEMENT_STRING = "_removed_";
    @NotNull
    private static final String PROCESS_EVENT_NAME = "process_event_name";
    @NotNull
    private static final String RESTRICTIVE_PARAM = "restrictive_param";
    @NotNull
    private static final String RESTRICTIVE_PARAM_KEY = "_restrictedParams";

    private RestrictiveDataManager() {
    }

    @JvmStatic
    public static final void enable() {
        if (CrashShieldHandler.isObjectCrashing(RestrictiveDataManager.class)) {
            return;
        }
        try {
            enabled = true;
            INSTANCE.initialize();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RestrictiveDataManager.class);
            return;
        }
    }

    private final void initialize() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            try {
                String restrictiveDataSetting;
                block12: {
                    block11: {
                        FetchedAppSettings fetchedAppSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.INSTANCE.getApplicationId(), false);
                        if (fetchedAppSettings == null) {
                            return;
                        }
                        FetchedAppSettings settings = fetchedAppSettings;
                        restrictiveDataSetting = settings.getRestrictiveDataSetting();
                        if (restrictiveDataSetting == null) break block11;
                        CharSequence charSequence = restrictiveDataSetting;
                        boolean bl = false;
                        if (!(charSequence.length() == 0)) break block12;
                    }
                    return;
                }
                JSONObject restrictiveData = new JSONObject(restrictiveDataSetting);
                restrictiveParamFilters.clear();
                restrictedEvents.clear();
                Iterator keys = restrictiveData.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONObject filteredValues = restrictiveData.getJSONObject(key);
                    if (filteredValues == null) continue;
                    JSONObject restrictiveParamJson = filteredValues.optJSONObject(RESTRICTIVE_PARAM);
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    RestrictiveParamFilter restrictiveParamFilter = new RestrictiveParamFilter(key, new HashMap());
                    if (restrictiveParamJson != null) {
                        restrictiveParamFilter.setRestrictiveParams(Utility.convertJSONObjectToStringMap(restrictiveParamJson));
                        restrictiveParamFilters.add(restrictiveParamFilter);
                    }
                    if (!filteredValues.has(PROCESS_EVENT_NAME)) continue;
                    restrictedEvents.add(restrictiveParamFilter.getEventName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    @NotNull
    public static final String processEvent(@NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(RestrictiveDataManager.class)) {
            return null;
        }
        try {
            String eventName;
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            return enabled && INSTANCE.isRestrictedEvent(eventName) ? REPLACEMENT_STRING : eventName;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RestrictiveDataManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void processParameters(@NotNull Map<String, String> map, @NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(RestrictiveDataManager.class)) {
            return;
        }
        try {
            void eventName;
            Map<String, String> parameters;
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            if (!enabled) {
                return;
            }
            Map restrictedParams = new HashMap();
            List keys = new ArrayList(parameters.keySet());
            for (String key : keys) {
                String type = INSTANCE.getMatchedRuleType((String)eventName, key);
                if (type == null) continue;
                Map map2 = restrictedParams;
                boolean bl = false;
                map2.put(key, type);
                parameters.remove(key);
            }
            Map map3 = restrictedParams;
            boolean bl = false;
            if (!map3.isEmpty()) {
                try {
                    JSONObject restrictedJSON = new JSONObject();
                    Object object = restrictedParams;
                    boolean bl2 = false;
                    Object object2 = object.entrySet().iterator();
                    while (object2.hasNext()) {
                        Object object3 = object = object2.next();
                        boolean bl3 = false;
                        String key = (String)object3.getKey();
                        Object object4 = object;
                        boolean bl4 = false;
                        String value = (String)object4.getValue();
                        restrictedJSON.put(key, (Object)value);
                    }
                    object2 = parameters;
                    object = RESTRICTIVE_PARAM_KEY;
                    String string2 = restrictedJSON.toString();
                    boolean bl5 = false;
                    object2.put(object, string2);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RestrictiveDataManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getMatchedRuleType(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            try {
                List restrictiveParamFiltersCopy = new ArrayList(restrictiveParamFilters);
                for (RestrictiveParamFilter filter : restrictiveParamFiltersCopy) {
                    void eventName;
                    if (filter == null || !Intrinsics.areEqual((Object)eventName, (Object)filter.getEventName())) continue;
                    for (String param : filter.getRestrictiveParams().keySet()) {
                        void paramKey;
                        if (!Intrinsics.areEqual((Object)paramKey, (Object)param)) continue;
                        return filter.getRestrictiveParams().get(param);
                    }
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"getMatchedRuleType failed", (Throwable)e);
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRestrictedEvent(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void eventName;
            return restrictedEvents.contains(eventName);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    static {
        TAG = RestrictiveDataManager.class.getCanonicalName();
        restrictiveParamFilters = new ArrayList();
        restrictedEvents = new CopyOnWriteArraySet();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR(\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/facebook/appevents/restrictivedatafilter/RestrictiveDataManager$RestrictiveParamFilter;", "", "eventName", "", "restrictiveParams", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getEventName", "()Ljava/lang/String;", "setEventName", "(Ljava/lang/String;)V", "getRestrictiveParams", "()Ljava/util/Map;", "setRestrictiveParams", "(Ljava/util/Map;)V", "facebook-core_release"})
    public static final class RestrictiveParamFilter {
        @NotNull
        private String eventName;
        @NotNull
        private Map<String, String> restrictiveParams;

        public RestrictiveParamFilter(@NotNull String eventName, @NotNull Map<String, String> restrictiveParams) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter(restrictiveParams, (String)"restrictiveParams");
            this.eventName = eventName;
            this.restrictiveParams = restrictiveParams;
        }

        @NotNull
        public final String getEventName() {
            return this.eventName;
        }

        public final void setEventName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.eventName = string;
        }

        @NotNull
        public final Map<String, String> getRestrictiveParams() {
            return this.restrictiveParams;
        }

        public final void setRestrictiveParams(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.restrictiveParams = map;
        }
    }
}

