/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.internal.HashUtils;
import com.facebook.appevents.internal.SessionInfo;
import com.facebook.appevents.internal.SourceApplicationInfo;
import com.facebook.internal.Logger;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.internal.security.CertificateUtil;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\u0016\u001a\u00020\u0011H\u0002J$\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/facebook/appevents/internal/SessionLogger;", "", "()V", "INACTIVE_SECONDS_QUANTA", "", "PACKAGE_CHECKSUM", "", "TAG", "kotlin.jvm.PlatformType", "computePackageChecksum", "context", "Landroid/content/Context;", "getQuantaIndex", "", "timeBetweenSessions", "", "logActivateApp", "", "activityName", "sourceApplicationInfo", "Lcom/facebook/appevents/internal/SourceApplicationInfo;", "appId", "logClockSkewEvent", "logDeactivateApp", "sessionInfo", "Lcom/facebook/appevents/internal/SessionInfo;", "facebook-core_release"})
public final class SessionLogger {
    @NotNull
    public static final SessionLogger INSTANCE = new SessionLogger();
    @NotNull
    private static final String PACKAGE_CHECKSUM = "PCKGCHKSUM";
    private static final String TAG = SessionLogger.class.getCanonicalName();
    @NotNull
    private static final long[] INACTIVE_SECONDS_QUANTA;

    private SessionLogger() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void logActivateApp(@NotNull String string, @Nullable SourceApplicationInfo sourceApplicationInfo, @Nullable String string2, @NotNull Context context) {
        if (CrashShieldHandler.isObjectCrashing(SessionLogger.class)) {
            return;
        }
        try {
            void appId;
            String string3;
            void sourceApplicationInfo2;
            void context2;
            String activityName;
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            void var5_4 = sourceApplicationInfo2;
            String sourAppInfoStr = var5_4 == null ? "Unclassified" : ((string3 = var5_4.toString()) == null ? "Unclassified" : string3);
            Bundle eventParams = new Bundle();
            eventParams.putString("fb_mobile_launch_source", sourAppInfoStr);
            eventParams.putString("fb_mobile_pckg_fp", INSTANCE.computePackageChecksum((Context)context2));
            eventParams.putString("fb_mobile_app_cert_hash", CertificateUtil.getCertificateHash((Context)context2));
            InternalAppEventsLogger logger = InternalAppEventsLogger.Companion.createInstance(activityName, (String)appId, null);
            logger.logEvent("fb_mobile_activate_app", eventParams);
            if (InternalAppEventsLogger.Companion.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
                logger.flush();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SessionLogger.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void logDeactivateApp(@NotNull String string, @Nullable SessionInfo sessionInfo, @Nullable String string2) {
        if (CrashShieldHandler.isObjectCrashing(SessionLogger.class)) {
            return;
        }
        try {
            void appId;
            long sessionLength;
            long interruptionDurationMillis;
            Long l;
            void sessionInfo2;
            String activityName;
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            if (sessionInfo2 == null) {
                return;
            }
            Long l2 = sessionInfo2.getDiskRestoreTime();
            long l3 = l2 == null ? 0L - ((l = sessionInfo2.getSessionLastEventTime()) == null ? 0L : l) : (interruptionDurationMillis = l2.longValue());
            if (interruptionDurationMillis < 0L) {
                interruptionDurationMillis = 0L;
                INSTANCE.logClockSkewEvent();
            }
            if ((sessionLength = sessionInfo2.getSessionLength()) < 0L) {
                INSTANCE.logClockSkewEvent();
                sessionLength = 0L;
            }
            Bundle eventParams = new Bundle();
            eventParams.putInt("fb_mobile_app_interruptions", sessionInfo2.getInterruptionCount());
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ROOT;
            Object object = "session_quanta_%d";
            Object object2 = new Object[1];
            object2[0] = SessionLogger.getQuantaIndex(interruptionDurationMillis);
            boolean bl = false;
            String string3 = String.format(locale, (String)object, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            eventParams.putString("fb_mobile_time_between_sessions", string3);
            SourceApplicationInfo sourceApplicationInfo = sessionInfo2.getSourceApplicationInfo();
            object = sourceApplicationInfo;
            Object sourAppInfoStr = object == null ? "Unclassified" : ((object2 = ((SourceApplicationInfo)object).toString()) == null ? "Unclassified" : object2);
            eventParams.putString("fb_mobile_launch_source", (String)sourAppInfoStr);
            object = sessionInfo2.getSessionLastEventTime();
            eventParams.putLong("_logTime", (object == null ? 0L : (Long)object) / (long)1000);
            InternalAppEventsLogger.Companion.createInstance(activityName, (String)appId, null).logEvent("fb_mobile_deactivate_app", (double)sessionLength / (double)1000L, eventParams);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SessionLogger.class);
            return;
        }
    }

    private final void logClockSkewEvent() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            String string = TAG;
            Intrinsics.checkNotNull((Object)string);
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, string, "Clock skew detected");
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @JvmStatic
    public static final int getQuantaIndex(long l) {
        if (CrashShieldHandler.isObjectCrashing(SessionLogger.class)) {
            return 0;
        }
        try {
            long timeBetweenSessions;
            int quantaIndex;
            for (quantaIndex = 0; quantaIndex < INACTIVE_SECONDS_QUANTA.length && INACTIVE_SECONDS_QUANTA[quantaIndex] < timeBetweenSessions; ++quantaIndex) {
            }
            return quantaIndex;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, SessionLogger.class);
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String computePackageChecksum(Context context) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            String string;
            try {
                String string2;
                void context2;
                PackageManager pm = context2.getPackageManager();
                String packageVersion = pm.getPackageInfo((String)context2.getPackageName(), (int)0).versionName;
                String packageHashSharedPrefKey = Intrinsics.stringPlus((String)"PCKGCHKSUM;", (Object)packageVersion);
                SharedPreferences preferences2 = context2.getSharedPreferences("com.facebook.sdk.appEventPreferences", 0);
                String packageHash = preferences2.getString(packageHashSharedPrefKey, null);
                if (packageHash != null && packageHash.length() == 32) {
                    return packageHash;
                }
                String androidPackageManagerChecksum = HashUtils.computeChecksumWithPackageManager((Context)context2, null);
                if (androidPackageManagerChecksum != null) {
                    string2 = androidPackageManagerChecksum;
                } else {
                    ApplicationInfo applicationInfo = pm.getApplicationInfo(context2.getPackageName(), 0);
                    Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"pm.getApplicationInfo(context.packageName, 0)");
                    ApplicationInfo ai = applicationInfo;
                    string2 = HashUtils.computeChecksum(ai.sourceDir);
                }
                packageHash = string2;
                preferences2.edit().putString(packageHashSharedPrefKey, packageHash).apply();
                string = packageHash;
            }
            catch (Exception e) {
                string = null;
            }
            return string;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    static {
        long[] lArray = new long[]{300000L, 900000L, 1800000L, 3600000L, 21600000L, 43200000L, 86400000L, 172800000L, 259200000L, 604800000L, 1209600000L, 1814400000L, 2419200000L, 5184000000L, 7776000000L, 10368000000L, 12960000000L, 15552000000L, 31536000000L};
        INACTIVE_SECONDS_QUANTA = lArray;
    }
}

