/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.appevents.iap.InAppPurchaseUtils;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0001\u00a2\u0006\u0002\b\u0018JK\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u00122\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u001b\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0007JR\u0010\u001f\u001a\u00020\u001e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u00152\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0017H\u0007J\b\u0010#\u001a\u00020\u0017H\u0007J4\u0010$\u001a\u00020\u001e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0017H\u0002J\b\u0010%\u001a\u00020\u001eH\u0007J\b\u0010&\u001a\u00020\u001eH\u0007J\b\u0010'\u001a\u00020\u001eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/facebook/appevents/iap/InAppPurchaseLoggerManager;", "", "()V", "APPROXIMATE_IAP_ENHANCEMENT_RELEASE_TIME", "", "APP_HAS_BEEN_LAUNCHED_KEY", "", "CACHED_PURCHASES_KEY", "IAP_CACHE_GPBLV2V7", "IAP_CACHE_OLD", "IAP_PURCHASE_CACHE_GPBLV1", "IAP_SKU_CACHE_GPBLV1", "MILLISECONDS_IN_SECONDS", "", "PURCHASE_TIME", "TIME_OF_LAST_LOGGED_PURCHASE_KEY", "TIME_OF_LAST_LOGGED_SUBSCRIPTION_KEY", "cacheDeDupPurchase", "", "Lorg/json/JSONObject;", "purchaseDetailsMap", "", "isSubscription", "", "cacheDeDupPurchase$facebook_core_release", "constructLoggingReadyMap", "skuDetailsMap", "packageName", "constructLoggingReadyMap$facebook_core_release", "deleteOldCacheHistory", "", "filterPurchaseLogging", "billingClientVersion", "Lcom/facebook/appevents/iap/InAppPurchaseUtils$BillingClientVersion;", "isFirstAppLaunch", "getIsFirstAppLaunchWithNewIAP", "logPurchases", "migrateOldCacheHistory", "setAppHasBeenLaunchedWithNewIAP", "updateLatestPossiblePurchaseTime", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InAppPurchaseLoggerManager {
    @NotNull
    public static final InAppPurchaseLoggerManager INSTANCE = new InAppPurchaseLoggerManager();
    private static final long APPROXIMATE_IAP_ENHANCEMENT_RELEASE_TIME = 1736528400000L;
    private static final double MILLISECONDS_IN_SECONDS = 1000.0;
    @NotNull
    private static final String PURCHASE_TIME = "purchaseTime";
    @NotNull
    private static final String IAP_SKU_CACHE_GPBLV1 = "com.facebook.internal.SKU_DETAILS";
    @NotNull
    private static final String IAP_PURCHASE_CACHE_GPBLV1 = "com.facebook.internal.PURCHASE";
    @NotNull
    private static final String IAP_CACHE_OLD = "com.facebook.internal.iap.PRODUCT_DETAILS";
    @NotNull
    private static final String IAP_CACHE_GPBLV2V7 = "com.facebook.internal.iap.IAP_CACHE_GPBLV2V7";
    @NotNull
    private static final String CACHED_PURCHASES_KEY = "PURCHASE_DETAILS_SET";
    @NotNull
    private static final String APP_HAS_BEEN_LAUNCHED_KEY = "APP_HAS_BEEN_LAUNCHED_KEY";
    @NotNull
    private static final String TIME_OF_LAST_LOGGED_PURCHASE_KEY = "TIME_OF_LAST_LOGGED_PURCHASE";
    @NotNull
    private static final String TIME_OF_LAST_LOGGED_SUBSCRIPTION_KEY = "TIME_OF_LAST_LOGGED_SUBSCRIPTION";

    private InAppPurchaseLoggerManager() {
    }

    @JvmStatic
    public static final void migrateOldCacheHistory() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return;
        }
        try {
            SharedPreferences iapCache = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(IAP_CACHE_GPBLV2V7, 0);
            long l = iapCache.getLong(TIME_OF_LAST_LOGGED_PURCHASE_KEY, 0L);
            long l2 = iapCache.getLong(TIME_OF_LAST_LOGGED_SUBSCRIPTION_KEY, 0L);
            boolean bl = false;
            l = Math.max(l, l2);
            l2 = 1736528400000L;
            bl = false;
            long newestCandidateTime = Math.max(l, l2);
            Set cachedPurchaseSet = new CopyOnWriteArraySet();
            SharedPreferences sharedPreferences = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(IAP_CACHE_OLD, 0);
            if (sharedPreferences.contains(CACHED_PURCHASES_KEY)) {
                Collection collection;
                boolean bl2 = false;
                Set set = sharedPreferences.getStringSet(CACHED_PURCHASES_KEY, (Set)new HashSet());
                if (set == null) {
                    bl2 = false;
                    collection = new HashSet();
                } else {
                    collection = set;
                }
                cachedPurchaseSet.addAll(collection);
                for (String purchaseHistory : cachedPurchaseSet) {
                    try {
                        String[] stringArray = new String[]{";"};
                        List splitPurchase = StringsKt.split$default((CharSequence)purchaseHistory, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                        String string = (String)splitPurchase.get(1);
                        boolean bl3 = false;
                        long timeInMilliseconds = Long.parseLong(string) * 1000L;
                        int digitsInTime = String.valueOf(timeInMilliseconds).length();
                        int digitsInReleaseTime = String.valueOf(1736528400000L).length();
                        int n = digitsInTime - digitsInReleaseTime;
                        boolean bl4 = false;
                        double d = 1000.0;
                        boolean bl5 = false;
                        if ((double)Math.abs(n) >= Math.log10(d)) continue;
                        boolean bl6 = false;
                        newestCandidateTime = Math.max(newestCandidateTime, timeInMilliseconds);
                    }
                    catch (Exception e) {}
                }
            }
            iapCache.edit().putLong(TIME_OF_LAST_LOGGED_SUBSCRIPTION_KEY, newestCandidateTime).apply();
            iapCache.edit().putLong(TIME_OF_LAST_LOGGED_PURCHASE_KEY, newestCandidateTime).apply();
            INSTANCE.deleteOldCacheHistory();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void deleteOldCacheHistory() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return;
        }
        try {
            SharedPreferences cachedSkuSharedPref = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(IAP_SKU_CACHE_GPBLV1, 0);
            SharedPreferences cachedPurchaseSharedPref = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(IAP_PURCHASE_CACHE_GPBLV1, 0);
            cachedSkuSharedPref.edit().clear().apply();
            cachedPurchaseSharedPref.edit().clear().apply();
            SharedPreferences sharedPreferences = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(IAP_CACHE_OLD, 0);
            sharedPreferences.edit().clear().apply();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return;
        }
    }

    @JvmStatic
    public static final boolean getIsFirstAppLaunchWithNewIAP() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return false;
        }
        try {
            SharedPreferences iapCache = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(IAP_CACHE_GPBLV2V7, 0);
            return !iapCache.contains(APP_HAS_BEEN_LAUNCHED_KEY);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return false;
        }
    }

    @JvmStatic
    public static final void setAppHasBeenLaunchedWithNewIAP() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return;
        }
        try {
            SharedPreferences iapCache = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(IAP_CACHE_GPBLV2V7, 0);
            try {
                iapCache.edit().putBoolean(APP_HAS_BEEN_LAUNCHED_KEY, true).apply();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void updateLatestPossiblePurchaseTime() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return;
        }
        try {
            INSTANCE.setAppHasBeenLaunchedWithNewIAP();
            try {
                SharedPreferences iapCache = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(IAP_CACHE_GPBLV2V7, 0);
                long currTime = System.currentTimeMillis();
                iapCache.edit().putLong(TIME_OF_LAST_LOGGED_SUBSCRIPTION_KEY, currTime).apply();
                iapCache.edit().putLong(TIME_OF_LAST_LOGGED_PURCHASE_KEY, currTime).apply();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void filterPurchaseLogging(@NotNull Map<String, JSONObject> map, @NotNull Map<String, ? extends JSONObject> map2, boolean bl, @NotNull String string, @NotNull InAppPurchaseUtils.BillingClientVersion billingClientVersion, boolean bl2) {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseLoggerManager.class)) {
            return;
        }
        try {
            void isFirstAppLaunch;
            void isSubscription;
            void billingClientVersion2;
            void packageName;
            void skuDetailsMap;
            Map<String, JSONObject> purchaseDetailsMap;
            Intrinsics.checkNotNullParameter(purchaseDetailsMap, (String)"purchaseDetailsMap");
            Intrinsics.checkNotNullParameter((Object)skuDetailsMap, (String)"skuDetailsMap");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)billingClientVersion2, (String)"billingClientVersion");
            Map<String, JSONObject> deduped = INSTANCE.cacheDeDupPurchase$facebook_core_release(purchaseDetailsMap, (boolean)isSubscription);
            Map<String, String> loggingReady = INSTANCE.constructLoggingReadyMap$facebook_core_release(deduped, (Map<String, ? extends JSONObject>)skuDetailsMap, (String)packageName);
            INSTANCE.logPurchases(loggingReady, (boolean)isSubscription, (InAppPurchaseUtils.BillingClientVersion)billingClientVersion2, (boolean)isFirstAppLaunch);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseLoggerManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logPurchases(Map<String, String> map, boolean bl, InAppPurchaseUtils.BillingClientVersion billingClientVersion, boolean bl2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void purchaseDetailsMap;
            Map.Entry entry = purchaseDetailsMap;
            boolean bl3 = false;
            Iterator iterator = entry.entrySet().iterator();
            while (iterator.hasNext()) {
                void isFirstAppLaunch;
                void billingClientVersion2;
                void isSubscription;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl4 = false;
                String purchaseDetails = (String)entry2.getKey();
                Map.Entry entry3 = entry;
                boolean bl5 = false;
                String skuDetails = (String)entry3.getValue();
                AutomaticAnalyticsLogger.logPurchase(purchaseDetails, skuDetails, (boolean)isSubscription, (InAppPurchaseUtils.BillingClientVersion)billingClientVersion2, (boolean)isFirstAppLaunch);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting(otherwise=2)
    @NotNull
    public final Map<String, JSONObject> cacheDeDupPurchase$facebook_core_release(@NotNull Map<String, JSONObject> map, boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void isSubscription;
            void purchaseDetailsMap;
            Intrinsics.checkNotNullParameter((Object)purchaseDetailsMap, (String)"purchaseDetailsMap");
            SharedPreferences iapCache = FacebookSdk.INSTANCE.getApplicationContext().getSharedPreferences(IAP_CACHE_GPBLV2V7, 0);
            long timeOfLatestNewlyLoggedPurchase = 0L;
            long timeOfLastLoggedPurchase = isSubscription != false ? iapCache.getLong(TIME_OF_LAST_LOGGED_SUBSCRIPTION_KEY, 1736528400000L) : iapCache.getLong(TIME_OF_LAST_LOGGED_PURCHASE_KEY, 1736528400000L);
            Map tempPurchaseDetailsMap = MapsKt.toMap((Map)purchaseDetailsMap);
            Object object = tempPurchaseDetailsMap;
            boolean bl2 = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl3 = false;
                String key = (String)object2.getKey();
                Object object3 = object;
                boolean bl4 = false;
                JSONObject purchaseJson = (JSONObject)object3.getValue();
                try {
                    if (!purchaseJson.has("purchaseToken") || !purchaseJson.has(PURCHASE_TIME)) continue;
                    long purchaseTime = purchaseJson.getLong(PURCHASE_TIME);
                    if (purchaseTime <= timeOfLastLoggedPurchase) {
                        purchaseDetailsMap.remove(key);
                    }
                    boolean bl5 = false;
                    timeOfLatestNewlyLoggedPurchase = Math.max(timeOfLatestNewlyLoggedPurchase, purchaseTime);
                }
                catch (Exception exception) {}
            }
            if (timeOfLatestNewlyLoggedPurchase >= timeOfLastLoggedPurchase) {
                if (isSubscription != false) {
                    iapCache.edit().putLong(TIME_OF_LAST_LOGGED_SUBSCRIPTION_KEY, timeOfLatestNewlyLoggedPurchase).apply();
                } else {
                    iapCache.edit().putLong(TIME_OF_LAST_LOGGED_PURCHASE_KEY, timeOfLatestNewlyLoggedPurchase).apply();
                }
            }
            return new HashMap(purchaseDetailsMap);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting(otherwise=2)
    @NotNull
    public final Map<String, String> constructLoggingReadyMap$facebook_core_release(@NotNull Map<String, ? extends JSONObject> map, @NotNull Map<String, ? extends JSONObject> map2, @NotNull String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void packageName;
            void skuDetailsMap;
            void purchaseDetailsMap;
            Intrinsics.checkNotNullParameter((Object)purchaseDetailsMap, (String)"purchaseDetailsMap");
            Intrinsics.checkNotNullParameter((Object)skuDetailsMap, (String)"skuDetailsMap");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            boolean bl = false;
            Map purchaseResultMap = new LinkedHashMap();
            Map.Entry entry = purchaseDetailsMap;
            boolean bl2 = false;
            Iterator iterator = entry.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2 = entry = iterator.next();
                boolean bl3 = false;
                String key = (String)entry2.getKey();
                Map.Entry entry3 = entry;
                boolean bl4 = false;
                JSONObject purchaseDetail = (JSONObject)entry3.getValue();
                JSONObject skuDetail = (JSONObject)skuDetailsMap.get(key);
                try {
                    purchaseDetail.put("packageName", (Object)packageName);
                    if (skuDetail == null) continue;
                    Map map3 = purchaseResultMap;
                    String string2 = purchaseDetail.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"purchaseDetail.toString()");
                    String string3 = skuDetail.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"skuDetail.toString()");
                    boolean bl5 = false;
                    map3.put(string2, string3);
                }
                catch (Exception exception) {}
            }
            return purchaseResultMap;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }
}

