/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.os.Bundle;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.OperationalData;
import com.facebook.appevents.OperationalDataEnum;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\rJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\fJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J&\u0010\u0015\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00070\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\tJ(\u0010\u0019\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0007\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017J!\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/facebook/appevents/iap/InAppPurchaseDedupeConfig;", "", "()V", "defaultCurrencyParameterEquivalents", "", "", "defaultDedupeParameters", "Lkotlin/Pair;", "defaultDedupeWindow", "", "defaultValueParameterEquivalents", "addDedupeParameters", "Landroid/os/Bundle;", "Lcom/facebook/appevents/OperationalData;", "dedupeParameters", "originalParameters", "originalOperationalData", "getCurrencyOfManualEvent", "Ljava/util/Currency;", "parameters", "getCurrencyParameterEquivalents", "getDedupeParameters", "dedupingWithImplicitlyLoggedHistory", "", "getDedupeWindow", "getTestDedupeParameters", "getValueOfManualEvent", "", "valueToSum", "(Ljava/lang/Double;Landroid/os/Bundle;)Ljava/lang/Double;", "getValueParameterEquivalents", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InAppPurchaseDedupeConfig {
    @NotNull
    public static final InAppPurchaseDedupeConfig INSTANCE = new InAppPurchaseDedupeConfig();
    @NotNull
    private static final List<String> defaultCurrencyParameterEquivalents = CollectionsKt.listOf((Object)"fb_currency");
    @NotNull
    private static final List<String> defaultValueParameterEquivalents = CollectionsKt.listOf((Object)"_valueToSum");
    private static final long defaultDedupeWindow = TimeUnit.MINUTES.toMillis(1L);
    @NotNull
    private static final List<Pair<String, List<String>>> defaultDedupeParameters;

    private InAppPurchaseDedupeConfig() {
    }

    @NotNull
    public final List<Pair<String, List<String>>> getDedupeParameters(boolean dedupingWithImplicitlyLoggedHistory) {
        FetchedAppSettings settings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(FacebookSdk.INSTANCE.getApplicationId());
        FetchedAppSettings fetchedAppSettings = settings;
        if ((fetchedAppSettings == null ? null : fetchedAppSettings.getProdDedupeParameters()) == null || settings.getProdDedupeParameters().isEmpty()) {
            return defaultDedupeParameters;
        }
        if (!dedupingWithImplicitlyLoggedHistory) {
            return settings.getProdDedupeParameters();
        }
        ArrayList<Pair> swappedParameters = new ArrayList<Pair>();
        for (Pair<String, List<String>> item : settings.getProdDedupeParameters()) {
            List values = (List)item.getSecond();
            for (String value : values) {
                swappedParameters.add(new Pair((Object)value, (Object)CollectionsKt.listOf((Object)item.getFirst())));
            }
        }
        return swappedParameters;
    }

    @Nullable
    public final List<Pair<String, List<String>>> getTestDedupeParameters(boolean dedupingWithImplicitlyLoggedHistory) {
        Object object = FetchedAppSettingsManager.getAppSettingsWithoutQuery(FacebookSdk.INSTANCE.getApplicationId());
        if (object == null) {
            return null;
        }
        FetchedAppSettings settings = object;
        object = settings.getTestDedupeParameters();
        boolean bl = false;
        boolean bl2 = false;
        if (object == null || object.isEmpty()) {
            return null;
        }
        if (!dedupingWithImplicitlyLoggedHistory) {
            return settings.getTestDedupeParameters();
        }
        ArrayList<Pair> swappedParameters = new ArrayList<Pair>();
        for (Pair<String, List<String>> item : settings.getTestDedupeParameters()) {
            List values = (List)item.getSecond();
            for (String value : values) {
                swappedParameters.add(new Pair((Object)value, (Object)CollectionsKt.listOf((Object)item.getFirst())));
            }
        }
        return swappedParameters;
    }

    @NotNull
    public final List<String> getCurrencyParameterEquivalents() {
        FetchedAppSettings settings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(FacebookSdk.INSTANCE.getApplicationId());
        FetchedAppSettings fetchedAppSettings = settings;
        if ((fetchedAppSettings == null ? null : fetchedAppSettings.getCurrencyDedupeParameters()) == null || settings.getCurrencyDedupeParameters().isEmpty()) {
            return defaultCurrencyParameterEquivalents;
        }
        return settings.getCurrencyDedupeParameters();
    }

    @NotNull
    public final List<String> getValueParameterEquivalents() {
        FetchedAppSettings settings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(FacebookSdk.INSTANCE.getApplicationId());
        FetchedAppSettings fetchedAppSettings = settings;
        if ((fetchedAppSettings == null ? null : fetchedAppSettings.getPurchaseValueDedupeParameters()) == null || settings.getPurchaseValueDedupeParameters().isEmpty()) {
            return defaultValueParameterEquivalents;
        }
        return settings.getPurchaseValueDedupeParameters();
    }

    @Nullable
    public final Currency getCurrencyOfManualEvent(@Nullable Bundle parameters) {
        List<String> currencyParameters = this.getCurrencyParameterEquivalents();
        for (String equivalent : currencyParameters) {
            try {
                Object object = parameters;
                String currencyCode = object == null ? null : object.getString(equivalent);
                object = currencyCode;
                boolean bl = false;
                boolean bl2 = false;
                if (object == null || object.length() == 0) continue;
                return Currency.getInstance(currencyCode);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Nullable
    public final Double getValueOfManualEvent(@Nullable Double valueToSum, @Nullable Bundle parameters) {
        if (valueToSum != null) {
            return valueToSum;
        }
        List<String> valueParameters = this.getValueParameterEquivalents();
        for (String equivalent : valueParameters) {
            try {
                Double d;
                Bundle bundle = parameters;
                Double d2 = d = bundle == null ? null : Double.valueOf(bundle.getDouble(equivalent));
                if (d == null) continue;
                double value = d;
                return value;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public final long getDedupeWindow() {
        FetchedAppSettings settings;
        block3: {
            block2: {
                settings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(FacebookSdk.INSTANCE.getApplicationId());
                FetchedAppSettings fetchedAppSettings = settings;
                if ((fetchedAppSettings == null ? null : fetchedAppSettings.getDedupeWindow()) == null) break block2;
                Long l = settings.getDedupeWindow();
                long l2 = 0L;
                if (l == null || l != l2) break block3;
            }
            return defaultDedupeWindow;
        }
        return settings.getDedupeWindow();
    }

    @NotNull
    public final Pair<Bundle, OperationalData> addDedupeParameters(@Nullable Bundle dedupeParameters, @Nullable Bundle originalParameters, @Nullable OperationalData originalOperationalData) {
        Bundle bundle = originalParameters;
        OperationalData operationalData = originalOperationalData;
        if (dedupeParameters == null) {
            return new Pair((Object)originalParameters, (Object)originalOperationalData);
        }
        try {
            for (String key : dedupeParameters.keySet()) {
                String value = dedupeParameters.getString(key);
                if (value == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                Pair<Bundle, OperationalData> pair = OperationalData.Companion.addParameterAndReturn(OperationalDataEnum.IAPParameters, key, value, bundle, operationalData);
                Bundle newBundle = (Bundle)pair.component1();
                OperationalData newOperationalData = (OperationalData)pair.component2();
                bundle = newBundle;
                operationalData = newOperationalData;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Pair((Object)bundle, (Object)operationalData);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"fb_iap_product_id", (Object)CollectionsKt.listOf((Object)"fb_iap_product_id")), TuplesKt.to((Object)"fb_iap_product_description", (Object)CollectionsKt.listOf((Object)"fb_iap_product_description")), TuplesKt.to((Object)"fb_iap_product_title", (Object)CollectionsKt.listOf((Object)"fb_iap_product_title")), TuplesKt.to((Object)"fb_iap_purchase_token", (Object)CollectionsKt.listOf((Object)"fb_iap_purchase_token"))};
        defaultDedupeParameters = CollectionsKt.listOf((Object[])objectArray);
    }
}

