/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.appevents.codeless.CodelessMatcher;
import com.facebook.appevents.codeless.ViewIndexer;
import com.facebook.appevents.codeless.ViewIndexingTrigger;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0007J\b\u0010\u0014\u001a\u00020\u0011H\u0007J\r\u0010\u0015\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0015\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\bH\u0001\u00a2\u0006\u0002\b!R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/facebook/appevents/codeless/CodelessManager;", "", "()V", "deviceSessionID", "", "isAppIndexingEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isCheckingSession", "", "isCodelessEnabled", "sensorManager", "Landroid/hardware/SensorManager;", "viewIndexer", "Lcom/facebook/appevents/codeless/ViewIndexer;", "viewIndexingTrigger", "Lcom/facebook/appevents/codeless/ViewIndexingTrigger;", "checkCodelessSession", "", "applicationId", "disable", "enable", "getCurrentDeviceSessionID", "getCurrentDeviceSessionID$facebook_core_release", "getIsAppIndexingEnabled", "getIsAppIndexingEnabled$facebook_core_release", "isDebugOnEmulator", "onActivityDestroyed", "activity", "Landroid/app/Activity;", "onActivityPaused", "onActivityResumed", "updateAppIndexing", "appIndexingEnabled", "updateAppIndexing$facebook_core_release", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CodelessManager {
    @NotNull
    public static final CodelessManager INSTANCE = new CodelessManager();
    @NotNull
    private static final ViewIndexingTrigger viewIndexingTrigger = new ViewIndexingTrigger();
    @Nullable
    private static SensorManager sensorManager;
    @Nullable
    private static ViewIndexer viewIndexer;
    @Nullable
    private static String deviceSessionID;
    @NotNull
    private static final AtomicBoolean isCodelessEnabled;
    @NotNull
    private static final AtomicBoolean isAppIndexingEnabled;
    private static volatile boolean isCheckingSession;

    private CodelessManager() {
    }

    @JvmStatic
    public static final void onActivityResumed(@NotNull Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            FetchedAppSettings appSettings;
            Activity activity2;
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            if (!isCodelessEnabled.get()) {
                return;
            }
            CodelessMatcher.Companion.getInstance().add(activity2);
            Context applicationContext = activity2.getApplicationContext();
            String appId = FacebookSdk.INSTANCE.getApplicationId();
            FetchedAppSettings fetchedAppSettings = appSettings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId);
            if (Intrinsics.areEqual((Object)(fetchedAppSettings == null ? null : Boolean.valueOf(fetchedAppSettings.getCodelessEventsEnabled())), (Object)true) || INSTANCE.isDebugOnEmulator()) {
                SensorManager sensorManager = (SensorManager)applicationContext.getSystemService("sensor");
                if (sensorManager == null) {
                    return;
                }
                SensorManager sensorManager2 = sensorManager;
                CodelessManager.sensorManager = sensorManager2;
                Sensor accelerometer = sensorManager2.getDefaultSensor(1);
                ViewIndexer viewIndexer = new ViewIndexer(activity2);
                CodelessManager.viewIndexer = viewIndexer;
                viewIndexingTrigger.setOnShakeListener(() -> CodelessManager.onActivityResumed$lambda-0(appSettings, appId));
                sensorManager2.registerListener((SensorEventListener)viewIndexingTrigger, accelerometer, 2);
                if (appSettings != null && appSettings.getCodelessEventsEnabled()) {
                    viewIndexer.schedule();
                }
            }
            if (INSTANCE.isDebugOnEmulator() && !isAppIndexingEnabled.get()) {
                INSTANCE.checkCodelessSession(appId);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void onActivityPaused(@NotNull Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            Activity activity2;
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            if (!isCodelessEnabled.get()) {
                return;
            }
            CodelessMatcher.Companion.getInstance().remove(activity2);
            ViewIndexer viewIndexer = CodelessManager.viewIndexer;
            if (viewIndexer != null) {
                viewIndexer.unschedule();
            }
            viewIndexer = sensorManager;
            if (viewIndexer != null) {
                viewIndexer.unregisterListener(viewIndexingTrigger);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void onActivityDestroyed(@NotNull Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            Activity activity2;
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            CodelessMatcher.Companion.getInstance().destroy(activity2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void enable() {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            isCodelessEnabled.set(true);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    @JvmStatic
    public static final void disable() {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            isCodelessEnabled.set(false);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCodelessSession(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void applicationId;
            if (isCheckingSession) {
                return;
            }
            isCheckingSession = true;
            FacebookSdk.INSTANCE.getExecutor().execute(() -> CodelessManager.checkCodelessSession$lambda-1((String)applicationId));
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    private final boolean isDebugOnEmulator() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            return false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    @JvmStatic
    @NotNull
    public static final String getCurrentDeviceSessionID$facebook_core_release() {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return null;
        }
        try {
            String string;
            if (deviceSessionID == null) {
                deviceSessionID = UUID.randomUUID().toString();
            }
            if ((string = deviceSessionID) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            return string;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return null;
        }
    }

    @JvmStatic
    public static final boolean getIsAppIndexingEnabled$facebook_core_release() {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return false;
        }
        try {
            return isAppIndexingEnabled.get();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return false;
        }
    }

    @JvmStatic
    public static final void updateAppIndexing$facebook_core_release(boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            boolean appIndexingEnabled;
            isAppIndexingEnabled.set(appIndexingEnabled);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void onActivityResumed$lambda-0(FetchedAppSettings fetchedAppSettings, String string) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            boolean codelessSetupEnabled;
            FetchedAppSettings $appSettings;
            void $appId;
            Intrinsics.checkNotNullParameter((Object)$appId, (String)"$appId");
            boolean codelessEventsEnabled = $appSettings != null && $appSettings.getCodelessEventsEnabled();
            boolean bl = FacebookSdk.INSTANCE.getCodelessSetupEnabled() ? true : (codelessSetupEnabled = false);
            if (codelessEventsEnabled && codelessSetupEnabled) {
                INSTANCE.checkCodelessSession((String)$appId);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    private static final void checkCodelessSession$lambda-1(String string) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            String $applicationId;
            Bundle requestParameters = new Bundle();
            Context context = FacebookSdk.INSTANCE.getApplicationContext();
            AttributionIdentifiers identifiers = AttributionIdentifiers.Companion.getAttributionIdentifiers(context);
            JSONArray extInfoArray = new JSONArray();
            extInfoArray.put((Object)(Build.MODEL != null ? Build.MODEL : ""));
            AttributionIdentifiers attributionIdentifiers = identifiers;
            if ((attributionIdentifiers == null ? null : attributionIdentifiers.getAndroidAdvertiserId()) != null) {
                extInfoArray.put((Object)identifiers.getAndroidAdvertiserId());
            } else {
                extInfoArray.put((Object)"");
            }
            extInfoArray.put((Object)"0");
            extInfoArray.put((Object)(AppEventUtility.INSTANCE.isEmulator() ? "1" : "0"));
            Locale locale = Utility.INSTANCE.getCurrentLocale();
            extInfoArray.put((Object)(locale.getLanguage() + '_' + locale.getCountry()));
            String string2 = extInfoArray.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"extInfoArray.toString()");
            String extInfo = string2;
            requestParameters.putString("device_session_id", INSTANCE.getCurrentDeviceSessionID$facebook_core_release());
            requestParameters.putString("extinfo", extInfo);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale2 = Locale.US;
            Object object = "%s/app_indexing_session";
            Object[] objectArray = new Object[]{$applicationId};
            boolean bl = false;
            String string3 = String.format(locale2, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            GraphRequest request = GraphRequest.Companion.newPostRequestWithBundle(null, string3, requestParameters, null);
            GraphResponse res = request.executeAndWait();
            JSONObject jsonRes = res.getJSONObject();
            isAppIndexingEnabled.set(jsonRes != null && jsonRes.optBoolean("is_app_indexing_enabled", false));
            if (!isAppIndexingEnabled.get()) {
                deviceSessionID = null;
            } else {
                object = viewIndexer;
                if (object != null) {
                    ((ViewIndexer)object).schedule();
                }
            }
            isCheckingSession = false;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    static {
        isCodelessEnabled = new AtomicBoolean(true);
        isAppIndexingEnabled = new AtomicBoolean(false);
    }
}

