/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.os.Bundle;
import com.facebook.GraphRequest;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.eventdeactivation.EventDeactivationManager;
import com.facebook.appevents.internal.AppEventsLoggerUtility;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bJ&\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001bJ8\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u001bH\u0002R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/facebook/appevents/SessionEventsState;", "", "attributionIdentifiers", "Lcom/facebook/internal/AttributionIdentifiers;", "anonymousAppDeviceGUID", "", "(Lcom/facebook/internal/AttributionIdentifiers;Ljava/lang/String;)V", "accumulatedEventCount", "", "getAccumulatedEventCount", "()I", "accumulatedEvents", "", "Lcom/facebook/appevents/AppEvent;", "eventsToPersist", "", "getEventsToPersist", "()Ljava/util/List;", "inFlightEvents", "numSkippedEventsDueToFullBuffer", "accumulatePersistedEvents", "", "events", "addEvent", "event", "clearInFlightAndStats", "moveToAccumulated", "", "populateRequest", "request", "Lcom/facebook/GraphRequest;", "applicationContext", "Landroid/content/Context;", "includeImplicitEvents", "limitEventUsage", "numSkipped", "Lorg/json/JSONArray;", "operationalParameters", "Companion", "facebook-core_release"})
public final class SessionEventsState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AttributionIdentifiers attributionIdentifiers;
    @NotNull
    private final String anonymousAppDeviceGUID;
    @NotNull
    private List<AppEvent> accumulatedEvents;
    @NotNull
    private final List<AppEvent> inFlightEvents;
    private int numSkippedEventsDueToFullBuffer;
    private static final String TAG = SessionEventsState.class.getSimpleName();
    private static final int MAX_ACCUMULATED_LOG_EVENTS = 1000;

    public SessionEventsState(@NotNull AttributionIdentifiers attributionIdentifiers, @NotNull String anonymousAppDeviceGUID) {
        Intrinsics.checkNotNullParameter((Object)attributionIdentifiers, (String)"attributionIdentifiers");
        Intrinsics.checkNotNullParameter((Object)anonymousAppDeviceGUID, (String)"anonymousAppDeviceGUID");
        this.attributionIdentifiers = attributionIdentifiers;
        this.anonymousAppDeviceGUID = anonymousAppDeviceGUID;
        boolean bl = false;
        this.accumulatedEvents = new ArrayList();
        bl = false;
        this.inFlightEvents = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void addEvent(@NotNull AppEvent appEvent) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void event;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.accumulatedEvents.size() + this.inFlightEvents.size() >= MAX_ACCUMULATED_LOG_EVENTS) {
                SessionEventsState sessionEventsState = this;
                int n = sessionEventsState.numSkippedEventsDueToFullBuffer;
                sessionEventsState.numSkippedEventsDueToFullBuffer = n + 1;
            } else {
                this.accumulatedEvents.add((AppEvent)event);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public final synchronized int getAccumulatedEventCount() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return 0;
        }
        try {
            return this.accumulatedEvents.size();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void clearInFlightAndStats(boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void moveToAccumulated;
            if (moveToAccumulated != false) {
                this.accumulatedEvents.addAll((Collection<AppEvent>)this.inFlightEvents);
            }
            this.inFlightEvents.clear();
            this.numSkippedEventsDueToFullBuffer = 0;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int populateRequest(@NotNull GraphRequest graphRequest, @NotNull Context context, boolean bl, boolean bl2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return 0;
        }
        try {
            void limitEventUsage;
            void applicationContext;
            void request;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
            int numSkipped = 0;
            JSONArray jsonArray = null;
            JSONArray operationalJsonArray = null;
            boolean bl3 = false;
            boolean bl4 = false;
            synchronized (this) {
                block9: {
                    boolean bl5 = false;
                    numSkipped = this.numSkippedEventsDueToFullBuffer;
                    EventDeactivationManager.processEvents(this.accumulatedEvents);
                    this.inFlightEvents.addAll((Collection<AppEvent>)this.accumulatedEvents);
                    this.accumulatedEvents.clear();
                    jsonArray = new JSONArray();
                    operationalJsonArray = new JSONArray();
                    for (AppEvent event : this.inFlightEvents) {
                        if (event.isChecksumValid()) {
                            void includeImplicitEvents;
                            if (includeImplicitEvents == false && event.isImplicit()) continue;
                            jsonArray.put((Object)event.getJsonObject());
                            operationalJsonArray.put((Object)event.getOperationalJsonObject());
                            continue;
                        }
                        Utility.logd(TAG, Intrinsics.stringPlus((String)"Event with invalid checksum: ", (Object)event));
                    }
                    if (jsonArray.length() != 0) break block9;
                    int n = 0;
                    return n;
                }
                Unit unit = Unit.INSTANCE;
            }
            this.populateRequest((GraphRequest)request, (Context)applicationContext, numSkipped, jsonArray, operationalJsonArray, (boolean)limitEventUsage);
            return jsonArray.length();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return 0;
        }
    }

    @NotNull
    public final synchronized List<AppEvent> getEventsToPersist() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            List<AppEvent> result = this.accumulatedEvents;
            boolean bl = false;
            this.accumulatedEvents = new ArrayList();
            return result;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void accumulatePersistedEvents(@NotNull List<AppEvent> list) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void events;
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            this.accumulatedEvents.addAll((Collection)events);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void populateRequest(GraphRequest graphRequest, Context context, int n, JSONArray jSONArray, JSONArray jSONArray2, boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void events;
            void request;
            JSONObject publishParams = null;
            try {
                void applicationContext;
                void limitEventUsage;
                publishParams = AppEventsLoggerUtility.getJSONObjectForGraphAPICall(AppEventsLoggerUtility.GraphAPIActivityType.CUSTOM_APP_EVENTS, this.attributionIdentifiers, this.anonymousAppDeviceGUID, (boolean)limitEventUsage, (Context)applicationContext);
                if (this.numSkippedEventsDueToFullBuffer > 0) {
                    void numSkipped;
                    publishParams.put("num_skipped_events", (int)numSkipped);
                }
            }
            catch (JSONException e) {
                publishParams = new JSONObject();
            }
            request.setGraphObject(publishParams);
            Bundle requestParameters = request.getParameters();
            String string = events.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"events.toString()");
            String jsonString = string;
            requestParameters.putString("custom_events", jsonString);
            if (FeatureManager.isEnabled(FeatureManager.Feature.IapLoggingLib5To7)) {
                void operationalParameters;
                requestParameters.putString("operational_parameters", operationalParameters.toString());
            }
            request.setTag(jsonString);
            request.setParameters(requestParameters);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/appevents/SessionEventsState$Companion;", "", "()V", "MAX_ACCUMULATED_LOG_EVENTS", "", "TAG", "", "kotlin.jvm.PlatformType", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

