/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.AuthenticationToken;
import com.facebook.AuthenticationTokenCache;
import com.facebook.FacebookSdk;
import com.facebook.internal.Utility;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\f\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/AuthenticationTokenManager;", "", "localBroadcastManager", "Landroidx/localbroadcastmanager/content/LocalBroadcastManager;", "authenticationTokenCache", "Lcom/facebook/AuthenticationTokenCache;", "(Landroidx/localbroadcastmanager/content/LocalBroadcastManager;Lcom/facebook/AuthenticationTokenCache;)V", "value", "Lcom/facebook/AuthenticationToken;", "currentAuthenticationToken", "getCurrentAuthenticationToken", "()Lcom/facebook/AuthenticationToken;", "setCurrentAuthenticationToken", "(Lcom/facebook/AuthenticationToken;)V", "currentAuthenticationTokenField", "currentAuthenticationTokenChanged", "", "loadCurrentAuthenticationToken", "", "sendCurrentAuthenticationTokenChangedBroadcastIntent", "oldAuthenticationToken", "saveToCache", "Companion", "CurrentAuthenticationTokenChangedBroadcastReceiver", "facebook-core_release"})
public final class AuthenticationTokenManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalBroadcastManager localBroadcastManager;
    @NotNull
    private final AuthenticationTokenCache authenticationTokenCache;
    @Nullable
    private AuthenticationToken currentAuthenticationTokenField;
    @NotNull
    public static final String TAG = "AuthenticationTokenManager";
    @NotNull
    public static final String ACTION_CURRENT_AUTHENTICATION_TOKEN_CHANGED = "com.facebook.sdk.ACTION_CURRENT_AUTHENTICATION_TOKEN_CHANGED";
    @NotNull
    public static final String EXTRA_OLD_AUTHENTICATION_TOKEN = "com.facebook.sdk.EXTRA_OLD_AUTHENTICATION_TOKEN";
    @NotNull
    public static final String EXTRA_NEW_AUTHENTICATION_TOKEN = "com.facebook.sdk.EXTRA_NEW_AUTHENTICATION_TOKEN";
    @NotNull
    public static final String SHARED_PREFERENCES_NAME = "com.facebook.AuthenticationTokenManager.SharedPreferences";
    @Nullable
    private static AuthenticationTokenManager instanceField;

    public AuthenticationTokenManager(@NotNull LocalBroadcastManager localBroadcastManager, @NotNull AuthenticationTokenCache authenticationTokenCache) {
        Intrinsics.checkNotNullParameter((Object)localBroadcastManager, (String)"localBroadcastManager");
        Intrinsics.checkNotNullParameter((Object)authenticationTokenCache, (String)"authenticationTokenCache");
        this.localBroadcastManager = localBroadcastManager;
        this.authenticationTokenCache = authenticationTokenCache;
    }

    @Nullable
    public final AuthenticationToken getCurrentAuthenticationToken() {
        return this.currentAuthenticationTokenField;
    }

    public final void setCurrentAuthenticationToken(@Nullable AuthenticationToken value) {
        this.setCurrentAuthenticationToken(value, true);
    }

    public final boolean loadCurrentAuthenticationToken() {
        AuthenticationToken authenticationToken = this.authenticationTokenCache.load();
        if (authenticationToken != null) {
            this.setCurrentAuthenticationToken(authenticationToken, false);
            return true;
        }
        return false;
    }

    public final void currentAuthenticationTokenChanged() {
        this.sendCurrentAuthenticationTokenChangedBroadcastIntent(this.getCurrentAuthenticationToken(), this.getCurrentAuthenticationToken());
    }

    private final void setCurrentAuthenticationToken(AuthenticationToken currentAuthenticationToken, boolean saveToCache) {
        AuthenticationToken oldAuthenticationToken = this.getCurrentAuthenticationToken();
        this.currentAuthenticationTokenField = currentAuthenticationToken;
        if (saveToCache) {
            if (currentAuthenticationToken != null) {
                this.authenticationTokenCache.save(currentAuthenticationToken);
            } else {
                this.authenticationTokenCache.clear();
                Utility.clearFacebookCookies(FacebookSdk.INSTANCE.getApplicationContext());
            }
        }
        if (!Utility.areObjectsEqual(oldAuthenticationToken, currentAuthenticationToken)) {
            this.sendCurrentAuthenticationTokenChangedBroadcastIntent(oldAuthenticationToken, currentAuthenticationToken);
        }
    }

    private final void sendCurrentAuthenticationTokenChangedBroadcastIntent(AuthenticationToken oldAuthenticationToken, AuthenticationToken currentAuthenticationToken) {
        Intent intent = new Intent(FacebookSdk.INSTANCE.getApplicationContext(), CurrentAuthenticationTokenChangedBroadcastReceiver.class);
        intent.setAction(ACTION_CURRENT_AUTHENTICATION_TOKEN_CHANGED);
        intent.putExtra(EXTRA_OLD_AUTHENTICATION_TOKEN, (Parcelable)oldAuthenticationToken);
        intent.putExtra(EXTRA_NEW_AUTHENTICATION_TOKEN, (Parcelable)currentAuthenticationToken);
        this.localBroadcastManager.sendBroadcast(intent);
    }

    @JvmStatic
    @NotNull
    public static final AuthenticationTokenManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/AuthenticationTokenManager$Companion;", "", "()V", "ACTION_CURRENT_AUTHENTICATION_TOKEN_CHANGED", "", "EXTRA_NEW_AUTHENTICATION_TOKEN", "EXTRA_OLD_AUTHENTICATION_TOKEN", "SHARED_PREFERENCES_NAME", "TAG", "instanceField", "Lcom/facebook/AuthenticationTokenManager;", "getInstance", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final AuthenticationTokenManager getInstance() {
            AuthenticationTokenManager instance = instanceField;
            if (instance == null) {
                boolean bl = false;
                boolean bl2 = false;
                synchronized (this) {
                    AuthenticationTokenManager authenticationTokenManager;
                    boolean bl3 = false;
                    AuthenticationTokenManager instance2 = instanceField;
                    if (instance2 == null) {
                        Context applicationContext = FacebookSdk.INSTANCE.getApplicationContext();
                        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)applicationContext);
                        Intrinsics.checkNotNullExpressionValue((Object)localBroadcastManager, (String)"getInstance(applicationContext)");
                        LocalBroadcastManager localBroadcastManager2 = localBroadcastManager;
                        AuthenticationTokenCache authenticationTokenCache = new AuthenticationTokenCache();
                        AuthenticationTokenManager newInstance = new AuthenticationTokenManager(localBroadcastManager2, authenticationTokenCache);
                        instanceField = newInstance;
                        authenticationTokenManager = newInstance;
                    } else {
                        authenticationTokenManager = instance2;
                    }
                    AuthenticationTokenManager authenticationTokenManager2 = authenticationTokenManager;
                    return authenticationTokenManager2;
                }
            }
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/facebook/AuthenticationTokenManager$CurrentAuthenticationTokenChangedBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "facebook-core_release"})
    public static final class CurrentAuthenticationTokenChangedBroadcastReceiver
    extends BroadcastReceiver {
        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        }
    }
}

