/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import com.facebook.appevents.ml.MTensor;
import com.facebook.appevents.ml.Utils;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u001b\u0010\b\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0007J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J+\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0013H\u0007J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0013H\u0007J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u001e"}, d2={"Lcom/facebook/appevents/ml/Operator;", "", "()V", "addmv", "", "x", "Lcom/facebook/appevents/ml/MTensor;", "b", "concatenate", "tensors", "", "([Lcom/facebook/appevents/ml/MTensor;)Lcom/facebook/appevents/ml/MTensor;", "conv1D", "w", "dense", "embedding", "texts", "", "seqLength", "", "([Ljava/lang/String;ILcom/facebook/appevents/ml/MTensor;)Lcom/facebook/appevents/ml/MTensor;", "flatten", "startDim", "maxPool1D", "poolSize", "mul", "relu", "softmax", "transpose2D", "transpose3D", "facebook-core_release"})
public final class Operator {
    @NotNull
    public static final Operator INSTANCE = new Operator();

    private Operator() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void addmv(@NotNull MTensor mTensor, @NotNull MTensor mTensor2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            void b;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int exampleSize = x.getShape(0);
            int seqLength = x.getShape(1);
            int inputSize = x.getShape(2);
            float[] xData = x.getData();
            float[] bData = b.getData();
            int n = 0;
            if (n < exampleSize) {
                do {
                    int i = n++;
                    int n2 = 0;
                    if (n2 >= seqLength) continue;
                    do {
                        int j = n2++;
                        int n3 = 0;
                        if (n3 >= inputSize) continue;
                        do {
                            int k = n3++;
                            float[] fArray = xData;
                            int n4 = i * seqLength * inputSize + j * inputSize + k;
                            fArray[n4] = fArray[n4] + bData[k];
                        } while (n3 < inputSize);
                    } while (n2 < seqLength);
                } while (n < exampleSize);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor mul(@NotNull MTensor mTensor, @NotNull MTensor mTensor2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void w;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            int exampleSize = x.getShape(0);
            int inputSize = w.getShape(0);
            int outputSize = w.getShape(1);
            int[] nArray = new int[]{exampleSize, outputSize};
            MTensor y = new MTensor(nArray);
            float[] xData = x.getData();
            float[] wData = w.getData();
            float[] yData = y.getData();
            int n = 0;
            if (n < exampleSize) {
                do {
                    int i = n++;
                    int n2 = 0;
                    if (n2 >= outputSize) continue;
                    do {
                        int j = n2++;
                        yData[i * outputSize + j] = 0.0f;
                        int n3 = 0;
                        if (n3 >= inputSize) continue;
                        do {
                            int k = n3++;
                            float[] fArray = yData;
                            int n4 = i * outputSize + j;
                            fArray[n4] = fArray[n4] + xData[i * inputSize + k] * wData[k * outputSize + j];
                        } while (n3 < inputSize);
                    } while (n2 < outputSize);
                } while (n < exampleSize);
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    @JvmStatic
    public static final void relu(@NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            float[] xData = x.getData();
            int n = 0;
            int n2 = xData.length + -1;
            if (n <= n2) {
                do {
                    int i;
                    if (!(xData[i = n++] < 0.0f)) continue;
                    xData[i] = 0.0f;
                } while (n <= n2);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void flatten(@NotNull MTensor mTensor, int n) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            int i;
            void startDim;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            if (startDim >= x.getShapeSize()) {
                return;
            }
            int outputSize = 1;
            void var3_3 = startDim;
            int n2 = x.getShapeSize();
            if (var3_3 < n2) {
                do {
                    i = var3_3++;
                    outputSize *= x.getShape(i);
                } while (var3_3 < n2);
            }
            int[] newShape = new int[startDim + true];
            n2 = 0;
            if (n2 < startDim) {
                do {
                    i = n2++;
                    newShape[i] = x.getShape(i);
                } while (n2 < startDim);
            }
            newShape[startDim] = outputSize;
            x.reshape(newShape);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    @JvmStatic
    @NotNull
    public static final MTensor concatenate(@NotNull MTensor[] mTensorArray) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            MTensor[] tensors;
            Intrinsics.checkNotNullParameter((Object)tensors, (String)"tensors");
            int exampleSize = tensors[0].getShape(0);
            int outputSize = 0;
            int n = 0;
            int n2 = tensors.length + -1;
            if (n <= n2) {
                do {
                    int i = n++;
                    outputSize += tensors[i].getShape(1);
                } while (n <= n2);
            }
            int[] nArray = new int[]{exampleSize, outputSize};
            MTensor y = new MTensor(nArray);
            float[] yData = y.getData();
            int n3 = 0;
            if (n3 < exampleSize) {
                do {
                    int n4 = n3++;
                    int desPos = n4 * outputSize;
                    int n5 = 0;
                    int n6 = tensors.length + -1;
                    if (n5 > n6) continue;
                    do {
                        int i = n5++;
                        float[] xData = tensors[i].getData();
                        int inputSize = tensors[i].getShape(1);
                        System.arraycopy(xData, n4 * inputSize, yData, desPos, inputSize);
                        desPos += inputSize;
                    } while (n5 <= n6);
                } while (n3 < exampleSize);
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    @JvmStatic
    public static final void softmax(@NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int exampleSize = x.getShape(0);
            int inputSize = x.getShape(1);
            float[] xData = x.getData();
            int n = 0;
            if (n < exampleSize) {
                do {
                    int i;
                    int n2 = n++;
                    int startIndex = n2 * inputSize;
                    int endIndex = startIndex + inputSize;
                    float max = Float.MIN_VALUE;
                    float sum = 0.0f;
                    int n3 = startIndex;
                    if (n3 < endIndex) {
                        do {
                            if (!(xData[i = n3++] > max)) continue;
                            max = xData[i];
                        } while (n3 < endIndex);
                    }
                    if ((n3 = startIndex) < endIndex) {
                        do {
                            i = n3++;
                            double d = xData[i] - max;
                            boolean bl = false;
                            xData[i] = (float)Math.exp(d);
                            sum += xData[i];
                        } while (n3 < endIndex);
                    }
                    if ((n3 = startIndex) >= endIndex) continue;
                    do {
                        i = n3++;
                        xData[i] = xData[i] / sum;
                    } while (n3 < endIndex);
                } while (n < exampleSize);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor dense(@NotNull MTensor mTensor, @NotNull MTensor mTensor2, @NotNull MTensor mTensor3) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void b;
            void w;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int exampleSize = x.getShape(0);
            int outputSize = b.getShape(0);
            MTensor y = Operator.mul(x, (MTensor)w);
            float[] bData = b.getData();
            float[] yData = y.getData();
            int n = 0;
            if (n < exampleSize) {
                do {
                    int i = n++;
                    int n2 = 0;
                    if (n2 >= outputSize) continue;
                    do {
                        int j = n2++;
                        float[] fArray = yData;
                        int n3 = i * outputSize + j;
                        fArray[n3] = fArray[n3] + bData[j];
                    } while (n2 < outputSize);
                } while (n < exampleSize);
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor embedding(@NotNull String[] stringArray, int n, @NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void seqLength;
            void w;
            String[] texts;
            Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            int exampleSize = texts.length;
            int embeddingSize = w.getShape(1);
            int[] nArray = new int[]{exampleSize, seqLength, embeddingSize};
            MTensor y = new MTensor(nArray);
            float[] yData = y.getData();
            float[] wData = w.getData();
            int n2 = 0;
            if (n2 < exampleSize) {
                do {
                    int i = n2++;
                    int[] vectorizedText = Utils.INSTANCE.vectorize(texts[i], (int)seqLength);
                    int n3 = 0;
                    if (n3 >= seqLength) continue;
                    do {
                        int j = n3++;
                        System.arraycopy(wData, vectorizedText[j] * embeddingSize, yData, embeddingSize * seqLength * i + embeddingSize * j, embeddingSize);
                    } while (n3 < seqLength);
                } while (n2 < exampleSize);
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final MTensor transpose2D(@NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int m = x.getShape(0);
            int n = x.getShape(1);
            int[] nArray = new int[]{n, m};
            MTensor y = new MTensor(nArray);
            float[] xData = x.getData();
            float[] yData = y.getData();
            int n2 = 0;
            if (n2 < m) {
                do {
                    int i = n2++;
                    int n3 = 0;
                    if (n3 >= n) continue;
                    do {
                        int j = n3++;
                        yData[j * m + i] = xData[i * n + j];
                    } while (n3 < n);
                } while (n2 < m);
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final MTensor transpose3D(@NotNull MTensor mTensor) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int m = x.getShape(0);
            int n = x.getShape(1);
            int p = x.getShape(2);
            int[] nArray = new int[]{p, n, m};
            MTensor y = new MTensor(nArray);
            float[] xData = x.getData();
            float[] yData = y.getData();
            int n2 = 0;
            if (n2 < m) {
                do {
                    int i = n2++;
                    int n3 = 0;
                    if (n3 >= n) continue;
                    do {
                        int j = n3++;
                        int n4 = 0;
                        if (n4 >= p) continue;
                        do {
                            int k = n4++;
                            yData[k * m * n + j * m + i] = xData[i * n * p + j * p + k];
                        } while (n4 < p);
                    } while (n3 < n);
                } while (n2 < m);
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor conv1D(@NotNull MTensor mTensor, @NotNull MTensor mTensor2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void w;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            int exampleSize = x.getShape(0);
            int inputSeqLength = x.getShape(1);
            int inputSize = x.getShape(2);
            int kernelSize = w.getShape(0);
            int outputSeqLength = inputSeqLength - kernelSize + 1;
            int outputSize = w.getShape(2);
            int[] nArray = new int[]{exampleSize, outputSeqLength, outputSize};
            MTensor y = new MTensor(nArray);
            float[] xData = x.getData();
            float[] yData = y.getData();
            float[] wData = w.getData();
            int n = 0;
            if (n < exampleSize) {
                do {
                    int n2 = n++;
                    int n3 = 0;
                    if (n3 >= outputSize) continue;
                    do {
                        int o = n3++;
                        int n4 = 0;
                        if (n4 >= outputSeqLength) continue;
                        do {
                            int i = n4++;
                            float sum = 0.0f;
                            int n5 = 0;
                            if (n5 < kernelSize) {
                                do {
                                    int m = n5++;
                                    int n6 = 0;
                                    if (n6 >= inputSize) continue;
                                    do {
                                        int k = n6++;
                                        sum += xData[n2 * (inputSeqLength * inputSize) + (m + i) * inputSize + k] * wData[(m * inputSize + k) * outputSize + o];
                                    } while (n6 < inputSize);
                                } while (n5 < kernelSize);
                            }
                            yData[n2 * (outputSeqLength * outputSize) + i * outputSize + o] = sum;
                        } while (n4 < outputSeqLength);
                    } while (n3 < outputSize);
                } while (n < exampleSize);
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final MTensor maxPool1D(@NotNull MTensor mTensor, int n) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void poolSize;
            MTensor x;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int exampleSize = x.getShape(0);
            int inputSeqLength = x.getShape(1);
            int inputSize = x.getShape(2);
            int outputSeqLength = inputSeqLength - poolSize + 1;
            int[] nArray = new int[]{exampleSize, outputSeqLength, inputSize};
            MTensor y = new MTensor(nArray);
            float[] xData = x.getData();
            float[] yData = y.getData();
            int n2 = 0;
            if (n2 < exampleSize) {
                do {
                    int n3 = n2++;
                    int n4 = 0;
                    if (n4 >= inputSize) continue;
                    do {
                        int c = n4++;
                        int n5 = 0;
                        if (n5 >= outputSeqLength) continue;
                        do {
                            int i = n5++;
                            int yIndex = n3 * outputSeqLength * inputSize + i * inputSize + c;
                            int xIndex = n3 * inputSeqLength * inputSize + i * inputSize + c;
                            yData[yIndex] = Float.MIN_VALUE;
                            int n6 = 0;
                            if (n6 >= poolSize) continue;
                            do {
                                int r = n6++;
                                float f = yData[yIndex];
                                float f2 = xData[xIndex + r * inputSize];
                                boolean bl = false;
                                yData[yIndex] = Math.max(f, f2);
                            } while (n6 < poolSize);
                        } while (n5 < outputSeqLength);
                    } while (n4 < inputSize);
                } while (n2 < exampleSize);
            }
            return y;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }
}

