/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/appevents/internal/AppEventsLoggerUtility;", "", "()V", "API_ACTIVITY_TYPE_TO_STRING", "", "Lcom/facebook/appevents/internal/AppEventsLoggerUtility$GraphAPIActivityType;", "", "getJSONObjectForGraphAPICall", "Lorg/json/JSONObject;", "activityType", "attributionIdentifiers", "Lcom/facebook/internal/AttributionIdentifiers;", "anonymousAppDeviceGUID", "limitEventUsage", "", "context", "Landroid/content/Context;", "GraphAPIActivityType", "facebook-core_release"})
public final class AppEventsLoggerUtility {
    @NotNull
    public static final AppEventsLoggerUtility INSTANCE = new AppEventsLoggerUtility();
    @NotNull
    private static final Map<GraphAPIActivityType, String> API_ACTIVITY_TYPE_TO_STRING;

    private AppEventsLoggerUtility() {
    }

    @JvmStatic
    @NotNull
    public static final JSONObject getJSONObjectForGraphAPICall(@NotNull GraphAPIActivityType activityType, @Nullable AttributionIdentifiers attributionIdentifiers, @Nullable String anonymousAppDeviceGUID, boolean limitEventUsage, @NotNull Context context) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)((Object)activityType), (String)"activityType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JSONObject publishParams = new JSONObject();
        publishParams.put("event", (Object)API_ACTIVITY_TYPE_TO_STRING.get((Object)activityType));
        String externalAnalyticsUserId = AppEventsLogger.Companion.getUserID();
        if (externalAnalyticsUserId != null) {
            publishParams.put("app_user_id", (Object)externalAnalyticsUserId);
        }
        Utility.setAppEventAttributionParameters(publishParams, attributionIdentifiers, anonymousAppDeviceGUID, limitEventUsage, context);
        try {
            Utility.setAppEventExtendedDeviceInfoParameters(publishParams, context);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e.toString()};
            Logger.Companion.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Fetching extended device info parameters failed: '%s'", objectArray);
        }
        JSONObject dataProcessingOptions = Utility.INSTANCE.getDataProcessingOptions();
        if (dataProcessingOptions != null) {
            Iterator it = dataProcessingOptions.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                publishParams.put(key, dataProcessingOptions.get(key));
            }
        }
        publishParams.put("application_package_name", (Object)context.getPackageName());
        return publishParams;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)GraphAPIActivityType.MOBILE_INSTALL_EVENT), (Object)"MOBILE_APP_INSTALL"), TuplesKt.to((Object)((Object)GraphAPIActivityType.CUSTOM_APP_EVENTS), (Object)"CUSTOM_APP_EVENTS")};
        API_ACTIVITY_TYPE_TO_STRING = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/facebook/appevents/internal/AppEventsLoggerUtility$GraphAPIActivityType;", "", "(Ljava/lang/String;I)V", "MOBILE_INSTALL_EVENT", "CUSTOM_APP_EVENTS", "facebook-core_release"})
    public static final class GraphAPIActivityType
    extends Enum<GraphAPIActivityType> {
        public static final /* enum */ GraphAPIActivityType MOBILE_INSTALL_EVENT = new GraphAPIActivityType();
        public static final /* enum */ GraphAPIActivityType CUSTOM_APP_EVENTS = new GraphAPIActivityType();
        private static final /* synthetic */ GraphAPIActivityType[] $VALUES;

        public static GraphAPIActivityType[] values() {
            GraphAPIActivityType[] graphAPIActivityTypeArray = $VALUES;
            return Arrays.copyOf(graphAPIActivityTypeArray, graphAPIActivityTypeArray.length);
        }

        public static GraphAPIActivityType valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(GraphAPIActivityType.class, value);
        }

        static {
            $VALUES = graphAPIActivityTypeArray = new GraphAPIActivityType[]{GraphAPIActivityType.MOBILE_INSTALL_EVENT, GraphAPIActivityType.CUSTOM_APP_EVENTS};
        }
    }
}

