/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.iap.InAppPurchaseActivityLifecycleTracker;
import com.facebook.appevents.iap.InAppPurchaseEventManager;
import com.facebook.appevents.iap.InAppPurchaseUtils;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u001aj\b\u0012\u0004\u0012\u00020\u0004`\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0007J\b\u0010\u001e\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/facebook/appevents/iap/InAppPurchaseActivityLifecycleTracker;", "", "()V", "BILLING_ACTIVITY_NAME", "", "SERVICE_INTERFACE_NAME", "TAG", "callbacks", "Landroid/app/Application$ActivityLifecycleCallbacks;", "hasBillingActivity", "", "Ljava/lang/Boolean;", "hasBillingService", "inAppBillingObj", "intent", "Landroid/content/Intent;", "isTracking", "Ljava/util/concurrent/atomic/AtomicBoolean;", "serviceConnection", "Landroid/content/ServiceConnection;", "initializeIfNotInitialized", "", "logPurchase", "context", "Landroid/content/Context;", "purchases", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "isSubscription", "startIapLogging", "startTracking", "facebook-core_release"})
public final class InAppPurchaseActivityLifecycleTracker {
    @NotNull
    public static final InAppPurchaseActivityLifecycleTracker INSTANCE = new InAppPurchaseActivityLifecycleTracker();
    @Nullable
    private static final String TAG = InAppPurchaseActivityLifecycleTracker.class.getCanonicalName();
    @NotNull
    private static final String SERVICE_INTERFACE_NAME = "com.android.vending.billing.IInAppBillingService$Stub";
    @NotNull
    private static final String BILLING_ACTIVITY_NAME = "com.android.billingclient.api.ProxyBillingActivity";
    @NotNull
    private static final AtomicBoolean isTracking = new AtomicBoolean(false);
    @Nullable
    private static Boolean hasBillingService;
    @Nullable
    private static Boolean hasBillingActivity;
    private static ServiceConnection serviceConnection;
    private static Application.ActivityLifecycleCallbacks callbacks;
    private static Intent intent;
    @Nullable
    private static Object inAppBillingObj;

    private InAppPurchaseActivityLifecycleTracker() {
    }

    @JvmStatic
    public static final void startIapLogging() {
        INSTANCE.initializeIfNotInitialized();
        if (Intrinsics.areEqual((Object)hasBillingService, (Object)false)) {
            return;
        }
        if (AutomaticAnalyticsLogger.INSTANCE.isImplicitPurchaseLoggingEnabled()) {
            INSTANCE.startTracking();
        }
    }

    private final void initializeIfNotInitialized() {
        if (hasBillingService != null) {
            return;
        }
        hasBillingService = InAppPurchaseUtils.getClass(SERVICE_INTERFACE_NAME) != null;
        if (Intrinsics.areEqual((Object)hasBillingService, (Object)false)) {
            return;
        }
        hasBillingActivity = InAppPurchaseUtils.getClass(BILLING_ACTIVITY_NAME) != null;
        InAppPurchaseEventManager.INSTANCE.clearSkuDetailsCache();
        Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND").setPackage("com.android.vending");
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(\"com.android.vending.billing.InAppBillingService.BIND\")\n            .setPackage(\"com.android.vending\")");
        InAppPurchaseActivityLifecycleTracker.intent = intent;
        serviceConnection = new ServiceConnection(){

            public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder service) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                InAppPurchaseActivityLifecycleTracker.access$setInAppBillingObj$p(InAppPurchaseEventManager.asInterface(FacebookSdk.INSTANCE.getApplicationContext(), service));
            }

            public void onServiceDisconnected(@NotNull ComponentName name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            }
        };
        callbacks = new Application.ActivityLifecycleCallbacks(){

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                try {
                    FacebookSdk.INSTANCE.getExecutor().execute(initializeIfNotInitialized.2::onActivityResumed$lambda-0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                try {
                    if (Intrinsics.areEqual((Object)InAppPurchaseActivityLifecycleTracker.access$getHasBillingActivity$p(), (Object)true) && Intrinsics.areEqual((Object)activity.getLocalClassName(), (Object)"com.android.billingclient.api.ProxyBillingActivity")) {
                        FacebookSdk.INSTANCE.getExecutor().execute(initializeIfNotInitialized.2::onActivityStopped$lambda-1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            private static final void onActivityResumed$lambda-0() {
                Context context = FacebookSdk.INSTANCE.getApplicationContext();
                ArrayList<String> purchasesInapp = InAppPurchaseEventManager.getPurchasesInapp(context, InAppPurchaseActivityLifecycleTracker.access$getInAppBillingObj$p());
                InAppPurchaseActivityLifecycleTracker.access$logPurchase(InAppPurchaseActivityLifecycleTracker.INSTANCE, context, purchasesInapp, false);
                ArrayList<String> purchasesSubs = InAppPurchaseEventManager.getPurchasesSubs(context, InAppPurchaseActivityLifecycleTracker.access$getInAppBillingObj$p());
                InAppPurchaseActivityLifecycleTracker.access$logPurchase(InAppPurchaseActivityLifecycleTracker.INSTANCE, context, purchasesSubs, true);
            }

            private static final void onActivityStopped$lambda-1() {
                Context context = FacebookSdk.INSTANCE.getApplicationContext();
                ArrayList<String> purchases = InAppPurchaseEventManager.getPurchasesInapp(context, InAppPurchaseActivityLifecycleTracker.access$getInAppBillingObj$p());
                if (purchases.isEmpty()) {
                    purchases = InAppPurchaseEventManager.getPurchaseHistoryInapp(context, InAppPurchaseActivityLifecycleTracker.access$getInAppBillingObj$p());
                }
                InAppPurchaseActivityLifecycleTracker.access$logPurchase(InAppPurchaseActivityLifecycleTracker.INSTANCE, context, purchases, false);
            }
        };
    }

    private final void startTracking() {
        if (!isTracking.compareAndSet(false, true)) {
            return;
        }
        Context context = FacebookSdk.INSTANCE.getApplicationContext();
        if (context instanceof Application) {
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = callbacks;
            if (activityLifecycleCallbacks == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"callbacks");
                throw null;
            }
            ((Application)context).registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
            activityLifecycleCallbacks = intent;
            if (activityLifecycleCallbacks == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"intent");
                throw null;
            }
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks2 = activityLifecycleCallbacks;
            activityLifecycleCallbacks = serviceConnection;
            if (activityLifecycleCallbacks == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"serviceConnection");
                throw null;
            }
            context.bindService((Intent)activityLifecycleCallbacks2, (ServiceConnection)activityLifecycleCallbacks, 1);
        }
    }

    private final void logPurchase(Context context, ArrayList<String> purchases, boolean isSubscription) {
        boolean bl;
        Object object;
        Object object2;
        if (purchases.isEmpty()) {
            return;
        }
        boolean bl2 = false;
        HashMap purchaseMap = new HashMap();
        boolean bl3 = false;
        ArrayList<String> skuList = new ArrayList<String>();
        for (String purchase : purchases) {
            try {
                JSONObject purchaseJson = new JSONObject(purchase);
                String sku = purchaseJson.getString("productId");
                object2 = purchaseMap;
                Intrinsics.checkNotNullExpressionValue((Object)sku, (String)"sku");
                object = sku;
                Intrinsics.checkNotNullExpressionValue((Object)purchase, (String)"purchase");
                String string = purchase;
                bl = false;
                object2.put(object, string);
                skuList.add(sku);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Error parsing in-app purchase data.", (Throwable)e);
            }
        }
        Map<String, String> skuDetailsMap = InAppPurchaseEventManager.getSkuDetails(context, skuList, inAppBillingObj, isSubscription);
        Object object3 = skuDetailsMap;
        boolean sku = false;
        Iterator<Map.Entry<String, String>> iterator = object3.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = object3 = iterator.next();
            boolean bl4 = false;
            String key = (String)object2.getKey();
            object = object3;
            boolean bl5 = false;
            String value = (String)object.getValue();
            object = (String)purchaseMap.get(key);
            if (object == null) continue;
            Object object4 = object;
            bl = false;
            boolean bl6 = false;
            Object it = object4;
            boolean bl7 = false;
            AutomaticAnalyticsLogger.logPurchase((String)it, value, isSubscription);
        }
    }

    public static final /* synthetic */ void access$setInAppBillingObj$p(Object object) {
        inAppBillingObj = object;
    }

    public static final /* synthetic */ Boolean access$getHasBillingActivity$p() {
        return hasBillingActivity;
    }

    public static final /* synthetic */ Object access$getInAppBillingObj$p() {
        return inAppBillingObj;
    }

    public static final /* synthetic */ void access$logPurchase(InAppPurchaseActivityLifecycleTracker $this, Context context, ArrayList purchases, boolean isSubscription) {
        $this.logPurchase(context, purchases, isSubscription);
    }
}

