/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless.internal;

import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RatingBar;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.TimePicker;
import androidx.annotation.RestrictTo;
import com.facebook.appevents.codeless.internal.SensitiveUserDataUtils;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\fH\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\fH\u0007J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007J\u0012\u0010\u001f\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007J\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007J\u0012\u0010\"\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007J\u001e\u0010#\u001a\u0004\u0018\u00010\f2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010'\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\fH\u0003J\u0018\u0010,\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010&\u001a\u0004\u0018\u00010\fJ\u0010\u0010-\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u001a\u0010.\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u001cH\u0007J \u00100\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u000203H\u0007J\u0018\u00104\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u00101\u001a\u00020\u0016H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/facebook/appevents/codeless/internal/ViewHierarchy;", "", "()V", "CLASS_RCTROOTVIEW", "", "CLASS_RCTVIEWGROUP", "CLASS_TOUCHTARGETHELPER", "ICON_MAX_EDGE_LENGTH", "", "METHOD_FIND_TOUCHTARGET_VIEW", "RCTRootViewReference", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "TAG", "methodFindTouchTargetView", "Ljava/lang/reflect/Method;", "findRCTRootView", "view", "getChildrenOfView", "", "getClassTypeBitmask", "getDictionaryOfView", "Lorg/json/JSONObject;", "getDimensionOfView", "getExistingClass", "Ljava/lang/Class;", "className", "getExistingOnClickListener", "Landroid/view/View$OnClickListener;", "getExistingOnTouchListener", "Landroid/view/View$OnTouchListener;", "getHintOfView", "getParentOfView", "Landroid/view/ViewGroup;", "getTextOfView", "getTouchReactView", "location", "", "RCTRootView", "getViewLocationOnScreen", "initTouchTargetHelperMethods", "", "isAdapterViewItem", "", "isRCTButton", "isRCTRootView", "setOnClickListener", "newListener", "updateAppearanceOfView", "json", "displayDensity", "", "updateBasicInfoOfView", "facebook-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ViewHierarchy {
    @NotNull
    public static final ViewHierarchy INSTANCE = new ViewHierarchy();
    @Nullable
    private static final String TAG = ViewHierarchy.class.getCanonicalName();
    @NotNull
    private static final String CLASS_RCTROOTVIEW = "com.facebook.react.ReactRootView";
    @NotNull
    private static final String CLASS_RCTVIEWGROUP = "com.facebook.react.views.view.ReactViewGroup";
    @NotNull
    private static final String CLASS_TOUCHTARGETHELPER = "com.facebook.react.uimanager.TouchTargetHelper";
    @NotNull
    private static final String METHOD_FIND_TOUCHTARGET_VIEW = "findTouchTargetView";
    private static final int ICON_MAX_EDGE_LENGTH = 44;
    @NotNull
    private static WeakReference<View> RCTRootViewReference = new WeakReference<Object>(null);
    @Nullable
    private static Method methodFindTouchTargetView;

    private ViewHierarchy() {
    }

    @JvmStatic
    @Nullable
    public static final ViewGroup getParentOfView(@Nullable View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            View view2;
            if (view2 == null) {
                return null;
            }
            ViewParent parent = view2.getParent();
            return parent instanceof ViewGroup ? (ViewGroup)parent : null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final List<View> getChildrenOfView(@Nullable View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            int count;
            int n;
            View view2;
            ArrayList<View> children = new ArrayList<View>();
            if (view2 instanceof ViewGroup && (n = 0) < (count = ((ViewGroup)view2).getChildCount())) {
                do {
                    int i = n++;
                    children.add(((ViewGroup)view2).getChildAt(i));
                } while (n < count);
            }
            return children;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void updateBasicInfoOfView(@NotNull View view, @NotNull JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return;
        }
        try {
            void json;
            View view2;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            try {
                String text = ViewHierarchy.getTextOfView(view2);
                String hint = ViewHierarchy.getHintOfView(view2);
                Object tag = view2.getTag();
                CharSequence description = view2.getContentDescription();
                json.put("classname", (Object)view2.getClass().getCanonicalName());
                json.put("classtypebitmask", ViewHierarchy.getClassTypeBitmask(view2));
                json.put("id", view2.getId());
                if (!SensitiveUserDataUtils.isSensitiveUserData(view2)) {
                    json.put("text", (Object)Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(text), ""));
                } else {
                    json.put("text", (Object)"");
                    json.put("is_user_input", true);
                }
                json.put("hint", (Object)Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(hint), ""));
                if (tag != null) {
                    json.put("tag", (Object)Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(tag.toString()), ""));
                }
                if (description != null) {
                    json.put("description", (Object)Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(((Object)description).toString()), ""));
                }
                JSONObject dimension = INSTANCE.getDimensionOfView(view2);
                json.put("dimension", (Object)dimension);
            }
            catch (JSONException e) {
                Utility.logd(TAG, (Exception)((Object)e));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void updateAppearanceOfView(@NotNull View view, @NotNull JSONObject jSONObject, float f) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return;
        }
        try {
            void json;
            View view2;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            try {
                Drawable drawable;
                View textView;
                Typeface typeface;
                JSONObject textStyle = new JSONObject();
                if (view2 instanceof TextView && (typeface = ((TextView)(textView = view2)).getTypeface()) != null) {
                    textStyle.put("font_size", (double)((TextView)textView).getTextSize());
                    textStyle.put("is_bold", typeface.isBold());
                    textStyle.put("is_italic", typeface.isItalic());
                    json.put("text_style", (Object)textStyle);
                }
                if (view2 instanceof ImageView && (drawable = ((ImageView)view2).getDrawable()) instanceof BitmapDrawable) {
                    void displayDensity;
                    if ((float)view2.getHeight() / displayDensity <= (float)44) {
                        Bitmap bitmap;
                        if ((float)view2.getWidth() / displayDensity <= (float)44 && (bitmap = ((BitmapDrawable)drawable).getBitmap()) != null) {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
                            byte[] byteArray = byteArrayOutputStream.toByteArray();
                            String encoded = Base64.encodeToString((byte[])byteArray, (int)0);
                            json.put("icon_image", (Object)encoded);
                        }
                    }
                }
            }
            catch (JSONException e) {
                Utility.logd(TAG, (Exception)((Object)e));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return;
        }
    }

    @JvmStatic
    @NotNull
    public static final JSONObject getDictionaryOfView(@NotNull View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            View view2;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            if (Intrinsics.areEqual((Object)view2.getClass().getName(), (Object)CLASS_RCTROOTVIEW)) {
                RCTRootViewReference = new WeakReference<View>(view2);
            }
            JSONObject json = new JSONObject();
            try {
                ViewHierarchy.updateBasicInfoOfView(view2, json);
                JSONArray childViews = new JSONArray();
                List<View> children = ViewHierarchy.getChildrenOfView(view2);
                int n = 0;
                int n2 = children.size() + -1;
                if (n <= n2) {
                    do {
                        int i = n++;
                        View child = children.get(i);
                        JSONObject childInfo = ViewHierarchy.getDictionaryOfView(child);
                        childViews.put((Object)childInfo);
                    } while (n <= n2);
                }
                json.put("childviews", (Object)childViews);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Failed to create JSONObject for view.", (Throwable)e);
            }
            return json;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    @JvmStatic
    public static final int getClassTypeBitmask(@NotNull View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return 0;
        }
        try {
            View view2;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            int bitmask = 0;
            if (view2 instanceof ImageView) {
                bitmask |= 2;
            }
            if (view2.isClickable()) {
                bitmask |= 0x20;
            }
            if (ViewHierarchy.isAdapterViewItem(view2)) {
                bitmask |= 0x200;
            }
            if (view2 instanceof TextView) {
                bitmask |= 0x400;
                bitmask |= 1;
                if (view2 instanceof Button) {
                    bitmask |= 4;
                    if (view2 instanceof Switch) {
                        bitmask |= 0x2000;
                    } else if (view2 instanceof CheckBox) {
                        bitmask |= 0x8000;
                    }
                }
                if (view2 instanceof EditText) {
                    bitmask |= 0x800;
                }
            } else if (view2 instanceof Spinner || view2 instanceof DatePicker) {
                bitmask |= 0x1000;
            } else if (view2 instanceof RatingBar) {
                bitmask |= 0x10000;
            } else if (view2 instanceof RadioGroup) {
                bitmask |= 0x4000;
            } else if (view2 instanceof ViewGroup && INSTANCE.isRCTButton(view2, (View)RCTRootViewReference.get())) {
                bitmask |= 0x40;
            }
            return bitmask;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return 0;
        }
    }

    @JvmStatic
    private static final boolean isAdapterViewItem(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return false;
        }
        try {
            View view2;
            ViewParent parent = view2.getParent();
            if (parent instanceof AdapterView) {
                return true;
            }
            Class<?> nestedScrollingChildClass = INSTANCE.getExistingClass("android.support.v4.view.NestedScrollingChild");
            if (nestedScrollingChildClass != null && nestedScrollingChildClass.isInstance(parent)) {
                return true;
            }
            nestedScrollingChildClass = INSTANCE.getExistingClass("androidx.core.view.NestedScrollingChild");
            return nestedScrollingChildClass != null && nestedScrollingChildClass.isInstance(parent);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return false;
        }
    }

    @JvmStatic
    @NotNull
    public static final String getTextOfView(@Nullable View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            String string;
            CharSequence charSequence;
            int m22;
            View view2;
            CharSequence textObj = null;
            if (view2 instanceof TextView) {
                textObj = ((TextView)view2).getText();
                if (view2 instanceof Switch) {
                    boolean isOn = ((Switch)view2).isChecked();
                    textObj = isOn ? "1" : "0";
                }
            } else if (view2 instanceof Spinner) {
                Object selectedItem;
                if (((Spinner)view2).getCount() > 0 && (selectedItem = ((Spinner)view2).getSelectedItem()) != null) {
                    textObj = selectedItem.toString();
                }
            } else if (view2 instanceof DatePicker) {
                int y = ((DatePicker)view2).getYear();
                m22 = ((DatePicker)view2).getMonth();
                int d = ((DatePicker)view2).getDayOfMonth();
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "%04d-%02d-%02d";
                Object[] objectArray = new Object[]{y, m22, d};
                boolean bl = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                textObj = string3;
            } else if (view2 instanceof TimePicker) {
                Integer m22 = ((TimePicker)view2).getCurrentHour();
                Intrinsics.checkNotNullExpressionValue((Object)m22, (String)"view.currentHour");
                int h = ((Number)m22).intValue();
                Integer n = ((TimePicker)view2).getCurrentMinute();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"view.currentMinute");
                m22 = ((Number)n).intValue();
                n = StringCompanionObject.INSTANCE;
                String string4 = "%02d:%02d";
                Object[] objectArray = new Object[]{h, m22};
                boolean bl = false;
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
                textObj = string5;
            } else if (view2 instanceof RadioGroup) {
                int checkedId = ((RadioGroup)view2).getCheckedRadioButtonId();
                int n = 0;
                int childCount = ((RadioGroup)view2).getChildCount();
                if (n < childCount) {
                    do {
                        int i;
                        View child;
                        if ((child = ((RadioGroup)view2).getChildAt(i = n++)).getId() != checkedId || !(child instanceof RadioButton)) continue;
                        textObj = ((RadioButton)child).getText();
                        break;
                    } while (n < childCount);
                }
            } else if (view2 instanceof RatingBar) {
                float rating = ((RatingBar)view2).getRating();
                textObj = String.valueOf(rating);
            }
            return (charSequence = textObj) == null ? "" : ((string = ((Object)charSequence).toString()) == null ? "" : string);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final String getHintOfView(@Nullable View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            String string;
            View view2;
            CharSequence hintObj = null;
            if (view2 instanceof EditText) {
                hintObj = ((EditText)view2).getHint();
            } else if (view2 instanceof TextView) {
                hintObj = ((TextView)view2).getHint();
            }
            CharSequence charSequence = hintObj;
            return charSequence == null ? "" : ((string = ((Object)charSequence).toString()) == null ? "" : string);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JSONObject getDimensionOfView(View view) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            JSONObject dimension = new JSONObject();
            try {
                void view2;
                dimension.put("top", view2.getTop());
                dimension.put("left", view2.getLeft());
                dimension.put("width", view2.getWidth());
                dimension.put("height", view2.getHeight());
                dimension.put("scrollx", view2.getScrollX());
                dimension.put("scrolly", view2.getScrollY());
                dimension.put("visibility", view2.getVisibility());
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Failed to create JSONObject for dimension.", (Throwable)e);
            }
            return dimension;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final View.OnClickListener getExistingOnClickListener(@Nullable View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            try {
                View view2;
                Field field = Class.forName("android.view.View").getDeclaredField("mListenerInfo");
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"forName(\"android.view.View\").getDeclaredField(\"mListenerInfo\")");
                Field listenerInfoField = field;
                listenerInfoField.setAccessible(true);
                Object object = listenerInfoField.get(view2);
                if (object == null) {
                    return null;
                }
                Object listenerObj = object;
                View.OnClickListener listener2 = null;
                Object object2 = Class.forName("android.view.View$ListenerInfo").getDeclaredField("mOnClickListener");
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"forName(\"android.view.View\\$ListenerInfo\").getDeclaredField(\"mOnClickListener\")");
                Field listenerField = object2;
                listenerField.setAccessible(true);
                object2 = listenerField.get(listenerObj);
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.View.OnClickListener");
                }
                listener2 = (View.OnClickListener)object2;
                return listener2;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void setOnClickListener(@NotNull View view, @Nullable View.OnClickListener onClickListener) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return;
        }
        try {
            View view2;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            try {
                void newListener;
                Field listenerInfoField = null;
                Field listenerField = null;
                try {
                    listenerInfoField = Class.forName("android.view.View").getDeclaredField("mListenerInfo");
                    listenerField = Class.forName("android.view.View$ListenerInfo").getDeclaredField("mOnClickListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (listenerInfoField == null || listenerField == null) {
                    view2.setOnClickListener((View.OnClickListener)newListener);
                    return;
                }
                listenerInfoField.setAccessible(true);
                listenerField.setAccessible(true);
                Object listenerObj = null;
                try {
                    listenerInfoField.setAccessible(true);
                    listenerObj = listenerInfoField.get(view2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (listenerObj == null) {
                    view2.setOnClickListener((View.OnClickListener)newListener);
                    return;
                }
                listenerField.set(listenerObj, newListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return;
        }
    }

    @JvmStatic
    @Nullable
    public static final View.OnTouchListener getExistingOnTouchListener(@Nullable View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            try {
                View view2;
                Field field = Class.forName("android.view.View").getDeclaredField("mListenerInfo");
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"forName(\"android.view.View\").getDeclaredField(\"mListenerInfo\")");
                Field listenerInfoField = field;
                listenerInfoField.setAccessible(true);
                Object object = listenerInfoField.get(view2);
                if (object == null) {
                    return null;
                }
                Object listenerObj = object;
                View.OnTouchListener listener2 = null;
                Object object2 = Class.forName("android.view.View$ListenerInfo").getDeclaredField("mOnTouchListener");
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"forName(\"android.view.View\\$ListenerInfo\").getDeclaredField(\"mOnTouchListener\")");
                Field listenerField = object2;
                listenerField.setAccessible(true);
                object2 = listenerField.get(listenerObj);
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.View.OnTouchListener");
                }
                listener2 = (View.OnTouchListener)object2;
                return listener2;
            }
            catch (NoSuchFieldException e) {
                Utility.logd(TAG, e);
            }
            catch (ClassNotFoundException e) {
                Utility.logd(TAG, e);
            }
            catch (IllegalAccessException e) {
                Utility.logd(TAG, e);
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final View getTouchReactView(float[] fArray, View view) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void RCTRootView;
            this.initTouchTargetHelperMethods();
            if (methodFindTouchTargetView == null || RCTRootView == null) {
                return null;
            }
            try {
                void location;
                Object[] objectArray = methodFindTouchTargetView;
                boolean bl = false;
                boolean bl2 = false;
                bl2 = false;
                boolean bl3 = false;
                if (objectArray == null) {
                    boolean bl4 = false;
                    String string = "Required value was null.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Object object = objectArray.invoke(null, objectArray = new Object[]{location, RCTRootView});
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.View");
                }
                View nativeTargetView = (View)object;
                if (nativeTargetView.getId() > 0) {
                    object = nativeTargetView.getParent();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.view.View");
                    }
                    return (View)object;
                }
            }
            catch (IllegalAccessException e) {
                Utility.logd(TAG, e);
            }
            catch (InvocationTargetException e) {
                Utility.logd(TAG, e);
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRCTButton(@NotNull View view, @Nullable View view2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void view3;
            Intrinsics.checkNotNullParameter((Object)view3, (String)"view");
            String string = view3.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"view.javaClass.name");
            String className = string;
            if (Intrinsics.areEqual((Object)className, (Object)CLASS_RCTVIEWGROUP)) {
                void RCTRootView;
                float[] location = this.getViewLocationOnScreen((View)view3);
                View touchTargetView = this.getTouchReactView(location, (View)RCTRootView);
                return touchTargetView != null && touchTargetView.getId() == view3.getId();
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRCTRootView(View view) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void view2;
            return Intrinsics.areEqual((Object)view2.getClass().getName(), (Object)CLASS_RCTROOTVIEW);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    @JvmStatic
    @Nullable
    public static final View findRCTRootView(@Nullable View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            View view2;
            View view3 = view2;
            while (view3 != null) {
                if (INSTANCE.isRCTRootView(view3)) {
                    return view3;
                }
                ViewParent viewParent = view3.getParent();
                if (!(viewParent instanceof View)) break;
                view3 = (View)viewParent;
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final float[] getViewLocationOnScreen(View view) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void view2;
            int[] location = new int[2];
            view2.getLocationOnScreen(location);
            float[] fArray = new float[]{location[0], location[1]};
            return fArray;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    private final void initTouchTargetHelperMethods() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            if (methodFindTouchTargetView != null) {
                return;
            }
            try {
                Object object = Class.forName(CLASS_TOUCHTARGETHELPER);
                Intrinsics.checkNotNullExpressionValue(object, (String)"forName(CLASS_TOUCHTARGETHELPER)");
                Class[] RCTTouchTargetHelper = object;
                object = new Class[]{float[].class, ViewGroup.class};
                methodFindTouchTargetView = RCTTouchTargetHelper.getDeclaredMethod(METHOD_FIND_TOUCHTARGET_VIEW, (Class<?>)object);
                object = methodFindTouchTargetView;
                boolean bl = false;
                boolean bl2 = false;
                bl2 = false;
                boolean bl3 = false;
                if (object == null) {
                    boolean bl4 = false;
                    String string = "Required value was null.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                ((Method)object).setAccessible(true);
            }
            catch (ClassNotFoundException e) {
                Utility.logd(TAG, e);
            }
            catch (NoSuchMethodException e) {
                Utility.logd(TAG, e);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Class<?> getExistingClass(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            Class clazz;
            try {
                void className;
                clazz = Class.forName((String)className);
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
            return clazz;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }
}

