/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.Utility;
import com.facebook.login.LoginClient;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

abstract class LoginMethodHandler
implements Parcelable {
    Map<String, String> methodLoggingExtras;
    protected LoginClient loginClient;

    LoginMethodHandler(LoginClient loginClient) {
        this.loginClient = loginClient;
    }

    LoginMethodHandler(Parcel source) {
        this.methodLoggingExtras = Utility.readStringMapFromParcel((Parcel)source);
    }

    void setLoginClient(LoginClient loginClient) {
        if (this.loginClient != null) {
            throw new FacebookException("Can't set LoginClient if it is already set.");
        }
        this.loginClient = loginClient;
    }

    abstract boolean tryAuthorize(LoginClient.Request var1);

    abstract String getNameForLogging();

    boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        return false;
    }

    boolean needsInternetPermission() {
        return false;
    }

    void cancel() {
    }

    void putChallengeParam(JSONObject param) throws JSONException {
    }

    protected String getClientState(String authId) {
        JSONObject param = new JSONObject();
        try {
            param.put("0_auth_logger_id", (Object)authId);
            param.put("3_method", (Object)this.getNameForLogging());
            this.putChallengeParam(param);
        }
        catch (JSONException e) {
            Log.w((String)"LoginMethodHandler", (String)("Error creating client state json: " + e.getMessage()));
        }
        return param.toString();
    }

    protected void addLoggingExtra(String key, Object value) {
        if (this.methodLoggingExtras == null) {
            this.methodLoggingExtras = new HashMap<String, String>();
        }
        this.methodLoggingExtras.put(key, value == null ? null : value.toString());
    }

    protected void logWebLoginCompleted(String e2e) {
        String applicationId = this.loginClient.getPendingRequest().getApplicationId();
        InternalAppEventsLogger logger = new InternalAppEventsLogger((Context)this.loginClient.getActivity(), applicationId);
        Bundle parameters = new Bundle();
        parameters.putString("fb_web_login_e2e", e2e);
        parameters.putLong("fb_web_login_switchback_time", System.currentTimeMillis());
        parameters.putString("app_id", applicationId);
        logger.logEventImplicitly("fb_dialogs_web_login_dialog_complete", null, parameters);
    }

    static AccessToken createAccessTokenFromNativeLogin(Bundle bundle, AccessTokenSource source, String applicationId) {
        Date expires = Utility.getBundleLongAsDate((Bundle)bundle, (String)"com.facebook.platform.extra.EXPIRES_SECONDS_SINCE_EPOCH", (Date)new Date(0L));
        ArrayList permissions = bundle.getStringArrayList("com.facebook.platform.extra.PERMISSIONS");
        String token = bundle.getString("com.facebook.platform.extra.ACCESS_TOKEN");
        Date dataAccessExpirationTime = Utility.getBundleLongAsDate((Bundle)bundle, (String)"com.facebook.platform.extra.EXTRA_DATA_ACCESS_EXPIRATION_TIME", (Date)new Date(0L));
        if (Utility.isNullOrEmpty((String)token)) {
            return null;
        }
        String userId = bundle.getString("com.facebook.platform.extra.USER_ID");
        String graphDomain = bundle.getString("graph_domain");
        return new AccessToken(token, applicationId, userId, (Collection)permissions, null, null, source, expires, new Date(), dataAccessExpirationTime, graphDomain);
    }

    public static AccessToken createAccessTokenFromWebBundle(Collection<String> requestedPermissions, Bundle bundle, AccessTokenSource source, String applicationId) throws FacebookException {
        Date expires = Utility.getBundleLongAsDate((Bundle)bundle, (String)"expires_in", (Date)new Date());
        String token = bundle.getString("access_token");
        Date dataAccessExpirationTime = Utility.getBundleLongAsDate((Bundle)bundle, (String)"data_access_expiration_time", (Date)new Date(0L));
        String grantedPermissions = bundle.getString("granted_scopes");
        if (!Utility.isNullOrEmpty((String)grantedPermissions)) {
            requestedPermissions = new ArrayList<String>(Arrays.asList(grantedPermissions.split(",")));
        }
        String deniedPermissions = bundle.getString("denied_scopes");
        ArrayList<String> declinedPermissions = null;
        if (!Utility.isNullOrEmpty((String)deniedPermissions)) {
            declinedPermissions = new ArrayList<String>(Arrays.asList(deniedPermissions.split(",")));
        }
        String expiredScopes = bundle.getString("expired_scopes");
        ArrayList<String> expiredPermissions = null;
        if (!Utility.isNullOrEmpty((String)expiredScopes)) {
            expiredPermissions = new ArrayList<String>(Arrays.asList(expiredScopes.split(",")));
        }
        if (Utility.isNullOrEmpty((String)token)) {
            return null;
        }
        String graphDomain = bundle.getString("graph_domain");
        String signed_request = bundle.getString("signed_request");
        String userId = LoginMethodHandler.getUserIDFromSignedRequest(signed_request);
        return new AccessToken(token, applicationId, userId, requestedPermissions, declinedPermissions, expiredPermissions, source, expires, new Date(), dataAccessExpirationTime, graphDomain);
    }

    static String getUserIDFromSignedRequest(String signedRequest) throws FacebookException {
        if (signedRequest == null || signedRequest.isEmpty()) {
            throw new FacebookException("Authorization response does not contain the signed_request");
        }
        try {
            String[] signatureAndPayload = signedRequest.split("\\.");
            if (signatureAndPayload.length == 2) {
                byte[] data = Base64.decode((String)signatureAndPayload[1], (int)0);
                String dataStr = new String(data, "UTF-8");
                JSONObject jsonObject = new JSONObject(dataStr);
                return jsonObject.getString("user_id");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        throw new FacebookException("Failed to retrieve user_id from signed_request");
    }

    public void writeToParcel(Parcel dest, int flags) {
        Utility.writeStringMapToParcel((Parcel)dest, this.methodLoggingExtras);
    }
}

