/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareMedia;
import com.facebook.share.model.SharePhoto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ShareStoryContent
extends ShareContent<ShareStoryContent, Builder> {
    private final ShareMedia mBackgroundAsset;
    private final SharePhoto mStickerAsset;
    @Nullable
    private final List<String> mBackgroundColorList;
    private final String mAttributionLink;
    public static final Parcelable.Creator<ShareStoryContent> CREATOR = new Parcelable.Creator<ShareStoryContent>(){

        public ShareStoryContent createFromParcel(Parcel in) {
            return new ShareStoryContent(in);
        }

        public ShareStoryContent[] newArray(int size) {
            return new ShareStoryContent[size];
        }
    };

    private ShareStoryContent(Builder builder) {
        super(builder);
        this.mBackgroundAsset = builder.mBackgroundAsset;
        this.mStickerAsset = builder.mStickerAsset;
        this.mBackgroundColorList = builder.mBackgroundColorList;
        this.mAttributionLink = builder.mAttributionLink;
    }

    ShareStoryContent(Parcel in) {
        super(in);
        this.mBackgroundAsset = (ShareMedia)in.readParcelable(ShareMedia.class.getClassLoader());
        this.mStickerAsset = (SharePhoto)in.readParcelable(SharePhoto.class.getClassLoader());
        this.mBackgroundColorList = this.readUnmodifiableStringList(in);
        this.mAttributionLink = in.readString();
    }

    public ShareMedia getBackgroundAsset() {
        return this.mBackgroundAsset;
    }

    public SharePhoto getStickerAsset() {
        return this.mStickerAsset;
    }

    @Nullable
    public List<String> getBackgroundColorList() {
        return this.mBackgroundColorList == null ? null : Collections.unmodifiableList(this.mBackgroundColorList);
    }

    public String getAttributionLink() {
        return this.mAttributionLink;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeParcelable((Parcelable)this.mBackgroundAsset, 0);
        out.writeParcelable((Parcelable)this.mStickerAsset, 0);
        out.writeStringList(this.mBackgroundColorList);
        out.writeString(this.mAttributionLink);
    }

    @Nullable
    private List<String> readUnmodifiableStringList(Parcel in) {
        ArrayList list = new ArrayList();
        in.readStringList(list);
        return list.isEmpty() ? null : Collections.unmodifiableList(list);
    }

    public static final class Builder
    extends ShareContent.Builder<ShareStoryContent, Builder> {
        static final String TAG = Builder.class.getSimpleName();
        private ShareMedia mBackgroundAsset;
        private SharePhoto mStickerAsset;
        private List<String> mBackgroundColorList;
        private String mAttributionLink;

        public Builder setBackgroundAsset(ShareMedia backgroundAsset) {
            this.mBackgroundAsset = backgroundAsset;
            return this;
        }

        public Builder setStickerAsset(SharePhoto stickerAsset) {
            this.mStickerAsset = stickerAsset;
            return this;
        }

        public Builder setBackgroundColorList(List<String> backgroundColorList) {
            this.mBackgroundColorList = backgroundColorList;
            return this;
        }

        public Builder setAttributionLink(String attributionLink) {
            this.mAttributionLink = attributionLink;
            return this;
        }

        @Override
        public ShareStoryContent build() {
            return new ShareStoryContent(this);
        }

        @Override
        public Builder readFrom(ShareStoryContent model) {
            if (model == null) {
                return this;
            }
            return ((Builder)super.readFrom(model)).setBackgroundAsset(model.getBackgroundAsset()).setStickerAsset(model.getStickerAsset()).setBackgroundColorList(model.getBackgroundColorList()).setAttributionLink(model.getAttributionLink());
        }
    }
}

