/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.core.content.ContextCompat;
import com.facebook.FacebookException;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.common.R;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\b'\u0018\u00002\u00020\u0001B9\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0012\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0014J*\u00104\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0014J\b\u00105\u001a\u00020\u0007H\u0016J\b\u00106\u001a\u00020\u0007H\u0016J\u0012\u00107\u001a\u0002012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0014J\u0012\u00108\u001a\u0002012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0014J\u0012\u00109\u001a\u00020\u00072\b\u0010:\u001a\u0004\u0018\u00010\nH\u0014J\b\u0010;\u001a\u000201H\u0014J\u0010\u0010<\u001a\u0002012\u0006\u0010=\u001a\u00020>H\u0014J*\u0010?\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J*\u0010@\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0003J*\u0010A\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J*\u0010B\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u000e\u0010C\u001a\u0002012\u0006\u0010\u001f\u001a\u00020%J\u000e\u0010C\u001a\u0002012\u0006\u0010\u001f\u001a\u00020 J\u0012\u0010D\u001a\u0002012\b\u0010E\u001a\u0004\u0018\u00010\u001eH\u0014J\u0012\u0010F\u001a\u0002012\b\u0010E\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010G\u001a\u000201H\u0002R\u0014\u0010\r\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u000b\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001f\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010$\u001a\u0004\u0018\u00010%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001a\u00a8\u0006H"}, d2={"Lcom/facebook/FacebookButtonBase;", "Landroid/widget/Button;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "analyticsButtonCreatedEventName", "", "analyticsButtonTappedEventName", "(Landroid/content/Context;Landroid/util/AttributeSet;IILjava/lang/String;Ljava/lang/String;)V", "activity", "Landroid/app/Activity;", "getActivity", "()Landroid/app/Activity;", "getAnalyticsButtonCreatedEventName", "()Ljava/lang/String;", "getAnalyticsButtonTappedEventName", "androidxActivityResultRegistryOwner", "Landroidx/activity/result/ActivityResultRegistryOwner;", "getAndroidxActivityResultRegistryOwner", "()Landroidx/activity/result/ActivityResultRegistryOwner;", "defaultRequestCode", "getDefaultRequestCode", "()I", "defaultStyleResource", "getDefaultStyleResource", "externalOnClickListener", "Landroid/view/View$OnClickListener;", "fragment", "Landroidx/fragment/app/Fragment;", "getFragment", "()Landroidx/fragment/app/Fragment;", "internalOnClickListener", "nativeFragment", "Landroid/app/Fragment;", "getNativeFragment", "()Landroid/app/Fragment;", "overrideCompoundPadding", "", "overrideCompoundPaddingLeft", "overrideCompoundPaddingRight", "parentFragment", "Lcom/facebook/internal/FragmentWrapper;", "requestCode", "getRequestCode", "callExternalOnClickListener", "", "v", "Landroid/view/View;", "configureButton", "getCompoundPaddingLeft", "getCompoundPaddingRight", "logButtonCreated", "logButtonTapped", "measureTextWidth", "text", "onAttachedToWindow", "onDraw", "canvas", "Landroid/graphics/Canvas;", "parseBackgroundAttributes", "parseCompoundDrawableAttributes", "parseContentAttributes", "parseTextAttributes", "setFragment", "setInternalOnClickListener", "l", "setOnClickListener", "setupOnClickListener", "facebook-common_release"})
@AutoHandleExceptions
@SuppressLint(value={"ResourceType"})
public abstract class FacebookButtonBase
extends Button {
    @NotNull
    private final String analyticsButtonCreatedEventName;
    @NotNull
    private final String analyticsButtonTappedEventName;
    @Nullable
    private View.OnClickListener externalOnClickListener;
    @Nullable
    private View.OnClickListener internalOnClickListener;
    private boolean overrideCompoundPadding;
    private int overrideCompoundPaddingLeft;
    private int overrideCompoundPaddingRight;
    @Nullable
    private FragmentWrapper parentFragment;
    private final int defaultStyleResource;

    protected FacebookButtonBase(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes, @NotNull String analyticsButtonCreatedEventName, @NotNull String analyticsButtonTappedEventName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analyticsButtonCreatedEventName, (String)"analyticsButtonCreatedEventName");
        Intrinsics.checkNotNullParameter((Object)analyticsButtonTappedEventName, (String)"analyticsButtonTappedEventName");
        super(context, attrs, 0);
        int defStyleRes2 = defStyleRes;
        defStyleRes2 = defStyleRes2 == 0 ? this.getDefaultStyleResource() : defStyleRes2;
        defStyleRes2 = defStyleRes2 == 0 ? R.style.com_facebook_button : defStyleRes2;
        this.configureButton(context, attrs, defStyleAttr, defStyleRes2);
        this.analyticsButtonCreatedEventName = analyticsButtonCreatedEventName;
        this.analyticsButtonTappedEventName = analyticsButtonTappedEventName;
        this.setClickable(true);
        this.setFocusable(true);
    }

    @NotNull
    protected final String getAnalyticsButtonCreatedEventName() {
        return this.analyticsButtonCreatedEventName;
    }

    @NotNull
    protected final String getAnalyticsButtonTappedEventName() {
        return this.analyticsButtonTappedEventName;
    }

    protected abstract int getDefaultRequestCode();

    @Nullable
    public final Fragment getNativeFragment() {
        FragmentWrapper fragmentWrapper = this.parentFragment;
        return fragmentWrapper == null ? null : fragmentWrapper.getNativeFragment();
    }

    public final void setFragment(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.parentFragment = new FragmentWrapper(fragment);
    }

    @Nullable
    public final androidx.fragment.app.Fragment getFragment() {
        FragmentWrapper fragmentWrapper = this.parentFragment;
        return fragmentWrapper == null ? null : fragmentWrapper.getSupportFragment();
    }

    public final void setFragment(@NotNull androidx.fragment.app.Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.parentFragment = new FragmentWrapper(fragment);
    }

    @Nullable
    public final ActivityResultRegistryOwner getAndroidxActivityResultRegistryOwner() {
        Activity activity = this.getActivity();
        return activity instanceof ActivityResultRegistryOwner ? (ActivityResultRegistryOwner)activity : null;
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.externalOnClickListener = l;
    }

    public int getRequestCode() {
        return this.getDefaultRequestCode();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.logButtonCreated(this.getContext());
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        boolean centered;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        boolean bl = centered = (this.getGravity() & 1) != 0;
        if (centered) {
            int compoundPaddingLeft = this.getCompoundPaddingLeft();
            int compoundPaddingRight = this.getCompoundPaddingRight();
            int compoundDrawablePadding = this.getCompoundDrawablePadding();
            int textX = compoundPaddingLeft + compoundDrawablePadding;
            int textContentWidth = this.getWidth() - textX - compoundPaddingRight;
            int textWidth = this.measureTextWidth(((Object)this.getText()).toString());
            int textPaddingWidth = (textContentWidth - textWidth) / 2;
            int imagePaddingWidth = (compoundPaddingLeft - this.getPaddingLeft()) / 2;
            int inset = Math.min(textPaddingWidth, imagePaddingWidth);
            this.overrideCompoundPaddingLeft = compoundPaddingLeft - inset;
            this.overrideCompoundPaddingRight = compoundPaddingRight + inset;
            this.overrideCompoundPadding = true;
        }
        super.onDraw(canvas);
        this.overrideCompoundPadding = false;
    }

    public int getCompoundPaddingLeft() {
        return this.overrideCompoundPadding ? this.overrideCompoundPaddingLeft : super.getCompoundPaddingLeft();
    }

    public int getCompoundPaddingRight() {
        return this.overrideCompoundPadding ? this.overrideCompoundPaddingRight : super.getCompoundPaddingRight();
    }

    @NotNull
    protected Activity getActivity() {
        Context context = this.getContext();
        while (!(context instanceof Activity) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (context instanceof Activity) {
            Context context2 = context;
            return (Activity)context2;
        }
        throw new FacebookException("Unable to get Activity.");
    }

    protected int getDefaultStyleResource() {
        return this.defaultStyleResource;
    }

    protected int measureTextWidth(@Nullable String text) {
        return (int)Math.ceil(this.getPaint().measureText(text));
    }

    protected void configureButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.parseBackgroundAttributes(context, attrs, defStyleAttr, defStyleRes);
        this.parseCompoundDrawableAttributes(context, attrs, defStyleAttr, defStyleRes);
        this.parseContentAttributes(context, attrs, defStyleAttr, defStyleRes);
        this.parseTextAttributes(context, attrs, defStyleAttr, defStyleRes);
        this.setupOnClickListener();
    }

    protected void callExternalOnClickListener(@Nullable View v) {
        View.OnClickListener onClickListener = this.externalOnClickListener;
        if (onClickListener != null) {
            onClickListener.onClick(v);
        }
    }

    protected void setInternalOnClickListener(@Nullable View.OnClickListener l) {
        this.internalOnClickListener = l;
    }

    protected void logButtonCreated(@Nullable Context context) {
        InternalAppEventsLogger logger = InternalAppEventsLogger.Companion.createInstance(context, null);
        logger.logEventImplicitly(this.analyticsButtonCreatedEventName);
    }

    protected void logButtonTapped(@Nullable Context context) {
        InternalAppEventsLogger logger = InternalAppEventsLogger.Companion.createInstance(context, null);
        logger.logEventImplicitly(this.analyticsButtonTappedEventName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseBackgroundAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (this.isInEditMode()) {
            return;
        }
        int[] nArray = new int[]{16842964};
        int[] attrsResources = nArray;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, attrsResources, defStyleAttr, defStyleRes);
        try {
            if (a.hasValue(0)) {
                int backgroundResource = a.getResourceId(0, 0);
                if (backgroundResource != 0) {
                    this.setBackgroundResource(backgroundResource);
                } else {
                    this.setBackgroundColor(a.getColor(0, 0));
                }
            } else {
                this.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.com_facebook_blue));
            }
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"ResourceType"})
    private final void parseCompoundDrawableAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int n;
        FacebookButtonBase facebookButtonBase;
        int[] nArray = new int[]{16843119, 16843117, 0x1010170, 16843118, 0x1010171};
        int[] attrsResources = nArray;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, attrsResources, defStyleAttr, defStyleRes);
        FacebookButtonBase facebookButtonBase2 = this;
        try {
            facebookButtonBase = facebookButtonBase2;
            this.setCompoundDrawablesWithIntrinsicBounds(a.getResourceId(0, 0), a.getResourceId(1, 0), a.getResourceId(2, 0), a.getResourceId(3, 0));
            n = a.getDimensionPixelSize(4, 0);
        }
        finally {
            a.recycle();
        }
        facebookButtonBase.setCompoundDrawablePadding(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseContentAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int[] nArray = new int[]{16842966, 16842967, 16842968, 16842969};
        int[] attrsResources = nArray;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, attrsResources, defStyleAttr, defStyleRes);
        try {
            this.setPadding(a.getDimensionPixelSize(0, 0), a.getDimensionPixelSize(1, 0), a.getDimensionPixelSize(2, 0), a.getDimensionPixelSize(3, 0));
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseTextAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        CharSequence charSequence;
        FacebookButtonBase facebookButtonBase;
        int n;
        FacebookButtonBase facebookButtonBase2;
        int[] nArray = new int[]{16842904};
        int[] colorResources = nArray;
        TypedArray colorAttrs = context.getTheme().obtainStyledAttributes(attrs, colorResources, defStyleAttr, defStyleRes);
        try {
            this.setTextColor(colorAttrs.getColorStateList(0));
        }
        finally {
            colorAttrs.recycle();
        }
        int[] nArray2 = new int[]{16842927};
        int[] gravityResources = nArray2;
        TypedArray gravityAttrs = context.getTheme().obtainStyledAttributes(attrs, gravityResources, defStyleAttr, defStyleRes);
        FacebookButtonBase facebookButtonBase3 = this;
        try {
            facebookButtonBase2 = facebookButtonBase3;
            n = gravityAttrs.getInt(0, 17);
        }
        finally {
            gravityAttrs.recycle();
        }
        facebookButtonBase2.setGravity(n);
        int[] nArray3 = new int[]{16842901, 16842903, 16843087};
        int[] attrsResources = nArray3;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, attrsResources, defStyleAttr, defStyleRes);
        facebookButtonBase3 = this;
        try {
            facebookButtonBase = facebookButtonBase3;
            this.setTextSize(0, a.getDimensionPixelSize(0, 0));
            Typeface typeface = this.getTypeface();
            this.setTypeface(Typeface.create((Typeface)typeface, (int)1));
            charSequence = a.getString(2);
        }
        finally {
            a.recycle();
        }
        facebookButtonBase.setText(charSequence);
    }

    private final void setupOnClickListener() {
        super.setOnClickListener(arg_0 -> FacebookButtonBase.setupOnClickListener$lambda-0(this, arg_0));
    }

    private static final void setupOnClickListener$lambda-0(FacebookButtonBase this$0, View v) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logButtonTapped(this$0.getContext());
        View.OnClickListener internalOnClickListener = this$0.internalOnClickListener;
        if (internalOnClickListener != null) {
            internalOnClickListener.onClick(v);
        } else {
            View.OnClickListener onClickListener = this$0.externalOnClickListener;
            if (onClickListener != null) {
                onClickListener.onClick(v);
            }
        }
    }
}

