/*
 * Decompiled with CFR 0.152.
 */
package com.ethanhua.skeleton;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class ViewReplacer {
    private static final String TAG = ViewReplacer.class.getName();
    private final View mSourceView;
    private View mTargetView;
    private int mTargetViewResID = -1;
    private View mCurrentView;
    private ViewGroup mSourceParentView;
    private final ViewGroup.LayoutParams mSourceViewLayoutParams;
    private int mSourceViewIndexInParent = 0;
    private final int mSourceViewId;

    public ViewReplacer(View sourceView) {
        this.mSourceView = sourceView;
        this.mSourceViewLayoutParams = this.mSourceView.getLayoutParams();
        this.mCurrentView = this.mSourceView;
        this.mSourceViewId = this.mSourceView.getId();
    }

    public void replace(int targetViewResID) {
        if (this.mTargetViewResID == targetViewResID) {
            return;
        }
        if (this.init()) {
            this.mTargetViewResID = targetViewResID;
            this.replace(LayoutInflater.from((Context)this.mSourceView.getContext()).inflate(this.mTargetViewResID, this.mSourceParentView, false));
        }
    }

    public void replace(View targetView) {
        if (this.mCurrentView == targetView) {
            return;
        }
        if (targetView.getParent() != null) {
            ((ViewGroup)targetView.getParent()).removeView(targetView);
        }
        if (this.init()) {
            this.mTargetView = targetView;
            this.mSourceParentView.removeView(this.mCurrentView);
            this.mTargetView.setId(this.mSourceViewId);
            this.mSourceParentView.addView(this.mTargetView, this.mSourceViewIndexInParent, this.mSourceViewLayoutParams);
            this.mCurrentView = this.mTargetView;
        }
    }

    public void restore() {
        if (this.mSourceParentView != null) {
            this.mSourceParentView.removeView(this.mCurrentView);
            this.mSourceParentView.addView(this.mSourceView, this.mSourceViewIndexInParent, this.mSourceViewLayoutParams);
            this.mCurrentView = this.mSourceView;
            this.mTargetView = null;
            this.mTargetViewResID = -1;
        }
    }

    public View getSourceView() {
        return this.mSourceView;
    }

    public View getTargetView() {
        return this.mTargetView;
    }

    public View getCurrentView() {
        return this.mCurrentView;
    }

    private boolean init() {
        if (this.mSourceParentView == null) {
            this.mSourceParentView = (ViewGroup)this.mSourceView.getParent();
            if (this.mSourceParentView == null) {
                Log.e((String)TAG, (String)"the source view have not attach to any view");
                return false;
            }
            int count = this.mSourceParentView.getChildCount();
            for (int index = 0; index < count; ++index) {
                if (this.mSourceView != this.mSourceParentView.getChildAt(index)) continue;
                this.mSourceViewIndexInParent = index;
                break;
            }
        }
        return true;
    }
}

