/*
 * Decompiled with CFR 0.152.
 */
package com.ethanhua.skeleton;

import android.content.Context;
import android.support.annotation.IntRange;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.ethanhua.skeleton.ShimmerViewHolder;
import io.supercharge.shimmerlayout.ShimmerLayout;

public class SkeletonAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private int mItemCount;
    private int mLayoutReference;
    private int mColor;
    private boolean mShimmer;
    private int mShimmerDuration;
    private int mShimmerAngle;

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        if (this.mShimmer) {
            return new ShimmerViewHolder(inflater, parent, this.mLayoutReference);
        }
        return new RecyclerView.ViewHolder(inflater.inflate(this.mLayoutReference, parent, false)){};
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.mShimmer) {
            ShimmerLayout layout2 = (ShimmerLayout)holder.itemView;
            layout2.setShimmerAnimationDuration(this.mShimmerDuration);
            layout2.setShimmerAngle(this.mShimmerAngle);
            layout2.setShimmerColor(this.mColor);
            layout2.startShimmerAnimation();
        }
    }

    public int getItemCount() {
        return this.mItemCount;
    }

    public void setLayoutReference(int layoutReference) {
        this.mLayoutReference = layoutReference;
    }

    public void setItemCount(int itemCount) {
        this.mItemCount = itemCount;
    }

    public void setShimmerColor(int color2) {
        this.mColor = color2;
    }

    public void shimmer(boolean shimmer) {
        this.mShimmer = shimmer;
    }

    public void setShimmerDuration(int shimmerDuration) {
        this.mShimmerDuration = shimmerDuration;
    }

    public void setShimmerAngle(@IntRange(from=0L, to=30L) int shimmerAngle) {
        this.mShimmerAngle = shimmerAngle;
    }
}

