/*
 * Decompiled with CFR 0.152.
 */
package com.ethanhua.skeleton;

import android.content.Context;
import android.support.annotation.ColorRes;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import com.ethanhua.skeleton.R;
import com.ethanhua.skeleton.SkeletonAdapter;
import com.ethanhua.skeleton.SkeletonScreen;

public class RecyclerViewSkeletonScreen
implements SkeletonScreen {
    private final RecyclerView mRecyclerView;
    private final RecyclerView.Adapter mActualAdapter;
    private final SkeletonAdapter mSkeletonAdapter;
    private final boolean mRecyclerViewFrozen;

    private RecyclerViewSkeletonScreen(Builder builder) {
        this.mRecyclerView = builder.mRecyclerView;
        this.mActualAdapter = builder.mActualAdapter;
        this.mSkeletonAdapter = new SkeletonAdapter();
        this.mSkeletonAdapter.setItemCount(builder.mItemCount);
        this.mSkeletonAdapter.setLayoutReference(builder.mItemResID);
        this.mSkeletonAdapter.shimmer(builder.mShimmer);
        this.mSkeletonAdapter.setShimmerColor(builder.mShimmerColor);
        this.mSkeletonAdapter.setShimmerAngle(builder.mShimmerAngle);
        this.mSkeletonAdapter.setShimmerDuration(builder.mShimmerDuration);
        this.mRecyclerViewFrozen = builder.mFrozen;
    }

    @Override
    public void show() {
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mSkeletonAdapter);
        if (!this.mRecyclerView.isComputingLayout() && this.mRecyclerViewFrozen) {
            this.mRecyclerView.setLayoutFrozen(true);
        }
    }

    @Override
    public void hide() {
        this.mRecyclerView.setAdapter(this.mActualAdapter);
    }

    public static class Builder {
        private RecyclerView.Adapter mActualAdapter;
        private final RecyclerView mRecyclerView;
        private boolean mShimmer = true;
        private int mItemCount = 10;
        private int mItemResID = R.layout.layout_default_item_skeleton;
        private int mShimmerColor;
        private int mShimmerDuration = 1000;
        private int mShimmerAngle = 20;
        private boolean mFrozen = true;

        public Builder(RecyclerView recyclerView) {
            this.mRecyclerView = recyclerView;
            this.mShimmerColor = ContextCompat.getColor((Context)recyclerView.getContext(), (int)R.color.shimmer_color);
        }

        public Builder adapter(RecyclerView.Adapter adapter) {
            this.mActualAdapter = adapter;
            return this;
        }

        public Builder count(int itemCount) {
            this.mItemCount = itemCount;
            return this;
        }

        public Builder shimmer(boolean shimmer) {
            this.mShimmer = shimmer;
            return this;
        }

        public Builder duration(int shimmerDuration) {
            this.mShimmerDuration = shimmerDuration;
            return this;
        }

        public Builder color(@ColorRes int shimmerColor) {
            this.mShimmerColor = ContextCompat.getColor((Context)this.mRecyclerView.getContext(), (int)shimmerColor);
            return this;
        }

        public Builder angle(@IntRange(from=0L, to=30L) int shimmerAngle) {
            this.mShimmerAngle = shimmerAngle;
            return this;
        }

        public Builder load(@LayoutRes int skeletonLayoutResID) {
            this.mItemResID = skeletonLayoutResID;
            return this;
        }

        public Builder frozen(boolean frozen) {
            this.mFrozen = frozen;
            return this;
        }

        public RecyclerViewSkeletonScreen show() {
            RecyclerViewSkeletonScreen recyclerViewSkeleton = new RecyclerViewSkeletonScreen(this);
            recyclerViewSkeleton.show();
            return recyclerViewSkeleton;
        }
    }
}

