/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow.webview.webviewclient;

import android.net.Uri;
import android.text.TextUtils;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.webservice.webwindow.webview.webviewclient.ClientParams;
import com.yy.webservice.webwindow.webview.webviewclient.CommonWebViewClient;
import com.yy.webservice.webwindow.webview.webviewclient.DoNothingClient;
import com.yy.webservice.webwindow.webview.webviewclient.PullAppClient;
import com.yy.webservice.webwindow.webview.webviewclient.PullBrowserClient;
import com.yy.webservice.webwindow.webview.webviewclient.SchemeDoNothingClient;

public class WebClientFilter {
    private static final String WEB_URL_UA = "selfDefUA";
    private String mAppIDFromUrl;
    private boolean mCanDownload = true;
    private CommonWebViewClient mClient;

    public WebClientFilter(String url, WebSettings settings) {
        this.doWebClientFilter(url);
        this.setExtraUAFromUrl(url, settings);
    }

    public String getAppIDFromUrl() {
        return this.mAppIDFromUrl;
    }

    public boolean canDownload() {
        return this.mCanDownload;
    }

    public CommonWebViewClient getBussinessClient() {
        return this.mClient;
    }

    public void doWebClientFilter(String url) {
        String download;
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        Uri uri = Uri.parse((String)url.trim());
        String filterIdListStr = null;
        String scheme = null;
        try {
            filterIdListStr = uri.getQueryParameter("selfDefFilterIdList");
            scheme = uri.getQueryParameter("selfDefFilterScheme");
            this.mAppIDFromUrl = uri.getQueryParameter("feedappid");
            if (StringUtils.isEmpty((String)filterIdListStr) || StringUtils.isEmpty((String)scheme)) {
                return;
            }
        }
        catch (Exception e) {
            MLog.error((Object)"WebClientFilter", (Throwable)e);
            return;
        }
        String[] idList = filterIdListStr.split(",");
        if (idList != null && idList.length > 0) {
            String[] schemeList = scheme.split("!");
            if (idList != null && idList.length > 0 && schemeList != null && schemeList.length > 0) {
                for (int i = 0; i < schemeList.length; ++i) {
                    int size = idList.length;
                    ClientParams params = new ClientParams();
                    params.scheme = schemeList[i];
                    params.filterIdList = new int[size];
                    for (int j = 0; j < size; ++j) {
                        params.filterIdList[j] = StringUtils.safeParseInt((String)idList[j]);
                    }
                    this.addWebViweClientFilterList(params);
                }
            }
        }
        if ("0".equals(download = uri.getQueryParameter("selfDefDownload"))) {
            this.mCanDownload = false;
        }
    }

    public void setExtraUAFromUrl(String url, WebSettings settings) {
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        try {
            String ua;
            Uri uri = Uri.parse((String)url);
            if (uri != null && !TextUtils.isEmpty((CharSequence)(ua = uri.getQueryParameter(WEB_URL_UA))) && settings != null) {
                String newUA = settings.getUserAgentString() + ua;
                settings.setUserAgentString(newUA);
            }
        }
        catch (Exception e) {
            MLog.error((Object)"WebClientFilter", (Throwable)e);
        }
    }

    public void addWebViweClientFilterList(ClientParams paramsObj) {
        if (paramsObj.filterIdList != null && paramsObj.filterIdList.length > 0) {
            int size = paramsObj.filterIdList.length;
            for (int i = size - 1; i >= 0; --i) {
                CommonWebViewClient client = null;
                int filterId = paramsObj.filterIdList[i];
                if (CommonWebViewClient.ClientType.valueOf(filterId) == CommonWebViewClient.ClientType.APP) {
                    client = new PullAppClient();
                } else if (CommonWebViewClient.ClientType.valueOf(filterId) == CommonWebViewClient.ClientType.BROWSER) {
                    client = new PullBrowserClient();
                } else if (CommonWebViewClient.ClientType.valueOf(filterId) == CommonWebViewClient.ClientType.HOSTNOTHING) {
                    client = new DoNothingClient();
                } else if (CommonWebViewClient.ClientType.valueOf(filterId) == CommonWebViewClient.ClientType.SCHEMENOTHING) {
                    client = new SchemeDoNothingClient();
                }
                if (client == null) continue;
                client.setParams(paramsObj);
                this.addWebViewClientFilter(client);
            }
        }
    }

    public boolean addWebViweClientFilterList(String jsonData) {
        if (StringUtils.isEmpty((String)jsonData)) {
            return false;
        }
        ClientParams paramsObj = (ClientParams)JsonParser.parseJsonObject((String)jsonData, ClientParams.class);
        if (paramsObj != null) {
            this.addWebViweClientFilterList(paramsObj);
            return true;
        }
        return false;
    }

    private void addWebViewClientFilter(CommonWebViewClient client) {
        if (this.mClient != null && client != null) {
            client.setDecorate(this.mClient);
            this.mClient = client;
        } else {
            this.mClient = client;
        }
    }

    public CommonWebViewClient.LoadValue shouldOverrideUrlLoading(WebView view, String url) {
        if (this.mClient != null) {
            return this.mClient.shouldOverrideUrlLoading(view, url);
        }
        return null;
    }
}

