/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow.webview.js;

import android.webkit.JavascriptInterface;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.event.parqam.JsReturn;
import com.yy.webservice.webwindow.webview.js.IJsInterfaceCallback;
import org.json.JSONException;
import org.json.JSONObject;

@DontProguardClass
public class NativeAppJavaScriptInterface {
    public static final String JS_CALL_NAME = "nativeApp";
    public static final String OLD_METHOD_CONTEXT = "oldMethodContext";
    private INativeCallBack callBack;

    public NativeAppJavaScriptInterface(INativeCallBack callBack) {
        this.callBack = callBack;
    }

    public void setCallBack(INativeCallBack callBack) {
        this.callBack = callBack;
    }

    @JavascriptInterface
    public void showToast(String str) {
        String paramJson = StringUtils.formatWitUSLocal((String)"{\"oldMethod\":\"showToast\", \"msg\": \"%s\"}", (Object[])new Object[]{str});
        this.callAppMethod("ui", "showToast", OLD_METHOD_CONTEXT, paramJson, "");
    }

    @JavascriptInterface
    public void sendIMLikeMessage(final long uid, final String gameId, final String content) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                final String paramJson = StringUtils.formatWitUSLocal((String)"{\"oldMethod\":\"sendIMLikeMessage\", \"uid\": %d, \"gameId\": \"%s\", \"content\": %s}", (Object[])new Object[]{uid, gameId, JsonParser.toJson((Object)content)});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NativeAppJavaScriptInterface.this.callAppMethod("im", "sendIMLikeMessage", NativeAppJavaScriptInterface.OLD_METHOD_CONTEXT, paramJson, "");
                    }
                });
            }
        });
    }

    @JavascriptInterface
    public void savePrivateUserData(final String key, final String value) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                final String paramJson = StringUtils.formatWitUSLocal((String)"{\"oldMethod\":\"savePrivateUserData\", \"key\": \"%s\", \"value\": %s}", (Object[])new Object[]{key, JsonParser.toJson((Object)value)});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NativeAppJavaScriptInterface.this.callAppMethod("base", "setLocalStorage", NativeAppJavaScriptInterface.OLD_METHOD_CONTEXT, paramJson, "");
                    }
                });
            }
        });
    }

    @JavascriptInterface
    public void loadPrivateUserData(final String key, final String defaultValue) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                final String paramJson = StringUtils.formatWitUSLocal((String)"{\"oldMethod\":\"loadPrivateUserData\", \"key\": \"%s\", \"defaultValue\": %s}", (Object[])new Object[]{key, JsonParser.toJson((Object)defaultValue)});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NativeAppJavaScriptInterface.this.callAppMethod("base", "getLocalStorage", NativeAppJavaScriptInterface.OLD_METHOD_CONTEXT, paramJson, "onLoadPrivateUserData");
                    }
                });
            }
        });
    }

    @JavascriptInterface
    public void toPersonalInfo(long uid, int fromType) {
        String paramJson = StringUtils.formatWitUSLocal((String)"{\"oldMethod\":\"toPersonalInfo\", \"uid\": %d, \"fromType\": %d}", (Object[])new Object[]{uid, fromType});
        this.callAppMethod("base", "openProfile", OLD_METHOD_CONTEXT, paramJson, "");
    }

    @JavascriptInterface
    public void nativeShare(int shareType, String title, String content, String image, String webUrl) {
        String paramJson = StringUtils.formatWitUSLocal((String)"{\"oldMethod\":\"nativeShare\", \"shareType\": %d, \"title\": \"%s\", \"content\": \"%s\", \"image\": \"%s\", \"webUrl\": \"%s\"}", (Object[])new Object[]{shareType, title, content, image, webUrl});
        this.callAppMethod("base", "share", OLD_METHOD_CONTEXT, paramJson, "");
    }

    @JavascriptInterface
    public void nativeShareSingleGame(int shareType, String gameId, int score, int bestScore) {
        String paramJson = StringUtils.formatWitUSLocal((String)"{\"oldMethod\":\"nativeShareSingleGame\", \"shareType\": %d, \"gameId\": \"%s\", \"score\": %d, \"bestScore\": %d}", (Object[])new Object[]{shareType, gameId, score, bestScore});
        this.callAppMethod("base", "share", OLD_METHOD_CONTEXT, paramJson, "");
    }

    @JavascriptInterface
    public void nativeStartGame(final int gameType, final String gameId, final String json) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                final String paramJson = StringUtils.formatWitUSLocal((String)"{\"oldMethod\":\"nativeStartGame\", \"gameType\": %d, \"gameId\": \"%s\", \"json\": %s}", (Object[])new Object[]{gameType, gameId, JsonParser.toJson((Object)json)});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NativeAppJavaScriptInterface.this.callAppMethod("base", "startGame", NativeAppJavaScriptInterface.OLD_METHOD_CONTEXT, paramJson, "");
                    }
                });
            }
        });
    }

    @JavascriptInterface
    public boolean getGameIsInstall(String gameId) {
        if (this.callBack != null) {
            return this.callBack.nativeGetGameIsInstall(gameId);
        }
        return false;
    }

    @JavascriptInterface
    public void invokeClientMethod(String module, String methodName, String paramJson, String callbackName) {
        if (this.callBack != null) {
            this.callBack.callAppMethod(module, methodName, "", paramJson, callbackName);
        }
    }

    @JavascriptInterface
    public String callAppMethod(String module, String methodName, final String context, final String paramJson, String callback) {
        if (this.callBack != null) {
            IJsParam result;
            if ("share".equals(module) && "activityShare".equals(methodName)) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSONObject jo = JsonParser.obtainJSONObject((String)paramJson);
                            jo.put("oldMethod", (Object)"activityShare");
                            final String pj = jo.toString();
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    NativeAppJavaScriptInterface.this.callBack.callAppMethod("base", "share", context, pj, "");
                                }
                            });
                        }
                        catch (JSONException e) {
                            MLog.error((Object)"callAppMethod", (Throwable)e);
                        }
                    }
                });
                return JsReturn.DEFAULT_ERROR_JSON;
            }
            if ("game".equals(module)) {
                module = "base";
                if ("getGameIsInstalled".equals(methodName)) {
                    methodName = "isGameInstalled";
                }
            } else if ("userinfo".equals(module) && "openProfile".equals(methodName)) {
                module = "base";
            }
            if ((result = this.callBack.callAppMethod(module, methodName, context, paramJson, callback)) != null) {
                return result.toJson();
            }
        }
        return JsReturn.DEFAULT_ERROR_JSON;
    }

    @JavascriptInterface
    public String appInfo() {
        String result = JsReturn.DEFAULT_ERROR_JSON;
        if (this.callBack != null) {
            result = this.callBack.appInfo();
        }
        return result;
    }

    @JavascriptInterface
    public String allSupportMethod() {
        String result = JsReturn.DEFAULT_ERROR_JSON;
        if (this.callBack != null) {
            result = this.callBack.allSupportMethod();
        }
        return result;
    }

    @JavascriptInterface
    public String userToken() {
        String result = JsReturn.DEFAULT_ERROR_JSON;
        if (this.callBack != null) {
            result = this.callBack.userToken();
        }
        return result;
    }

    @JavascriptInterface
    public String myselfUserInfo() {
        String result = JsReturn.DEFAULT_ERROR_JSON;
        if (this.callBack != null) {
            result = this.callBack.myselfUserInfo();
        }
        return result;
    }

    @JavascriptInterface
    public String getCurrentWebviewStyle() {
        String result = JsReturn.DEFAULT_ERROR_JSON;
        if (this.callBack != null) {
            result = this.callBack.getCurrentWebviewStyle();
        }
        return result;
    }

    public static interface INativeCallBack
    extends IJsInterfaceCallback {
        public boolean nativeGetGameIsInstall(String var1);

        public String appInfo();

        public String allSupportMethod();

        public String userToken();

        public String myselfUserInfo();

        public String getCurrentWebviewStyle();
    }
}

