/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow.webview.base;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import com.yy.base.logger.MLog;
import com.yy.webservice.webwindow.webview.base.YYWebView;
import java.util.ArrayList;

public class WebViewReuse {
    private static final String TAG = "WebViewReuse";
    private static ArrayList<YYWebView> sRecycledWeb;
    private static IWebViewReuseCallBack sCallBack;

    public static boolean recycle(WebView webView2) {
        MLog.info((Object)TAG, (String)"recycle!", (Object[])new Object[0]);
        if (sCallBack == null || !sCallBack.isSwitchOn() || !sCallBack.canCacheNow()) {
            return false;
        }
        if (!(webView2 instanceof YYWebView)) {
            return false;
        }
        YYWebView yyWebView = (YYWebView)webView2;
        if (yyWebView == null || sRecycledWeb != null && sRecycledWeb.size() >= 1) {
            return false;
        }
        if (sRecycledWeb == null) {
            sRecycledWeb = new ArrayList(2);
        } else {
            for (int i = 0; i < sRecycledWeb.size(); ++i) {
                if (yyWebView != sRecycledWeb.get(i)) continue;
                MLog.info((Object)TAG, (String)"has recycled!", (Object[])new Object[0]);
                return false;
            }
        }
        if (yyWebView != null && yyWebView.getParent() instanceof ViewGroup) {
            ((ViewGroup)yyWebView.getParent()).removeView((View)yyWebView);
        }
        MLog.info((Object)TAG, (String)"recycled web index:%d!", (Object[])new Object[]{yyWebView.getWebViewIndex()});
        yyWebView.setReused();
        sRecycledWeb.add(yyWebView);
        return true;
    }

    public static void destroy(WebView webView2) {
        if (webView2 != null) {
            if (webView2.getParent() instanceof ViewGroup) {
                ((ViewGroup)webView2.getParent()).removeView((View)webView2);
            }
            webView2.destroy();
        }
    }

    public static YYWebView obtainWebView() {
        MLog.info((Object)TAG, (String)"obtainWebView", (Object[])new Object[0]);
        if (sCallBack == null || !sCallBack.isSwitchOn()) {
            return null;
        }
        if (sRecycledWeb == null || sRecycledWeb.size() <= 0) {
            return null;
        }
        YYWebView item = sRecycledWeb.get(0);
        sRecycledWeb.remove(0);
        MLog.info((Object)TAG, (String)"obtainWebView use cache, web index:%d!", (Object[])new Object[]{item.getWebViewIndex()});
        return item;
    }

    public static void releaseCacheByTrimMemory() {
        MLog.info((Object)TAG, (String)"releaseCacheByTrimMemory", (Object[])new Object[0]);
        if (sRecycledWeb == null || sRecycledWeb.size() <= 0) {
            return;
        }
        YYWebView item = sRecycledWeb.get(0);
        sRecycledWeb.remove(0);
        if (item != null) {
            MLog.info((Object)TAG, (String)"releaseCacheByTrimMemory, web index:%d!", (Object[])new Object[]{item.getWebViewIndex()});
            WebViewReuse.destroy(item);
        }
    }

    public static void precreateWebView(Context context) {
        MLog.info((Object)TAG, (String)"precreateWebView!", (Object[])new Object[0]);
        if (sRecycledWeb != null && sRecycledWeb.size() > 0) {
            return;
        }
        if (sCallBack == null || !sCallBack.isSwitchOn() || !sCallBack.canCacheNow()) {
            return;
        }
        YYWebView webViewWindow = new YYWebView(context);
        if (sRecycledWeb == null) {
            sRecycledWeb = new ArrayList(2);
        }
        webViewWindow.loadUrl("about:blank");
        sRecycledWeb.add(webViewWindow);
        webViewWindow.setReused();
        MLog.info((Object)TAG, (String)"precreateWebView, web index:%d!", (Object[])new Object[]{webViewWindow.getWebViewIndex()});
    }

    public static void setCallBack(IWebViewReuseCallBack callBack) {
        sCallBack = callBack;
    }

    public static boolean loadUrlBeforeWindowShownSwitchOn() {
        if (sCallBack != null) {
            return sCallBack.isSwitchOn();
        }
        return false;
    }

    public static interface IWebViewReuseCallBack {
        public boolean isSwitchOn();

        public boolean canCacheNow();
    }
}

