/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow.webview;

import android.os.Build;
import android.webkit.WebView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.webservice.webwindow.webview.base.WebViewReuse;
import java.util.ArrayList;

public class WebViewProtecter {
    private static final String TAG = "Web_WebViewProtecter";
    private static ArrayList<WebView> sCacheWebViews;
    private static ArrayList<WebView> sNeedDestryWebViews;

    public static void onWebInit(WebView webView2) {
        if (webView2 == null) {
            return;
        }
        if (!WebViewProtecter.isSwitchOn()) {
            return;
        }
        if (sCacheWebViews == null) {
            sCacheWebViews = new ArrayList(5);
        }
        if (sNeedDestryWebViews != null) {
            sNeedDestryWebViews.remove(webView2);
        }
        sCacheWebViews.remove(webView2);
        sCacheWebViews.add(webView2);
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)TAG, (String)"webView init:%s", (Object[])new Object[]{webView2.toString()});
        }
    }

    private static void destroyReal(WebView webView2) {
        if (webView2 == null) {
            return;
        }
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)TAG, (String)"webView destroy:%s, url:%s", (Object[])new Object[]{webView2.toString(), webView2.getUrl()});
        }
        WebViewReuse.destroy(webView2);
        if (sNeedDestryWebViews != null) {
            sNeedDestryWebViews.remove(webView2);
        }
        if (sCacheWebViews != null) {
            sCacheWebViews.remove(webView2);
        }
    }

    public static void onWebRecycled(WebView webView2) {
        if (sNeedDestryWebViews != null) {
            sNeedDestryWebViews.remove(webView2);
        }
        if (sCacheWebViews != null) {
            sCacheWebViews.remove(webView2);
        }
    }

    public static void destroy(WebView webView2) {
        if (webView2 == null || !WebViewProtecter.isSwitchOn()) {
            WebViewProtecter.destroyReal(webView2);
            return;
        }
        if (sCacheWebViews != null && sCacheWebViews.size() > 0) {
            if (sCacheWebViews.get(sCacheWebViews.size() - 1) == webView2) {
                if (sNeedDestryWebViews != null && sNeedDestryWebViews.size() > 0) {
                    ArrayList<WebView> items = new ArrayList<WebView>(sNeedDestryWebViews);
                    for (WebView item : items) {
                        WebViewProtecter.destroyReal(item);
                    }
                    sNeedDestryWebViews.clear();
                }
                WebViewProtecter.destroyReal(webView2);
            } else {
                if (sNeedDestryWebViews == null) {
                    sNeedDestryWebViews = new ArrayList(5);
                }
                sNeedDestryWebViews.remove(webView2);
                sNeedDestryWebViews.add(webView2);
            }
        } else {
            WebViewProtecter.destroyReal(webView2);
        }
    }

    private static boolean isSwitchOn() {
        return Build.VERSION.SDK_INT >= 28;
    }
}

