/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow.webview;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import androidx.annotation.RequiresApi;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.webservice.R;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\u000bJ\u0012\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\"\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J6\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0007J0\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001fJ\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/yy/webservice/webwindow/webview/WebViewFileChooser;", "Lcom/yy/framework/core/INotify;", "()V", "fileChooserParams", "Landroid/webkit/WebChromeClient$FileChooserParams;", "filePathCallback", "Landroid/webkit/ValueCallback;", "", "Landroid/net/Uri;", "uploadFile", "clear", "", "call", "", "destroy", "notify", "notification", "Lcom/yy/framework/core/Notification;", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onShowFileChooser", "context", "Landroid/app/Activity;", "webView", "Landroid/webkit/WebView;", "openFileChooser", "acceptType", "", "capture", "showFileChooser", "webservice_release"})
public final class WebViewFileChooser
implements INotify {
    private ValueCallback<Uri[]> filePathCallback;
    private ValueCallback<Uri> uploadFile;
    private WebChromeClient.FileChooserParams fileChooserParams;

    public final void openFileChooser(@NotNull Activity context, @NotNull ValueCallback<Uri> uploadFile, @Nullable String acceptType, @Nullable String capture) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(uploadFile, (String)"uploadFile");
        try {
            this.uploadFile = uploadFile;
            this.showFileChooser(context);
        }
        catch (Exception e) {
            MLog.error((Object)"WebViewFileChooser", (String)"openFileChooser ", (Throwable)e, (Object[])new Object[0]);
            this.clear(true);
        }
    }

    @RequiresApi(value=21)
    public final boolean onShowFileChooser(@NotNull Activity context, @NotNull WebView webView2, @NotNull ValueCallback<Uri[]> filePathCallback, @Nullable WebChromeClient.FileChooserParams fileChooserParams) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)webView2, (String)"webView");
        Intrinsics.checkParameterIsNotNull(filePathCallback, (String)"filePathCallback");
        try {
            block7: {
                WebChromeClient.FileChooserParams fileChooserParams2;
                block6: {
                    this.filePathCallback = filePathCallback;
                    this.fileChooserParams = fileChooserParams;
                    fileChooserParams2 = fileChooserParams;
                    if (fileChooserParams2 == null) break block6;
                    WebChromeClient.FileChooserParams fileChooserParams3 = fileChooserParams2;
                    boolean bl = false;
                    boolean bl2 = false;
                    WebChromeClient.FileChooserParams it = fileChooserParams3;
                    boolean bl3 = false;
                    Intent intent = it.createIntent();
                    context.startActivityForResult(intent, 4001);
                    CharSequence charSequence = it.getTitle();
                    if (charSequence == null) {
                        charSequence = ResourceUtils.getString((int)R.string.title_file_chooser);
                    }
                    Intent intent2 = intent.putExtra("android.intent.extra.TITLE", charSequence);
                    fileChooserParams2 = intent2;
                    if (intent2 != null) break block7;
                }
                this.showFileChooser(context);
                fileChooserParams2 = Unit.INSTANCE;
            }
            return true;
        }
        catch (Exception e) {
            MLog.error((Object)"WebViewFileChooser", (String)"onShowFileChooser ", (Throwable)e, (Object[])new Object[0]);
            this.clear(false);
            return false;
        }
    }

    private final void showFileChooser(Activity context) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType("*/*");
        context.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)ResourceUtils.getString((int)R.string.title_file_chooser)), 4001);
    }

    public final void destroy() {
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_MAIN_ACTIVITY_RESULT, (INotify)this);
        this.clear(true);
    }

    public void notify(@Nullable Notification notification) {
        block7: {
            Notification notification2 = notification;
            if (notification2 == null) break block7;
            if (notification2.id == NotificationDef.N_MAIN_ACTIVITY_RESULT) {
                Object object;
                Object object2 = notification.extObj;
                if (!(object2 instanceof Object[])) {
                    object2 = null;
                }
                if ((object = (Object[])object2) != null) {
                    Object[] objectArray = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object[] it = objectArray;
                    boolean bl3 = false;
                    object = it.length == 3 ? objectArray : null;
                    if (object != null) {
                        objectArray = object;
                        bl = false;
                        bl2 = false;
                        it = objectArray;
                        boolean bl4 = false;
                        Object object3 = it[0];
                        if (object3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                        }
                        int n = (Integer)object3;
                        Object object4 = it[1];
                        if (object4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                        }
                        int n2 = (Integer)object4;
                        Object object5 = it[2];
                        if (!(object5 instanceof Intent)) {
                            object5 = null;
                        }
                        this.onActivityResult(n, n2, (Intent)object5);
                    }
                }
            }
        }
    }

    private final void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != 4001) {
            return;
        }
        if (data == null) {
            this.clear(true);
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Uri[] uris = WebChromeClient.FileChooserParams.parseResult((int)resultCode, (Intent)data);
            if (this.filePathCallback != null) {
                ValueCallback<Uri[]> valueCallback = this.filePathCallback;
                if (valueCallback == null) {
                    Intrinsics.throwNpe();
                }
                valueCallback.onReceiveValue((Object)uris);
            } else if (this.uploadFile != null) {
                ValueCallback<Uri> valueCallback = this.uploadFile;
                if (valueCallback == null) {
                    Intrinsics.throwNpe();
                }
                valueCallback.onReceiveValue(uris != null ? uris[0] : null);
            }
        } else {
            Uri uri = data.getData();
            if (uri == null) {
                this.clear(true);
                return;
            }
            if (this.filePathCallback != null) {
                ValueCallback<Uri[]> valueCallback = this.filePathCallback;
                if (valueCallback == null) {
                    Intrinsics.throwNpe();
                }
                valueCallback.onReceiveValue((Object)new Uri[]{uri});
            } else if (this.uploadFile != null) {
                ValueCallback<Uri> valueCallback = this.uploadFile;
                if (valueCallback == null) {
                    Intrinsics.throwNpe();
                }
                valueCallback.onReceiveValue((Object)uri);
            }
        }
        this.clear(false);
    }

    private final void clear(boolean call) {
        if (call) {
            ValueCallback<Uri[]> valueCallback = this.filePathCallback;
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
        }
        this.filePathCallback = null;
        if (call) {
            ValueCallback<Uri> valueCallback = this.uploadFile;
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
        }
        this.uploadFile = null;
        this.fileChooserParams = null;
    }

    public WebViewFileChooser() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_MAIN_ACTIVITY_RESULT, (INotify)this);
    }
}

