/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow.webview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.animation.Animation;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.DownloadListener;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.MimeTypeMap;
import android.webkit.PermissionRequest;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.webservice.R;
import com.yy.webservice.WebConfigure;
import com.yy.webservice.YYWebViewFeature;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.event.parqam.JsReturn;
import com.yy.webservice.webwindow.webview.ICallBack;
import com.yy.webservice.webwindow.webview.IWebIntentFilter;
import com.yy.webservice.webwindow.webview.IWebViewEventListener;
import com.yy.webservice.webwindow.webview.IWebViewPermissionCallback;
import com.yy.webservice.webwindow.webview.Utils;
import com.yy.webservice.webwindow.webview.WebViewFileChooser;
import com.yy.webservice.webwindow.webview.WebViewProtecter;
import com.yy.webservice.webwindow.webview.base.WebViewReuse;
import com.yy.webservice.webwindow.webview.base.WebViewSettings;
import com.yy.webservice.webwindow.webview.base.YYWebView;
import com.yy.webservice.webwindow.webview.js.IJsInterfaceCallback;
import com.yy.webservice.webwindow.webview.js.NativeAppJavaScriptInterface;
import com.yy.webservice.webwindow.webview.js.YYJsInterface;
import com.yy.webservice.webwindow.webview.webviewclient.CommonWebViewClient;
import com.yy.webservice.webwindow.webview.webviewclient.WebClientFilter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public class WebViewController {
    private static final String TAG = "Web_WebViewController";
    private static boolean ENABLE_DEBUG_LOG = RuntimeContext.sIsDebuggable;
    private final String clientLoadUrl = "objc://clientLoadUrl/";
    private WebView mWebView;
    private WebViewSettings mWebEnvSettings;
    private MyWebChromeClient mWebChromeClient;
    private MyWebViewClient mWebViewClient;
    private WebSettings mWebSettings;
    private WebConfigure mWebConfigure;
    private WebClientFilter mWebClientFilter;
    private ICallBack mCallBack;
    private AbsAppearanceCallback mAppearanceCallback;
    private volatile IWebViewEventListener mWebViewEventListener;
    private NativeAppJavaScriptInterface mNativeAppJavaScriptInterface;
    private YYJsInterface mYYJsInterface;
    private boolean mRecvError = false;
    private String mCurrentWebUrl = null;
    private String mOriginUrl;
    private String mBeReplacedOriginUrl;
    private static volatile IWebInterceptor sWebInterceptor;

    public WebViewController(WebViewSettings webEnvSettings, WebView webView2, WebConfigure webConfigure, ICallBack callBack) {
        this.mCallBack = callBack;
        this.mWebEnvSettings = webEnvSettings;
        this.mWebView = webView2;
        this.mWebConfigure = webConfigure;
        this.initSettings();
        WebViewProtecter.onWebInit(webView2);
    }

    public void loadOriginUrl(String url, boolean showLoading) {
        if (this.mWebView == null) {
            return;
        }
        if (showLoading && this.mCallBack != null) {
            this.mCallBack.showLoading();
        }
        this.mBeReplacedOriginUrl = url;
        this.mOriginUrl = sWebInterceptor != null ? sWebInterceptor.replaceUrl(url) : url;
        if (StringUtils.equal((String)this.mBeReplacedOriginUrl, (String)this.mOriginUrl)) {
            MLog.info((Object)TAG, (String)"replace url:%s, newUrl:%s", (Object[])new Object[]{this.mBeReplacedOriginUrl, this.mOriginUrl});
        }
        this.loadUrl(this.mOriginUrl);
        this.mWebClientFilter = new WebClientFilter(this.mOriginUrl, this.mWebSettings);
    }

    public void refresh() {
        this.loadUrl(this.getWebCurrentUrl());
    }

    private void loadUrl(String url) {
        MLog.info((Object)TAG, (String)"loadUrl, url = %s", (Object[])new Object[]{url});
        if (this.mWebView == null || url == null) {
            return;
        }
        if (sWebInterceptor != null) {
            url = sWebInterceptor.replaceUrl(url);
        }
        if (SystemUtils.isShowEnvSetting() && sWebInterceptor != null) {
            int type = SettingFlags.getIntValue((String)"ENV_WEB_URL_REPLACE", (int)0);
            url = sWebInterceptor.replaceTestUrl(url, type);
            MLog.info((Object)TAG, (String)"replace loadUrl, url = %s", (Object[])new Object[]{url});
        }
        if (url.startsWith("http")) {
            this.mCurrentWebUrl = url;
            if (this.mWebEnvSettings.renderMode == 1) {
                if (this.mWebView.getSettings().getBlockNetworkImage()) {
                    this.mWebView.getSettings().setBlockNetworkImage(false);
                    MLog.info((Object)TAG, (String)"setBlockNetworkImage:false!", (Object[])new Object[0]);
                }
            } else if (!this.mWebView.getSettings().getBlockNetworkImage()) {
                this.mWebView.getSettings().setBlockNetworkImage(true);
                MLog.info((Object)TAG, (String)"setBlockNetworkImage:true!", (Object[])new Object[0]);
            }
        }
        this.mWebView.loadUrl(url);
        this.mRecvError = false;
    }

    public boolean getRecvError() {
        return this.mRecvError;
    }

    public void loadUrl(String url, boolean force) {
        if (this.mWebView == null) {
            return;
        }
        if (StringUtils.isEmpty((String)url)) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)TAG, (String)"loadUrl, url is nulll", (Object[])new Object[0]);
            }
            return;
        }
        if (force) {
            this.loadUrl(url);
        } else {
            if (url.equals(this.getWebCurrentUrl())) {
                return;
            }
            this.loadUrl(url);
        }
    }

    public void updateRenderMode(int mode) {
        if (this.mWebEnvSettings.renderMode != mode) {
            this.mWebEnvSettings.renderMode = mode;
            MLog.info((Object)TAG, (String)"updateRenderMode:%d", (Object[])new Object[]{mode});
            if (this.mWebEnvSettings.renderMode == 1 && this.mWebView.getSettings().getBlockNetworkImage()) {
                this.mWebView.getSettings().setBlockNetworkImage(false);
            }
        }
    }

    public boolean canGoBack() {
        return WebViewController.canGoBack(this.mWebView);
    }

    public static boolean canGoBack(WebView webView2) {
        if (webView2 != null) {
            WebHistoryItem itemFirst;
            boolean canGoBack = webView2.canGoBack();
            if (!canGoBack) {
                return false;
            }
            WebBackForwardList backList = webView2.copyBackForwardList();
            return backList == null || backList.getSize() <= 0 || backList.getCurrentIndex() != 1 || (itemFirst = backList.getItemAtIndex(0)) == null || !StringUtils.equal((String)itemFirst.getUrl(), (String)"about:blank");
        }
        return false;
    }

    public void goBack() {
        if (this.mWebView != null) {
            this.mWebView.goBack();
        }
    }

    public String getWebCurrentTitle() {
        if (this.mWebView != null) {
            return this.mWebView.getTitle();
        }
        return "";
    }

    public String getWebCurrentUrl() {
        return this.mCurrentWebUrl;
    }

    public void setDownloadListenerToNull() {
        if (this.mWebView != null) {
            this.mWebView.setDownloadListener(null);
        }
    }

    @Nullable
    public Context getContext() {
        if (this.mWebView != null) {
            Context context = this.mWebView.getContext();
            if (context instanceof Activity) {
                return context;
            }
            if (context instanceof ContextThemeWrapper) {
                Context baseContext = ((ContextThemeWrapper)context).getBaseContext();
                if (baseContext instanceof Activity) {
                    return baseContext;
                }
            } else {
                return context;
            }
        }
        return null;
    }

    private void initSettings() {
        String curUa;
        if (this.mWebView == null) {
            return;
        }
        this.mWebChromeClient = new MyWebChromeClient(this.mCallBack);
        this.mWebView.setWebChromeClient((WebChromeClient)this.mWebChromeClient);
        this.mWebViewClient = new MyWebViewClient(this.mWebView, this.mWebConfigure);
        this.mWebView.setWebViewClient((WebViewClient)this.mWebViewClient);
        if (this.mCallBack != null) {
            WebViewController.setWebContentsDebuggingEnabled(this.mCallBack.enabledWebContentsDebugging());
            this.mWebViewClient.setJsCallBack(this.mCallBack);
        }
        this.applyWebViewFeature();
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        this.mWebSettings = webSettings;
        final IJsInterfaceCallback jsInterfaceCallback = new IJsInterfaceCallback(){

            @Override
            public IJsParam callAppMethod(String module, String methodName, String context, String paramJson, String callback) {
                IJsParam result;
                if (WebViewController.this.mCallBack != null && (result = WebViewController.this.mCallBack.callAppMethod(module, methodName, context, paramJson, callback)) != null) {
                    return result;
                }
                return JsReturn.DEFAULT_ERROR;
            }
        };
        this.mNativeAppJavaScriptInterface = new NativeAppJavaScriptInterface(new NativeAppJavaScriptInterface.INativeCallBack(){

            @Override
            public boolean nativeGetGameIsInstall(String gameId) {
                if (WebViewController.this.mCallBack != null) {
                    return WebViewController.this.mCallBack.nativeGetGameIsInstall(gameId);
                }
                return false;
            }

            @Override
            public String appInfo() {
                if (WebViewController.this.mCallBack != null) {
                    return WebViewController.this.mCallBack.appInfo();
                }
                return JsReturn.DEFAULT_ERROR_JSON;
            }

            @Override
            public String allSupportMethod() {
                if (WebViewController.this.mCallBack != null) {
                    return WebViewController.this.mCallBack.allSupportMethod();
                }
                return JsReturn.DEFAULT_ERROR_JSON;
            }

            @Override
            public String userToken() {
                if (WebViewController.this.mCallBack != null && WebViewController.this.checkUrlForToken()) {
                    return WebViewController.this.mCallBack.userToken();
                }
                return JsReturn.DEFAULT_ERROR_JSON;
            }

            @Override
            public String myselfUserInfo() {
                if (WebViewController.this.mCallBack != null && WebViewController.this.checkUrlForToken()) {
                    return WebViewController.this.mCallBack.myselfUserInfo();
                }
                return JsReturn.DEFAULT_ERROR_JSON;
            }

            @Override
            public String getCurrentWebviewStyle() {
                if (WebViewController.this.mCallBack != null) {
                    return WebViewController.this.mCallBack.getCurrentWebviewStyle();
                }
                return JsReturn.DEFAULT_ERROR_JSON;
            }

            @Override
            public IJsParam callAppMethod(String module, String methodName, String context, String paramJson, String callback) {
                return jsInterfaceCallback.callAppMethod(module, methodName, context, paramJson, callback);
            }
        });
        this.mWebView.addJavascriptInterface((Object)this.mNativeAppJavaScriptInterface, "nativeApp");
        if (this.mWebEnvSettings.useYYJsInterface) {
            if (this.mYYJsInterface == null) {
                this.mYYJsInterface = new YYJsInterface(jsInterfaceCallback);
            }
            this.mWebView.addJavascriptInterface((Object)this.mYYJsInterface, "AndroidJSInterfaceV2");
        }
        this.mWebSettings.setBuiltInZoomControls(false);
        this.mWebSettings.setUseWideViewPort(true);
        String lastUa = this.mWebSettings.getUserAgentString();
        String string2 = curUa = this.mCallBack != null ? this.mCallBack.getDefaultUA() : "";
        if (lastUa != null && lastUa.contains(curUa)) {
            curUa = "";
        }
        this.mWebSettings.setUserAgentString(lastUa + curUa);
        this.mWebSettings.setDomStorageEnabled(true);
        if (this.mWebSettings.getBlockNetworkImage()) {
            MLog.info((Object)TAG, (String)"setBlockNetworkImage:false!", (Object[])new Object[0]);
            this.mWebSettings.setBlockNetworkImage(false);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWebView.getSettings().setMixedContentMode(0);
        }
        if (this.mWebEnvSettings.forceEnableSwLayer) {
            HardwareUtils.setLayerType((View)this.mWebView, (int)1);
            MLog.debug((Object)TAG, (String)"webview enable software layer", (Object[])new Object[0]);
        } else if (SettingFlags.getBoolean((String)"webviewhardware", (boolean)true)) {
            HardwareUtils.setLayerType((View)this.mWebView, (int)2);
        }
    }

    private boolean checkUrlForToken() {
        boolean result;
        boolean bl = result = this.mOriginUrl != null && this.mOriginUrl.contains("iyoco.net");
        if (!result && sWebInterceptor != null) {
            result = sWebInterceptor.isOurUrl(this.mOriginUrl);
        }
        return result;
    }

    public void setAppearanceCallback(AbsAppearanceCallback appearanceCallback) {
        this.mAppearanceCallback = appearanceCallback;
        if (this.mWebChromeClient == null) {
            return;
        }
        this.mWebChromeClient.setAppearanceCallack(this.mAppearanceCallback);
    }

    public void setWebViewEventListener(IWebViewEventListener eventListener) {
        this.mWebViewEventListener = eventListener;
        this.mWebChromeClient.setWebEventListener(eventListener);
    }

    public void setUserAgentString(String ua) {
        if (this.mWebView == null) {
            return;
        }
        WebSettings webSettings = this.mWebView.getSettings();
        if (webSettings != null) {
            webSettings.setUserAgentString(ua);
        }
    }

    public void appendUserAgentString(String ua) {
        String oldUa = this.getUserAgentString();
        if (oldUa != null && oldUa.contains(ua)) {
            return;
        }
        this.setUserAgentString(oldUa + ua);
    }

    public String getUserAgentString() {
        if (this.mWebView == null) {
            return "";
        }
        WebSettings webSettings = this.mWebView.getSettings();
        if (webSettings != null) {
            return webSettings.getUserAgentString();
        }
        return "";
    }

    public String getAppIdFromUrl() {
        if (this.mWebClientFilter != null) {
            return this.mWebClientFilter.getAppIDFromUrl();
        }
        return "";
    }

    public WebBackForwardList copyBackForwardList() {
        if (this.mWebView == null) {
            return null;
        }
        return this.mWebView.copyBackForwardList();
    }

    public boolean addWebViweClientFilterList(String jsonData) {
        if (this.mWebClientFilter != null) {
            return this.mWebClientFilter.addWebViweClientFilterList(jsonData);
        }
        return false;
    }

    public void onResume() {
        if (this.mWebView != null && Build.VERSION.SDK_INT >= 11) {
            this.mWebView.onResume();
        }
        this.loadUrl(this.getWebCurrentUrl(), false);
    }

    @TargetApi(value=11)
    public void onPause() {
        if (this.mWebView == null) {
            return;
        }
        if (this.mWebView != null && Build.VERSION.SDK_INT >= 11) {
            this.mWebView.onPause();
        }
    }

    public void destroy() {
        if (this.mWebView != null) {
            this.mWebView.setDownloadListener(null);
            this.mWebView.setWebChromeClient(null);
            if (this.mWebViewClient != null) {
                this.mWebViewClient.setJsCallBack(null);
                this.mWebViewClient.removeJavascriptInterface(this.mWebView);
            }
            if (this.mWebChromeClient != null) {
                this.mWebChromeClient.onDestroy();
            }
            this.setUserAgentString(null);
            this.mWebView.loadUrl("about:blank");
            this.mWebView.clearView();
            this.mWebView.clearCache(false);
            boolean recyled = WebViewReuse.recycle(this.mWebView);
            if (!recyled) {
                this.mWebView.setWebViewClient(null);
                this.mWebView.clearHistory();
                WebViewProtecter.destroy(this.mWebView);
            } else {
                WebViewProtecter.onWebRecycled(this.mWebView);
            }
            this.mWebView = null;
            this.mCallBack = null;
            this.mWebViewEventListener = null;
        }
    }

    @Nullable
    private IWebIntentFilter getIntentFilter() {
        if (this.mCallBack != null) {
            return this.mCallBack.getIntentFilter(this.mOriginUrl);
        }
        return null;
    }

    private static void setWebContentsDebuggingEnabled(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)enabled);
        }
    }

    public void safetyLoadJs(String js) {
        JSWebViewClient.safetyLoadJs(this.mWebView, js);
    }

    public void setWebViewDownLoadListener() {
        if (this.mWebView != null) {
            this.mWebView.setDownloadListener((DownloadListener)new WebViewDownLoadListener());
        }
    }

    private void applyWebViewFeature() {
        if (null == this.mWebView) {
            MLog.warn((Object)TAG, (String)"warnning: fail apply webview feature, target webview is null.", (Object[])new Object[0]);
            return;
        }
        try {
            if (YYWebViewFeature.isSupportFeature(this.mWebEnvSettings.webviewFeature, 1)) {
                MLog.info((Object)TAG, (String)"applyWebViewFeature: support js true", (Object[])new Object[0]);
                this.mWebView.getSettings().setJavaScriptEnabled(true);
            } else {
                MLog.info((Object)TAG, (String)"applyWebViewFeature: support false", (Object[])new Object[0]);
                this.mWebView.getSettings().setJavaScriptEnabled(false);
            }
        }
        catch (Throwable t) {
            MLog.info((Object)TAG, (String)("t=" + t), (Object[])new Object[0]);
        }
        if (YYWebViewFeature.isSupportFeature(this.mWebEnvSettings.webviewFeature, 8)) {
            MLog.info((Object)TAG, (String)"applyWebViewFeature: clear cache", (Object[])new Object[0]);
        }
        this.setCacheMode();
        if (YYWebViewFeature.isSupportFeature(this.mWebEnvSettings.webviewFeature, 32)) {
            MLog.info((Object)TAG, (String)"applyWebViewFeature: clear from data", (Object[])new Object[0]);
            this.mWebView.clearFormData();
        }
        if (YYWebViewFeature.isSupportFeature(this.mWebEnvSettings.webviewFeature, 64)) {
            MLog.info((Object)TAG, (String)"applyWebViewFeature: clear history", (Object[])new Object[0]);
            this.mWebView.clearHistory();
        }
        this.mWebView.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
    }

    private void setCacheMode() {
        if (YYWebViewFeature.isSupportFeature(this.mWebEnvSettings.webviewFeature, 16)) {
            MLog.info((Object)TAG, (String)"applyWebViewFeature: enable cache", (Object[])new Object[0]);
            if (Build.VERSION.SDK_INT >= 11) {
                this.mWebView.getSettings().setCacheMode(-1);
            } else {
                this.mWebView.getSettings().setCacheMode(0);
            }
        } else {
            MLog.verbose((Object)this, (String)"applyWebViewFeature: disable cache", (Object[])new Object[0]);
            this.mWebView.getSettings().setCacheMode(2);
        }
    }

    public static void setInterceptor(IWebInterceptor webInterceptor) {
        sWebInterceptor = webInterceptor;
    }

    public static interface IWebInterceptor {
        public String replaceUrl(String var1);

        public boolean isOurUrl(String var1);

        public boolean isOurHost(String var1);

        public String replaceTestUrl(String var1, int var2);
    }

    protected static class MyWebChromeClient
    extends WebChromeClient {
        private AppearanceCallback mAppearanceCallack;
        private IWebViewEventListener mEventListener;
        private ICallBack mCallBack;
        private WebViewFileChooser mWebViewFileChooser;

        MyWebChromeClient(ICallBack callBack) {
            this.mCallBack = callBack;
        }

        public void setCallBack(ICallBack callBack) {
            this.mCallBack = callBack;
        }

        public void onDestroy() {
            if (this.mWebViewFileChooser != null) {
                this.mWebViewFileChooser.destroy();
                this.mWebViewFileChooser = null;
            }
            this.mCallBack = null;
            this.mEventListener = null;
            this.mAppearanceCallack = null;
        }

        public boolean onJsAlert(WebView view, String url, String message, final JsResult result) {
            Activity context;
            if (this.mCallBack == null) {
                return super.onJsAlert(view, url, message, result);
            }
            if (ENABLE_DEBUG_LOG) {
                MLog.verbose((Object)WebViewController.TAG, (String)"onJsAlert, url:%s, message: %s!", (Object[])new Object[]{url, message});
            }
            if (null == (context = this.mCallBack.getActivity())) {
                MLog.error((Object)WebViewController.TAG, (String)"onJsAlert context null", (Object[])new Object[0]);
                return false;
            }
            AlertDialog.Builder b = new AlertDialog.Builder((Context)context);
            b.setMessage((CharSequence)message);
            b.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    result.confirm();
                }
            });
            b.setCancelable(false);
            b.create().show();
            return true;
        }

        public boolean onJsConfirm(WebView view, String url, String message, final JsResult result) {
            if (this.mCallBack == null) {
                return super.onJsConfirm(view, url, message, result);
            }
            if (ENABLE_DEBUG_LOG) {
                MLog.verbose((Object)WebViewController.TAG, (String)"onJsConfirm, url:%s, message: %s!", (Object[])new Object[]{url, message});
            }
            Activity context = this.mCallBack.getActivity();
            AlertDialog.Builder b = new AlertDialog.Builder((Context)context);
            b.setMessage((CharSequence)message);
            b.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    result.confirm();
                }
            });
            b.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    result.cancel();
                }
            });
            b.create().show();
            return true;
        }

        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            if (ENABLE_DEBUG_LOG) {
                MLog.verbose((Object)WebViewController.TAG, (String)"onJsPrompt, url:%s, message: %s!", (Object[])new Object[]{url, message});
            }
            return super.onJsPrompt(view, url, message, defaultValue, result);
        }

        public void onConsoleMessage(String message, int lineNumber, String sourceID) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)WebViewController.TAG, (String)"javascript console-> lineNumber: %d, message: %s, sourceID: %s", (Object[])new Object[]{lineNumber, message, sourceID});
            }
            if (ENABLE_DEBUG_LOG) {
                MLog.verbose((Object)WebViewController.TAG, (String)"onConsoleMessage, message: %s!", (Object[])new Object[]{message});
            }
            super.onConsoleMessage(message, lineNumber, sourceID);
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            if (ENABLE_DEBUG_LOG) {
                MLog.verbose((Object)WebViewController.TAG, (String)"onConsoleMessage, message: %s!", (Object[])new Object[]{consoleMessage});
            }
            return super.onConsoleMessage(consoleMessage);
        }

        public void onReceivedTitle(WebView view, String title) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)((Object)this), (String)("xuwakao, title = " + title + ", mAppearanceCallack = " + this.mAppearanceCallack), (Object[])new Object[0]);
            }
            if (ENABLE_DEBUG_LOG) {
                MLog.verbose((Object)WebViewController.TAG, (String)"onReceivedTitl message: %s!", (Object[])new Object[]{title});
            }
            super.onReceivedTitle(view, title);
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.onReceivedTitle(view, title);
            }
            if (this.mEventListener != null) {
                this.mEventListener.onReceivedTitle(view, title);
            }
        }

        @RequiresApi(api=21)
        public void onPermissionRequest(final PermissionRequest request) {
            if (request.getResources().length > 0) {
                String[] resources;
                for (final String resource : resources = request.getResources()) {
                    if (!resource.equals("android.webkit.resource.VIDEO_CAPTURE") || this.mAppearanceCallack == null) continue;
                    this.mAppearanceCallack.onPermissionRequested(resource, new IWebViewPermissionCallback(){

                        @Override
                        public void onGrant(String permission) {
                            if (permission.equals(resource)) {
                                request.grant(request.getResources());
                            }
                        }

                        @Override
                        public void onDeny(String permission) {
                            request.deny();
                        }
                    });
                }
            }
        }

        public void onProgressChanged(WebView view, int newProgress) {
            if (ENABLE_DEBUG_LOG) {
                MLog.verbose((Object)WebViewController.TAG, (String)"onProgressChanged: %d!", (Object[])new Object[]{newProgress});
            }
            if (this.mEventListener != null) {
                this.mEventListener.onProgressChanged(view, newProgress);
            }
        }

        public Bitmap getDefaultVideoPoster() {
            return super.getDefaultVideoPoster();
        }

        public View getVideoLoadingProgressView() {
            return super.getVideoLoadingProgressView();
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            if (ENABLE_DEBUG_LOG) {
                MLog.verbose((Object)WebViewController.TAG, (String)"onShowCustomVie!", (Object[])new Object[0]);
            }
            super.onShowCustomView(view, callback);
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)((Object)this), (String)("xuwakao, onShowCustomView1 view = " + view), (Object[])new Object[0]);
            }
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.onShowCustomView(view, callback);
            }
        }

        @TargetApi(value=14)
        public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
            if (ENABLE_DEBUG_LOG) {
                MLog.verbose((Object)WebViewController.TAG, (String)"onShowCustomView!", (Object[])new Object[0]);
            }
            if (Build.VERSION.SDK_INT >= 14) {
                super.onShowCustomView(view, requestedOrientation, callback);
                if (this.mAppearanceCallack != null) {
                    this.mAppearanceCallack.onShowCustomView(view, callback);
                }
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((Object)((Object)this), (String)("xuwakao, onShowCustomView2 view = " + view), (Object[])new Object[0]);
                }
            }
        }

        public void onHideCustomView() {
            if (ENABLE_DEBUG_LOG) {
                MLog.verbose((Object)WebViewController.TAG, (String)"onHideCustomView!", (Object[])new Object[0]);
            }
            super.onHideCustomView();
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)((Object)this), (String)"xuwakao, onHideCustomView", (Object[])new Object[0]);
            }
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.onHideCustomView();
            }
        }

        public void openFileChooser(ValueCallback<Uri> uploadFile, String acceptType, String capture) {
            if (this.mWebViewFileChooser == null) {
                this.mWebViewFileChooser = new WebViewFileChooser();
            }
            this.mWebViewFileChooser.openFileChooser(this.mCallBack.getActivity(), uploadFile, acceptType, capture);
        }

        @RequiresApi(api=21)
        public boolean onShowFileChooser(WebView webView2, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            if (ENABLE_DEBUG_LOG) {
                MLog.verbose((Object)WebViewController.TAG, (String)"onShowFileChooser!", (Object[])new Object[0]);
            }
            if (this.mWebViewFileChooser == null) {
                this.mWebViewFileChooser = new WebViewFileChooser();
            }
            return this.mWebViewFileChooser.onShowFileChooser(this.mCallBack.getActivity(), webView2, filePathCallback, fileChooserParams);
        }

        public void setAppearanceCallack(AppearanceCallback appearanceCallack) {
            this.mAppearanceCallack = appearanceCallack;
        }

        public void setWebEventListener(IWebViewEventListener listener) {
            this.mEventListener = listener;
        }

        public static interface AppearanceCallback {
            public void onReceivedTitle(WebView var1, String var2);

            public void onHideCustomView();

            public void onShowCustomView(View var1, WebChromeClient.CustomViewCallback var2);

            public void onPermissionRequested(String var1, IWebViewPermissionCallback var2);
        }
    }

    public static abstract class AbsAppearanceCallback
    implements MyWebChromeClient.AppearanceCallback {
        protected abstract void handleBackAction(Object var1);

        public abstract void changeHeight(int var1);

        public Animation createAnim(int transit, boolean enter, int nextAnim) {
            return null;
        }

        protected void onJsHandlerNotFound(String handlerName) {
        }

        public void shouldOverrideUrlLoading(WebView view, String url) {
        }

        public void onPageFinished(WebView view, String url) {
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        }

        public void onPageStarted(WebView view, String url, Bitmap favIcon) {
        }

        @Override
        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        }

        public void onViewCreated(View view) {
        }

        @Override
        public void onHideCustomView() {
        }
    }

    @DontProguardClass
    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected static class JSWebViewClient
    extends WebViewClient {
        public static final String kCustomProtocolScheme = "wvjbscheme";
        public static final String kQueueHasMessage = "__WVJB_QUEUE_MESSAGE__";
        private boolean ignoreSslError = false;
        private WebConfigure mWebConfigure;
        private ICallBack mJsCallBack;

        public JSWebViewClient(WebView webView2, WebConfigure webConfigure) {
            this.mWebConfigure = webConfigure;
        }

        public void removeJavascriptInterface(WebView webView2) {
        }

        public void setJsCallBack(ICallBack jsCallBack) {
            this.mJsCallBack = jsCallBack;
        }

        public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
            MLog.info((Object)"MyWebViewClient", (String)"onReceivedSslError", (Object[])new Object[0]);
            if (this.ignoreSslError) {
                handler.proceed();
                return;
            }
            if (error != null && error.getUrl() != null) {
                String url = error.getUrl();
                try {
                    URL uri = new URL(url);
                    String host = uri.getHost();
                    MLog.info((Object)WebViewController.TAG, (String)"onReceivedSslError:%s", (Object[])new Object[]{host});
                    if (host.endsWith(".hiido.com") || host.endsWith("yystatic.com") || host.endsWith("hm.baidu.com")) {
                        handler.proceed();
                        return;
                    }
                    if (sWebInterceptor != null && sWebInterceptor.isOurHost(host)) {
                        handler.proceed();
                        return;
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            Activity activity = null;
            if (view != null && view.getContext() instanceof Activity) {
                activity = (Activity)view.getContext();
            } else if (this.mJsCallBack != null) {
                activity = this.mJsCallBack.getActivity();
            }
            if (activity != null) {
                Utils.IAlertDialogCallBack callBack = new Utils.IAlertDialogCallBack(){

                    @Override
                    public void onPositiveButtonClicked() {
                        MLog.info((Object)"MyWebViewClient", (String)"onReceivedSslError onOk", (Object[])new Object[0]);
                        JSWebViewClient.this.ignoreSslError = true;
                        handler.proceed();
                    }

                    @Override
                    public void onNeutralButtonClicked() {
                        JSWebViewClient.this.ignoreSslError = false;
                        MLog.info((Object)"MyWebViewClient", (String)"onReceivedSslError onCancel", (Object[])new Object[0]);
                        handler.cancel();
                    }

                    @Override
                    public void onNegativeButtonClicked() {
                        JSWebViewClient.this.ignoreSslError = false;
                        MLog.info((Object)"MyWebViewClient", (String)"onReceivedSslError onCancel", (Object[])new Object[0]);
                        handler.cancel();
                    }

                    @Override
                    public void onCancled() {
                        JSWebViewClient.this.ignoreSslError = false;
                        MLog.info((Object)"MyWebViewClient", (String)"onReceivedSslError onCancel", (Object[])new Object[0]);
                        handler.cancel();
                    }
                };
                Utils.showAlertDialog(activity, activity.getString(R.string.current_web_page_error), activity.getString(R.string.web_page_error_detail), activity.getString(R.string.dialog_btn_yes), activity.getString(R.string.dialog_btn_no), callBack);
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            boolean overrideLoadingReturnSwitch;
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)((Object)this), (String)("kuiannan load web url = " + url), (Object[])new Object[0]);
            }
            if (url.startsWith("jsbridge")) {
                return true;
            }
            if (url.startsWith("intent://platformapi/startapp?")) {
                try {
                    Intent intent = null;
                    try {
                        intent = Intent.parseUri((String)url, (int)1);
                        intent.addCategory("android.intent.category.BROWSABLE");
                        intent.setComponent(null);
                        if (Build.VERSION.SDK_INT >= 15) {
                            intent.setSelector(null);
                        }
                    }
                    catch (URISyntaxException e) {
                        MLog.error((Object)WebViewController.TAG, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                    view.getContext().startActivity(intent);
                }
                catch (Exception e) {
                    MLog.error((Object)WebViewController.TAG, (String)e.getMessage(), (Object[])new Object[0]);
                }
                return true;
            }
            MimeTypeMap.getSingleton();
            String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
            boolean bl = overrideLoadingReturnSwitch = this.mWebConfigure != null && this.mWebConfigure.getOverrideLoadingReturnSwitch();
            if ("mp4".equalsIgnoreCase(extension)) {
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((Object)((Object)this), (String)("mp4 url " + url), (Object[])new Object[0]);
                }
                if (view != null && view.getContext() instanceof Activity) {
                    this.playWebViewVideo((Activity)view.getContext(), url);
                } else if (this.mJsCallBack != null) {
                    this.playWebViewVideo(this.mJsCallBack.getActivity(), url);
                }
            } else {
                Uri uri = Uri.parse((String)url);
                if (uri.getScheme().equalsIgnoreCase(kCustomProtocolScheme)) {
                    if (uri.getHost().equalsIgnoreCase(kQueueHasMessage)) {
                        this.startFlushMessageQueue(view);
                    }
                } else if (!overrideLoadingReturnSwitch) {
                    JSWebViewClient.safetyLoadUrl(view, url);
                }
            }
            return !overrideLoadingReturnSwitch;
        }

        public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)"WebView", (String)"onReceivedHttpError %s ", (Object[])new Object[]{view != null ? view.getOriginalUrl() : ""});
            }
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)WebViewController.TAG, (String)"onPageFinished startCapture!", (Object[])new Object[0]);
            }
        }

        public void onLoadResource(WebView view, String url) {
            super.onLoadResource(view, url);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            MLog.error((Object)WebViewController.TAG, (String)("onReceivedError errorCode:" + errorCode + ",description:" + description + ",failingUrl:" + failingUrl), (Object[])new Object[0]);
            view.clearView();
            JSWebViewClient.safetyLoadUrl(view, "file:///android_asset/load_page_fail.html");
        }

        private static void safetyLoadUrl(final WebView view, final String url) {
            if (view != null && url != null) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            view.loadUrl(url);
                        }
                        catch (Exception e) {
                            MLog.error((Object)WebViewController.TAG, (Throwable)e);
                        }
                    }
                }, (long)0L);
            }
        }

        private void startFlushMessageQueue(WebView webView2) {
            JSWebViewClient.safetyLoadJs(webView2, "javascript:WebViewJavascriptBridge._fetchQueue();");
        }

        private static void safetyLoadJs(final WebView view, final String js) {
            if (Build.VERSION.SDK_INT <= 18) {
                JSWebViewClient.safetyLoadUrl(view, js);
                return;
            }
            if (view != null && !StringUtils.isEmpty((String)js)) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    @TargetApi(value=19)
                    public void run() {
                        try {
                            if (Build.VERSION.SDK_INT > 18) {
                                try {
                                    view.evaluateJavascript(js, null);
                                }
                                catch (Exception e) {
                                    MLog.error((Object)WebViewController.TAG, (Throwable)e);
                                    MLog.info((Object)WebViewController.TAG, (String)"switch to call loadUrl", (Object[])new Object[0]);
                                    view.loadUrl(js);
                                }
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)WebViewController.TAG, (Throwable)e);
                        }
                    }
                }, (long)0L);
            }
        }

        @TargetApi(value=11)
        public static void removeJavascriptInterface(WebView view, String objName) {
            if (Build.VERSION.SDK_INT >= 11) {
                view.removeJavascriptInterface(objName);
            }
        }

        private void playWebViewVideo(Activity act, String url) {
        }
    }

    protected class MyWebViewClient
    extends JSWebViewClient {
        private boolean mStartDownloadRes;
        private WebView theWebView;

        public MyWebViewClient(WebView webView2, WebConfigure webConfigure) {
            super(webView2, webConfigure);
            this.mStartDownloadRes = false;
            this.theWebView = webView2;
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            IWebIntentFilter filter;
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)WebViewController.TAG, (String)("WebViewClient shouldOverrideUrlLoading webView =" + view + ",---url = " + url), (Object[])new Object[0]);
            }
            if ((filter = WebViewController.this.getIntentFilter()) != null) {
                IWebIntentFilter.Result result = filter.shouldOverrideUrlLoading(view, url);
                if (result == IWebIntentFilter.Result.TRUE) {
                    return true;
                }
                if (result == IWebIntentFilter.Result.FALSE) {
                    return false;
                }
            }
            if (url.startsWith("objc://clientLoadUrl/")) {
                url = url.substring("objc://clientLoadUrl/".length());
            }
            if (!StringUtils.isEmpty((String)url) && url.startsWith("http")) {
                WebViewController.this.mCurrentWebUrl = url;
            }
            if (WebViewController.this.mAppearanceCallback != null) {
                WebViewController.this.mAppearanceCallback.shouldOverrideUrlLoading(view, url);
            }
            if (WebViewController.this.mWebViewEventListener != null) {
                WebViewController.this.mWebViewEventListener.shouldOverrideUrlLoading(view, url);
            }
            if (WebViewController.this.mWebClientFilter != null) {
                CommonWebViewClient.LoadValue val = WebViewController.this.mWebClientFilter.shouldOverrideUrlLoading(view, url);
                if (CommonWebViewClient.LoadValue.TRUE.equals((Object)val)) {
                    return true;
                }
                if (CommonWebViewClient.LoadValue.FALSE.equals((Object)val)) {
                    return false;
                }
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        @Override
        public void onLoadResource(WebView view, String url) {
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)WebViewController.TAG, (String)("xuwakao, WebViewClient onLoadResource url = " + url), (Object[])new Object[0]);
            }
            super.onLoadResource(view, url);
            this.mStartDownloadRes = true;
            if (WebViewController.this.mWebViewEventListener != null) {
                WebViewController.this.mWebViewEventListener.onLoadResource(view, url);
            }
        }

        @Override
        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            MLog.info((Object)WebViewController.TAG, (String)("xuwakao, WebViewClient onReceivedError failingUrl = " + failingUrl + " errorCode = " + errorCode + " description = " + description), (Object[])new Object[0]);
            WebViewController.this.mRecvError = true;
            if (WebViewController.this.mCallBack != null) {
                WebViewController.this.mCallBack.showNetError(WebViewController.this.mOriginUrl, errorCode, description, failingUrl);
            }
            if (WebViewController.this.mAppearanceCallback != null) {
                WebViewController.this.mAppearanceCallback.onReceivedError(view, errorCode, description, failingUrl);
            }
            if (WebViewController.this.mWebViewEventListener != null) {
                WebViewController.this.mWebViewEventListener.onReceivedError(view, errorCode, description, failingUrl);
            }
        }

        @Override
        public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)WebViewController.TAG, (String)"onReceivedHttpError:%s", (Object[])new Object[]{request});
            }
            if (WebViewController.this.mWebViewEventListener != null) {
                WebViewController.this.mWebViewEventListener.onReceivedHttpError(view, request, errorResponse);
            }
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favIcon) {
            MLog.info((Object)WebViewController.TAG, (String)("xuwakao, WebViewClient onPageStarted url = " + url + ",----WebView=" + view), (Object[])new Object[0]);
            super.onPageStarted(view, url, favIcon);
            if (url != null && url.startsWith("http")) {
                WebViewController.this.mCurrentWebUrl = url;
            }
            if (WebViewController.this.mAppearanceCallback != null) {
                WebViewController.this.mAppearanceCallback.onPageStarted(view, url, favIcon);
            }
            if (WebViewController.this.mWebViewEventListener != null) {
                WebViewController.this.mWebViewEventListener.onPageStarted(view, url, favIcon);
            }
            if (StringUtils.equal((String)url, (String)"about:blank") && this.theWebView instanceof YYWebView && ((YYWebView)this.theWebView).isReused()) {
                this.theWebView.clearHistory();
                this.theWebView.clearCache(false);
                MLog.info((Object)WebViewController.TAG, (String)("onPageFinish clearHistory = " + url), (Object[])new Object[0]);
            }
        }

        @Override
        @TargetApi(value=14)
        public void onPageFinished(WebView view, String url) {
            MLog.info((Object)WebViewController.TAG, (String)("xuwakao, WebViewClient onPageFinished url = " + url), (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)url) && url.startsWith("http")) {
                WebViewController.this.mCurrentWebUrl = url;
            }
            if (view.getSettings().getBlockNetworkImage()) {
                view.getSettings().setBlockNetworkImage(false);
                MLog.info((Object)WebViewController.TAG, (String)"setBlockNetworkImage:false!", (Object[])new Object[0]);
            }
            if (WebViewController.this.mWebClientFilter != null && WebViewController.this.mWebClientFilter.canDownload()) {
                WebViewController.this.setWebViewDownLoadListener();
            }
            super.onPageFinished(view, url);
            if (StringUtils.equal((String)url, (String)"about:blank") && this.theWebView instanceof YYWebView && ((YYWebView)this.theWebView).isReused()) {
                this.theWebView.clearHistory();
                this.theWebView.clearCache(false);
                MLog.info((Object)WebViewController.TAG, (String)("onPageFinish clearHistory = " + url), (Object[])new Object[0]);
            }
            if (StringUtils.equal((String)url, (String)WebViewController.this.mOriginUrl) && this.theWebView instanceof YYWebView && ((YYWebView)this.theWebView).isReused()) {
                this.theWebView.clearHistory();
                MLog.info((Object)WebViewController.TAG, (String)("onPageStart clearHistory = " + url), (Object[])new Object[0]);
            }
            if (WebViewController.this.mCallBack != null) {
                WebViewController.this.mCallBack.hideStatusView();
                WebViewController.this.mCallBack.onRefreshComplete(WebViewController.this.mOriginUrl, url);
                if (WebViewController.this.mRecvError) {
                    WebViewController.this.mCallBack.showNetError(WebViewController.this.mOriginUrl, -1, "had onReceivedError", url);
                }
            }
            if (WebViewController.this.mAppearanceCallback != null) {
                WebViewController.this.mAppearanceCallback.onPageFinished(view, url);
            }
            if (WebViewController.this.mWebViewEventListener != null) {
                WebViewController.this.mWebViewEventListener.onPageFinished(view, url);
            }
            if (this.mStartDownloadRes) {
                this.mStartDownloadRes = false;
            }
            CookieManager cookieManager = CookieManager.getInstance();
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
            WebResourceResponse webResourceResponse = null;
            IWebViewEventListener listener = WebViewController.this.mWebViewEventListener;
            if (listener != null) {
                webResourceResponse = listener.shouldInterceptRequest(view, request);
            }
            if (webResourceResponse == null) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.debug((Object)WebViewController.TAG, (String)"shouldInterceptRequest no!", (Object[])new Object[0]);
                }
                return super.shouldInterceptRequest(view, request);
            }
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)WebViewController.TAG, (String)"shouldInterceptRequest:%s!", (Object[])new Object[]{webResourceResponse});
            }
            return webResourceResponse;
        }
    }

    private class WebViewDownLoadListener
    implements DownloadListener {
        private WebViewDownLoadListener() {
        }

        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
            if (WebViewController.this.mCallBack != null) {
                WebViewController.this.mCallBack.onDownloadStart(url, userAgent, contentDisposition, mimetype, contentLength);
            }
        }
    }
}

