/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow.webview;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import com.yy.base.utils.StringUtils;

public class Utils {
    public static void showAlertDialog(Activity activity, String title, String message, String positiveButton, String negativeButton, IAlertDialogCallBack callBack) {
        Utils.showAlertDialog(activity, title, message, positiveButton, null, negativeButton, true, callBack);
    }

    public static void showAlertDialog(Activity activity, String title, String message, String positiveButton, String neutralButton, String negativeButton, boolean cancelable, final IAlertDialogCallBack callBack) {
        if (activity == null) {
            return;
        }
        if (title == null) {
            title = "";
        }
        if (message == null) {
            message = "";
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setTitle((CharSequence)title);
        builder.setMessage((CharSequence)message);
        builder.setCancelable(cancelable);
        if (positiveButton != null) {
            builder.setPositiveButton((CharSequence)positiveButton, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callBack != null) {
                        callBack.onPositiveButtonClicked();
                    }
                    dialog.dismiss();
                }
            });
        }
        if (!StringUtils.isEmpty((String)neutralButton)) {
            builder.setNeutralButton((CharSequence)neutralButton, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callBack != null) {
                        callBack.onNeutralButtonClicked();
                    }
                    dialog.dismiss();
                }
            });
        }
        if (negativeButton != null) {
            builder.setNegativeButton((CharSequence)negativeButton, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callBack != null) {
                        callBack.onNegativeButtonClicked();
                    }
                    dialog.dismiss();
                }
            });
        }
        builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (callBack != null) {
                    callBack.onCancled();
                }
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    public static interface IAlertDialogCallBack {
        public void onPositiveButtonClicked();

        public void onNeutralButtonClicked();

        public void onNegativeButtonClicked();

        public void onCancled();
    }
}

