/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow.titlebar;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.StringUtils;
import com.yy.webservice.R;
import com.yy.webservice.webwindow.titlebar.WebTitleButton;

public class CommonTitle {
    private TextView mTextTitle;
    private ImageView mImageTitle;
    private ViewGroup mRightContainer;
    private View.OnClickListener mBackListener;
    private View.OnClickListener mCloseListener;
    private RecycleImageView mBack;
    private RecycleImageView mCloseBtn;
    private int mImageTitleResId = -1;
    private String mTitleText;
    private ViewGroup root;
    private View divider;
    private boolean isShowBackBtn = true;
    private boolean hideTitle = false;
    private Context mContext;

    public CommonTitle(Context context, boolean isShowBackBtn) {
        this.isShowBackBtn = isShowBackBtn;
        this.mContext = context;
    }

    private Context getContext() {
        return this.mContext;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container) {
        View view = inflater.inflate(R.layout.webactivity_common_title, container, false);
        this.mTextTitle = (TextView)view.findViewById(R.id.text_title);
        this.mImageTitle = (ImageView)view.findViewById(R.id.image_title);
        this.mBack = (RecycleImageView)view.findViewById(R.id.back);
        this.mCloseBtn = (RecycleImageView)view.findViewById(R.id.close);
        this.mRightContainer = (ViewGroup)view.findViewById(R.id.right_container);
        this.mBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CommonTitle.this.mBackListener != null) {
                    CommonTitle.this.mBackListener.onClick(v);
                }
            }
        });
        this.mCloseBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CommonTitle.this.mCloseListener != null) {
                    CommonTitle.this.mCloseListener.onClick(view);
                }
            }
        });
        this.mBack.setVisibility(this.isShowBackBtn ? 0 : 8);
        if (this.mImageTitleResId > 0) {
            this.setTitleImage(this.mImageTitleResId);
        } else if (!StringUtils.isEmpty((String)this.mTitleText)) {
            this.setTitleText(this.mTitleText);
        }
        this.divider = view.findViewById(R.id.divider);
        this.root = (ViewGroup)view.findViewById(R.id.root);
        return view;
    }

    public void setDividerVisibility(boolean visible) {
        if (null == this.divider) {
            return;
        }
        this.divider.setVisibility(visible ? 0 : 8);
    }

    public void setCloseIcon() {
        if (this.mBack != null) {
            this.mBack.setImageResource(R.drawable.web_icon_close);
        }
    }

    public void hideTitleText() {
        if (this.mTextTitle == null) {
            return;
        }
        this.hideTitle = true;
        this.mTextTitle.setVisibility(4);
    }

    public void showTitleText() {
        if (this.mTextTitle == null) {
            return;
        }
        this.hideTitle = false;
        this.mTextTitle.setVisibility(0);
    }

    public void setTitleText(String title) {
        this.mTitleText = title;
        this.mImageTitleResId = -1;
        if (this.mTextTitle == null || this.mImageTitle == null || this.hideTitle) {
            return;
        }
        this.mTextTitle.setText((CharSequence)this.mTitleText);
        this.mImageTitle.setVisibility(4);
        this.mTextTitle.setVisibility(0);
    }

    public void setTitleTextColor(int color) {
        if (this.mTextTitle == null || this.mImageTitle == null || this.hideTitle) {
            return;
        }
        this.mTextTitle.setTextColor(color);
    }

    public void setTitleImage(int resId) {
        this.mTitleText = "";
        this.mImageTitleResId = resId;
        if (this.mTextTitle == null || this.mImageTitle == null) {
            return;
        }
        this.mImageTitle.setVisibility(0);
        this.mTextTitle.setVisibility(4);
        if (resId > 0) {
            this.mImageTitle.setImageResource(this.mImageTitleResId);
        } else {
            this.mImageTitle.setVisibility(4);
        }
    }

    public void clearTitle() {
        if (this.mRightContainer == null) {
            return;
        }
        this.mRightContainer.removeAllViews();
    }

    public void setBackBtnState(int flag) {
        if (this.isShowBackBtn) {
            this.mBack.setVisibility(flag);
        }
    }

    public void setBackBtnEnableState(boolean enableState) {
        this.mBack.clearColorFilter();
        if (enableState) {
            this.mBack.setEnabled(true);
        } else {
            this.mBack.setEnabled(false);
            this.mBack.setColorFilter(Color.parseColor((String)"#cccccc"), PorterDuff.Mode.SRC_IN);
        }
    }

    public void showBack(boolean show) {
        this.isShowBackBtn = show;
        this.mBack.setVisibility(this.isShowBackBtn ? 0 : 8);
    }

    public void setBackListener(View.OnClickListener listener) {
        this.mBackListener = listener;
    }

    public void enableClose(boolean btnShow, View.OnClickListener listener) {
        if (btnShow) {
            if (this.mCloseBtn != null && this.mCloseBtn.getVisibility() != 0) {
                this.mCloseBtn.setVisibility(0);
            }
            this.mCloseListener = listener;
        } else {
            if (this.mCloseBtn != null && this.mCloseBtn.getVisibility() != 8) {
                this.mCloseBtn.setVisibility(8);
            }
            this.mCloseListener = listener;
        }
    }

    public void addRightBtn(WebTitleButton btn) {
        if (btn == null || this.mRightContainer == null) {
            return;
        }
        if (btn.iconType == 1) {
            this.addRightButtonWithResId(btn.iconResId, btn.getOnClickListener());
        } else if (btn.iconType == 2) {
            this.addRightButtonWithDrawable(btn.iconDrawable, btn.getOnClickListener());
        } else if (btn.iconType == 3) {
            this.addRightButtonWithUlr(btn.iconUrl, btn.getOnClickListener());
        }
    }

    public void removeRightBtn() {
        if (this.mRightContainer == null) {
            return;
        }
        this.mRightContainer.removeAllViews();
    }

    public void updateMsgStatus(int id2, String badge) {
        TextView view = (TextView)((Activity)this.getContext()).findViewById(id2);
        if (view == null) {
            return;
        }
        if (StringUtils.isEmpty((String)badge)) {
            view.setVisibility(4);
            return;
        }
        view.setVisibility(0);
        view.setText((CharSequence)badge);
    }

    public void addLeftButtonWithImageRes(int imgRes) {
        if (null != this.mBack) {
            this.mBack.setImageResource(imgRes);
        }
    }

    public void addRightButtonWithResId(@DrawableRes int resId, View.OnClickListener clickListener) {
        RecycleImageView recycleImageView = this.addRightButton(this.mRightContainer, clickListener);
        recycleImageView.setBackgroundResource(resId);
    }

    public void addRightButtonWithDrawable(Drawable resId, View.OnClickListener clickListener) {
        RecycleImageView recycleImageView = this.addRightButton(this.mRightContainer, clickListener);
        recycleImageView.setBackgroundDrawable(resId);
    }

    public void addRightButtonWithUlr(String url, View.OnClickListener clickListener) {
        RecycleImageView recycleImageView = this.addRightButton(this.mRightContainer, clickListener);
        ImageLoader.loadImage((ImageView)recycleImageView, (String)url, (int)0);
    }

    private RecycleImageView addRightButton(ViewGroup right, View.OnClickListener clickListener) {
        right.removeAllViews();
        RecycleImageView recycleImageView = new RecycleImageView(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(11);
        right.addView((View)recycleImageView, (ViewGroup.LayoutParams)params);
        right.setOnClickListener(clickListener);
        return recycleImageView;
    }

    public void setMyBackground(int color) {
        this.root.setBackgroundColor(color);
    }

    public void setDeviderColor(int color) {
        if (this.divider != null) {
            this.divider.setBackgroundColor(color);
        }
    }

    public void setMyBackgroundWithDivider(int color) {
        this.root.setBackgroundColor(color);
        if (this.divider != null) {
            this.divider.setBackgroundColor(color);
        }
    }
}

