/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.RelativeLayout;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.IHidePushToast;
import com.yy.framework.core.ui.StatusBarManager;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.webservice.R;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.WebViewStyle;
import com.yy.webservice.webwindow.IWebUi;
import com.yy.webservice.webwindow.IWebViewWindow;
import com.yy.webservice.webwindow.OnRefreshListener;
import com.yy.webservice.webwindow.StatusLayout;
import com.yy.webservice.webwindow.TitleBar;
import com.yy.webservice.webwindow.WebViewWindow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebWindow
extends DefaultWindow
implements IWebUi,
IHidePushToast {
    private TitleBar mTitleBar;
    private WebViewWindow mWebViewWindow;
    private StatusLayout mStatusLayout;
    private WebEnvSettings mWebEnvSettings;
    private IWebWindowCallBack mWebWindowCallBack;
    RelativeLayout container;
    private OnRefreshListener mRefreshListener = new OnRefreshListener(){

        @Override
        public void onPullDownToRefresh() {
            if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.network_error), (int)1);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (WebWindow.this.mWebViewWindow != null) {
                            WebWindow.this.mWebViewWindow.onRefreshComplete();
                        }
                    }
                }, 500L);
            } else if (WebWindow.this.mWebWindowCallBack != null) {
                WebWindow.this.mWebWindowCallBack.onPullDownToRefresh();
            }
        }
    };

    public WebWindow(Context context, UICallBacks callBacks, WebEnvSettings webEnvSettings) {
        super(context, callBacks, "Web");
        this.mWebEnvSettings = webEnvSettings;
        this.setScreenOrientationType(webEnvSettings.orientation);
        this.setIsNeedDetachWatch(false);
        if (!webEnvSettings.hideLastWindow) {
            this.setTransparent(true);
            this.setSingleTop(false);
        }
        if (this.mWebEnvSettings.webViewStyle != WebViewStyle.FULL_WINDOW) {
            this.mWebEnvSettings.webViewStyle = WebViewStyle.FULL_WINDOW;
        }
        this.initView(context, this.mWebEnvSettings.isFullScreen);
    }

    @Override
    public void setWebWindowCallBack(IWebWindowCallBack callBack) {
        this.mWebWindowCallBack = callBack;
    }

    @Override
    public TitleBar getTitleBar() {
        return this.mTitleBar;
    }

    @Override
    public void showTitleBar(boolean isShow) {
        if (this.mTitleBar != null) {
            this.mTitleBar.showTitleBar(isShow);
        }
    }

    @Override
    public WebView getWebView() {
        return this.mWebViewWindow.getWebView();
    }

    @Override
    public WebEnvSettings getWebEnvSettings() {
        return this.mWebEnvSettings;
    }

    @Override
    @Nullable
    public IWebViewWindow getWebViewWindow() {
        return this.mWebViewWindow;
    }

    @Override
    public StatusLayout getStatusLayout() {
        return this.mStatusLayout;
    }

    @Override
    public void setBackListener(@NotNull View.OnClickListener listener) {
        if (this.mTitleBar != null) {
            this.mTitleBar.setBackListener(listener);
        }
    }

    private void initView(Context context, boolean fullScreen) {
        this.container = new YYRelativeLayout(context);
        this.container.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mWebViewWindow = new WebViewWindow(context, this.mWebEnvSettings.disablePullRefresh);
        this.mWebViewWindow.setPullRefreshEnable(!this.mWebEnvSettings.disablePullRefresh);
        if (this.mWebEnvSettings.mWebViewWeak != null) {
            this.mWebViewWindow.setWebView(this.mWebEnvSettings.mWebViewWeak);
        }
        this.mStatusLayout = new StatusLayout(this.mWebViewWindow.getStatusLayout());
        RelativeLayout.LayoutParams titleBarLayoutParams = new RelativeLayout.LayoutParams(-1, -2);
        titleBarLayoutParams.addRule(10);
        if (!this.mWebEnvSettings.hideTitleBar) {
            this.mTitleBar = new TitleBar(context);
            this.mTitleBar.setId(R.id.wa_title_bar_id);
            this.mTitleBar.setLayoutParams((ViewGroup.LayoutParams)titleBarLayoutParams);
            this.mTitleBar.initWebTitle(this.mWebEnvSettings.isShowBackBtn, this.mWebEnvSettings.isFullScreen, this.mWebEnvSettings.title, -13421773, this.mWebEnvSettings.backBtnResId);
            if (this.mWebEnvSettings.backStyle == 1) {
                this.mTitleBar.setCloseIcon();
            }
            if (this.mWebEnvSettings.rightButton != null) {
                this.mTitleBar.addRightBtn(this.mWebEnvSettings.rightButton);
            }
        }
        this.mWebViewWindow.setPllOnRefreshListener(this.mRefreshListener);
        this.container.addView((View)this.mWebViewWindow.getView());
        if (!this.mWebEnvSettings.hideTitleBar) {
            this.container.addView((View)this.mTitleBar);
        }
        this.mWebViewWindow.updateLayout(fullScreen);
        this.getBaseLayer().addView((View)this.container);
        this.mStatusLayout.setRefreshListener(new View.OnClickListener(){

            public void onClick(View v) {
                WebWindow.this.refresh();
            }
        });
        this.container.setBackgroundColor(this.mWebEnvSettings.webViewBackgroundColor);
        if (!this.isTransParentBackground()) {
            StatusBarManager.INSTANCE.addTopPadding((Activity)this.getContext(), (View)this.container, (AbstractWindow)this);
        }
    }

    private void refresh() {
        if (this.mWebWindowCallBack != null) {
            this.mStatusLayout.showLoading();
            this.mWebWindowCallBack.refresh();
        }
    }

    @Override
    public boolean interceptorClose() {
        return false;
    }

    public void onShown() {
        super.onShown();
        this.setSoftInputMode(16);
    }

    public boolean isTranslucentBar() {
        return this.mWebEnvSettings == null ? true : this.mWebEnvSettings.enableTranslucent;
    }

    private boolean isTransParentBackground() {
        boolean isTransparent = false;
        if (this.mWebEnvSettings != null) {
            isTransparent = !this.mWebEnvSettings.hideLastWindow && Color.alpha((int)this.mWebEnvSettings.webViewBackgroundColor) < 255;
        }
        return isTransparent;
    }

    public boolean isDarkMode() {
        return this.isTranslucentBar();
    }

    public boolean isTransparent() {
        return this.isTransParentBackground();
    }

    public boolean isHidePushToast() {
        if (null != this.mWebEnvSettings) {
            return this.mWebEnvSettings.hidePushToast;
        }
        return false;
    }

    @Override
    public void checkHideNavBar() {
        String abTestValue = SettingFlags.getStringValue((String)"key_hide_nav_bar_abvalue", (String)"");
        this.mWindowInfo.setsNeedHideNavigationBar(StringUtils.equalsIgnoreCase((String)abTestValue, (String)"B"));
    }

    public static interface IWebWindowCallBack {
        public void onPullDownToRefresh();

        public void refresh();
    }
}

