/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshWebView;
import com.yy.appbase.growth.ExperimentParam;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.MsgDispatcher;
import com.yy.webservice.R;
import com.yy.webservice.webwindow.IWebViewWindow;
import com.yy.webservice.webwindow.OnRefreshListener;
import com.yy.webservice.webwindow.webview.base.WebViewReuse;
import com.yy.webservice.webwindow.webview.base.YYWebView;
import java.lang.ref.WeakReference;

public class WebViewWindow
implements IWebViewWindow {
    private static int sWebViewIndex = 1;
    private Context mContext;
    private ViewGroup mContainer;
    private PullToRefreshWebView mPullWebView;
    private YYLinearLayout mProgressBarContainer;
    private ProgressBar mProgressBar;
    private YYTextView mProgressBarLabel;
    private YYFrameLayout mStatusLayout;
    private YYPlaceHolderView mBottomPlaceholder;
    private WeakReference<View> webViewWeak;
    private WebView mWebView;
    private int mWebViewIndex = -1;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private Runnable hideProgressTask = new Runnable(){

        @Override
        public void run() {
            WebViewWindow.this.hideProgress();
        }
    };

    public WebViewWindow(Context context, boolean disablePullRefresh) {
        this.mContext = context;
        this.initViews(disablePullRefresh);
        this.mWebViewIndex = sWebViewIndex++;
        if (this.mPullWebView != null) {
            this.mPullWebView.setId(this.mWebViewIndex);
        } else if (this.mWebView != null) {
            this.mWebView.setId(this.mWebViewIndex);
        }
    }

    private void initViews(boolean disablePullRefresh) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        YYPlaceHolderView webPlaceholder = null;
        if (!disablePullRefresh) {
            this.mContainer = (ViewGroup)inflater.inflate(R.layout.webactivity_webview, null);
            this.mPullWebView = (PullToRefreshWebView)this.mContainer.findViewById(R.id.ptr_webview);
            this.mProgressBarContainer = (YYLinearLayout)this.mContainer.findViewById(R.id.progress);
            this.mProgressBar = (ProgressBar)this.mContainer.findViewById(R.id.progress_bar);
            this.mProgressBarLabel = (YYTextView)this.mContainer.findViewById(R.id.progress_label);
            this.mStatusLayout = (YYFrameLayout)this.mContainer.findViewById(R.id.status_layout);
            this.mBottomPlaceholder = (YYPlaceHolderView)this.mContainer.findViewById(R.id.pvBottomOther);
        } else {
            this.mContainer = (ViewGroup)inflater.inflate(R.layout.webactivity_webview_two, null);
            webPlaceholder = (YYPlaceHolderView)this.mContainer.findViewById(R.id.pvWebView);
            this.mProgressBarContainer = (YYLinearLayout)this.mContainer.findViewById(R.id.progress);
            this.mProgressBar = (ProgressBar)this.mContainer.findViewById(R.id.progress_bar);
            this.mProgressBarLabel = (YYTextView)this.mContainer.findViewById(R.id.progress_label);
            this.mStatusLayout = (YYFrameLayout)this.mContainer.findViewById(R.id.status_layout);
            this.mBottomPlaceholder = (YYPlaceHolderView)this.mContainer.findViewById(R.id.pvBottomOther);
            if (this.webViewWeak != null && this.webViewWeak.get() != null) {
                webPlaceholder.inflate((View)this.webViewWeak.get());
            } else {
                YYWebView webView2 = WebViewReuse.obtainWebView();
                if (webView2 == null) {
                    webView2 = new YYWebView(this.mContext);
                }
                webView2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.mWebView = webView2;
                webPlaceholder.inflate((View)webView2);
            }
        }
        this.setWebViewBackgroundTransparent();
    }

    @Override
    public void initBottomAction(String url) {
        ExperimentParam param = new ExperimentParam();
        param.setData((Object)new Pair((Object)this.mBottomPlaceholder, (Object)url));
        if (!RuntimeContext.isHagoPartySdk()) {
            MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.SCHEME_LEAD_BROWSER, (Object)param);
        }
    }

    private Context getContext() {
        if (SettingFlags.getBoolean((String)"disable_webview_inflater_context", (boolean)false)) {
            return this.mContext;
        }
        return this.mContext.getApplicationContext();
    }

    @Override
    public void onRefreshComplete() {
        if (this.mPullWebView != null) {
            this.mPullWebView.onRefreshComplete();
        }
    }

    @Override
    public void setPllOnRefreshListener(final OnRefreshListener listener) {
        if (this.mPullWebView != null) {
            this.mPullWebView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<WebView>(){

                public void onRefresh(PullToRefreshBase<WebView> refreshView) {
                    if (listener != null) {
                        listener.onPullDownToRefresh();
                    }
                }
            });
        }
    }

    public boolean isPullRefreshEnabled() {
        if (this.mPullWebView != null) {
            return this.mPullWebView.getMode() != PullToRefreshBase.Mode.DISABLED;
        }
        return false;
    }

    @Override
    public boolean setPullRefreshEnable(boolean enable) {
        if (this.mPullWebView != null) {
            if (enable) {
                this.mPullWebView.setMode(PullToRefreshBase.Mode.MANUAL_REFRESH_ONLY);
            } else {
                this.mPullWebView.setMode(PullToRefreshBase.Mode.DISABLED);
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateLayout(boolean fullScreen) {
        RelativeLayout.LayoutParams webviewLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        if (!fullScreen) {
            webviewLayoutParams.addRule(3, R.id.wa_title_bar_id);
        }
        if (this.mContainer != null) {
            this.mContainer.setLayoutParams((ViewGroup.LayoutParams)webviewLayoutParams);
        }
    }

    public void setWebViewBackgroundColor(int color2) {
        if (this.mPullWebView != null) {
            ((WebView)this.mPullWebView.getRefreshableView()).setBackgroundColor(color2);
        } else if (this.mWebView != null) {
            this.mWebView.setBackgroundColor(color2);
        }
    }

    public void setWebViewBackgroundTransparent() {
        this.setWebViewBackgroundColor(0);
        if (this.mPullWebView != null && ((WebView)this.mPullWebView.getRefreshableView()).getBackground() != null) {
            ((WebView)this.mPullWebView.getRefreshableView()).getBackground().setAlpha(0);
        } else if (this.mWebView != null && this.mWebView.getBackground() != null) {
            this.mWebView.getBackground().setAlpha(0);
        }
    }

    @Override
    public void showProgressDialog(String label, final boolean cancelable, int timeout) {
        if (this.mProgressBarContainer != null) {
            this.mHandler.removeCallbacks(this.hideProgressTask);
            if (this.mProgressBarLabel != null) {
                this.mProgressBarLabel.setText((CharSequence)label);
            }
            this.mProgressBarContainer.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (cancelable) {
                        WebViewWindow.this.hideProgress();
                    }
                }
            });
            if (timeout >= 0) {
                this.mHandler.postDelayed(this.hideProgressTask, (long)timeout);
            }
        }
        this.showProgressDialog();
    }

    private void showProgressDialog() {
        if (this.mProgressBarContainer != null) {
            this.mProgressBarContainer.setVisibility(0);
        }
    }

    @Override
    public void hideProgress() {
        this.mHandler.removeCallbacks(this.hideProgressTask);
        if (this.mProgressBarContainer != null) {
            this.mProgressBarContainer.setVisibility(8);
        }
    }

    public ViewGroup getView() {
        return this.mContainer;
    }

    public ViewGroup getStatusLayout() {
        return this.mStatusLayout;
    }

    @Override
    public WebView getWebView() {
        if (this.mPullWebView != null) {
            return (WebView)this.mPullWebView.getRefreshableView();
        }
        return this.mWebView;
    }

    public int getWebViewId() {
        return this.mWebViewIndex;
    }

    public void setWebView(WeakReference<View> webViewWeak) {
        this.webViewWeak = webViewWeak;
    }
}

