/*
 * Decompiled with CFR 0.152.
 */
package com.yy.webservice.webwindow;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import com.yy.base.logger.MLog;
import com.yy.webservice.webwindow.WebViewWindow;
import java.util.ArrayList;

public class WebViewReuseTwo {
    private static final String TAG = "WebViewReuse";
    private static ArrayList<WebViewWindow> sRecycledWeb;
    private static IWebViewReuseCallBack sCallBack;

    public static synchronized boolean recycle(WebViewWindow webViewWindow) {
        MLog.info((Object)TAG, (String)"recycle!", (Object[])new Object[0]);
        if (sCallBack == null || !sCallBack.isSwitchOn() || !sCallBack.canCacheNow() || webViewWindow.isPullRefreshEnabled()) {
            return false;
        }
        if (webViewWindow == null || sRecycledWeb != null && sRecycledWeb.size() >= 1) {
            return false;
        }
        if (sRecycledWeb == null) {
            sRecycledWeb = new ArrayList(2);
        } else {
            for (int i = 0; i < sRecycledWeb.size(); ++i) {
                if (webViewWindow != sRecycledWeb.get(i)) continue;
                MLog.info((Object)TAG, (String)"has recycled!", (Object[])new Object[0]);
                return false;
            }
        }
        if (webViewWindow.getView() != null && webViewWindow.getView().getParent() instanceof ViewGroup) {
            ((ViewGroup)webViewWindow.getView().getParent()).removeView((View)webViewWindow.getView());
        }
        MLog.info((Object)TAG, (String)"recycled web index:%d!", (Object[])new Object[]{webViewWindow.getWebViewId()});
        sRecycledWeb.add(webViewWindow);
        return true;
    }

    public static synchronized WebViewWindow obtainWebViewWindow(boolean disablePullRefresh) {
        MLog.info((Object)TAG, (String)"obtainWebViewWindo", (Object[])new Object[0]);
        if (sCallBack == null || !sCallBack.isSwitchOn() || !disablePullRefresh) {
            return null;
        }
        if (sRecycledWeb == null || sRecycledWeb.size() <= 0) {
            return null;
        }
        WebViewWindow item = sRecycledWeb.get(0);
        sRecycledWeb.remove(0);
        MLog.info((Object)TAG, (String)"obtainWebViewWindo use cache, web index:%d!", (Object[])new Object[]{item.getWebViewId()});
        return item;
    }

    public static void clearCache() {
        WebView webView2;
        if (sRecycledWeb == null || sRecycledWeb.size() <= 0) {
            return;
        }
        MLog.info((Object)TAG, (String)"releaseCacheByTrimMemory", (Object[])new Object[0]);
        WebViewWindow item = sRecycledWeb.get(0);
        sRecycledWeb.remove(0);
        if (item != null && (webView2 = item.getWebView()) != null) {
            if (webView2.getParent() instanceof ViewGroup) {
                ((ViewGroup)webView2.getParent()).removeView((View)webView2);
            }
            webView2.destroy();
        }
    }

    public static synchronized void precreateWebViewWindow(Context context) {
        MLog.info((Object)TAG, (String)"precreateWebView!", (Object[])new Object[0]);
        if (sRecycledWeb != null && sRecycledWeb.size() > 0) {
            return;
        }
        if (sCallBack == null || !sCallBack.isSwitchOn() || !sCallBack.canCacheNow()) {
            return;
        }
        WebViewWindow webViewWindow = new WebViewWindow(context, true);
        if (sRecycledWeb == null) {
            sRecycledWeb = new ArrayList(2);
        }
        sRecycledWeb.add(webViewWindow);
        MLog.info((Object)TAG, (String)"precreateWebView, web index:%d!", (Object[])new Object[]{webViewWindow.getWebViewId()});
    }

    public static void setCallBack(IWebViewReuseCallBack callBack) {
        sCallBack = callBack;
    }

    public static interface IWebViewReuseCallBack {
        public boolean isSwitchOn();

        public boolean canCacheNow();
    }
}

